(function($) {
    "use strict";

    /*-------------------------------------
	Background image
	-------------------------------------*/
    $("[data-bg-image]").each(function() {
        var img = $(this).data("bg-image");
        $(this).css({
            backgroundImage: "url(" + img + ")"
        });
    });

    /*-------------------------------------
    After Load All Content Add a Class
    -------------------------------------*/
    window.onload = addNewClass();

    function addNewClass() {
        $('.fxt-template-animation').imagesLoaded().done(function(instance) {
            $('.fxt-template-animation').addClass('loaded');
        });
    }

    /*-------------------------------------
    Toggle Class
    -------------------------------------*/
    $(".toggle-password").on('click', function() {
        $(this).toggleClass("fa-eye fa-eye-slash");
        var input = $($(this).attr("toggle"));
        if (input.attr("type") == "password") {
            input.attr("type", "text");
        } else {
            input.attr("type", "password");
        }
    });

    /*-------------------------------------
    Youtube Video
    -------------------------------------*/
    if ($.fn.YTPlayer !== undefined && $("#fxtVideo").length) {
        $("#fxtVideo").YTPlayer({ useOnMobile: true });
    }

    /*-------------------------------------
    Vegas Slider
    -------------------------------------*/
    if ($.fn.vegas !== undefined && $("#vegas-slide").length) {
        var target_slider = $("#vegas-slide"),
            vegas_options = target_slider.data('vegas-options');
        if (typeof vegas_options === "object") {
            target_slider.vegas(vegas_options);
        }
    }

    /*-------------------------------------
    OTP Form (Focusing on next input)
    -------------------------------------*/
    $("#otp-form .otp-input").keyup(function() {
        if (this.value.length == this.maxLength) {
            $(this).next('.otp-input').focus();
        }
    });

    /*-------------------------------------
	Social Animation
	-------------------------------------*/
    $('#fxt-login-option >ul >li').hover(function() {
        $('#fxt-login-option >ul >li').removeClass('active');
        $(this).addClass('active');
    });

    /*-------------------------------------
    Preloader
    -------------------------------------*/
    $('#preloader').fadeOut('slow', function() {
        $(this).remove();
    });

    /*-------------------------------------
    Multi Steps
    -------------------------------------*/
    var current_fs, next_fs, previous_fs; //form
    var opacity;
    var current = 1;
    var steps = $(".fxt-form-step").length;

    $('.fxt-current-step').html(current);
    $('.fxt-total-step').html(steps);

    setProgressBar(current);

    $(".next").on('click', function(e) {
        e.preventDefault();
        current_fs = $(this).parents(".fxt-form-step");
        next_fs = $(this).parents(".fxt-form-step").next();

        //show the next step
        next_fs.show();
        //hide the current step with style
        current_fs.animate({ opacity: 0 }, {
            step: function(now) {
                // for making step appear animation
                opacity = 1 - now;

                current_fs.css({
                    'display': 'none',
                    'position': 'relative'
                });
                next_fs.css({ 'opacity': opacity });
            },
            duration: 500
        });
        setProgressBar(++current);

        $('.fxt-current-step').html(current);
    });

    $(".previous").click(function() {

        current_fs = $(this).parents(".fxt-form-step");
        previous_fs = $(this).parents(".fxt-form-step").prev();

        //show the previous step
        previous_fs.show();

        //hide the current step with style
        current_fs.animate({ opacity: 0 }, {
            step: function(now) {
                // for making step appear animation
                opacity = 1 - now;

                current_fs.css({
                    'display': 'none',
                    'position': 'relative'
                });
                previous_fs.css({ 'opacity': opacity });
            },
            duration: 500
        });
        setProgressBar(--current);
        $('.fxt-current-step').html(current);
    });

    function setProgressBar(curStep) {
        var percent = parseFloat(100 / steps) * curStep;
        percent = percent.toFixed();
        $(".progress-bar")
            .css("width", percent + "%")
    }
	
	///////LOGIN SCRIPTS///////
	$("#loginBtn").on('click', function(){
		let email = $("#email").val();
		let password = $("#password").val();
		let errorMsg = '';

		if(!email){
			$("#email").attr('style','border-color: red;');
			if(errorMsg){
				errorMsg = '<i class="fa fa-times"></i> Email required';
			}
			else{
				errorMsg = '<i class="fa fa-times"></i> Email required';
			}
		}
		else{
			if(!(/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(email))){
				if(errorMsg){
					errorMsg = '<i class="fa fa-times"></i> Invalid Email';
				}
				else{
					errorMsg = '<i class="fa fa-times"></i> Invalid Email';
				}
				$("#email").attr('style','border-color: red;');
			}
			else{
				$("#email").removeAttr('style');
			}
		}

		if(!password){
			$("#password").attr('style','border-color: red;');
			if(errorMsg){
				errorMsg += '<br><i class="fa fa-times"></i> Password required';
			}
			else{
				errorMsg += '<i class="fa fa-times"></i> Password required';
			}
		}
		else{
			$("#password").removeAttr('style');
		}

		if(!errorMsg){
			$.ajax({
				type: 'POST',
				url: 'scripts/auth.php',
				data: 'action=login&email='+email+'&password='+password,
				dataType: 'JSON',
				beforeSend:function(){
					$("#errorMsg").removeAttr('style').html('<i class="fa fa-spinner fa-spin"></i>...please wait.').attr('style','color: blue;');
				},
				success:function(response){
					if(response.header=='successful'){
						$("#errorMsg").removeAttr('style').html('Loading Dashboard...<i class="fa fa-spinner fa-spin"></i>').attr('style','color: green;');
						setTimeout(function(){
							window.location = './';
						},4000);
					}
					else{
						$("#errorMsg").removeAttr('style').html('<i class="fa fa-times"></i> Incorrect email/password').attr('style','color: red;');
					}
				}
			});
		}
		else{
			$("#errorMsg").removeAttr('style').html(errorMsg).attr('style','color: red;');
		}
		
	});

	/////////REGISTER SCRIPT/////////////////////
	$("#createAccountBtn").on('click', function(){
		let errorMsg = '';
		let email = $("#email").val();
		let name = $("#name").val();
		var fd = new FormData();
		if(name==''){
            $("#name").attr('style','border-color: red;');
            errorMsg = '<i class="fa fa-times"></i> Enter your full name (First & last names)';
        }
        else{
            var fullName = name.split(' ');
            if(fullName.length > 1){
				$("#name").removeAttr('style');
                var firstName = fullName[0];
                var lastName = fullName[1];
                var middleName = fullName[2];
				
				if(firstName){
					fd.append('firstname', firstName);
				}
				if(lastName){
					fd.append('lastname', lastName);
				}
				if(middleName){
					fd.append('middlename', middleName);
				}
            }
            else{
                errorMsg = '<i class="fa fa-times"></i> First name and Last name required';
            }
        }
		
		if(!email){
			$("#email").attr('style','border-color: red;');
			if(errorMsg){
				errorMsg += '<br><i class="fa fa-times"></i> Email required';
			}
			else{
				errorMsg = '<i class="fa fa-times"></i> Email required';
			}
		}
		else{
			if(!(/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(email))){
				if(errorMsg){
					errorMsg += '<br><i class="fa fa-times"></i> Invalid Email';
				}
				else{
					errorMsg = '<i class="fa fa-times"></i> Invalid Email';
				}
				$("#email").attr('style','border-color: red;');
			}
			else{
				$("#email").removeAttr('style');
				fd.append('email', email);
			}
		}

		
		if(!errorMsg){
			fd.append('action', 'create-account');
			$.ajax({
				type: 'POST',
				url: 'scripts/auth.php',
				data: fd,
				contentType: false,
				processData: false,
				dataType: 'JSON',
				beforeSend:function(){
					$("#errorMsg").removeAttr('style').html('<i class="fa fa-spinner fa-spin"></i>...please wait.').attr('style','color: blue;');
				},
				success:function(response){
					//alert(response);
					if(response.header=='successful'){
						$("#errorMsg").removeAttr('style').html('Account Created and login details sent to your email.<br>Wait while we redirect you...<i class="fa fa-spinner fa-spin"></i>').attr('style','color: green;');
						setTimeout(function(){
							window.location = './?page=investment-plans';
						},4000);
					}
					else{
						$("#errorMsg").removeAttr('style').html(response.message).attr('style','color: red;');
					}
				}
			});
		}
		else{
			$("#errorMsg").removeAttr('style').html(errorMsg).attr('style','color: red;');
		}
	});
})(jQuery);