﻿<!doctype html>
<html class="no-js" lang="">

<head>
	<meta charset="utf-8">
	<meta http-equiv="x-ua-compatible" content="ie=edge">
	<title><?php echo $appName; ?> | <?php echo $appTagline; ?></title>
	<meta name="description" content="">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!-- Favicon -->
	<link rel="shortcut icon" type="image/x-icon" href="img/favicon.png">
	<!-- Bootstrap CSS -->
	<link rel="stylesheet" href="auth/css/bootstrap.min-2.css">
	<!-- Fontawesome CSS -->
	<link rel="stylesheet" href="auth/css/fontawesome-all.min-2.css">
	<!-- Flaticon CSS -->
	<link rel="stylesheet" href="auth/font/flaticon-2.css">
	<!-- Google Web Fonts -->
	<link href="css-2?family=Roboto:300,400,500,700&display=swap" rel="stylesheet">
	<!-- Custom CSS -->
	<link rel="stylesheet" href="auth/style-2.css">
	
	<script src="https://kit.fontawesome.com/4600147d2b.js" crossorigin="anonymous"></script>  
    <script src="jquery.min.js"></script>
    <!-- <script src="https://code.jquery.com/jquery-2.1.1.min.js" type="text/javascript"></script> -->
    <script src="https://code.jquery.com/jquery-3.7.0.min.js" type="text/javascript"></script>
</head>

<body>
	
	<section class="fxt-template-animation fxt-template-layout12" data-bg-image="auth/img/figure/bg12-l.jpg">
		<div class="container">
			<div class="row align-items-center justify-content-center">
				<div class="col-xl-7 col-lg-8 col-sm-10 col-12 fxt-bg-color">
					<div class="fxt-content">
						<div class="fxt-header">
							<p>Enter your email and password to continue</p>
							<h5 id="errorMsg"></h5>
						</div>
						<div class="fxt-form">
							<form method="POST">
								<div class="form-group">
									<div class="fxt-transformY-50 fxt-transition-delay-1">
										<input type="email" id="email" class="form-control" id="email" placeholder="Email Address">
									</div>
								</div>
								<div class="form-group">
									<div class="fxt-transformY-50 fxt-transition-delay-2">
										<input id="password" type="password" class="form-control" id="password" placeholder="Enter Password">
										<i toggle="#password" class="fa fa-fw fa-eye toggle-password field-icon"></i>
									</div>
								</div>
								<div class="form-group">
									<div class="fxt-transformY-50 fxt-transition-delay-3">
										<div class="fxt-checkbox-area">
											<div class="checkbox">
												<input id="checkbox1" type="checkbox">
												<label for="checkbox1">Keep me logged in</label>
											</div>
											<a href="./?action=forgot-password" class="switcher-text">Forgot Password</a>
										</div>
									</div>
								</div>
								<div class="form-group">
									<div class="fxt-transformY-50 fxt-transition-delay-4">
										<button type="button" id="loginBtn" id="loginBtn" class="fxt-btn-fill">Log in</button>
									</div>
								</div>
							</form>
						</div>
						
						<div class="fxt-footer">
							<div class="fxt-transformY-50 fxt-transition-delay-9">
								<p>Don't have an account?<a href="./?action=register" class="switcher-text2 inline-text">Register</a></p>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- jquery-->
	<script src="auth/js/jquery.min-2.js"></script>
	<!-- Bootstrap js -->
	<script src="auth/js/bootstrap.min-2.js"></script>
	<!-- Imagesloaded js -->
	<script src="auth/js/imagesloaded.pkgd.min-2.js"></script>
	<!-- Validator js -->
	<script src="auth/js/validator.min-2.js"></script>
	<!-- Custom Js -->
	<script src="auth/js/main-2.js"></script>
	<script>
		$(document).ready(function(){
			$("#loginBtn").on('click', function(){
				let email = $("#email").val();
				let password = $("#password").val();
				let errorMsg = '';

				if(!email){
					$("#email").attr('style','border-color: red;');
					if(errorMsg){
						errorMsg = '<i class="fa fa-times"></i> Email required';
					}
					else{
						errorMsg = '<i class="fa fa-times"></i> Email required';
					}
				}
				else{
					if(!(/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(email))){
						if(errorMsg){
							errorMsg = '<i class="fa fa-times"></i> Invalid Email';
						}
						else{
							errorMsg = '<i class="fa fa-times"></i> Invalid Email';
						}
						$("#email").attr('style','border-color: red;');
					}
					else{
						$("#email").removeAttr('style');
					}
				}

				if(!password){
					$("#password").attr('style','border-color: red;');
					if(errorMsg){
						errorMsg += '<br><i class="fa fa-times"></i> Password required';
					}
					else{
						errorMsg += '<i class="fa fa-times"></i> Password required';
					}
				}
				else{
					$("#password").removeAttr('style');
				}

				if(!errorMsg){
					$.ajax({
						type: 'POST',
						url: 'scripts/auth.php',
						data: 'action=login&email='+email+'&password='+password,
						dataType: 'JSON',
						beforeSend:function(){
							$("#errorMsg").removeAttr('style').html('<i class="fa fa-spinner fa-spin"></i>...please wait.').attr('style','color: blue;');
						},
						success:function(response){
							if(response.header=='successful'){
								$("#errorMsg").removeAttr('style').html('Loading Dashboard...<i class="fa fa-spinner fa-spin"></i>').attr('style','color: green;');
								setTimeout(function(){
									window.location = './';
								},4000);
							}
							else{
								$("#errorMsg").removeAttr('style').html('<i class="fa fa-times"></i> Incorrect email/password').attr('style','color: red;');
							}
						}
					});
				}
				else{
					$("#errorMsg").removeAttr('style').html(errorMsg).attr('style','color: red;');
				}
				
			});
		});
	</script>

</body>

</html>