$(document).ready(function(){
    $(function () {
        //Initialize Select2 Elements
        $('.select2bs4').select2({
          theme: 'bootstrap4'
        })
      });

    $.ajax({
        type:'POST',
        url:'resources/scripts/property/data.php',
        data:'action=load-properties',
        dataType: 'JSON',
        beforeSend: function(){
            $("#propertyDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
        },
        success:function(responseData){
            $("#propertyDetails").html(responseData.body);
        }
    });

  $(document).delegate("[data-target='#view-property']", "click", function() {
    var propId = $(this).attr('data-id');
    //alert(propId);

    $.ajax({
        type:'POST',
        url:'resources/scripts/property/data.php',
        data:'action=view-property&property-id='+propId,
        dataType: 'JSON',
        beforeSend: function(){
            $("#detailsBody").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
        },
        success:function(responseData){
            $("#detailsHeader").html('<b>'+responseData.property_name+'</b>');
            //$("#rejectBody").html(responseDataMain).addClass('text-center');
            $("#detailsBody").html(responseData.property_body);
        }
    });
  });

  $(document).delegate("[data-target='#edit-property']", "click", function() {
    $('#edit-property').on('hide.bs.modal', function(e) {
        e.preventDefault();
    });
    var propId = $(this).attr('data-id');
    var name = $(this).attr('name');
    var title = $(this).attr('title');

    $("#editDetailsHeader").html('Edit <b>'+name+'</b>');
    //alert(propId);

    $.ajax({
        type:'POST',
        url:'resources/scripts/property/data.php',
        data:'action=edit-property&property-id='+propId,
        beforeSend: function(){
            $("#editDetailsBody").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
        },
        success:function(responseData){
            $("#editDetailsBody").html(responseData);
        }
    });
    $.ajax({
        type:'POST',
        url:'resources/scripts/property/upload-images.php',
        data:'action=load-images-edit',
        beforeSend:function(){
            $("#imgPreviewEdit").html('<h6><b class="text-info">Loading...<i class="fa fa-spinner fa-spin"></i></b></h65><br>');
        },
        success:function(uploadResponse){
            $("#imgPreviewEdit").html(uploadResponse);
        }
    });
  });


  $('#closeEditBtn').on('click', function(){
      $('#edit-property').off("hide.bs.modal").trigger("click");
      $.ajax({
          type:'POST',
          url:'resources/scripts/property/data.php',
          data:'action=remove-images-edit',
          success:function(responseData){
              if(responseData=='successful'){
                  location.href='./';
              }
          }
      });
  });
  $('#closeEdit').on('click', function(){
      $('#edit-property').off("hide.bs.modal").trigger("click");
      $.ajax({
          type:'POST',
          url:'resources/scripts/property/data.php',
          data:'action=remove-images-edit',
          success:function(responseDataDel){
              if(responseDataDel=='successful'){
                  location.href='./';
              }
          }
      });
  });

  $('#closeAdd').on('click', function(){
    $('#add-property').off("hide.bs.modal").trigger("click");
    $.ajax({
        type:'POST',
        url:'resources/scripts/property/data.php',
        data:'action=remove-images',
        success:function(responseData){
          if(responseData=='successful'){
            location.href='./';
          }
        }
    });
  });

  $('#closeAddBtn').on('click', function(){
    $('#add-property').off("hide.bs.modal").trigger("click");
    $.ajax({
        type:'POST',
        url:'resources/scripts/property/data.php',
        data:'action=remove-images',
        success:function(responseData){
          if(responseData=='successful'){
            location.href='./';
          }
        }
    });
  });

  $('.addProperty').on('click', function(){
      $('#add-property').off("hide.bs.modal").trigger("click");
      $.ajax({
          type:'POST',
          url:'resources/scripts/property/data.php',
          data:'action=remove-images',
          success:function(responseData){
          if(responseData=='successful'){
              location.href='./';
          }
          }
      });
  });
  
    $(document).delegate("[data-target='#add-property']", "click", function() {
        $('#add-property').on('hide.bs.modal', function(e) {
        e.preventDefault();
        });
        /* $.ajax({
            type:'POST',
            url:'resources/scripts/property/data.php',
            data:'action=add-property',
            beforeSend: function(){
                $("#addPropertyDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
            },
            success:function(responseData){
                $("#addPropertyDetails").html(responseData);
            }
        }); */

        $.ajax({
            type:'POST',
            url:'resources/scripts/property/upload-images.php',
            data:'action=load-images',
            beforeSend:function(){
                $("#imgPreview").html('<h6><b class="text-info">Loading...<i class="fa fa-spinner fa-spin"></i></b></h65><br>');
            },
            success:function(uploadResponse){
                $("#imgPreview").html(uploadResponse);
            }
        });
    });

   /* ///////load property delete modal confirm box///////////
    $(document).delegate("[data-target=#delete-prop]", "click", function() {
        var propId = $(this).attr('data-id');
        var name = $(this).attr('name');
        var title = $(this).attr('title');

        alert(name);
        
         $.ajax({
            type:POST,
            url:'resources/scripts/property/data.php',
            data:'action=load-delete&prop-id='+propId,
            dataType: 'JSON',
            beforeSend: function(){
                $("#deleteBody").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
            },
            success:function(responseData){
            $("#deleteHead").html(responseData.head);
            $("#deleteBody").html(responseData.body);
            }
        }); 
    });*/

    $('#closeAddBtn').on('click', function(){
        $('#add-property').off("hide.bs.modal").trigger("click");
        $.ajax({
            type:'POST',
            url:'resources/scripts/property/data.php',
            data:'action=remove-images-add',
            success:function(responseData){
                if(responseData=='successful'){
                    location.href='./';
                }
            }
        });
    });
    $('#closeAdd').on('click', function(){
        $('#add-property').off("hide.bs.modal").trigger("click");
        $.ajax({
            type:'POST',
            url:'resources/scripts/property/data.php',
            data:'action=remove-images-add',
            success:function(responseDataDel){
                if(responseDataDel=='successful'){
                    location.href='./';
                }
            }
        });
    });

    $("#propName").on('blur', function(){
      var name = $(this).val();
      if(name==''){
        $(this).addClass('is-invalid');
      }else{
        $(this).removeClass('is-invalid');
      }
    });

    
    $("#propType").on('change', function(){
      var type = $("#propType").val();
      if(type){
        $("#propType").addClass('is-invalid');
      }else{
        $("#propType").removeClass('is-invalid');
      }
    });

    ////add new property/////////////////
    $("#addPropertyBtn").on('click', function(){
      /////pull the $_SESSION['image_files'] details to be sure that images have been added to the property///////////////////
      
      $.ajax({
        type:'POST',
        url:'resources/scripts/property/data.php',
        data:'action=check-uploaded-images',
        success:function(responseDataDel){
          $("#imagesSelected").val(responseDataDel);
        }
      });
      var errorMsg = '';

        var propName = $("#propName").val();
        if(propName==''){
          $("#propName").addClass('is-invalid');
          errorMsg = '<i class="fa fa-times"></i> Enter Property Name';
        }else{
          $("#propName").removeClass('is-invalid');
        }
        var propType = $("#propType").val();
        if(propType==''){
          $("#propType").addClass('is-invalid');
          if(errorMsg==''){
            errorMsg = '<i class="fa fa-times"></i> Select Propery Type';
          }
          else{
            errorMsg += '<br><i class="fa fa-times"></i> Select Propery Type';
          }
        }else{
          $("#propType").removeClass('is-invalid');
        }
        var propPrice = $("#propPrice").val();
        if(propPrice==''){
          $("#propPrice").addClass('is-invalid');
          if(errorMsg==''){
            errorMsg = '<i class="fa fa-times"></i> Enter Propery Price';
          }
          else{
            errorMsg += '<br><i class="fa fa-times"></i> Enter Propery Price';
          }
        }else{
          $("#propPrice").removeClass('is-invalid');
        }
        var propPromoPrice = $("#propPromoPrice").val();
        var propSize = $("#propSize").val();
        if(propSize==''){
          $("#propSize").addClass('is-invalid');
          if(errorMsg==''){
            errorMsg = '<i class="fa fa-times"></i> Enter Propery Size';
          }
          else{
            errorMsg += '<br><i class="fa fa-times"></i> Enter Propery Size';
          }
        }else{
          $("#propSize").removeClass('is-invalid');
        }
        var propTag = $("#propTag").val();
        var propMap = $("#propMap").val();
        var shortDescription = $("#shortDescription").val();
        if(shortDescription==''){
          $("#shortDescription").addClass('is-invalid');
          if(errorMsg==''){
            errorMsg = '<i class="fa fa-times"></i> Enter Propery Short Description';
          }
          else{
            errorMsg += '<br><i class="fa fa-times"></i> Enter Propery Short Description';
          }
        }else{
          $("#shortDescription").removeClass('is-invalid');
        }
        var propLocation = $("#propLocation").val();
        if(propLocation==''){
          $("#propLocation").addClass('is-invalid');
          if(errorMsg==''){
            errorMsg = '<i class="fa fa-times"></i> Enter Propery Location';
          }
          else{
            errorMsg += '<br><i class="fa fa-times"></i> Enter Propery Location';
          }
        }else{
          $("#propLocation").removeClass('is-invalid');
        }
        var propDescription = $("#propDescription").val();
        if(propDescription==''){
          $("#propDescription").addClass('is-invalid');
          if(errorMsg==''){
            errorMsg = '<i class="fa fa-times"></i> Enter Propery Description';
          }
          else{
            errorMsg += '<br><i class="fa fa-times"></i> Enter Propery Description';
          }
        }else{
          $("#propDescription").removeClass('is-invalid');
        }

        var propAllocation = $("#propAllocation").val();
        if(propAllocation==''){
          $("#propAllocation").addClass('is-invalid');
          if(errorMsg==''){
            errorMsg = '<i class="fa fa-times"></i> Select Propery Allocation Type';
          }
          else{
            errorMsg += '<br><i class="fa fa-times"></i> Select Propery Allocation Type';
          }
        }else{
          $("#propAllocation").removeClass('is-invalid');
        }

        var images = $("#imagesSelected").val();
        if(!images){
          $("#files").addClass('is-invalid');
          if(errorMsg==''){
            errorMsg = '<i class="fa fa-times"></i> You have not uploaded property images';
          }
          else{
            errorMsg += '<br><i class="fa fa-times"></i> You have not uploaded property images';
          }
        }
        else{
          $("#files").removeClass('is-invalid');
        }

        

        ///////////check to see that all fields have been properly filled/////////////
        if(propName && propType && propPrice && propSize && shortDescription && propAllocation && propLocation && propDescription && images){
          $.ajax({
              type:'POST',
              url:'resources/scripts/property/submit.php',
              data:'action=add-new&propName='+propName+'&propType='+propType+'&propPrice='+propPrice+'&propSize='+propSize+'&shortDescription='+shortDescription+'&propAllocation='+propAllocation+'&propLocation='+propLocation+'&propDescription='+propDescription+'&propPromoPrice='+propPromoPrice+'&propTag='+propTag+'&propMap='+propMap,
              beforeSend:function(){
                $("#addPropertyBtn").html('Submitting...<i class="fa fa-spinner fa-spin"></i>').attr('disabled','disabled');
              },
              success:function(submitResponse){
                if(submitResponse=='successful'){
                  $("#propName").val('');
                  $("#propPrice").val('');
                  $("#propPromoPrice").val('');
                  $("#propSize").val('');
                  $("#propTag").val( );
                  $("#propMap").val();
                  $("#shortDescription").val();
                  $("#propLocation").val();
                  $("#propDescription").val();
                  $("#propAllocation").val();
                  $("#addPropertyBtn").html('<i class="fa fa-save"></i> Save Changes').removeAttr('disabled');
                }
              }
          });
        }
        else{
          $("#errorModal").attr('style','display: block;');
          $("#errorMessages").html(errorMsg);
        }
        
    });

  $(function () {
    bsCustomFileInput.init();
    $('#compose-textarea').summernote()
    $(document).on('click', '[data-toggle="lightbox"]', function(event) {
        event.preventDefault();
        $(this).ekkoLightbox({
            alwaysShowClose: true
        });
    });
  });

  /////upload property images
    const filepicker = document.getElementById("files");

    filepicker.addEventListener("change", (event) => {
      var files = $('#files')[0].files;
  
      var formData = new FormData();

      // Read selected files
        for (var index = 0; index < files.length; index++) {
            formData.append("files[]", document.getElementById('files').files[index]);
        }

        if(files.length > 0){
            formData.append('action', 'upload-images');
            $.ajax({
                type: 'POST',
                url: 'resources/scripts/property/upload-images.php',
                data: formData,
                contentType: false,
                processData: false,
                beforeSend:function(){
                    $("#imgPreview").html('<h6><b class="text-info"><i class="fa fa-spinner fa-spin"></i>...uploading '+files.length+' files. Please, wait</b></h65><br>');
                },
                success:function(uploadResponse){
                    $.ajax({
                        type:'POST',
                        url:'resources/scripts/property/upload-images.php',
                        data:'action=load-images',
                        beforeSend:function(){
                            $("#imgPreview").html('<h6><b class="text-info">Loading...<i class="fa fa-spinner fa-spin"></i></b></h65><br>');
                        },
                        success:function(uploadResponse){
                            $("#imgPreview").html(uploadResponse);
                            $("#files").next('.custom-file-label').html('Browse Files').removeClass('is-invalid');
                            $("#files").removeClass('is-invalid');
                            $.ajax({
                            type:'POST',
                            url:'resources/scripts/property/data.php',
                            data:'action=check-uploaded-images',
                            success:function(responseDataDel){
                                $("#imagesSelected").val(responseDataDel);
                            }
                            });
                        }
                    });
                }
            });
        }
        else{
            var images = $("#imagesSelected").val();
            if(images){
            $("#files").removeClass('is-invalid');
            }
            else{
            $("#files").addClass('is-invalid');
            }
        }
    });
  
});