$(document).ready(function(){
	function isValidPhoneNumber(phoneNumber) {
		// Define the regex pattern for a valid Nigerian phone number.
		// This pattern matches phone numbers in the formats: 08168290811, 2348168290811, +2348168290811.
		const pattern = /^(?:\+?234|0)?(7\d|8\d|9\d)\d{8}$/;
		
		// Test the phone number against the regex pattern.
		return pattern.test(phoneNumber);
	}
    var currentPage = $("#currentPage").val();
    //alert(currentPage);
    ///////load the USERS DETAILS details////////////
    if(currentPage!='Website Setting' && currentPage!='Roles Setting'){
        $.ajax({
            type:'POST',
            url:'resources/scripts/settings/settings.php',
            data:'action=load-ambassadors&usertype='+currentPage,
            beforeSend: function(){
                $("#ambassadorDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
            },
            success:function(responseData){
                $("#ambassadorDetails").html(responseData);
            }
        });
 
        $("#refreshPage").on('click', function(){
            $.ajax({
                type:'POST',
                url:'resources/scripts/settings/settings.php',
                data:'action=load-ambassadors&usertype='+currentPage,
                beforeSend: function(){
                    $("#ambassadorDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                    $("#refreshPage").html('<i class="fas fa-sync-alt fa-spin"></i>').attr('disabled', 'disabled');
                },
                success:function(responseData){
                    $("#ambassadorDetails").html(responseData);
                    $("#refreshPage").html('<i class="fas fa-sync-alt"></i>').removeAttr('disabled');
                }
            });
        });
    }

    if(currentPage=='Website Setting'){
        $.ajax({
            type:'POST',
            url:'resources/scripts/settings/website.php',
            data:'action=load-website-setting&usertype='+currentPage,
            beforeSend: function(){
                $("#websiteDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
            },
            success:function(responseData){
                $("#websiteDetails").html(responseData);
            }
        });
 
        $("#refreshPage").on('click', function(){
            $.ajax({
                type:'POST',
                url:'resources/scripts/settings/website.php',
                data:'action=load-website-setting&usertype='+currentPage,
                beforeSend: function(){
                    $("#websiteDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                    $("#refreshPage").html('<i class="fas fa-sync-alt fa-spin"></i>').attr('disabled', 'disabled');
                },
                success:function(responseData){
                    $("#websiteDetails").html(responseData);
                    $("#refreshPage").html('<i class="fas fa-sync-alt"></i>').removeAttr('disabled');
                }
            });
        });
    }

    

    /////ADD NEW DEPT//////
    $(document).delegate("[data-target='#add-department']", "click", function() {
        $("#addDeptMsg").html('').removeClass('text-danger');
        $("#dept").removeClass('is-invalid');
    });
    $("#addDeptBtn").on('click', function(){
        var deptName = $("#dept").val();
        var errorMsg = '';
        /////check type///////
        if(deptName){
            $("#dept").removeClass('is-invalid');
            $.ajax({
                type: 'POST',
                url: 'resources/scripts/settings/website.php',
                data: 'action=check-dept&dept='+deptName,
                success: function(deptResponse){
                    if(deptResponse=='exists'){
                        errorMsg = '<i class="fa fa-times"></i> <b>'+deptName+'</b> already created';
                        $("#dept").addClass('is-invalid');
                        $("#addDeptMsg").html('<br>'+errorMsg).addClass('text-danger');
                    }
                    else{
                        $("#dept").removeClass('is-invalid');
                        $("#addDeptMsg").html('').removeClass('text-danger');

                        /////add the dept proper//////////////
                        $.ajax({
                            type: 'POST',
                            url: 'resources/scripts/settings/website.php',
                            data: 'action=add-dept&deptname='+deptName,
                            dataType: 'JSON',
                            beforeSend:function(){
                                $("#addDeptMsg").html('<br>Adding...<i class="fa fa-spinner fa-spin"></i>').addClass('text-info').removeClass('text-danger');
                            },
                            success:function(addDeptResponse){
                                if(addDeptResponse.header=='successful'){
                                    toastr.success('<b>'+deptName+'</b> successfully added');
                                    $("#addDeptMsg").html('').removeClass('text-danger');
                                    $("#dept").val('');
                                    $.ajax({
                                        type:'POST',
                                        url:'resources/scripts/settings/website.php',
                                        data:'action=load-depts',
                                        beforeSend: function(){
                                            $("#deptDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                                        },
                                        success:function(responseData){
                                            $("#deptDetails").html(responseData);
                                        }
                                    });
                                }
                                else{
                                    $("#addDeptMsg").html(addDeptResponse.message).addClass('text-danger').removeClass('text-info');
                                }
                            }
                        });
                    }
                }
            });
        }
        else{
            $("#dept").addClass('is-invalid');
            $("#addDeptMsg").html('<br><i class="fa fa-times"></i> Department name is required').addClass('text-danger');
        }

    });

    /////LOAD THE LIST OF DEPTS//////
    $(document).delegate("[data-target='#view-department']", "click", function() {
        $.ajax({
            type:'POST',
            url:'resources/scripts/settings/website.php',
            data:'action=load-depts',
            beforeSend: function(){
                $("#deptDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
            },
            success:function(responseData){
                $("#deptDetails").html(responseData);
            }
        });
    });

    $(document).delegate("[data-target='#edit-dept']", "click", function() {
        var name = $(this).attr('name');
        var id = $(this).attr('data-id');
        var title = $(this).attr('title');
        $("#editDeptHead").html(title);
        $("#editDeptName").val(name);
        $("#editOldDeptName").val(name);
        $("#editDeptId").val(id);
        $("#editDeptMsg").html('');
    });

    $("#editDeptBtn").on('click', function(){
        var deptId = $("#editDeptId").val();
        var deptName = $("#editDeptName").val();
        var oldDeptName = $("#editOldDeptName").val();

        if(deptName){
            $("#editDeptName").removeClass('is-invalid');
            $.ajax({
                type:'POST',
                url:'resources/scripts/settings/website.php',
                data:'action=edit-dept&deptid='+deptId+'&deptname='+deptName,
                dataType: 'JSON',
                beforeSend:function(){
                    $("#editDeptBtn").html('Saving...<i class="fa fa-spinner fa-spin"></i>');
                },
                success:function(editDeptResponse){
                    if(editDeptResponse.header==='successful'){
                        $("#editDeptMsg").html('');
                        toastr.success('<b>'+oldDeptName+'</b> '+editDeptResponse.message+' to <b>'+deptName+'</b>');
                        $("#editDeptBtn").html('<i class="fa fa-check"></i> Saved').attr('disabled', 'disabled');
                        
                        $('#edit-dept').modal('hide');
                        //////refresh the list///////////
                        $.ajax({
                            type:'POST',
                            url:'resources/scripts/settings/website.php',
                            data:'action=load-depts',
                            beforeSend: function(){
                                $("#deptDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                            },
                            success:function(responseData){
                                $("#deptDetails").html(responseData);
                            }
                        });
                        $("#editDeptBtn").html('<i class="fa fa-save"></i> Save').removeAttr('disabled');
                        $("#editDeptMsg").html('');
                    }
                    else{
                    $("#editDeptMsg").html('<br>'+editDeptResponse.message).addClass('text-danger').removeClass('text-success');
                    $("#editDeptBtn").html('<i class="fa fa-save"></i> Save');
                    }
                }
            });
        }
        else{
            $("#editDeptName").addClass('is-invalid');
        }
    });

    /////DELETE DEPT//////
    $(document).delegate("[data-target='#delete-dept']", "click", function() {
        var name = $(this).attr('name');
        var id = $(this).attr('data-id');
        var title = $(this).attr('title');
        $("#deleteDeptHead").html(title);
        $("#delDeptName").val(name);
        $("#delDept").html(name);
        $("#delDeptId").val(id);
        $("#delDeptMsg").html('');
    });

    $("#deleteDeptBtn").on('click', function(){
        var deptId = $("#delDeptId").val();
        var deptName = $("#delDeptName").val();

        if(deptId){
            $.ajax({
                type:'POST',
                url:'resources/scripts/settings/website.php',
                data:'action=delete-dept&deptid='+deptId+'&deptname='+deptName,
                dataType: 'JSON',
                beforeSend:function(){
                    $("#deleteDeptBtn").html('Deleting...<i class="fa fa-spinner fa-spin"></i>');
                },
                success:function(editCatResponse){
                    if(editCatResponse.header==='successful'){
                    $("#delDeptMsg").html('');
                    toastr.success('<b>'+deptName+'</b> was successfully deleted.');
                    $("#deleteDeptBtn").html('<i class="fa fa-check"></i> Deleted').attr('disabled', 'disabled');
                    $('#delete-dept').modal('hide');
                        //////refresh the list///////////
                        $.ajax({
                            type:'POST',
                            url:'resources/scripts/settings/website.php',
                            data:'action=load-depts',
                            beforeSend: function(){
                                $("#deptDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                            },
                            success:function(responseData){
                                $("#deptDetails").html(responseData);
                            }
                        });
                        $("#deleteDeptBtn").html('<i class="fa fa-trash"></i> Yes, Delete').removeAttr('disabled');
                        $("#delDeptMsg").html('');
                    }
                    else{
                        $("#delDeptMsg").html('<br>'+editCatResponse.message).addClass('text-danger').removeClass('text-success');
                        $("#deleteDeptBtn").html('<i class="fa fa-trash"></i> Try Again');
                    }
                }
            });
        }
    });

    /////PERMANENTLY DELETE DEPT////////////
    $(document).delegate("[data-target='#perm-delete-dept']", "click", function() {
        var name = $(this).attr('name');
        var id = $(this).attr('data-id');
        var title = $(this).attr('title');
        $("#permDeleteDeptHead").html(title);
        $("#permDelDeptName").val(name);
        $("#permDelDept").html(name);
        $("#permDelDeptId").val(id);
        $("#permDelDeptMsg").html('');
    });

    $("#permDeleteDeptBtn").on('click', function(){
        var deptId = $("#permDelDeptId").val();
        var deptName = $("#permDelDeptName").val();

        if(deptId){
            $.ajax({
                type:'POST',
                url:'resources/scripts/settings/website.php',
                data:'action=perm-delete-dept&deptid='+deptId+'&deptname='+deptName,
                dataType: 'JSON',
                beforeSend:function(){
                    $("#permDeleteDeptBtn").html('Deleting...<i class="fa fa-spinner fa-spin"></i>');
                },
                success:function(permDelResponse){
                    if(permDelResponse.header==='successful'){
                    $("#permDelDeptMsg").html('');
                    toastr.success('<b>'+deptName+'</b> was permanently deleted.');
                    $("#permDeleteDeptBtn").html('<i class="fa fa-check"></i> Deleted').attr('disabled', 'disabled');
                    $('#perm-delete-dept').modal('hide');
                        //////refresh the list///////////
                        $.ajax({
                            type:'POST',
                            url:'resources/scripts/settings/website.php',
                            data:'action=load-depts',
                            beforeSend: function(){
                                $("#deptDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                            },
                            success:function(responseData){
                                $("#deptDetails").html(responseData);
                            }
                        });
                        $("#permDeleteDeptBtn").html('<i class="fa fa-trash"></i> Yes, Delete').removeAttr('disabled');
                        $("#permDelDeptMsg").html('');
                    }
                    else{
                        $("#permDelDeptMsg").html('<br>'+permDelResponse.message).addClass('text-danger').removeClass('text-success');
                        $("#permDeleteDeptBtn").html('<i class="fa fa-trash"></i> Try Again');
                    }
                }
            });
        }
    });

    ///////restore deleted dept///////
    $(document).delegate("[data-target='#restore-dept']", "click", function() {
        var name = $(this).attr('name');
        var id = $(this).attr('data-id');
        var title = $(this).attr('title');
        $("#restoreDeptHead").html(title);
        $("#resDeptName").val(name);
        $("#resDept").html(name);
        $("#resDeptId").val(id);
        $("#resDeptMsg").html('');
    });

    $("#restoreDeptBtn").on('click', function(){
        var deptId = $("#resDeptId").val();
        var deptName = $("#resDeptName").val();

        if(deptId){
            $.ajax({
                type:'POST',
                url:'resources/scripts/settings/website.php',
                data:'action=restore-dept&deptid='+deptId+'&deptname='+deptName,
                dataType: 'JSON',
                beforeSend:function(){
                    $("#restoreDeptBtn").html('Restoring...<i class="fa fa-spinner fa-spin"></i>');
                },
                success:function(resDeptResponse){
                    if(resDeptResponse.header==='successful'){
                        $("#resDeptMsg").html('');
                        toastr.success('<b>'+deptName+'</b> was successfully restored.');
                        $("#restoreDeptBtn").html('<i class="fa fa-check"></i> Restored').attr('disabled', 'disabled');
                        $('#restore-dept').modal('hide');
                        //////refresh the list///////////
                        $.ajax({
                            type:'POST',
                            url:'resources/scripts/settings/website.php',
                            data:'action=load-depts',
                            beforeSend: function(){
                                $("#deptDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                            },
                            success:function(responseData){
                                $("#deptDetails").html(responseData);
                            }
                        });
                        $("#restoreDeptBtn").html('<i class="fa fa-save"></i> Yes, Restore').removeAttr('disabled');
                        $("#resDeptMsg").html('');
                    }
                    else{
                    $("#resDeptMsg").html('<br>'+resDeptResponse.message).addClass('text-danger').removeClass('text-success');
                    $("#restoreDeptBtn").html('<i class="fa fa-save"></i> Try Again');
                    }
                }
            });
        }
    });


    ////////////////ADD NEW USER DETAILS////////////////
	$.ajax({
		type:'POST',
		url:'../resources/scripts.php',
		data:'action=load-states',
		success:function(responseData){
			$("#addState").html(responseData);
			$('#addCity').html('<option value="">Select State first</option>');
		}
	});
	
	$("#addState").on('change', function(){
		var stateId = $(this).val();
		if(stateId){
			$("#addState").removeClass('is-invalid')
			$.ajax({
				type: 'POST',
				url:'resources/scripts/settings/website.php',
				data:'action=load-cities&stateid='+stateId,
				success:function(responseData){
					$("#addCity").html(responseData);
				}
			});
		}
		else{
			$("#addCity").html('<option value="">Select State First</option>');
			$("#addState").addClass('is-invalid');
		}
	});
    $(document).delegate("[data-target='#add-user']", "click", function() {
        var selectedType = $(this).attr('data-id');
		
		$("#addUserType").val(currentPage);
		$("#addUserTitle").html(currentPage);
    });
	
    $("#addUserBtn").on('click', function(){
        $("#addUserMsg").html('');
		let formdata = new FormData();
        var errorMsg = '';
        var userType = $("#addUserType").val();
        var firstName = $("#addFirstName").val();
        
        if(firstName){
            $("#addFirstName").removeClass('is-invalid');
			formdata.append('firstname',firstName);
        }
        else{
            $("#addFirstName").addClass('is-invalid');
            if(errorMsg==''){
                errorMsg += '<i class="fa fa-times"></i> First name is required';
            }
            else{
                errorMsg += '<br><i class="fa fa-times"></i> First name is required';
            }
        }
        var lastName = $("#addLastName").val();
        if(lastName){
            $("#addLastName").removeClass('is-invalid');
			formdata.append('lastname',lastName);
        }
        else{
            $("#addLastName").addClass('is-invalid');
            if(errorMsg==''){
                errorMsg += '<i class="fa fa-times"></i> Last name is required';
            }
            else{
                errorMsg += '<br><i class="fa fa-times"></i> Last name is required';
            }
        }
        var middleName = $("#addMiddleName").val();
		if(middleName){
			formdata.append('middlename',middleName);
		}
		else{
			formdata.append('middlename','');
		}
        var title = $("#addTitle").val();
        if(title){
            $("#addTitle").removeClass('is-invalid');
			formdata.append('title',title);
        }
        else{
            $("#addTitle").addClass('is-invalid');
            if(errorMsg==''){
                errorMsg += '<i class="fa fa-times"></i> Title is required';
            }
            else{
                errorMsg += '<br><i class="fa fa-times"></i> Title is required';
            }
        }
        var gender = $("#addGender").val();
        if(gender){
            $("#addGender").removeClass('is-invalid');
			formdata.append('gender',gender);
        }
        else{
            $("#addGender").addClass('is-invalid');
            if(errorMsg==''){
                errorMsg += '<i class="fa fa-times"></i> Gender is required';
            }
            else{
                errorMsg += '<br><i class="fa fa-times"></i> Gender is required';
            }
        }
        var phone = $("#addPhone").val();
		if(phone){
			if(isValidPhoneNumber(phone)){
				$("#addPhone").removeClass('is-invalid');
				formdata.append('phone',phone);
			}
			else{
				$("#addPhone").addClass('is-invalid');
				if(errorMsg==''){
					errorMsg += '<i class="fa fa-times"></i> Invalid Phone Number';
				}
				else{
					errorMsg += '<br><i class="fa fa-times"></i> Invalid Phone Number';
				}
			}
		}
		else{
			$("#addPhone").addClass('is-invalid');
			if(errorMsg==''){
				errorMsg += '<i class="fa fa-times"></i>Phone Number required';
			}
			else{
				errorMsg += '<br><i class="fa fa-times"></i> Phone Number required';
			}
		}
        var email = $("#addEmail").val();
        if(email){
            if(/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(email)){
                $("#addEmail").removeClass('is-invalid');
				formdata.append('email',email);
            }
            else{
                if(errorMsg){
                    errorMsg += '<br><i class="fa fa-times"></i> Invalid Email';
                }
                else{
                    errorMsg += '<i class="fa fa-times"></i> Invalid Email';
                }
            }
        }
        else{
            $("#addEmail").addClass('is-invalid');
            if(errorMsg==''){
                errorMsg += '<i class="fa fa-times"></i> Email is required';
            }
            else{
                errorMsg += '<br><i class="fa fa-times"></i> Email is required';
            }
        }
        
        var addState = $("#addState").val();
		if(addState){
			$("#addState").removeClass('is-invalid');
			formdata.append('state',addState);
		}
		else{
			$("#addState").addClass('is-invalid');
			if(errorMsg==''){
				errorMsg += '<i class="fa fa-times"></i> State is Required';
			}
			else{
				errorMsg += '<br><i class="fa fa-times"></i> Please Select State';
			}
		}
		
		var addCity = $("#addCity").val();
		if(addCity){
			$("#addCity").removeClass('is-invalid');
			formdata.append('city',addCity);
		}
		else{
			$("#addCity").addClass('is-invalid');
			if(errorMsg==''){
				errorMsg += '<i class="fa fa-times"></i> City/LGA is Required';
			}
			else{
				errorMsg += '<br><i class="fa fa-times"></i> Please Select City/LGA';
			}
		}
		var addAddress = $("#addAddress").val();
		if(addAddress){
			$("#addAddress").removeClass('is-invalid');
			formdata.append('address',addAddress);
		}
		else{
			$("#addAddress").addClass('is-invalid');
			if(errorMsg==''){
				errorMsg += '<i class="fa fa-times"></i> Enter Address';
			}
			else{
				errorMsg += '<br><i class="fa fa-times"></i> Enter Address';
			}
		}

        if(!errorMsg){
			formdata.append('action','add-user-submit');
            $.ajax({
                type:'POST',
                url:'resources/scripts/settings/settings.php',
                data: formdata,
				contentType: false,
				processData: false,
				dataType:'JSON',
                beforeSend:function(){
                    $("#addUserBtn").html('Saving...<i class="fa fa-spinner fa-spin"></i>');
                },
                success:function(addUserResponse){
                    if(addUserResponse.header==='successful'){
                        $("#addUserMsg").html('').removeClass('text-success').removeClass('text-danger');
                    
                        toastr.success('Details for <b>'+firstName+' '+lastName+'</b> successfully added');
                    
                        $("#addUserBtn").html('<i class="fa fa-check"></i> Saved').attr('disabled', 'disabled');
                        //$('#add-user').modal('hide');
                        $("#addUserBtn").html('<i class="fa fa-save"></i> Save').removeAttr('disabled');

                        //////reset the for//////////
                        $("#addFirstName").val('');
                        $("#addLastName").val('');
                        $("#addMiddleName").val('');
                        $("#addEmail").val('');
                        $("#addPhone").val('');

                        //////refresh the list///////////
                        $.ajax({
                            type:'POST',
                            url:'resources/scripts/settings/settings.php',
                            data:'action=load-ambassadors&usertype='+currentPage,
                            beforeSend: function(){
                                $("#ambassadorDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                            },
                            success:function(responseData){
                                $("#ambassadorDetails").html(responseData);
                            }
                        });
                        $("#addUserMsg").html('');
                    }
                    else{
                        $("#addUserMsg").html('<br>'+addUserResponse.message).addClass('text-danger').removeClass('text-success');
                        $("#addUserBtn").html('<i class="fa fa-save"></i> Save');
                    }
                }
            });
        }
        else{
            //$("#addUserMsg").html(errorMsg).addClass('text-danger');
        }
        //alert(userType);
    });

    ////////////////EDIT USER RECORDS///////////////
    $(document).delegate("[data-target='#edit-user']", "click", function() {
        var name = $(this).attr('name');
        var userid = $(this).attr('data-id');
        $("#editUserId").val(userid);
        $("#editName").html(name);

        
        $.ajax({
            type:'POST',
            url:'resources/scripts/settings/settings.php',
            data:'action=edit-user&userid='+userid,
            dataType: 'JSON',
            success:function(editUserResponse){
                if(editUserResponse.header=='error'){

                }
                else{
                    $("#editLastName").val(editUserResponse.last_name);
                    $("#editFirstName").val(editUserResponse.first_name);
                    $("#editMiddleName").val(editUserResponse.middle_name);
                    $("#editPhone").val(editUserResponse.phone);
                    $("#editEmail").val(editUserResponse.email);
                    $("#editUserId").val(editUserResponse.unique_id);

                    $.ajax({
                        type:'POST',
                        url:'resources/scripts/settings/settings.php',
                        data:'action=edit-user-title&title='+editUserResponse.title,
                        success:function(editUserTitle){
                            $("#editTitle").html(editUserTitle);
                        }
                    });
                    $.ajax({
                        type:'POST',
                        url:'resources/scripts/settings/settings.php',
                        data:'action=edit-user-gender&gender='+editUserResponse.gender,
                        success:function(editUserGender){
                            $("#editGender").html(editUserGender);
                        }
                    });
                    
                }
            }
        });
    });

    $("#editUserBtn").on('click', function(){
        var userId = $("#editUserId").val();
        var firstName = $("#editFirstName").val();
        var errorMsg = '';
        if(firstName){
            $("#editFirstName").removeClass('is-invalid');
        }
        else{
            $("#editFirstName").addClass('is-invalid');
            errorMsg += '<i class="fa fa-times"></i> First name is required';
        }
        var lastName = $("#editLastName").val();
        if(lastName){
            $("#editLastName").removeClass('is-invalid');
        }
        else{
            $("#editLastName").addClass('is-invalid');
            if(errorMsg==''){
                errorMsg += '<i class="fa fa-times"></i> Last name is required';
            }
            else{
                errorMsg += '<br><i class="fa fa-times"></i> Last name is required';
            }
        }
        var middleName = $("#editMiddleName").val();
        var title = $("#editTitle").val();
        if(title){
            $("#editTitle").removeClass('is-invalid');
        }
        else{
            $("#editTitle").addClass('is-invalid');
            if(errorMsg==''){
                errorMsg += '<i class="fa fa-times"></i> Title is required';
            }
            else{
                errorMsg += '<br><i class="fa fa-times"></i> Title is required';
            }
        }
        var gender = $("#editGender").val();
        if(gender){
            $("#editGender").removeClass('is-invalid');
        }
        else{
            $("#editGender").addClass('is-invalid');
            if(errorMsg==''){
                errorMsg += '<i class="fa fa-times"></i> Gender is required';
            }
            else{
                errorMsg += '<br><i class="fa fa-times"></i> Gender is required';
            }
        }
        var email = $("#editEmail").val();
        if(email){
            if(/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(email)){
                //
                ////check to ensure no other person is already using this email since this is a unique field///////////////
                $.ajax({
                    type: 'POST',
                    url: 'resources/scripts/settings/settings.php',
                    data: 'action=validate-email&email='+email+'&userid='+userId,
                    success: function(emailResp){
                        if(emailResp=='exists'){
                            if(errorMsg){
                                errorMsg = '<br><i class="fa fa-times"></i> Email already in use by another user';
                            }
                            else{
                                errorMsg = '<i class="fa fa-times"></i> Email already in use by another user';
                            }
                        }
                        else{
                            $("#editEmail").removeClass('is-invalid');
                        }
                    }
                });
            }
            else{
                if(errorMsg){
                    errorMsg = '<br><i class="fa fa-times"></i> Invalid Email';
                }
                else{
                    errorMsg = '<i class="fa fa-times"></i> Invalid Email';
                }
            }
        }
        else{
            $("#editEmail").addClass('is-invalid');
            if(errorMsg==''){
                errorMsg += '<i class="fa fa-times"></i> Email is required';
            }
            else{
                errorMsg += '<br><i class="fa fa-times"></i> Email is required';
            }
        }
        var phone = $("#editPhone").val();
        if(phone){
            $("#editPhone").removeClass('is-invalid');
        }
        else{
            $("#editPhone").addClass('is-invalid');
        }

        if(!errorMsg){
            
            $.ajax({
                type:'POST',
                url:'resources/scripts/settings/settings.php',
                data:'action=edit-user-submit&userid='+userId+'&lastname='+lastName+'&firstname='+firstName+'&middlename='+middleName+'&title='+title+'&gender='+gender+'&email='+email+'&phone='+phone,
                dataType: 'JSON',
                beforeSend:function(){
                    $("#editUserBtn").html('Saving...<i class="fa fa-spinner fa-spin"></i>');
                },
                success:function(editUserResponse){
                    if(editUserResponse.header==='successful'){
                        $("#editUserMsg").html('').removeClass('text-success').removeClass('text-danger');
                    
                        toastr.success('User details successfully updated');
                        $("#editUserBtn").html('<i class="fa fa-check"></i> Saved').attr('disabled', 'disabled');
                        $('#edit-user').modal('hide');
                        $("#editUserBtn").html('<i class="fa fa-save"></i> Save').removeAttr('disabled');
                        //////refresh the list///////////
                        $.ajax({
                            type:'POST',
                            url:'resources/scripts/settings/settings.php',
                            data:'action=load-ambassadors&usertype='+currentPage,
                            beforeSend: function(){
                                $("#ambassadorDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                            },
                            success:function(responseData){
                                $("#ambassadorDetails").html(responseData);
                            }
                        });
                        $("#editUserMsg").html('');
                    }
                    else{
                    $("#editUserMsg").html('<br>'+editUserResponse.message).addClass('text-danger').removeClass('text-success');
                    $("#editUserBtn").html('<i class="fa fa-save"></i> Save');
                    }
                }
            });
        }
        else{
            $("#editUserMsg").html(errorMsg).addClass('text-danger');
        }
    });

    /////RESEND MAIL TO USER//////
    $(document).delegate("[data-target='#resend-mail']", "click", function() {
        var name = $(this).attr('name');
        var id = $(this).attr('data-id');
        var title = $(this).attr('title');
        $("#resendUserHead").html(title);
        $("#resendUserName").val(name);
        $("#resendUser").html(name);
        $("#resendUserId").val(id);
        $("#resendUserMsg").html('');
    });

    $("#resendUserBtn").on('click', function(){
        var userId = $("#resendUserId").val();
        var userName = $("#resendUserName").val();

        if(userId){
            $.ajax({
                type:'POST',
                url:'resources/scripts/settings/settings.php',
                data:'action=resend-mail&userid='+userId+'&username='+userName,
                dataType: 'JSON',
                beforeSend:function(){
                    $("#resendUserBtn").html('Sending Mail...<i class="fa fa-spinner fa-spin"></i>');
                },
                success:function(resendUserResponse){
                    if(resendUserResponse.header==='successful'){
                    $("#resendUserMsg").html('');
                    toastr.success('Login details successfully sent to <b>'+userName+'</b>.');
                    $("#resendUserBtn").html('<i class="fa fa-check"></i> Mail Sent').attr('disabled', 'disabled');
                    $('#resend-mail').modal('hide');
                        //////refresh the list///////////
                        $.ajax({
                            type:'POST',
                            url:'resources/scripts/settings/settings.php',
                            data:'action=load-ambassadors&usertype='+currentPage,
                            beforeSend: function(){
                                $("#ambassadorDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                            },
                            success:function(responseData){
                                $("#ambassadorDetails").html(responseData);
                            }
                        });
                        $("#resendUserBtn").html('<i class="fa fa-send"></i> Yes, Send Mail').removeAttr('disabled');
                        $("#resendUserMsg").html('');
                    }
                    else{
                    $("#resendUserMsg").html('<br>'+resendUserResponse.message).addClass('text-danger').removeClass('text-success');
                    $("#resendUserBtn").html('<i class="fa fa-send"></i> Try Again');
                    }
                }
            });
        }
    });
    /////SUSPEND USER RECORD//////
    $(document).delegate("[data-target='#suspend-user']", "click", function() {
        var name = $(this).attr('name');
        var id = $(this).attr('data-id');
        var title = $(this).attr('title');
        $("#suspendUserHead").html(title);
        $("#susUserName").val(name);
        $("#susUser").html(name);
        $("#susUserId").val(id);
        $("#susUserMsg").html('');
    });

    $("#suspendUserBtn").on('click', function(){
        var userId = $("#susUserId").val();
        var userName = $("#susUserName").val();

        if(userId){
            $.ajax({
                type:'POST',
                url:'resources/scripts/settings/settings.php',
                data:'action=suspend-user&userid='+userId+'&username='+userName,
                dataType: 'JSON',
                beforeSend:function(){
                    $("#suspendUserBtn").html('Suspending...<i class="fa fa-spinner fa-spin"></i>');
                },
                success:function(susUserResponse){
                    if(susUserResponse.header==='successful'){
                    $("#susUserMsg").html('');
                    toastr.success('<b>'+userName+'</b> was successfully suspended.');
                    $("#suspendUserBtn").html('<i class="fa fa-check"></i> Suspended').attr('disabled', 'disabled');
                    $('#suspend-user').modal('hide');
                        //////refresh the list///////////
                        $.ajax({
                            type:'POST',
                            url:'resources/scripts/settings/settings.php',
                            data:'action=load-ambassadors&usertype='+currentPage,
                            beforeSend: function(){
                                $("#ambassadorDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                            },
                            success:function(responseData){
                                $("#ambassadorDetails").html(responseData);
                            }
                        });
                        $("#suspendUserBtn").html('<i class="fa fa-trash"></i> Yes, Suspend').removeAttr('disabled');
                        $("#susUserMsg").html('');
                    }
                    else{
                    $("#susUserMsg").html('<br>'+susUserResponse.message).addClass('text-danger').removeClass('text-success');
                    $("#suspendUserBtn").html('<i class="fa fa-trash"></i> Try Again');
                    }
                }
            });
        }
    });
    /////DELETE USER RECORD//////
    $(document).delegate("[data-target='#delete-user']", "click", function() {
        var name = $(this).attr('name');
        var id = $(this).attr('data-id');
        var title = $(this).attr('title');
        $("#deleteUserHead").html(title);
        $("#delUserName").val(name);
        $("#delUser").html(name);
        $("#delUserId").val(id);
        $("#delUserMsg").html('');
    });

    $("#deleteUserBtn").on('click', function(){
        var userId = $("#delUserId").val();
        var userName = $("#delUserName").val();

        if(userId){
            $.ajax({
                type:'POST',
                url:'resources/scripts/settings/settings.php',
                data:'action=delete-user&userid='+userId+'&username='+userName,
                dataType: 'JSON',
                beforeSend:function(){
                    $("#deleteUserBtn").html('Deleting...<i class="fa fa-spinner fa-spin"></i>');
                },
                success:function(delUserResponse){
                    if(delUserResponse.header==='successful'){
                    $("#delUserMsg").html('');
                    toastr.success('<b>'+userName+'</b> was successfully deleted.');
                    $("#deleteUserBtn").html('<i class="fa fa-check"></i> Deleted').attr('disabled', 'disabled');
                    $('#delete-user').modal('hide');
                        //////refresh the list///////////
                        $.ajax({
                            type:'POST',
                            url:'resources/scripts/settings/settings.php',
                            data:'action=load-ambassadors&usertype='+currentPage,
                            beforeSend: function(){
                                $("#ambassadorDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                            },
                            success:function(responseData){
                                $("#ambassadorDetails").html(responseData);
                            }
                        });
                        $("#deleteUserBtn").html('<i class="fa fa-trash"></i> Yes, Delete').removeAttr('disabled');
                        $("#delUserMsg").html('');
                    }
                    else{
                    $("#delUserMsg").html('<br>'+delUserResponse.message).addClass('text-danger').removeClass('text-success');
                    $("#deleteUserBtn").html('<i class="fa fa-trash"></i> Try Again');
                    }
                }
            });
        }
    });

    /////PERMANENTLY DELETE USER////////////
    $(document).delegate("[data-target='#perm-delete-user']", "click", function() {
        var name = $(this).attr('name');
        var id = $(this).attr('data-id');
        var title = $(this).attr('title');
        $("#permDeleteUserHead").html(title);
        $("#permDelUserName").val(name);
        $("#permDelUser").html(name);
        $("#permDelUserId").val(id);
        $("#permDelUserMsg").html('');
    });

    $("#permDeleteUserBtn").on('click', function(){
        var userId = $("#permDelUserId").val();
        var userName = $("#permDelUserName").val();

        if(userId){
            $.ajax({
                type:'POST',
                url:'resources/scripts/settings/settings.php',
                data:'action=perm-delete-user&userid='+userId+'&username='+userName,
                dataType: 'JSON',
                beforeSend:function(){
                    $("#permDeleteUserBtn").html('Deleting...<i class="fa fa-spinner fa-spin"></i>');
                },
                success:function(permDelResponse){
                    if(permDelResponse.header==='successful'){
                    $("#permDelUserMsg").html('');
                    toastr.success('<b>'+userName+'</b> was permanently deleted.');
                    $("#permDeleteUserBtn").html('<i class="fa fa-check"></i> Deleted').attr('disabled', 'disabled');
                    $('#perm-delete-user').modal('hide');
                        //////refresh the list///////////
                        $.ajax({
                            type:'POST',
                            url:'resources/scripts/settings/settings.php',
                            data:'action=load-ambassadors&usertype='+currentPage,
                            beforeSend: function(){
                                $("#ambassadorDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                            },
                            success:function(responseData){
                                $("#ambassadorDetails").html(responseData);
                            }
                        });
                        $("#permDeleteUserBtn").html('<i class="fa fa-trash"></i> Yes, Delete').removeAttr('disabled');
                        $("#permDelUserMsg").html('');
                    }
                    else{
                    $("#permDelUserMsg").html('<br>'+permDelResponse.message).addClass('text-danger').removeClass('text-success');
                    $("#permDeleteUserBtn").html('<i class="fa fa-trash"></i> Try Again');
                    }
                }
            });
        }
    });

    ///////restore deleted user type///////
    $(document).delegate("[data-target='#restore-user']", "click", function() {
        var name = $(this).attr('name');
        var id = $(this).attr('data-id');
        var title = $(this).attr('title');
        $("#restoreUserHead").html(title);
        $("#resUserName").val(name);
        $("#resUser").html(name);
        $("#resUserId").val(id);
        $("#resUserMsg").html('');
    });

    $("#restoreUserBtn").on('click', function(){
        var userId = $("#resUserId").val();
        var userName = $("#resUserName").val();

        if(userId){
            $.ajax({
                type:'POST',
                url:'resources/scripts/settings/settings.php',
                data:'action=restore-user&userid='+userId+'&username='+userName,
                dataType: 'JSON',
                beforeSend:function(){
                    $("#restoreUserBtn").html('Restoring...<i class="fa fa-spinner fa-spin"></i>');
                },
                success:function(resUserResponse){
                    if(resUserResponse.header==='successful'){
                        $("#resUserMsg").html('');
                        toastr.success('<b>'+userName+'</b> was successfully restored.');
                        $("#restoreUserBtn").html('<i class="fa fa-check"></i> Restored').attr('disabled', 'disabled');
                        $('#restore-user').modal('hide');
                        //////refresh the list///////////
                        $.ajax({
                            type:'POST',
                            url:'resources/scripts/settings/settings.php',
                            data:'action=load-ambassadors&usertype='+currentPage,
                            beforeSend: function(){
                                $("#ambassadorDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                            },
                            success:function(responseData){
                                $("#ambassadorDetails").html(responseData);
                            }
                        });
                        $("#restoreUserBtn").html('<i class="fa fa-save"></i> Yes, Restore').removeAttr('disabled');
                        $("#resUserMsg").html('');
                    }
                    else{
                    $("#resUserMsg").html('<br>'+resUserResponse.message).addClass('text-danger').removeClass('text-success');
                    $("#restoreUserBtn").html('<i class="fa fa-save"></i> Try Again');
                    }
                }
            });
        }
    });

    ///////////////////WEBSITE SETTING//////////////
    $(document).delegate("[data-target='#edit-website']", "click", function() {
        var name = $(this).attr('name');
        var id = $(this).attr('data-id');
        var title = $(this).attr('title');
        var action = $(this).attr('action');
        if(action){
            $("#editContentId").val(action);
        }
        $("#editWebsiteHead").html('Edit '+title);
        $("#editWebsiteName").val(name);
        $("#editOldWebsiteName").val(name);
        $("#editWebsiteId").val(id);
        $("#editWebsiteLabel").html(title);
        $("#editContentName").val(title);
        $("#editWebsiteMsg").html('');

        

        if(id=='time_zone' || id=='country' || id=='state' || id=='city'){
            $("#textChange").attr('style', 'display:none;');

            if(id=='time_zone'){
                $("#timeZone").attr('style', 'display:block;');
                $("#stateChange").attr('style', 'display:none;');
                $("#cityChange").attr('style', 'display:none;');
                $("#countryChange").attr('style', 'display:none;');
                
                $.ajax({
                    type: 'POST',
                    url:'resources/scripts/settings/website.php',
                    data:'action=countries-load&timezone='+name,
                    success:function(responseData){
                        $("#countryTimeZone").html(responseData);
                        $.ajax({
                            type: 'POST',
                            url:'resources/scripts/settings/website.php',
                            data:'action=load-time-zones&timezone='+name,
                            success:function(responseData){
                                $("#editWebsiteNameTimeZone").html(responseData);
                            }
                        });
                    }
                });
            }
            else if(id=='country'){
                $("#timeZone").attr('style', 'display:none;');
                $("#stateChange").attr('style', 'display:none;');
                $("#cityChange").attr('style', 'display:none;');
                $("#countryChange").attr('style', 'display:block;');

                $.ajax({
                    type: 'POST',
                    url:'resources/scripts/settings/website.php',
                    data:'action=countries-load&country='+name+'&countryid='+action,
                    success:function(responseData){
                        $("#editWebsiteNameCountry").html(responseData);
                    }
                });

            }
            else if(id=='state'){
                $("#timeZone").attr('style', 'display:none;');
                $("#stateChange").attr('style', 'display:block;');
                $("#cityChange").attr('style', 'display:none;');
                $("#countryChange").attr('style', 'display:none;');
                
                $.ajax({
                    type: 'POST',
                    url:'resources/scripts/settings/website.php',
                    data:'action=countries-load&state='+name+'&stateid='+action,
                    success:function(responseData){
                        $("#countryState").html(responseData);
                        $.ajax({
                            type: 'POST',
                            url:'resources/scripts/settings/website.php',
                            data:'action=load-states&state='+name+'&stateid='+action,
                            success:function(responseData){
                                $("#editWebsiteNameState").html(responseData);
                            }
                        });
                    }
                });
            }
            else if(id=='city'){
                $("#timeZone").attr('style', 'display:none;');
                $("#stateChange").attr('style', 'display:none;');
                $("#cityChange").attr('style', 'display:block;');
                $("#countryChange").attr('style', 'display:none;');

                $.ajax({
                    type: 'POST',
                    url:'resources/scripts/settings/website.php',
                    data:'action=countries-load&city='+name+'&cityid='+action,
                    success:function(responseData){
                        $("#countryCity").html(responseData);
                        $.ajax({
                            type: 'POST',
                            url:'resources/scripts/settings/website.php',
                            data:'action=load-states-city&city='+name+'&cityid='+action,
                            success:function(responseData){
                                $("#editWebsiteNameCityState").html(responseData);
                            }
                        });

                        $.ajax({
                            type: 'POST',
                            url:'resources/scripts/settings/website.php',
                            data:'action=load-cities&city='+name+'&cityid='+action,
                            success:function(responseData){
                                $("#editWebsiteNameCity").html(responseData);
                            }
                        });
                    }
                });
            }
        }
        else{
            $("#textChange").attr('style', 'display:block;');
            $("#timeZone").attr('style', 'display:none;');
            $("#stateChange").attr('style', 'display:none;');
            $("#cityChange").attr('style', 'display:none;');
            $("#countryChange").attr('style', 'display:none;');

        }
    });

    ////////generate states on change of country///////////////////////
    $("#countryCity").on('change', function(){
        var countryId = $(this).val();
        if(countryId){
            $("#editWebsiteNameCity").html('<option value="">Select State First</option>');
            $.ajax({
                type: 'POST',
                url:'resources/scripts/settings/website.php',
                data:'action=load-states&countryid='+countryId,
                success:function(responseData){
                    $("#editWebsiteNameCityState").html(responseData);
                }
            });
        }
        else{
            $("#editWebsiteNameCityState").html('<option value="">Select Country First</option>');
        }
    });

    ////////generate cities on change of state///////////////////////
    $("#editWebsiteNameCityState").on('change', function(){
        var stateId = $(this).val();
        if(stateId){
            $.ajax({
                type: 'POST',
                url:'resources/scripts/settings/website.php',
                data:'action=load-cities&stateid='+stateId,
                success:function(responseData){
                    $("#editWebsiteNameCity").html(responseData);
                }
            });
        }
        else{
            $("#editWebsiteNameCity").html('<option value="">Select State First</option>');
        }
    });

    ////////generate timezone on country change//////////
    $("#countryTimeZone").on('change', function(){
        var country = $(this).val();
        
        if(country){
            $("#countryTimeZone").removeClass('is-invalid');
            $.ajax({
                type: 'POST',
                url:'resources/scripts/settings/website.php',
                data:'action=load-country-time-zones&countryid='+country,
                success:function(responseData){
                    $("#editWebsiteNameTimeZone").html(responseData);
                }
            });
        }
        else{
            $("#editWebsiteNameTimeZone").html('<option value="">You must select country first</option>');
            $("#countryTimeZone").addClass('is-invalid');
        }
    })

    $("#countryState").on('change', function(){
        var country = $(this).val();
        //alert(country);
        if(country){
            $("#countryState").removeClass('is-invalid');
            $.ajax({
                type: 'POST',
                url:'resources/scripts/settings/website.php',
                data:'action=load-country-states&countryid='+country,
                success:function(responseData){
                    //alert(responseData);
                    $("#editWebsiteNameState").html(responseData);
                }
            });
        }
        else{
            $("#countryState").addClass('is-invalid');
        }
    })
        

    $("#editWebsiteBtn").on('click', function(){
        var websiteId = $("#editWebsiteId").val();
        var editContentName = $("#editContentName").val();
        var editOldWebsiteName = $("#editOldWebsiteName").val();
        

        if(websiteId=='time_zone' || websiteId=='country' || websiteId=='state' || websiteId=='city'){
            if(websiteId=='time_zone'){
                var websiteName = $("#editWebsiteNameTimeZone").val();
                if(websiteName){
                    $("#editWebsiteNameTimeZone").removeClass('is-invalid');
                }
                else{
                    $("#editWebsiteNameTimeZone").addClass('is-invalid');
                }
            }
            else if(websiteId=='country'){
                var websiteName = $("#editWebsiteNameCountry").val();
            }
            else if(websiteId=='state'){
                var websiteName = $("#editWebsiteNameState").val();
            }
            else if(websiteId=='city'){
                var websiteName = $("#editWebsiteNameCity").val();
            }
        }
        else{
            var websiteName = $("#editWebsiteName").val();
            if(websiteName){
                $("#editWebsiteName").removeClass('is-invalid');
            }
            else{
                $("#editWebsiteName").addClass('is-invalid');
            }
        }

        if(websiteName){
            $("#editWebsiteName").removeClass('is-invalid');
            $.ajax({
                type:'POST',
                url:'resources/scripts/settings/website.php',
                data:'action=edit-website&websiteid='+websiteId+'&websitename='+websiteName+'&oldname='+editOldWebsiteName,
                dataType: 'JSON',
                beforeSend:function(){
                    $("#editWebsiteBtn").html('Saving...<i class="fa fa-spinner fa-spin"></i>');
                },
                success:function(editWebsiteResponse){
                    if(editWebsiteResponse.header==='successful'){
                        $("#editWebsiteMsg").html('');
                        toastr.success('<b>'+editContentName+'</b> '+editWebsiteResponse.message);
                        $("#editWebsiteBtn").html('<i class="fa fa-check"></i> Saved').attr('disabled', 'disabled');
                        
                        $('#edit-website').modal('hide');
                        //////refresh the list///////////
                        $.ajax({
                            type:'POST',
                            url:'resources/scripts/settings/website.php',
                            data:'action=load-website-setting',
                            beforeSend: function(){
                                $("#websiteDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                            },
                            success:function(responseData){
                                $("#websiteDetails").html(responseData);
                            }
                        });
                        $("#editWebsiteBtn").html('<i class="fa fa-save"></i> Save').removeAttr('disabled');
                        $("#editWebsiteMsg").html('');
                    }
                    else{
                        $("#editWebsiteMsg").html('<br>'+editWebsiteResponse.message).addClass('text-danger').removeClass('text-success');
                        $("#editWebsiteBtn").html('<i class="fa fa-save"></i> Save');
                    }
                }
            });
        }
    });


    ////////ROLES AND PRIVILEGES SETTING/////////
    if(currentPage=='Roles Setting'){
        $.ajax({
            type:'POST',
            url:'resources/scripts/settings/roles.php',
            data:'action=load-roles',
            beforeSend: function(){
                $("#roleDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
            },
            success:function(responseData){
                $("#roleDetails").html(responseData);
            }
        });
 
        $("#refreshPage").on('click', function(){
            $.ajax({
                type:'POST',
                url:'resources/scripts/settings/roles.php',
                data:'action=load-roles',
                beforeSend: function(){
                    $("#roleDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                    $("#refreshPage").html('<i class="fas fa-sync-alt fa-spin"></i>').attr('disabled', 'disabled');
                },
                success:function(responseData){
                    $("#roleDetails").html(responseData);
                    $("#refreshPage").html('<i class="fas fa-sync-alt"></i>').removeAttr('disabled');
                }
            });
        });

        $(".websiteSetting").on('click', function(){
            var id = $(this).attr('data-id');
        });

        /////ADD NEW USER TYPE//////
        $("#addTypeBtn").on('click', function(){
            var typeName = $("#userType").val();
            var errorMsg = '';
            /////check type///////
            if(typeName){
                $.ajax({
                    type: 'POST',
                    url: 'resources/scripts/settings/settings.php',
                    data: 'action=check-user-type&usertype='+typeName,
                    success: function(typeResponse){
                        if(typeResponse=='exists'){
                            errorMsg = '<i class="fa fa-times"></i> <b>'+typeName+'</b> already created';
                            $("#userType").addClass('is-invalid');
                            $("#addTypeMsg").html('<br>'+errorMsg).addClass('text-danger');
                        }
                        else{
                            $("#userType").removeClass('is-invalid');
                            $("#addTypeMsg").html('').removeClass('text-danger');

                            /////add the user type proper//////////////
                            $.ajax({
                                type: 'POST',
                                url: 'resources/scripts/settings/settings.php',
                                data: 'action=add-user-type&usertype='+typeName,
                                dataType: 'JSON',
                                beforeSend:function(){
                                    $("#addTypeMsg").html('<br>Adding...<i class="fa fa-spinner fa-spin"></i>').addClass('text-info').removeClass('text-danger');
                                },
                                success:function(addTypeResponse){
                                    if(addTypeResponse.header=='successful'){
                                        toastr.success('<b>'+typeName+'</b> successfully added');
                                        $("#addTypeMsg").html('').removeClass('text-danger');
                                        $("#userType").val('');
                                    }
                                    else{
                                        $("#addTypeMsg").html(addTypeResponse.message).addClass('text-danger').removeClass('text-info');
                                    }
                                }
                            });
                        }
                    }
                });
            }
            else{
                $("#userType").addClass('is-invalid');
                errorMsg = '<i class="fa fa-times"></i> User Type is required';
            }

            if(!errorMsg){

            }
            else{
                $("#addTypeMsg").html('<br>'+errorMsg).addClass('text-danger');
            }
        });

        /////LOAD THE LIST OF USER TYPES//////
        $(document).delegate("[data-target='#user-types']", "click", function() {
            $.ajax({
                type:'POST',
                url:'resources/scripts/settings/settings.php',
                data:'action=load-user-types',
                beforeSend: function(){
                    $("#userTypeDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                },
                success:function(responseData){
                    $("#userTypeDetails").html(responseData);
                }
            });
        });

        $(document).delegate("[data-target='#edit-user-type']", "click", function() {
            var name = $(this).attr('name');
            var id = $(this).attr('data-id');
            var title = $(this).attr('title');
            $("#editUserTypeHead").html(title);
            $("#editUserTypeName").val(name);
            $("#editOldUserTypeName").val(name);
            $("#editUserTypeId").val(id);
            $("#editUserTypeMsg").html('');
        });

        $("#editUserTypeBtn").on('click', function(){
            var userTypeId = $("#editUserTypeId").val();
            var userTypeName = $("#editUserTypeName").val();
            var oldUserTypeName = $("#editOldUserTypeName").val();

            if(userTypeName){
                $("#editUserTypeName").removeClass('is-invalid');
                $.ajax({
                    type:'POST',
                    url:'resources/scripts/settings/settings.php',
                    data:'action=edit-user-type&usertypeid='+userTypeId+'&usertypename='+userTypeName,
                    dataType: 'JSON',
                    beforeSend:function(){
                        $("#editUserTypeBtn").html('Saving...<i class="fa fa-spinner fa-spin"></i>');
                    },
                    success:function(editUserTypeResponse){
                        if(editUserTypeResponse.header==='successful'){
                            $("#editUserTypeMsg").html('');
                            toastr.success('<b>'+oldUserTypeName+'</b> '+editUserTypeResponse.message+' to <b>'+userTypeName+'</b>');
                            $("#editUserTypeBtn").html('<i class="fa fa-check"></i> Saved').attr('disabled', 'disabled');
                            
                            $('#edit-user-type').modal('hide');
                            //////refresh the list///////////
                            $.ajax({
                                type:'POST',
                                url:'resources/scripts/settings/settings.php',
                                data:'action=load-user-types',
                                beforeSend: function(){
                                    $("#userTypeDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                                },
                                success:function(responseData){
                                    $("#userTypeDetails").html(responseData);
                                }
                            });
                            $("#editUserTypeBtn").html('<i class="fa fa-save"></i> Save').removeAttr('disabled');
                            $("#editUserTypeMsg").html('');
                        }
                        else{
                        $("#editUserTypeMsg").html('<br>'+editUserTypeResponse.message).addClass('text-danger').removeClass('text-success');
                        $("#editUserTypeBtn").html('<i class="fa fa-save"></i> Save');
                        }
                    }
                });
            }
            else{
                $("#editUserTypeName").addClass('is-invalid');
            }
        });

        /////DELETE USER TYPE//////
        $(document).delegate("[data-target='#delete-user-type']", "click", function() {
            var name = $(this).attr('name');
            var id = $(this).attr('data-id');
            var title = $(this).attr('title');
            $("#deleteUserTypeHead").html(title);
            $("#delUserTypeName").val(name);
            $("#delUserType").html(name);
            $("#delUserTypeId").val(id);
            $("#delUserTypeMsg").html('');
        });

        $("#deleteUserTypeBtn").on('click', function(){
            var userTypeId = $("#delUserTypeId").val();
            var userTypeName = $("#delUserTypeName").val();

            if(userTypeId){
                $.ajax({
                    type:'POST',
                    url:'resources/scripts/settings/settings.php',
                    data:'action=delete-user-type&usertypeid='+userTypeId+'&usertypename='+userTypeName,
                    dataType: 'JSON',
                    beforeSend:function(){
                        $("#deleteUserTypeBtn").html('Deleting...<i class="fa fa-spinner fa-spin"></i>');
                    },
                    success:function(editCatResponse){
                        if(editCatResponse.header==='successful'){
                        $("#delUserTypeMsg").html('');
                        toastr.success('<b>'+userTypeName+'</b> was successfully deleted.');
                        $("#deleteUserTypeBtn").html('<i class="fa fa-check"></i> Deleted').attr('disabled', 'disabled');
                        $('#delete-user-type').modal('hide');
                            //////refresh the list///////////
                            $.ajax({
                                type:'POST',
                                url:'resources/scripts/settings/settings.php',
                                data:'action=load-user-types',
                                beforeSend: function(){
                                    $("#userTypeDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                                },
                                success:function(responseData){
                                    $("#userTypeDetails").html(responseData);
                                }
                            });
                            $("#deleteUserTypeBtn").html('<i class="fa fa-trash"></i> Yes, Delete').removeAttr('disabled');
                            $("#delUserTypeMsg").html('');
                        }
                        else{
                        $("#delUserTypeMsg").html('<br>'+editCatResponse.message).addClass('text-danger').removeClass('text-success');
                        $("#deleteUserTypeBtn").html('<i class="fa fa-trash"></i> Try Again');
                        }
                    }
                });
            }
        });

        /////PERMANENTLY DELETE USER TYPE////////////
        $(document).delegate("[data-target='#perm-delete-user-type']", "click", function() {
            var name = $(this).attr('name');
            var id = $(this).attr('data-id');
            var title = $(this).attr('title');
            $("#permDeleteUserTypeHead").html(title);
            $("#permDelUserTypeName").val(name);
            $("#permDelUserType").html(name);
            $("#permDelUserTypeId").val(id);
            $("#permDelUserTypeMsg").html('');
        });

        $("#permDeleteUserTypeBtn").on('click', function(){
            var userTypeId = $("#permDelUserTypeId").val();
            var userTypeName = $("#permDelUserTypeName").val();

            if(userTypeId){
                $.ajax({
                    type:'POST',
                    url:'resources/scripts/settings/settings.php',
                    data:'action=perm-delete-user-type&usertypeid='+userTypeId+'&usertypename='+userTypeName,
                    dataType: 'JSON',
                    beforeSend:function(){
                        $("#permDeleteUserTypeBtn").html('Deleting...<i class="fa fa-spinner fa-spin"></i>');
                    },
                    success:function(permDelResponse){
                        if(permDelResponse.header==='successful'){
                        $("#permDelUserTypeMsg").html('');
                        toastr.success('<b>'+userTypeName+'</b> was permanently deleted.');
                        $("#permDeleteUserTypeBtn").html('<i class="fa fa-check"></i> Deleted').attr('disabled', 'disabled');
                        $('#perm-delete-user-type').modal('hide');
                            //////refresh the list///////////
                            $.ajax({
                                type:'POST',
                                url:'resources/scripts/settings/settings.php',
                                data:'action=load-user-types',
                                beforeSend: function(){
                                    $("#userTypeDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                                },
                                success:function(responseData){
                                    $("#userTypeDetails").html(responseData);
                                }
                            });
                            $("#permDeleteUserTypeBtn").html('<i class="fa fa-trash"></i> Yes, Delete').removeAttr('disabled');
                            $("#permDelUserTypeMsg").html('');
                        }
                        else{
                        $("#permDelUserTypeMsg").html('<br>'+permDelResponse.message).addClass('text-danger').removeClass('text-success');
                        $("#permDeleteUserTypeBtn").html('<i class="fa fa-trash"></i> Try Again');
                        }
                    }
                });
            }
        });

        ///////restore deleted user type///////
        $(document).delegate("[data-target='#restore-user-type']", "click", function() {
            var name = $(this).attr('name');
            var id = $(this).attr('data-id');
            var title = $(this).attr('title');
            $("#restoreUserTypeHead").html(title);
            $("#resUserTypeName").val(name);
            $("#resUserType").html(name);
            $("#resUserTypeId").val(id);
            $("#resUserTypeMsg").html('');
        });

        $("#restoreUserTypeBtn").on('click', function(){
            var userTypeId = $("#resUserTypeId").val();
            var userTypeName = $("#resUserTypeName").val();

            if(userTypeId){
                $.ajax({
                    type:'POST',
                    url:'resources/scripts/settings/settings.php',
                    data:'action=restore-user-type&usertypeid='+userTypeId+'&usertypename='+userTypeName,
                    dataType: 'JSON',
                    beforeSend:function(){
                        $("#restoreUserTypeBtn").html('Restoring...<i class="fa fa-spinner fa-spin"></i>');
                    },
                    success:function(resUserTypeResponse){
                        if(resUserTypeResponse.header==='successful'){
                            $("#resUserTypeMsg").html('');
                            toastr.success('<b>'+userTypeName+'</b> was successfully restored.');
                            $("#restoreUserTypeBtn").html('<i class="fa fa-check"></i> Restored').attr('disabled', 'disabled');
                            $('#restore-user-type').modal('hide');
                            //////refresh the list///////////
                            $.ajax({
                                type:'POST',
                                url:'resources/scripts/settings/settings.php',
                                data:'action=load-user-types',
                                beforeSend: function(){
                                    $("#userTypeDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                                },
                                success:function(responseData){
                                    $("#userTypeDetails").html(responseData);
                                }
                            });
                            $("#restoreUserTypeBtn").html('<i class="fa fa-save"></i> Yes, Restore').removeAttr('disabled');
                            $("#resUserTypeMsg").html('');
                        }
                        else{
                        $("#resUserTypeMsg").html('<br>'+resUserTypeResponse.message).addClass('text-danger').removeClass('text-success');
                        $("#restoreUserTypeBtn").html('<i class="fa fa-save"></i> Try Again');
                        }
                    }
                });
            }
        });
    }
    
});