
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title><?php echo $appName; ?> | Account Suspended</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?php echo $dir; ?>plugins/fontawesome-free/css/all.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="<?php echo $dir; ?>https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo $dir; ?>dist/css/adminlte.min.css">
  <link rel="shortcut icon" type="image/x-icon" href="<?php echo $dir; ?>dist/img/favicon.png">
  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <script src="<?php echo $dir; ?>jquery.min.js"></script>
  <script src="https://code.jquery.com/jquery-2.1.1.min.js" type="text/javascript"></script>
</head>
<body class="hold-transition lockscreen">
<!-- Automatic element centering -->
<div class="lockscreen-wrapper">
  <div class="lockscreen-logo">
    <span class="text-danger"><b><i class="fa fa-user-times"></i> Account </b>Suspended</a>
  </div>
  <!-- User name -->
  

  <!-- START LOCK SCREEN ITEM -->
	<div class="text-center">
	  <img class="profile-user-img img-fluid img-circle" src="<?php echo $userImage; ?>" alt="<?php echo $myName; ?>">
	</div>
	<h3 class="profile-username text-center"><strong><?php echo $myName; ?></strong></h3>

	<p class="text-muted text-center"><?php print $user['user_type']; ?></p>
  
  <!-- /.lockscreen-item -->
  <div class="help-block text-center">
      Your account is currently suspended and as such you will not be able to access your dashboard.
    Account suspension happens when you violate our system usage or security policies.
    If you believe this is a mistake, kindly contact us at <br><a href="mailto:support<?php echo $mailLink; ?>"><i class="fa fa-envelope"></i> <strong>support<?php echo $mailLink; ?></strong></a> <br><a href="javascript: void();"><i class="fa fa-mobile"></i><strong><?php echo $appPhone; ?></a></strong>
  
      <br><br><button class="btn btn-danger" id="logoutBtn"><i class="fa fa-power-off"></i> Logout</button>
  </div>
  
</div>
<!-- /.center -->
<script>
    $(document).ready(function(){
        $("#logoutBtn").on('click', function(){
            $.ajax({
                type: 'POST',
                url: 'resources/scripts/auth.php',
                data: 'action=logout',
                beforeSend: function(){
                    $("#logoutBtn").html('Loading...<i class="fa fa-spinner fa-spin"></i>').attr('disabled','disabled');
                },
                success:function(response){
                    setTimeout(function(){
                        window.location = './';
                    },2000);
                }
            });
        });
    });
</script>

<!-- jQuery -->
<script src="<?php print $dir; ?>plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="<?php print $dir; ?>plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
</body>
</html>
