<?php
    $dir = './';
    $title = 'Mail Campaign';
    $currentPage = 'Campaigns';
    $page = 'Campaign';
    $mailCampaignMenu = 'active';
    $mailCampaignMenuState = 'menu-open';
    $campaignMenu = 'active';
?>
<?php include($dir.'pages/universal/header.php'); ?>
  
  <!-- Content Wrapper. Contains page content -->
  <input type="hidden" id="currentPage" value="<?php echo $currentPage; ?>" />
  <div class="content-wrapper">
    <div id="systemNotification"></div>
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1><?php echo $title; ?></h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item"><a href="#"><?php echo $page; ?></a></li>
              <li class="breadcrumb-item active"><?php echo $title; ?></li>
            </ol>
          </div>
          <div class="col-sm-12" align="right">
            <button type="button" class="btn btn-info btn-sm" data-toggle="modal" data-target="#start-campaign" title="Add New <?php echo $currentPage; ?>">
                <i class="fas fa-user-plus"></i> Launch Campaign
            </button>
			<button type="button" class="btn btn-info btn-sm" id="loadData">
                <i class="fas fa-eye"></i> Show Records
            </button>
          </div>
		  <br><br>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            <div class="card" id="caignDetails">
				<?php
					$queryPCampaign = mysqli_query($db_conn, "SELECT * FROM mail_campaign");
					$dataResponse = '<div class="card-header">
						<h3 class="card-title">Total Records ('.mysqli_num_rows($queryPCampaign).')</h3>

						<div class="card-tools">
						  <button type="button" class="btn btn-tool" title="Refresh List" id="refreshPlans">
							<i class="fas fa-sync-alt"></i>
						  </button>
						</div>
					  </div>
					  <div class="card-body">
					  <table id="example1" class="table table-bordered table-hover">
						<thead>
						  <tr>
							<th>S/N</th>
							<th class="text-center">First Name</th>
							<th class="text-center">Last Name</th>
							<th class="text-center">Phone</th>
							<th class="text-center">Email</th>
							<th class="text-center">Status</th>
							<th class="text-center">Read Reciept</th>
							<th><i class="fa fa-cogs"></i></th>
						  </tr>
						</thead>
					<tbody>';
					
					$number = 1;
					while($detail = mysqli_fetch_assoc(($queryPCampaign))){
						
						$dataResponse .= '<tr>
							<td>'.$number.'</td>
							<td><h6><b>'.$detail['first_name'].'</b></h6></td>
							<td><h6><b>'.$detail['last_name'].'</b></h6></td>
							<td>'.$detail['phone'].'</td>
							<td>'.$detail['email'].'</td>
							<td class="text-center">'.$detail['mail_status'].'</td>
							<td class="text-center">'.$detail['read_receipt'].'</td>
							<td></td>
						</tr>';
						$number++;
					}
					$dataResponse .= '</tbody></table></div>';
					echo $dataResponse;
				?>
            </div>
            <!-- /.card -->
            <script src="<?php echo $dir; ?>pages/main/mail-campaign/scripts/campaign-setting.js"></script>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  
	<div class="modal fade" id="start-campaign">
        <div class="modal-dialog">
          <div class="modal-content">
            <div class="modal-header bg-info">
              <h4 class="modal-title">Launch Mail Campaign</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <p>You are about initiating a Mail camapaign on the system. <br>Are you sure you want to proceed?</p>
              
            </div>
            <div class="modal-footer justify-content-between">
              <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
              <button type="button" class="btn btn-info" id="launchCampaignBtn">Yes, Launch Now</button>
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
  
  
  <!-- /.content-wrapper -->
  <?php include($dir.'pages/universal/footer.php'); ?>