<?php
	$webdir = '../';
	require $webdir.'connection.php';
	
	$title = 'Internal Operations Invoices';
	$invoiceMenu = 'active';
	$chatWidget = 'No';
	
	$myId = $user['unique_id'];
	
	if(empty($systemAdminSession)){
		header("location: $webdir");
	}
	
	if(isset($_POST['createInvoice'])){
		        
		
	}
	if(isset($_POST['addItem'])){
		$itemName = strtolower(stripslashes(mysqli_real_escape_string($db_conn, $_POST['item_name'])));
		$itemDescription = stripslashes(mysqli_real_escape_string($db_conn, $_POST['item_description']));
		$itemAmount = mysqli_real_escape_string($db_conn, $_POST['item_amount']);
		
		$dateAdded = date("Y-m-d h:i:s A", time());
		$invoiceNo = $_GET['invid'];
		$itemNo = mt_rand(0000000, 9999999);
		
		$insertItem = mysqli_query($db_conn, "INSERT INTO tbl_invoice_items SET invoice_no='$invoiceNo',item_id='$itemNo',item_name='$itemName',description='$itemDescription',amount=$itemAmount,added_on='$dateAdded',added_by='".$user['unique_id']."'");
		if($insertItem===true){
			$message = '<div class="callout callout-success">
				<h5 class="text-success"><i class="fa fa-check-circle"></i> <strong>Item successfully added.</strong></h5>
			</div>';
		}
		else{
			$message = '<div class="callout callout-danger">
				<h5 class="text-danger"><i class="fa fa-times-circle"></i> Could not add <strong>'.$itemName.'</strong>('.mysqli_error($db_conn).')</h5>
			</div>';
		}
	}
	
	///////delete invoice////////
	if(isset($_POST['deleteInvoice'])){
		$invoiceId = $_POST['invoice_id'];
		$invStatus = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT * FROM tbl_invoices WHERE invoice_no='$invoiceId' LIMIT 1"));
		
		
		if($invStatus['status']=='Deleted'){
			$deleteQuery = mysqli_query($db_conn, "DELETE FROM tbl_invoices WHERE invoice_no='$invoiceId'");
			mysqli_query($db_conn, "DELETE FROM tbl_invoice_items WHERE invoice_no='$invoiceId'");
		}
		else{
			$deleteQuery = mysqli_query($db_conn, "UPDATE tbl_invoices SET status='Deleted' WHERE invoice_no='$invoiceId'");
		}
		
		
		if($deleteQuery===true){
			$message = '<div class="callout callout-danger">
				<h5 class="text-danger"><i class="fa fa-check-circle"></i> <strong>Invoice successfully deleted from the system. - '.$query.'</strong></h5>
			</div>';
		}
		else{
			$message = '<div class="callout callout-warning">
				<h5 class="text-warning"><i class="fa fa-times-circle"></i> Could not delete invoice from the system.('.mysqli_error($db_conn).')</h5>
			</div>';
		}
	}
	
	//////////delete invoice item/////////////////////
	if(isset($_POST['deleteItem'])){
		$itemId = $_POST['item_id'];
		$deleteItemQuery = mysqli_query($db_conn, "DELETE FROM tbl_invoice_items WHERE item_id=$itemId LIMIT 1");
		if($deleteItemQuery===true){
			$message = '<div class="callout callout-danger">
				<h5 class="text-danger"><i class="fa fa-check-circle"></i> <strong>Invoice item successfully deleted from the system.</strong></h5>
			</div>';
		}
		else{
			$message = '<div class="callout callout-warning">
				<h5 class="text-warning"><i class="fa fa-times-circle"></i> Could not delete invoice item from the system.('.mysqli_error($db_conn).')</h5>
			</div>';
		}
	}
	
	////edit invoice item//////
	if(isset($_POST['editItem'])){
		$itemName = mysqli_real_escape_string($db_conn, $_POST['item_name']);
		$itemDescription = stripslashes(mysqli_real_escape_string($db_conn, $_POST['item_description']));
		$itemAmount = mysqli_real_escape_string($db_conn, $_POST['item_amount']);
		$itemId = $_POST['item_id'];
		
		$updateItemQuery = mysqli_query($db_conn, "UPDATE tbl_invoice_items SET item_name='$itemName', description='$itemDescription', amount='$itemAmount' WHERE item_id=$itemId LIMIT 1");
		if($updateItemQuery===true){
			$message = '<div class="callout callout-success">
				<h5 class="text-success"><i class="fa fa-check-circle"></i> <strong>Invoice item successfully updated.</strong></h5>
			</div>';
		}
		else{
			$message = '<div class="callout callout-danger">
				<h5 class="text-danger"><i class="fa fa-times-circle"></i> Could not update invoice item.('.mysqli_error($db_conn).')</h5>
			</div>';
		}
	}
	
	///////restore deleted invoice////////////
	if(isset($_POST['restoreInvoice'])){
		$invoiceId = $_POST['invoice_id'];
		$restoreQuery = mysqli_query($db_conn, "UPDATE tbl_invoices SET status='Pending' WHERE invoice_no='$invoiceId' LIMIT 1");
		
		if($restoreQuery===true){
			$message = '<div class="callout callout-success">
				<h5 class="text-success"><i class="fa fa-check-circle"></i> <strong>Invoice successfully restored.</strong></h5>
			</div>';
		}
		else{
			$message = '<div class="callout callout-danger">
				<h5 class="text-danger"><i class="fa fa-times-circle"></i> Could not restore invoice from the deleted folder.('.mysqli_error($db_conn).')</h5>
			</div>';
		}
	}
	
	///////APPROVE INVOICE////////////
	if(isset($_POST['approveInvoice'])){
		$invoiceId = $_POST['invoice_no'];
		$queryInv = mysqli_query($db_conn, "SELECT * FROM tbl_invoices WHERE invoice_no='$invoiceId' LIMIT 1");
		$detail = mysqli_fetch_assoc($queryInv);
		$amount = $_POST['invoice_amount'];
		$dateApproved = date("Y-m-d h:i:s A", time());
		$approvedBy = $user['unique_id'];
		
		if($detail['status']=='Pending'){
			$approveInvoice = mysqli_query($db_conn, "UPDATE tbl_invoices SET status='Approved', approved_by='$approvedBy', approved_on='$dateApproved' WHERE invoice_no='$invoiceId' LIMIT 1");
			if($approveInvoice===true){
				////////SEND APPROVAL SMS TO THE RECEIVER//////////////
				$value = explode('.', $amount);
				$main = $value[0];
				$decimal = $value[1];
				if(empty($decimal)){
					$amount = number_format($main);
				}
				else{
					$amount = number_format($main).'.'.$decimal;
				}
				$receiver = $detail['receiver_name'];
				
				$receiverPhone = '08168290811';//$detail['receiver_phone'];
				$msgSend = 'Dear '.$receiver.', invoice of NGN'.$amount.' has been approved. We will notify you once the fund is disbursed.';
						$refId = md5(date("d-M-Y H:i", time()));
						
						$baseurl = 'https://smartsmssolutions.com/api/json.php?';
						$curl = curl_init();
						curl_setopt_array($curl, array(
						  CURLOPT_URL => 'https://app.smartsmssolutions.ng/io/api/client/v1/sms/',
						  CURLOPT_RETURNTRANSFER => true,
						  CURLOPT_ENCODING => '',
						  CURLOPT_MAXREDIRS => 10,
						  CURLOPT_TIMEOUT => 0,
						  CURLOPT_FOLLOWLOCATION => true,
						  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
						  CURLOPT_CUSTOMREQUEST => 'POST',
						  CURLOPT_POSTFIELDS => array(
							  'token' => $apiToken,
							  'sender' => $senderid,
							  'to' => $receiverPhone,
							  'message' => $msgSend,
							  'type' => 0,
							  'routing' => 8,
							  'ref_id' => $refId
						  ),
						));
						curl_exec($curl);
						
						///////////SEND APPROVAL SMS TO THE CAMPAIGN DG AND PRINCIPAL///////////////
						
						$msgSend = 'A new invoice of NGN'.$amount.' was approved by '.$user['last_name'].'. This invoice is now awaiting disbursement.';
						$refId = md5(date("d-M-Y H:i", time()));
						//$phone = '07035269355, 08035004050';
						$phone = '08168290811';
						
						$baseurl = 'https://smartsmssolutions.com/api/json.php?';
						$curl1 = curl_init();
						curl_setopt_array($curl1, array(
						  CURLOPT_URL => 'https://app.smartsmssolutions.ng/io/api/client/v1/sms/',
						  CURLOPT_RETURNTRANSFER => true,
						  CURLOPT_ENCODING => '',
						  CURLOPT_MAXREDIRS => 10,
						  CURLOPT_TIMEOUT => 0,
						  CURLOPT_FOLLOWLOCATION => true,
						  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
						  CURLOPT_CUSTOMREQUEST => 'POST',
						  CURLOPT_POSTFIELDS => array(
							  'token' => $apiToken,
							  'sender' => $senderid,
							  'to' => $phone,
							  'message' => $msgSend,
							  'type' => 0,
							  'routing' => 8,
							  'ref_id' => $refId
						  ),
						));
						curl_exec($curl1);
						
						$message = '<div class="callout callout-success">
							<h5 class="text-success"><i class="fa fa-check-circle"></i> <strong>Invoice successfully Approved.</strong></h5>
						</div>';
			}
			else{
				$message = '<div class="callout callout-danger">
					<h5 class="text-danger"><i class="fa fa-times-circle"></i> Could not approve invoice.('.mysqli_error($db_conn).')</h5>
				</div>';
			}
		}
		else{
			$message = '<div class="callout callout-warning">
				<h5 class="text-warning"><i class="fa fa-info-circle"></i> This invoice is already approved. Kindly ignore as approval instructions are already sent to those in charge.</h5>
			</div>';
		}
	}
	
	///////REJECT INVOICE////////////
	if(isset($_POST['rejectInvoice'])){
		$invoiceId = $_POST['invoice_no'];
		$rejectReason = addslashes(mysqli_real_escape_string($db_conn, $_POST['reject_reason']));
		
		$dateRejected = date("Y-m-d h:i:s A", time());
		$approvedBy = $user['unique_id'];
		$queryInv = mysqli_query($db_conn, "SELECT * FROM tbl_invoices WHERE invoice_no='$invoiceId' LIMIT 1");
		$detail = mysqli_fetch_assoc($queryInv);
		
		if($detail['status']=='Pending'){
			$approveInvoice = mysqli_query($db_conn, "UPDATE tbl_invoices SET status='Rejected' WHERE invoice_no='$invoiceId' LIMIT 1");
			if($approveInvoice===true){
				mysqli_query($db_conn, "INSERT INTO tbl_invoice_reject SET invoice_id='$invoiceId', reject_reason='$rejectReason', rejected_by='$approvedBy', rejected_on='$dateRejected'");
				////////SEND APPROVAL SMS TO THE RECEIVER//////////////
				$value = explode('.', $amount);
				$main = $value[0];
				$decimal = $value[1];
				if(empty($decimal)){
					$amount = number_format($main);
				}
				else{
					$amount = number_format($main).'.'.$decimal;
				}
				$receiver = $detail['receiver_name'];
				
				$receiverPhone = $receiver['receiver_phone'];//$detail['receiver_phone'];
				$msgSend = 'Your invoice on '.$appName.' was rejected. Kindly contact the admin officer for more details.';
						$refId = md5(date("d-M-Y H:i", time()));
						
						$baseurl = 'https://smartsmssolutions.com/api/json.php?';
						$curl = curl_init();
						curl_setopt_array($curl, array(
						  CURLOPT_URL => 'https://app.smartsmssolutions.ng/io/api/client/v1/sms/',
						  CURLOPT_RETURNTRANSFER => true,
						  CURLOPT_ENCODING => '',
						  CURLOPT_MAXREDIRS => 10,
						  CURLOPT_TIMEOUT => 0,
						  CURLOPT_FOLLOWLOCATION => true,
						  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
						  CURLOPT_CUSTOMREQUEST => 'POST',
						  CURLOPT_POSTFIELDS => array(
							  'token' => $apiToken,
							  'sender' => $senderid,
							  'to' => $receiverPhone,
							  'message' => $msgSend,
							  'type' => 0,
							  'routing' => 8,
							  'ref_id' => $refId
						  ),
						));
						curl_exec($curl);
						
						///////////SEND APPROVAL SMS TO THE CAMPAIGN DG AND PRINCIPAL///////////////
						
						$msgSend = 'A generated invoice on '.$appName.' was rejected by '.$user['last_name'].'.';
						$refId = md5(date("d-M-Y H:i", time()));
						//$phone = '07035269355, 08035004050';
						$phone = '08168290811';
						
						$baseurl = 'https://smartsmssolutions.com/api/json.php?';
						$curl1 = curl_init();
						curl_setopt_array($curl1, array(
						  CURLOPT_URL => 'https://app.smartsmssolutions.ng/io/api/client/v1/sms/',
						  CURLOPT_RETURNTRANSFER => true,
						  CURLOPT_ENCODING => '',
						  CURLOPT_MAXREDIRS => 10,
						  CURLOPT_TIMEOUT => 0,
						  CURLOPT_FOLLOWLOCATION => true,
						  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
						  CURLOPT_CUSTOMREQUEST => 'POST',
						  CURLOPT_POSTFIELDS => array(
							  'token' => $apiToken,
							  'sender' => $senderid,
							  'to' => $phone,
							  'message' => $msgSend,
							  'type' => 0,
							  'routing' => 8,
							  'ref_id' => $refId
						  ),
						));
						curl_exec($curl1);
						
						$message = '<div class="callout callout-success">
							<h5 class="text-success"><i class="fa fa-check-circle"></i> <strong>Invoice successfully Rejected.</strong></h5>
						</div>';
			}
			else{
				$message = '<div class="callout callout-danger">
					<h5 class="text-danger"><i class="fa fa-times-circle"></i> Could not reject invoice.('.mysqli_error($db_conn).')</h5>
				</div>';
			}
		}
		else{
			$message = '<div class="callout callout-warning">
				<h5 class="text-warning"><i class="fa fa-info-circle"></i> This invoice is already rejected.</h5>
			</div>';
		}
	}
	
	///////INVOICE FUNDS DISBURSEMENT////////////
	if(isset($_POST['disburseFund'])){
		$invoiceId = $_POST['invoice_no'];
		$queryInv = mysqli_query($db_conn, "SELECT * FROM tbl_invoices WHERE invoice_no='$invoiceId' LIMIT 1");
		$detail = mysqli_fetch_assoc($queryInv);
		$amount = $_POST['invoice_amount'];
		$dateDisbursed = date("Y-m-d h:i:s A", time());
		$disbursedBy = $user['unique_id'];
		
		if($detail['status']=='Pending'){
			$approveInvoice = mysqli_query($db_conn, "UPDATE tbl_invoices SET status='Approved', amount_disbursed=$amount, disbursed_by='$disbursedBy', disbursed_on='$dateDisbursed' WHERE invoice_no='$invoiceId' LIMIT 1");
			if($approveInvoice===true){
				////////SEND APPROVAL SMS TO THE RECEIVER//////////////
				$receiver = $detail['receiver_name'];
				$receiverPhone = '09017287101';//$detail['receiver_phone'];
				$msgSend = 'Dear '.$receiver.', invoice: '.$detail['invoice_name'].' of NGN'.$amount.' has been approved. We will notify you once the fund is disbursed.';
						$refId = md5(date("d-M-Y H:i", time()));
						$senderid = 'SPAC';
						$baseurl = 'https://smartsmssolutions.com/api/json.php?';
						$curl = curl_init();
						curl_setopt_array($curl, array(
						  CURLOPT_URL => 'https://app.smartsmssolutions.ng/io/api/client/v1/sms/',
						  CURLOPT_RETURNTRANSFER => true,
						  CURLOPT_ENCODING => '',
						  CURLOPT_MAXREDIRS => 10,
						  CURLOPT_TIMEOUT => 0,
						  CURLOPT_FOLLOWLOCATION => true,
						  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
						  CURLOPT_CUSTOMREQUEST => 'POST',
						  CURLOPT_POSTFIELDS => array(
							  'token' => $apiToken,
							  'sender' => $senderid,
							  'to' => $receiverPhone,
							  'message' => $msgSend,
							  'type' => 0,
							  'routing' => 8,
							  'ref_id' => $refId
						  ),
						));
						
						///////////SEND APPROVAL SMS TO THE CAMPAIGN DG AND PRINCIPAL///////////////
						$msgSend = 'Sir, this is to notify you that a new invoice was approved by '.$user['last_name'].' '.$user['first_name'].' with the following details:
'.$detail['invoice_name'].'
Amount: NGN'.$amount.'.
This invoice is now awaiting fund disbursement.';
						$refId = md5(date("d-M-Y H:i", time()));
						//$phone = '07035269355, 08035004050';
						$phone = '08035004050';
						$senderid = 'SAPA MF';
						$baseurl = 'https://smartsmssolutions.com/api/json.php?';
						$curl = curl_init();
						curl_setopt_array($curl, array(
						  CURLOPT_URL => 'https://app.smartsmssolutions.ng/io/api/client/v1/sms/',
						  CURLOPT_RETURNTRANSFER => true,
						  CURLOPT_ENCODING => '',
						  CURLOPT_MAXREDIRS => 10,
						  CURLOPT_TIMEOUT => 0,
						  CURLOPT_FOLLOWLOCATION => true,
						  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
						  CURLOPT_CUSTOMREQUEST => 'POST',
						  CURLOPT_POSTFIELDS => array(
							  'token' => $apiToken,
							  'sender' => $senderid,
							  'to' => $phone,
							  'message' => $msgSend,
							  'type' => 0,
							  'routing' => 8,
							  'ref_id' => $refId
						  ),
						));
						
						$message = '<div class="callout callout-success">
							<h5 class="text-success"><i class="fa fa-check-circle"></i> <strong>Invoice successfully Approved.</strong></h5>
						</div>';
			}
			else{
				$message = '<div class="callout callout-danger">
					<h5 class="text-danger"><i class="fa fa-times-circle"></i> Could not approve invoice.('.mysqli_error($db_conn).')</h5>
				</div>';
			}
		}
		else{
			$message = '<div class="callout callout-warning">
				<h5 class="text-warning"><i class="fa fa-info-circle"></i> This invoice is already approved. Kindly ignore as approval instructions are already sent to those in charge.</h5>
			</div>';
		}
	}
	
	
	
	if(empty($_GET['action'])){
		$queryInvoices = mysqli_query($db_conn, "SELECT a.city,a.status,a.state,a.country,a.invoice_no, a.invoice_name,a.invoice_category,a.receiver_name,a.receiver_company,a.receiver_phone,a.receiver_email,a.receiver_address,a.payment_due_date,a.payment_channel,a.payment_id,a.generated_on,a.approved_on,b.last_name as generator_lname, b.first_name as generator_fname FROM tbl_invoices a, meditech_users b WHERE a.status!='Deleted' AND b.unique_id=a.generated_by");
	}
	else{
		if($user['user_type']=='super_admin' || $user['user_type']=='admin' || $user['user_type']=='manager'){
			$queryInvoices = mysqli_query($db_conn, "SELECT a.city,a.status,a.state,a.country,a.invoice_no, a.invoice_name,a.invoice_category,a.receiver_name,a.receiver_company,a.receiver_phone,a.receiver_email,a.receiver_address,a.payment_due_date,a.payment_channel,a.payment_id,a.generated_on,a.approved_on,b.last_name as generator_lname, b.first_name as generator_fname FROM tbl_invoices a, meditech_users b WHERE a.status='Deleted' AND b.unique_id=a.generated_by");
		}
		else{
			$queryInvoices = mysqli_query($db_conn, "SELECT a.city,a.status,a.state,a.country,a.invoice_no, a.invoice_name,a.invoice_category,a.receiver_name,a.receiver_company,a.receiver_phone,a.receiver_email,a.receiver_address,a.payment_due_date,a.payment_channel,a.payment_id,a.generated_on,a.approved_on,b.last_name as generator_lname, b.first_name as generator_fname FROM tbl_invoices a, meditech_users b WHERE a.status='Deleted' AND b.unique_id=a.generated_by AND generated_by='$myId'");
		}
	}
	$queryInvoice = mysqli_query($db_conn, "SELECT a.city,a.state,a.country,a.invoice_no,a.status, a.invoice_name,a.invoice_category,a.receiver_name,a.receiver_company,a.receiver_phone,a.receiver_email,a.receiver_address,a.payment_due_date,a.payment_channel,a.payment_id,a.generated_on,a.approved_on,b.last_name as generator_lname, b.first_name as generator_fname FROM tbl_invoices a, meditech_users b WHERE a.invoice_no='".$_GET['invid']."' AND b.unique_id=a.generated_by");
	
	if(mysqli_num_rows($queryInvoices)>0){
		$invoiceHeading = '<strong>ALL INVOICES ('.mysqli_num_rows($queryInvoices).')</strong>';
	}
	
	if(!empty($_GET['invid']) AND mysqli_num_rows($queryInvoice)>0){
		$invoiceDet = mysqli_fetch_assoc($queryInvoice);
	}
?>
<?php @include $webdir.'header.php'; ?>
	<div id="page" data-id="invoices" title="onboard"></div>
	<input type="hidden" id="dataUrl" value="<?php echo $webdir; ?>" />
	<input type="hidden" id="invid" value="<?php echo $_GET['invid']; ?>" />
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
		<?php print $message; ?>
        <div class="row mb-2">
          <div class="col-sm-6">
            <h4 class="text-success"><a href="./"><i class="fa fa-home"></i> Campaign Operational Invoices</a></h4>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Invoices</li>
            </ol>
          </div>
		  <br><br>
		  <div class="col-sm-12" align="right">
			<?php if(empty($_GET['invid']) || mysqli_num_rows($queryInvoice)<1){ ?>
				<button type="button" class="btn btn-sm btn-success pull-right" data-toggle="modal" data-target="#add-invoice">
				  <i class="fas fa-plus"></i> Add New Invoice
				</button>
				<?php if($user['user_type'] == 'super_admin'){ ?>
					<button type="button" class="btn btn-sm btn-danger pull-right" onclick="location.href='./?action=deleted';">
					  <i class="fas fa-trash"></i> Deleted Invoices
					</button>
				<?php } ?>
			<?php }else{ ?>
				<?php if($invoiceDet['status']=='Pending'){ ?>
				<button type="button" class="btn btn-success pull-right" data-toggle="modal" data-target="#add-item"><i class="far fa-credit-card"></i> Add Item</button>
				<?php } ?>
				<button type="button" onclick="location.href='./';" class="btn btn-danger pull-right"><i class="fa fa-times-circle"></i> Close</button>
			<?php } ?>
		  </div><br><br>
        </div>
		
      </div><!-- /.container-fluid -->
    </section>
	
    <!-- Main content -->
<?php if(empty($_GET['invid']) || mysqli_num_rows($queryInvoice)<1){ ?>
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card card-success">
            <div class="card-header">
              <h3 class="card-title"><?php print $invoiceHeading; ?></h3>
            </div>
            <!-- /.card-header -->
			<?php if(mysqli_num_rows($queryInvoices)>0){ ?>
				<div class="card-body">
				  <table id="example2" class="table table-bordered table-striped">
					<thead>
					<tr>
					  <th>#</th>
					  <th>Invoice ID</th>
					  <th>Invoice Name</th>
					  <th>Items</th>
					  <th>Amount</th>
					  <th>Invoice Date</th>
					  <th>Status</th>
					  <th><i class="fa fa-cogs"></i></th>
					</tr>
					</thead>
					<tbody>
						<?php
							$number = 1;
							while($invoice = mysqli_fetch_assoc($queryInvoices)){
								if($invoice['status']=='Pending'){
									$status = '<span class="badge badge-primary">Pending</span>';
								}
								elseif($invoice['status']=='Disbursed'){
									$status = '<span class="badge badge-success">Disbursed</span>';
								}
								elseif($invoice['status']=='Approved'){
									$status = '<span class="badge badge-success">Approved</span>';
								}
								elseif($invoice['status']=='Rejected'){
									$status = '<span class="badge badge-warning">Rejected</span>';
								}
								elseif($invoice['status']=='Deleted'){
									$status = '<span class="badge badge-danger">Deleted</span>';
								}
								else{
									$status = 'No Status';
								}
								
								$invNo = $invoice['invoice_no'];
								$itemList = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT COUNT(*) as total, SUM(amount) as amount FROM tbl_invoice_items WHERE invoice_no='$invNo'"));
									$value = explode('.', $itemList['amount']);
									$main = $value[0];
									$decimal = $value[1];
									if(empty($decimal)){
										$amount = '&#x20A6;'.number_format($main);
									}
									else{
										$amount = '&#x20A6;'.number_format($main).'.'.$decimal;
									}
						?>
						<tr>
						  <td><?php print $number; ?></td>
						  <td><?php print '<a href="./?invid='.$invNo.'">'.$invNo.'</a>'; ?></td>
						  <td><?php print '<a href="./?invid='.$invNo.'">'.$invoice['invoice_name'].'</a>'; ?></td>
						  <td><?php print $itemList['total']; ?></td>
						  <td><?php print $amount; ?></td>
						  <td><?php print $invoice['generated_on']; ?></td>
						  <td><?php print $status; ?></td>
						  <td>
							<?php if($_GET['action']!='deleted'){ ?>
								<?php if($invoice['status']=='Pending'){ ?>
								<a href="javascript: void();" class="btn btn-xs btn-info" data-toggle="modal" data-target="#edit-invoice-<?php print $invoice['invoice_no']; ?>"><i class="fa fa-edit" title="Edit"></i></a>
								<a href="javascript: void();" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#delete-invoice-<?php print $invoice['invoice_no']; ?>"><i class="fa fa-trash" title="Remove"></i></a>
								<?php }?>
							<?php }else{ ?>
								<a href="javascript: void();" class="btn btn-xs btn-info" data-toggle="modal" data-target="#restore-invoice-<?php print $invoice['invoice_no']; ?>"><i class="fa fa-reply" title="Restore"></i></a>
							<?php } ?>
						  </td>
						</tr>
						<?php if($_GET['action']!='deleted'){ ?>
						<div class="modal fade" id="edit-invoice-<?php print $invoice['invoice_no']; ?>">
							<div class="modal-dialog modal-lg">
							  <div class="modal-content">
								<div class="modal-header bg-info">
								  <h4 class="modal-title">Edit <strong><?php print $invoice['invoice_name']; ?></strong></h4>
								  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span></button>
								</div>
								<form method="post">
									<div class="modal-body">
										<div class="row">
											<div class="col-md-4 col-lg-4 col-xl-4">
												<div class="form-group">
													<label>Invoice Name</label>
													<input placeholder="Enter invoice Name" type="text" name="edit_invoice_name" value="<?php print $invoice['invoice_name']; ?>" class="form-control" >
												</div>
											</div>
											<div class="col-md-4 col-lg-4 col-xl-4">
												<div class="form-group">
													<label>Invoice Type</label>
													<select class="form-control select2bs4"  id="editInvoiceTyp" name="edit_invoice_type" style="width: 100%;">
														<?php
															$queryCat = mysqli_query($db_conn, "SELECT * FROM tbl_invoice_category WHERE status=1 ORDER BY category ASC");
															if(mysqli_num_rows($queryCat)>0){
																while($cat=mysqli_fetch_assoc($queryCat)){
																	if($cat['category']==$invoice['invoice_category']){
																		print '<option value="'.$cat['category'].'" selected="selected">'.$cat['category'].'</option>';
																	}
																	else{
																		print '<option value="'.$cat['category'].'">'.$cat['category'].'</option>';
																	}
																}
															}
															else{
																print '<option value="">Invoice Categories not available</option>';
															}
														?>
													</select>
												</div>
											</div>
											<div class="col-md-4 col-lg-4 col-xl-4">
												<div class="form-group">
													<label>Receiver Name</label>
													<input placeholder="Enter receiver name" type="text" name="edit_receiver_name" value="<?php print $invoice['receiver_name']; ?>" class="form-control" >
												</div>
											</div>
											<div class="col-md-4 col-lg-4 col-xl-4">
												<div class="form-group">
													<label>Receiver Phone</label>
													<input placeholder="Enter receiver phone" type="text" name="edit_receiver_phone" value="<?php print $invoice['receiver_phone']; ?>" class="form-control" >
												</div>
											</div>
											<div class="col-md-4 col-lg-4 col-xl-4">
												<div class="form-group">
													<label>Receiver Email</label>
													<input placeholder="Enter receiver email" type="text" name="edit_receiver_email" value="<?php print $invoice['receiver_email']; ?>" class="form-control" >
												</div>
											</div>
											<div class="col-md-4 col-lg-4 col-xl-4">
												<div class="form-group">
													<label>Due Date</label>
													<input type="text" class="form-control" name="edit_due_date" data-inputmask-alias="datetime" value="<?php print $invoice['due_date']; ?>" data-inputmask-inputformat="dd/mm/yyyy" data-mask>
												</div>
											</div>
											<div class="col-md-12 col-lg-12 col-xl-12">
												<div class="form-group">
													<label>Receiver Organization</label>
													<input placeholder="Enter receiver organization" type="text" name="edit_receiver_company" value="<?php print $invoice['receiver_company']; ?>" class="form-control" >
												</div>
											</div>
											<div class="col-md-4 col-lg-4 col-xl-4">
												<div class="form-group">
													<label>Country</label>
													<select class="form-control select2bs4"  id="editCountry" name="edit_country" style="width: 100%;">
														<?php 
															$queryCountry = mysqli_query($db_conn, "SELECT * FROM countries WHERE status=1 ORDER BY country_name ASC");
															if(mysqli_num_rows($queryCountry)>0){
																while($country=mysqli_fetch_assoc($queryCountry)){
																	if($country['country_name']==$invoice['country']){
																		print '<option value="'.$country['country_id'].'" selected="selected">'.$country['country_name'].'</option>';
																	}else{
																		print '<option value="'.$country['country_id'].'">'.$country['country_name'].'</option>';
																	}
																}
															}
															else{
																print '<option value="">Countries not available</option>';
															}
														?>
													</select>
												</div>
											</div>
											<div class="col-md-4 col-lg-4 col-xl-4">
												<div class="form-group">
													<label>State</label>
													<select class="form-control select2bs4"  id="editState" name="edit_state" style="width: 100%;">
														<?php print '<option value="'.$invoice['state'].'">'.$invoice['state'].'</option>'; ?>
													</select>
												</div>
											</div>
											<div class="col-md-4 col-lg-4 col-xl-4">
												<div class="form-group">
													<label>City</label>
													<select class="form-control select2bs4"  id="editLga" name="edit_city" style="width: 100%;">
														<?php print '<option value="'.$invoice['city'].'">'.$invoice['city'].'</option>'; ?>
													</select>
												</div>
											</div>
											
											<div class="col-md-12 col-lg-12 col-xl-12">
												<div class="form-group">
													<label>Receiver Address</label>
													<input placeholder="Enter receiver address" type="text" name="edit_receiver_address" class="form-control" >
												</div>
											</div>
										</div>
									</div>
									<input type="hidden" name="invoice_id" value="<?php print $invoice['invoice_no']; ?>" />
									<div class="modal-footer bg-info justify-content-between">
									  <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									  <button type="submit" class="btn btn-secondary" name="updateInvoice">Submit <i class="fa fa-check-circle"></i></button>
									</div>
								</form>
							  </div>
							  <!-- /.modal-content -->
							</div>
							<!-- /.modal-dialog -->
						</div>
						<?php }else{ ?>
						<div class="modal fade" id="restore-invoice-<?php print $invoice['invoice_no']; ?>">
							<div class="modal-dialog">
							  <div class="modal-content">
								<div class="modal-header bg-info">
								  <h4 class="modal-title">Restore <strong><?php print $invoice['invoice_name']; ?></strong></h4>
								  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span></button>
								</div>
								<form method="post">
									<div class="modal-body">
										<input type="hidden" name="invoice_id" value="<?php print $admin['user_id']; ?>" />
										 <p>Are you sure you want to restore this deleted invoice and all the associated items?</p>
									</div>
									<input type="hidden" name="invoice_id" value="<?php print $invoice['invoice_no']; ?>" />
									<div class="modal-footer bg-info justify-content-between">
									  <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									  <button type="submit" class="btn btn-secondary" name="restoreInvoice">Yes, Restore</button>
									</div>
								</form>
							  </div>
							  <!-- /.modal-content -->
							</div>
							<!-- /.modal-dialog -->
						</div>
						<?php } ?>
						
						<div class="modal fade" id="delete-invoice-<?php print $invoice['invoice_no']; ?>">
							<div class="modal-dialog">
							  <div class="modal-content">
								<div class="modal-header bg-danger">
								  <h4 class="modal-title">Delete <strong><?php print $invoice['invoice_name']; ?></strong></h4>
								  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
									<span aria-hidden="true">&times;</span></button>
								</div>
								<form method="post">
									<div class="modal-body">
										 <p>Are you sure you want to <strong><?php if($_GET['action']=='deleted'){ print 'permanently'; } ?> delete</strong> this invoice and all the associated items?</p>
									</div>
									<input type="hidden" name="invoice_id" value="<?php print $invoice['invoice_no']; ?>" />
									<div class="modal-footer bg-danger justify-content-between">
									  <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
									  <button type="submit" class="btn btn-secondary" name="deleteInvoice">Yes, Delete</button>
									</div>
								</form>
							  </div>
							  <!-- /.modal-content -->
							</div>
							<!-- /.modal-dialog -->
						</div>
						<?php  $number++; } ?>
					</tbody>
				  </table>
				</div>
			<?php }else{ ?>
				<div class="card-body">
					<div class="row">
						<div class="callout callout-danger text-center">
						  <h5 class="text-danger"><strong>NO INVOICE FOUND</strong></h5>
						  <p>There are currently no invoice generated on this system. To start, kindly generate new invoice by clicking on the <strong>Add New Invoice</strong> button above.
						  <br>Creating invoice is as quick and simple as ABC. Why not create one now?</p>
						</div>
					</div>
				</div>
			<?php } ?>
            <!-- /.card-body -->
          </div>
		</div>
	</div>

</section>
	
		<div class="modal fade" id="add-invoice">
			<div class="modal-dialog modal-xl">
				  <form class="modal-content" method="post" id="editForm">
					<div class="modal-header bg-info">
					  <h4 class="modal-title">Add New Invoice</h4>
					  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					  </button>
					</div>
					<div class="modal-body">
						<div class="row">
							<div class="col-md-12 text-center" id="invoiceMsg"></div>

							<div class="col-md-4 col-lg-4 col-xl-4">
								<div class="form-group">
									<label>Invoice Name</label>
									<input placeholder="Enter invoice Name" type="text" id="invoiceName" class="form-control" >
								</div>
							</div>
							<div class="col-md-4 col-lg-4 col-xl-4">
								<div class="form-group">
									<label>Invoice Type</label>
									<select class="form-control select2bs4"  id="invoiceType" style="width: 100%;">
										<?php 
											$queryCat = mysqli_query($db_conn, "SELECT * FROM tbl_invoice_category WHERE status=1 ORDER BY category ASC");
											if(mysqli_num_rows($queryCat)>0){
												print '<option value="">Select invoice category</option>';
												while($cat=mysqli_fetch_assoc($queryCat)){
													print '<option value="'.$cat['category'].'">'.$cat['category'].'</option>';
												}
											}
											else{
												print '<option value="">Invoice Categories not available</option>';
											}
										?>
									</select>
								</div>
							</div>
							<div class="col-md-4 col-lg-4 col-xl-4">
								<div class="form-group">
									<label>Receiver Name</label>
									<input placeholder="Enter receiver name" type="text" id="receiverName" class="form-control" >
								</div>
							</div>
							<div class="col-md-4 col-lg-4 col-xl-4">
								<div class="form-group">
									<label>Receiver Phone</label>
									<input placeholder="Enter receiver phone" type="text" id="receiverPhone" class="form-control" >
								</div>
							</div>
							<div class="col-md-4 col-lg-4 col-xl-4">
								<div class="form-group">
									<label>Receiver Email</label>
									<input placeholder="Enter receiver email" type="text" id="receiverEmail" class="form-control" >
								</div>
							</div>
							<div class="col-md-4 col-lg-4 col-xl-4">
								<div class="form-group">
									<label>Due Date</label>
									<input type="text" class="form-control" id="dueDate" data-inputmask-alias="datetime" data-inputmask-inputformat="dd/mm/yyyy" data-mask>
								</div>
							</div>
							
							<br/>
							<div class="col-md-12 col-lg-12 col-xl-12">
								<h5><br>Invoice Item</h5>
								<hr />
							</div>
							<div class="col-md-5 col-lg-5 col-xl-5">
								<div class="form-group">
									<label>Item Name</label>
									<input placeholder="Enter item name" type="text" id="itemName" class="form-control" >
								</div>
							</div>
							<div class="col-md-5 col-lg-5 col-xl-5">
								<div class="form-group">
									<label>Item Description</label>
									<input placeholder="Enter description" type="text" id="itemDescription" class="form-control" >
								</div>
							</div>
							<div class="col-md-2 col-lg-2 col-xl-2">
								<div class="form-group">
									<label>Amount</label>
									<input placeholder="amount" type="number" min="1" step="1" id="itemAmount" class="form-control" >
								</div>
							</div>
						</div>
					<div class="modal-footer bg-info justify-content-between">
					  <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
					  <button type="button" class="btn btn-secondary" id="createInvoice">Create Invoice <i class="fa fa-check-circle"></i></button>
					</div>
				  </div>
				  <!-- /.modal-content -->
				</div>
			</div>
		</div>
<?php 
	}else{ 
		
		if($invoiceDet['status']=='Pending'){
			$status = '<span class="badge badge-primary">Pending</span>';
		}
		elseif($invoiceDet['status']=='Approved'){
			$status = '<span class="badge badge-success">Approved</span>';
		}
		elseif($invoiceDet['status']=='Deleted'){
			$status = '<span class="badge badge-danger">Deleted</span>';
		}
		//$
?>
	<section class="content">
      <div class="container-fluid">
        <div class="row" id="invoiceDetails"></div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </section>

	<div class="modal fade" id="edit-item">
		<div class="modal-dialog modal-lg">
			<div class="modal-content">
				<div class="modal-header bg-info">
					<h4 class="modal-title">Edit <strong id="editHeading"></strong></h4>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body" id="editDetails">
					
				</div>
				<input type="hidden" name="itemId" value="<?php print $invoiceItem['item_id']; ?>" />
				<div class="modal-footer bg-info justify-content-between">
					<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
					<button type="submit" class="btn btn-secondary" id="editItem">Save Changes <i class="fa fa-check-circle"></i></button>
				</div>
			</div>
			<!-- /.modal-content -->
		</div>
		<!-- /.modal-dialog -->
	</div>

	<div class="modal fade" id="delete-item">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header bg-danger">
					<h4 class="modal-title">Delete <strong id="delHeading"></strong></h4>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span></button>
				</div>
				<div class="modal-body">
						<p>Are you sure you want to <strong>delete</strong> this invoice item?</p>
				</div>
				<input type="hidden" name="item_id" value="<?php print $invoiceItem['item_id']; ?>" />
				<div class="modal-footer bg-danger justify-content-between">
					<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
					<button type="submit" class="btn btn-secondary" name="deleteItem">Yes, Delete</button>
				</div>
			</div>
			<!-- /.modal-content -->
		</div>
		<!-- /.modal-dialog -->
	</div>


		<div class="modal fade" id="add-item">
			<div class="modal-dialog modal-lg">
				  <form class="modal-content" method="post" id="quickForm">
					<div class="modal-header bg-success">
					  <h4 class="modal-title">Add New Item</h4>
					  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					  </button>
					</div>
					<div class="modal-body">
						<div class="row">
							<div class="col-md-5 col-lg-5 col-xl-5">
								<div class="form-group">
									<label>Item Name</label>
									<input placeholder="Enter item name" type="text" name="item_name" class="form-control" >
								</div>
							</div>
							<div class="col-md-5 col-lg-5 col-xl-5">
								<div class="form-group">
									<label>Item Description</label>
									<input placeholder="Enter description" type="text" name="item_description" class="form-control" >
								</div>
							</div>
							<div class="col-md-2 col-lg-2 col-xl-2">
								<div class="form-group">
									<label>Amount</label>
									<input placeholder="amount" type="number" min="1" step="1" name="item_amount" class="form-control" >
								</div>
							</div>
						</div>
					<div class="modal-footer bg-success justify-content-between">
					  <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
					  <button type="submit" class="btn btn-secondary" name="addItem">Submit <i class="fa fa-check-circle"></i></button>
					</div>
				  </form>
				  <!-- /.modal-content -->
				</div>
			</div>
		</div>

<?php } ?>
	
  </div>
  
<script>
	function myFunction(){
	  window.print();
	}
</script>  
 
<?php @include $webdir.'footer.php'; ?>
