<?php
    $dir = './';
    $title = 'Office Expenses';
    $page = 'Invoices';
    $expenseMenu = 'active';

    if(empty($_GET['action'])){
		$queryInvoices = mysqli_query($db_conn, "SELECT a.city,a.status,a.state,a.country,a.invoice_no, a.invoice_name,a.invoice_category,a.receiver_name,a.receiver_company,a.receiver_phone,a.receiver_email,a.receiver_address,a.payment_due_date,a.payment_channel,a.payment_id,a.generated_on,a.approved_on,b.last_name as generator_lname, b.first_name as generator_fname FROM tbl_invoices a, tbl_users b WHERE a.status!='Deleted' AND b.unique_id=a.generated_by");
	}
	else{
		
	}
	$queryInvoice = mysqli_query($db_conn, "SELECT a.city,a.state,a.country,a.invoice_no,a.status, a.invoice_name,a.invoice_category,a.receiver_name,a.receiver_company,a.receiver_phone,a.receiver_email,a.receiver_address,a.payment_due_date,a.payment_channel,a.payment_id,a.generated_on,a.approved_on,b.last_name as generator_lname, b.first_name as generator_fname FROM tbl_invoices a, tbl_users b WHERE a.invoice_no='".$_GET['invid']."' AND b.unique_id=a.generated_by");
	
	
	
	if(!empty($_GET['invid']) AND mysqli_num_rows($queryInvoice)>0){
		$invoiceDet = mysqli_fetch_assoc($queryInvoice);
	}
?>
<?php include($dir.'pages/universal/header.php'); ?>
    <div id="page" data-id="invoices" title="onboard"></div>
	<input type="hidden" id="dataUrl" value="<?php echo $dir; ?>" />
	<input type="hidden" id="invid" value="<?php echo $_GET['invid']; ?>" />

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1><?php echo $title; ?></h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item"><a href="#"><?php echo $page; ?></a></li>
              <li class="breadcrumb-item active"><?php echo $title; ?></li>
            </ol>
          </div>
          <br><br>
		  <div class="col-sm-12" align="right">
			<?php if(empty($_GET['invid']) || mysqli_num_rows($queryInvoice)<1){ ?>
				<button type="button" class="btn btn-sm btn-info pull-right" data-toggle="modal" data-target="#add-invoice">
				  <i class="fas fa-plus"></i> Add New Invoice
				</button>
				<?php if($user['user_type'] == 'super_admin'){ ?>
					<button type="button" class="btn btn-sm btn-danger pull-right" onclick="location.href='./?action=deleted';">
					  <i class="fas fa-trash"></i> Deleted Invoices
					</button>
				<?php } ?>
			<?php }else{ ?>
				<?php if($invoiceDet['status']=='Pending'){ ?>
				<button type="button" class="btn btn-info pull-right" data-toggle="modal" data-target="#add-item"><i class="far fa-credit-card"></i> Add Item</button>
				<?php } ?>
				<button type="button" onclick="location.href='./';" class="btn btn-danger pull-right"><i class="fa fa-times-circle"></i> Close</button>
			<?php } ?>
		  </div><br><br>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    
    <?php if(empty($_GET['invid']) || mysqli_num_rows($queryInvoice)<1){ ?>
	<input type="hidden" id="main" value="load-data" />
    <section class="content">
      <div class="row">
        <div class="col-12" id="mainLoad"></div>
	  </div>

    </section>
	
		
<?php 
	}else{ 
		
		if($invoiceDet['status']=='Pending'){
			$status = '<span class="badge badge-primary">Pending</span>';
		}
		elseif($invoiceDet['status']=='Approved'){
			$status = '<span class="badge badge-info">Approved</span>';
		}
		elseif($invoiceDet['status']=='Deleted'){
			$status = '<span class="badge badge-danger">Deleted</span>';
		}
		//$
?>
	<section class="content">
      <div class="container-fluid">
        <div class="row" id="invoiceDetails">

        <div class="col-12">
    <div class="callout callout-info no-print">
        <h5><strong><?php print $invoiceDet['invoice_name']; ?></strong></h5>				
    </div>

            <!-- Main content -->
			<div class="position-relative">
                <div class="invoice p-3 mb-3">
              <!-- title row -->
					  <div class="row">
						<div class="col-md-12 col-xl-12 col-lg-12">
						  <h1 class="text-center text-info">
							<strong><?php print $appName; ?><br><?php print $invoiceDet['invoice_name']; ?></strong>
						  </h1><hr />
						</div>
						
						<!-- /.col -->
					  </div>
					  <!-- info row -->
					  <div class="row invoice-info">
						<div class="col-sm-4 invoice-col">
						  From
						  <address>
							<strong><?php print $invoiceDet['generator_lname'].' '.$invoiceDet['generator_fname']; ?></strong>,<br>
							<strong><?php print $appName; ?></strong><br>
							Email: <?php print $appDetail['app_email']; ?>
						  </address>
						</div>
						<!-- /.col -->
						<div class="col-sm-4 invoice-col">
						  To
						  <address>
							<strong><?php print $invoiceDet['receiver_name']; ?>,</strong><br>
							Phone: <?php print $invoiceDet['receiver_phone']; ?><br>
							Email: <?php print $invoiceDet['receiver_email']; ?>
						  </address>
						</div>
						<!-- /.col -->
						<div class="col-sm-4 invoice-col">
						  <b>Invoice #<?php print $invoiceDet['invoice_no']; ?></b><br>
						  <?php if ($invoiceDet['status']=='Approved'){print '<b>Order ID:</b> '.$invoiceDet['payment_id'].'<br>';}; ?>
						  <b>Payment Due:</b> <?php print $invoiceDet['payment_due_date']; ?><br>
						  <b>Status: </b> <?php print $status; ?><br>
						  <?php if($invoiceDet['status']=='Approved'){ ?>
							<b>Approval Date: </b> <?php print $invoiceDet['approved_on']; ?><br>
						  <?php } ?>
						</div>
						<!-- /.col -->
					  </div>
					  <!-- /.row -->

					  <!-- Table row -->
					  <div class="row">
						<div class="col-12 table-responsive">
						  <table class="table table-striped">
							<thead>
							<tr>
							  <th>#</th>
							  <th>Item Name</th>
							  <th>Description</th>
							  <th>Amount (&#x20A6;)</th>
							  <?php if($invoiceDet['status']=='Pending'){ ?><th class="no-print"></th><?php } ?>
							</tr>
							</thead>
							<tbody>
							<?php
								$number = 1;
								$totalAmount = 0;
								$queryItems = mysqli_query($db_conn, "SELECT * FROM tbl_invoice_items WHERE invoice_no='".$invoiceDet['invoice_no']."'");
								while($invoiceItem = mysqli_fetch_assoc($queryItems)){
									$value = explode('.', $invoiceItem['amount']);
									$main = $value[0];
									$decimal = $value[1];
									if(empty($decimal)){
										$amount = number_format($main);
									}
									else{
										$amount = number_format($main).'.'.$decimal;
									}
							?>
							<tr>
							  <td><?php print $number; ?></td>
							  <td><?php print strtoupper($invoiceItem['item_name']); ?></td>
							  <td><?php print $invoiceItem['description']; ?></td>
							  <td><?php print $amount; ?></td>
							  <?php if($invoiceDet['status']=='Pending'){ ?>
							  <td class="no-print">
								<button type="button" class="btn btn-info btn-xs" data-toggle="modal" data-target="#edit-item" data-id="<?php print $invoiceItem['item_id']; ?>"><i class="fas fa-edit"></i></button>
								<button type="button" class="btn btn-danger btn-xs" data-toggle="modal" data-target="#delete-item" data-id="<?php print $invoiceItem['item_id']; ?>"><i class="fa fa-trash"></i></button>
							  </td><?php } ?>
							</tr>
							
							
							
							<?php 
									$number++;
									$totalAmount+=$invoiceItem['amount'];
								} 
								$invoiceAmount = $totalAmount;
								$value = explode('.', $totalAmount);
								$main = $value[0];
								$decimal = $value[1];
								if(empty($decimal)){
									$totalAmount = '&#x20A6;'.number_format($main);
								}
								else{
									$totalAmount = '&#x20A6;'.number_format($main).'.'.$decimal;
								}
							?>
							</tbody>
						  </table>
						</div>
						<!-- /.col -->
					  </div>
					  <!-- /.row -->

					  <div class="row">
						<!-- accepted payments column -->
						<div class="col-6">
						  <!--<p class="lead">Payment Methods:</p>
						  <img src="<?php print $webdir; ?>dist/img/credit/visa.png" alt="Visa">
						  <img src="<?php print $webdir; ?>dist/img/credit/mastercard.png" alt="Mastercard">
						  <img src="<?php print $webdir; ?>dist/img/credit/american-express.png" alt="American Express">
						  <img src="<?php print $webdir; ?>dist/img/credit/paypal2.png" alt="Paypal">

						  <p class="text-muted well well-sm shadow-none" style="margin-top: 10px;">
							Etsy doostang zoodles disqus groupon greplin oooj voxy zoodles, weebly ning heekya handango imeem
							plugg
							dopplr jibjab, movity jajah plickers sifteo edmodo ifttt zimbra.
						  </p>-->
						</div>
						<!-- /.col -->
						<div class="col-6">
						  <p class="lead">Payment Due <b><?php print $invoiceDet['payment_due_date']; ?></b></p>

						  <div class="table-responsive">
							<table class="table">
							  <tr>
								<th width="20%"><h3><strong>Total:</strong></h3></th>
								<td><h3><strong><?php print $totalAmount; ?></strong></h3></td>
							  </tr>
							  <tr>
								<th></th>
								<td></td>
							  </tr>
							  <!--<tr>
								<th>Tax (9.3%)</th>
								<td>$10.34</td>
							  </tr>
							  <tr>
								<th>Shipping:</th>
								<td>$5.80</td>
							  </tr>-->
							  
							</table>
						  </div>
						</div>
						<!-- /.col -->
					  </div>
					  <!-- /.row -->

					  <!-- this row will not appear when printing -->
					  <div class="row no-print">
						<div class="col-12">
						  <button rel="noopener" type="button" onclick="myFunction()" class="btn btn-primary btn-sm"><i class="fas fa-print"></i> Print</button> 
						  <?php if($invoiceDet['status']=='Pending'){ ?>
						  <button type="button" class="btn btn-info btn-sm float-right" data-toggle="modal" data-target="#approve-invoice"><i class="fa fa-check-circle"></i> Approve Invoice</button>
						  <button type="button" class="btn btn-danger btn-sm float-right" style="margin-right: 5px;"  data-toggle="modal" data-target="#reject-invoice"><i class="fas fa-download"></i> Reject Invoice</button>
						  <?php }elseif($invoiceDet['status']=='Approved'){ ?>
						  <button type="button" class="btn btn-info btn-sm float-right" data-toggle="modal" data-target="#disburse-fund"><i class="fa fa-check-circle"></i> Disburse Fund</button>
						  <?php } ?>
						</div>
					  </div>
					  <div class="modal fade" id="approve-invoice">
						<div class="modal-dialog">
						  <div class="modal-content">
							<div class="modal-header bg-info">
							  <h4 class="modal-title">APPROVE <strong><?php print $invoiceDet['invoice_name']; ?></strong></h4>
							  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">&times;</span></button>
							</div>
							<form method="post">
								<div class="modal-body text-center">
									 <p>Immediately this is approved, the disbursement officer will be notified. Are you sure you want to <strong>APPROVE</strong> this invoice?</p>
									 <div class="col-md-5 col-lg-5 col-xl-5">
										<div class="form-group">
											<label>Item Name</label>
											<input placeholder="Enter item name" type="text" name="item_name" class="form-control" >
										</div>
									</div>
									<div class="col-md-5 col-lg-5 col-xl-5">
										<div class="form-group">
											<label>Item Description</label>
											<input placeholder="Enter description" type="text" name="item_description" class="form-control" >
										</div>
									</div>
									<div class="col-md-2 col-lg-2 col-xl-2">
										<div class="form-group">
											<label>Amount</label>
											<input placeholder="amount" type="number" min="1" step="1" name="item_amount" class="form-control" >
										</div>
									</div>
								</div>
								<input type="hidden" name="invoice_no" value="<?php print $invoiceDet['invoice_no']; ?>" />
								<input type="hidden" name="invoice_amount" value="<?php print $invoiceAmount; ?>" />
								<div class="modal-footer bg-info justify-content-between">
								  <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
								  <button type="submit" class="btn btn-secondary" name="DisburseFund">Yes, Disburse</button>
								</div>
							</form>
						  </div>
						  <!-- /.modal-content -->
						</div>
						<!-- /.modal-dialog -->
					  </div>
					  <div class="modal fade" id="disburse-fund">
						<div class="modal-dialog">
						  <div class="modal-content">
							<div class="modal-header bg-info">
							  <h4 class="modal-title">DISBURSE FUND FOR <strong><?php print $invoiceDet['invoice_name']; ?></strong></h4>
							  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">&times;</span></button>
							</div>
							<form method="post">
								<div class="modal-body text-center">
									 <p> <strong>APPROVE</strong> this invoice?</p>
								</div>
								<input type="hidden" name="invoice_no" value="<?php print $invoiceDet['invoice_no']; ?>" />
								<input type="hidden" name="invoice_amount" value="<?php print $invoiceAmount; ?>" />
								<div class="modal-footer bg-info justify-content-between">
								  <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
								  <button type="submit" class="btn btn-secondary" name="approveInvoice">Yes, Approve</button>
								</div>
							</form>
						  </div>
						  <!-- /.modal-content -->
						</div>
						<!-- /.modal-dialog -->
					  </div>
					  <div class="modal fade" id="reject-invoice">
						<div class="modal-dialog modal-md">
						  <div class="modal-content">
							<div class="modal-header bg-info">
							  <h4 class="modal-title">REJECT <strong><?php print $invoiceDet['invoice_name']; ?></strong></h4>
							  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">&times;</span></button>
							</div>
							<form method="post" id="rejectForm">
								<div class="modal-body">
									<div class="row">
										<div class="col-md-12 col-lg-12 col-xl-12">
											<div class="form-group">
												<label>Rejection Reason</label>
												<textarea placeholder="Enter post here" rows="5" required name="reject_reason" class="form-control"></textarea>
											</div>
										</div>
									</div>
								</div>
								<input type="hidden" name="invoice_no" value="<?php print $invoiceDet['invoice_no']; ?>" />
								<input type="hidden" name="invoice_amount" value="<?php print $invoiceAmount; ?>" />
								<div class="modal-footer bg-info justify-content-between">
								  <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
								  <button type="submit" class="btn btn-secondary" name="rejectInvoice">Reject Now</button>
								</div>
							</form>
						  </div>
						  <!-- /.modal-content -->
						</div>
						<!-- /.modal-dialog -->
					  </div>
				</div> 
			  <div class="ribbon-wrapper ribbon-xl">
				<?php
					if($invoiceDet['status']=='Pending'){
						print '<div class="ribbon bg-warning text-lg">'.$invoiceDet['status'].'</div>';
					}elseif($invoiceDet['status']=='Approved'){
						print '<div class="ribbon bg-info text-lg">'.$invoiceDet['status'].'</div>';
					}elseif($invoiceDet['status']=='Disbursed'){
						print '<div class="ribbon bg-info text-lg">'.$invoiceDet['status'].'</div>';
					}elseif($invoiceDet['status']=='Rejected'){
						print '<div class="ribbon bg-danger text-lg">'.$invoiceDet['status'].'</div>';
					}
				?>
			  </div>
			</div>
          </div><!-- /.col -->




        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </section>

	<div class="modal fade" id="edit-item">
		<div class="modal-dialog modal-lg">
			<div class="modal-content">
				<div class="modal-header bg-info">
					<h4 class="modal-title">Edit <strong id="editHeading"></strong></h4>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body" id="editDetails">
					
				</div>
				<input type="hidden" name="itemId" value="<?php print $invoiceItem['item_id']; ?>" />
				<div class="modal-footer bg-info justify-content-between">
					<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
					<button type="submit" class="btn btn-secondary" id="editItem">Save Changes <i class="fa fa-check-circle"></i></button>
				</div>
			</div>
			<!-- /.modal-content -->
		</div>
		<!-- /.modal-dialog -->
	</div>

	<div class="modal fade" id="delete-item">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header bg-danger">
					<h4 class="modal-title">Delete <strong id="delHeading"></strong></h4>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span></button>
				</div>
				<div class="modal-body">
						<p>Are you sure you want to <strong>delete</strong> this invoice item?</p>
				</div>
				<input type="hidden" name="item_id" value="<?php print $invoiceItem['item_id']; ?>" />
				<div class="modal-footer bg-danger justify-content-between">
					<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
					<button type="submit" class="btn btn-secondary" name="deleteItem">Yes, Delete</button>
				</div>
			</div>
			<!-- /.modal-content -->
		</div>
		<!-- /.modal-dialog -->
	</div>


	<div class="modal fade" id="add-item">
		<div class="modal-dialog modal-lg">
				<form class="modal-content" method="post" id="quickForm">
				<div class="modal-header bg-info">
					<h4 class="modal-title">Add New Item</h4>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<div class="row">
						<div class="col-md-5 col-lg-5 col-xl-5">
							<div class="form-group">
								<label>Item Name</label>
								<input placeholder="Enter item name" type="text" name="item_name" class="form-control" >
							</div>
						</div>
						<div class="col-md-5 col-lg-5 col-xl-5">
							<div class="form-group">
								<label>Item Description</label>
								<input placeholder="Enter description" type="text" name="item_description" class="form-control" >
							</div>
						</div>
						<div class="col-md-2 col-lg-2 col-xl-2">
							<div class="form-group">
								<label>Amount</label>
								<input placeholder="amount" type="number" min="1" step="1" name="item_amount" class="form-control" >
							</div>
						</div>
					</div>
				<div class="modal-footer bg-info justify-content-between">
					<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
					<button type="submit" class="btn btn-secondary" name="addItem">Submit <i class="fa fa-check-circle"></i></button>
				</div>
				</form>
				<!-- /.modal-content -->
			</div>
		</div>
	</div>

<?php } ?>
    <!-- /.content -->
  </div>

<!--////////MODALS///////////-->
	<div class="modal fade" id="edit-invoice">
		<div class="modal-dialog modal-lg">
			<div class="modal-content" id="editInvoiceBody">
				
			</div>
			<!-- /.modal-content -->
		</div>
		<!-- /.modal-dialog -->
	</div>

	<div class="modal fade" id="add-invoice">
		<div class="modal-dialog modal-lg">
			<div class="modal-content">
				<div class="modal-header bg-info">
					<h4 class="modal-title">Add New Invoice</h4>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<div class="row">
						<div class="col-md-12 text-center" id="invoiceMsg"></div>

						<div class="col-md-4 col-lg-4 col-xl-4">
							<div class="form-group">
								<label>Invoice Name</label>
								<input placeholder="Enter invoice Name" type="text" id="invoiceName" class="form-control" >
							</div>
						</div>
						<div class="col-md-4 col-lg-4 col-xl-4">
							<div class="form-group">
								<label>Invoice Type</label>
								<select class="form-control select2bs4"  id="invoiceType" style="width: 100%;">
									<?php 
										$queryCat = mysqli_query($db_conn, "SELECT * FROM tbl_invoice_category WHERE status=1 ORDER BY category ASC");
										if(mysqli_num_rows($queryCat)>0){
											print '<option value="">Select invoice category</option>';
											while($cat=mysqli_fetch_assoc($queryCat)){
												print '<option value="'.$cat['category'].'">'.$cat['category'].'</option>';
											}
										}
										else{
											print '<option value="">Invoice Categories not available</option>';
										}
									?>
								</select>
							</div>
						</div>
						<div class="col-md-4 col-lg-4 col-xl-4">
							<div class="form-group">
								<label>Receiver Name</label>
								<input placeholder="Enter receiver name" type="text" id="receiverName" class="form-control" >
							</div>
						</div>
						<div class="col-md-4 col-lg-4 col-xl-4">
							<div class="form-group">
								<label>Receiver Phone</label>
								<input placeholder="Enter receiver phone" type="text" id="receiverPhone" class="form-control" >
							</div>
						</div>
						<div class="col-md-4 col-lg-4 col-xl-4">
							<div class="form-group">
								<label>Receiver Email</label>
								<input placeholder="Enter receiver email" type="text" id="receiverEmail" class="form-control" >
							</div>
						</div>
						<div class="col-md-4 col-lg-4 col-xl-4">
							<div class="form-group">
								<label>Due Date</label>
								<input type="text" class="form-control" id="dueDate" data-inputmask-alias="datetime" data-inputmask-inputformat="dd/mm/yyyy" data-mask>
							</div>
						</div>

						<div class="col-md-12 col-lg-12 col-xl-12">
							<div class="form-group">
								<label>Receiver Organization</label>
								<input placeholder="Enter receiver organization" type="text" id="receiverCompany" value="<?php echo $invoiceDetails['receiver_company']; ?>" class="form-control" >
							</div>
						</div>
						<div class="col-md-4 col-lg-4 col-xl-4">
							<div class="form-group">
								<label>Country</label>
								<select class="form-control select2bs4"  id="country" style="width: 100%;">
									<?php 
										$queryCountry = mysqli_query($db_conn, "SELECT * FROM countries WHERE status=1 ORDER BY country_name ASC");
										if(mysqli_num_rows($queryCountry)>0){
											echo '<option value="">Select Country</option>';
											while($country=mysqli_fetch_assoc($queryCountry)){
												echo '<option value="'.$country['country_id'].'">'.$country['country_name'].'</option>';
											}
										}
										else{
											print '<option value="">Countries not available</option>';
										}
									?>
								</select>
							</div>
						</div>
						<div class="col-md-4 col-lg-4 col-xl-4">
							<div class="form-group">
								<label>State</label>
								<select class="form-control select2bs4"  id="state" style="width: 100%;">
									<option value="">Select Country first</option>
								</select>
							</div>
						</div>
						<div class="col-md-4 col-lg-4 col-xl-4">
							<div class="form-group">
								<label>City</label>
								<select class="form-control select2bs4"  id="city" style="width: 100%;">
									<option value="">Select State first</option>
								</select>
							</div>
						</div>
						
						<div class="col-md-12 col-lg-12 col-xl-12">
							<div class="form-group">
								<label>Receiver Address</label>
								<input placeholder="Enter receiver address" type="text" id="receiverAddress" class="form-control" >
							</div>
						</div>
						
						<br/>
						<div class="col-md-12 col-lg-12 col-xl-12">
							<h5><br>Invoice Item</h5>
							<hr />
						</div>
						<div class="col-md-5 col-lg-5 col-xl-5">
							<div class="form-group">
								<label>Item Name</label>
								<input placeholder="Enter item name" type="text" id="itemName" class="form-control" >
							</div>
						</div>
						<div class="col-md-5 col-lg-5 col-xl-5">
							<div class="form-group">
								<label>Item Description</label>
								<input placeholder="Enter description" type="text" id="itemDescription" class="form-control" >
							</div>
						</div>
						<div class="col-md-2 col-lg-2 col-xl-2">
							<div class="form-group">
								<label>Amount</label>
								<input placeholder="amount" type="number" min="1" step="1" id="itemAmount" class="form-control" >
							</div>
						</div>
					</div>
					<div class="modal-footer bg-info justify-content-between">
						<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
						<button type="button" class="btn btn-secondary" id="createInvoice">Create Invoice <i class="fa fa-check-circle"></i></button>
					</div>
				</div>  
			</div>
			<!-- /.modal-content -->
		</div>
		<!-- /.modal-dialog -->
	</div>



  <script>
	function myFunction(){
	  window.print();
	}
</script> 
  <!-- /.content-wrapper -->
  <?php include($dir.'pages/universal/footer.php'); ?>