<?php
    $dir = './';
    $title = 'Approved Crypto Payments';
    $paymentsMenu = 'active';
    $paymentsMenuState = 'menu-open';
    $cryptoPaymentsMenuState = 'menu-open';
    $approvedCryptoMenu = 'active';
    $currentPage = 'Payments';
?>
<?php include($dir.'pages/universal/header.php'); ?>
    
      <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <input type="hidden" id="currentPage" value="<?php echo $currentPage; ?>" />
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Approved Crypto Payments</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Approved Payments</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
<?php
    $queryPayments = mysqli_query($db_conn, "SELECT * FROM tbl_payments WHERE channel='Crypto' AND status='Completed' ORDER BY date_paid DESC");
?>
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-info">
              <div class="inner">
                <h3 id="usdtAll"></h3>

                <p>All Payments</p>
              </div>
              <div class="icon">
                <i class="ion ion-stats-bars"></i>
              </div>
              <a href="javascript:void();" onclick="location.href='./?loc=crypto-payments';" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <!-- ./col -->
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-success">
              <div class="inner">
                <h3 id="usdtApproved"></h3>

                <p>All Approved</p>
              </div>
              <div class="icon">
                <i class="ion ion-stats-bars"></i>
              </div>
              <a href="javascript:void();" onclick="location.href='./?loc=crypto-payments-approved';" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <!-- ./col -->
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-warning">
              <div class="inner">
                <h3 id="usdtPending"></h3>

                <p>Pending Approval</p>
              </div>
              <div class="icon">
                <i class="ion ion-stats-bars"></i>
              </div>
              <a href="javascript:void();" onclick="location.href='./?loc=crypto-payments-pending';" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <!-- ./col -->
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-danger">
              <div class="inner">
                <h3 id="usdtRejected"></h3>

                <p>Rejected Payments</p>
              </div>
              <div class="icon">
                <i class="ion ion-stats-bars"></i>
              </div>
              <a href="javascript:void();" onclick="location.href='./?loc=crypto-payments-rejected';" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <!-- ./col -->
        </div>
        <div class="row">
          <div class="col-12">
            <div class="card card-info">
              <div class="card-header">
                <h3 class="card-title">Payments (<?php echo mysqli_num_rows($queryPayments); ?>)</h3>
              </div>
              
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                    <tr>
                        <th>S/N</th>
                        <th>Payer</th>
                        <th>Amount</th>
                        <th>Email</th>
                        <th>Channel</th>
                        <th>Date</th>
                        <th></th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php
                        $number = 1;
                        $totalAmount = 0;
                        while($payments=mysqli_fetch_assoc($queryPayments)){
                    ?>
                    <tr>
                        <td><?php echo $number; ?></td>
                        <td><?php echo ucwords(strtolower($payments['last_name'].' '.$payments['first_name'])); ?></td>
                        <td><?php echo numberFormat($payments['amount']); ?></td>
                        <td><?php echo $payments['email']; ?></td>
                        <td><?php echo $payments['channel']; ?></td>
                        <td><?php echo timeCheck($payments['date_paid']); ?></td>
                        <td>
                          <?php if($payments['status']=='Success'){ ?>
                            <button class="btn btn-info btn-sm" data-toggle="modal" data-target="#view-details" data-id="<?php echo $payments['payment_id']; ?>"><i class="fa fa-eye"></i></button>
                            <button class="btn btn-info btn-sm" data-toggle="modal" data-target="#approve" data-id="<?php echo $payments['payment_id']; ?>"><i class="fa fa-check-square"></i> </button>
                            <button class="btn btn-warning btn-sm" data-toggle="modal" data-target="#reject" data-id="<?php echo $payments['payment_id']; ?>"><i class="fa fa-times-circle"></i></button>
                            <button class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></button>
                          <?php } ?>
                        </td>
                    </tr>
                    <?php $number++; $totalAmount += $payments['amount']; } ?>
                  </tbody>
                  <tfoot>
                    <tr>
                        <th></th>
                        <th></th>
                        <th><?php echo numberFormat($totalAmount); ?></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                    </tr>
                  </tfoot>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    
    <div class="modal fade" id="approveAll">
        <div class="modal-dialog">
          <div class="modal-content">
            <div class="modal-header bg-info">
              <h4 class="modal-title" id="approveAllHeader"></h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <p id="approveAllBody"></p>
              <input type="hidden" value="" id="channel" />
            </div>
            <div class="modal-footer justify-content-between">
              <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
              <button type="button" class="btn btn-info" id="approveAllBtn">Yes, Approve All</button>
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    <div class="modal fade" id="approve">
        <div class="modal-dialog">
          <div class="modal-content">
            <div class="modal-header bg-info">
              <h4 class="modal-title" id="approveHeader"></h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <p id="approveBody">One fine body&hellip;</p>
              <input type="hidden" id="paymentIdApprove" value="" />
            </div>
            <div class="modal-footer justify-content-between">
              <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
              <button type="button" class="btn btn-info" id="approveBtn">Yes, Approve</button>
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    <div class="modal fade" id="reject">
        <div class="modal-dialog">
          <div class="modal-content">
            <div class="modal-header bg-danger">
              <h4 class="modal-title" id="rejectHeader"></h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <p id="rejectBody">

              </p>
              <input type="hidden" id="paymentId" value="" />
            </div>
            <div class="modal-footer justify-content-between">
              <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
              <button type="button" class="btn btn-danger" id="rejectBtn">Yes, Reject</button>
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    <div class="modal fade" id="view-details">
        <div class="modal-dialog modal-lg">
          <div class="modal-content">
            <div class="modal-header bg-info">
              <h4 class="modal-title" id="detailsHeader">Payment Detail for <b id="payerName"></b></h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body" id="detailsBody">
              
            </div>
            <div class="modal-footer justify-content-between">
              <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <?php include($dir.'pages/universal/footer.php'); ?>
