<?php
    $dir = './';
    $title = 'My Profile';
    $page = 'Profile';
    $profileMenu = 'active';
    $profileMenuState = 'menu-open';
    $profileListMenu = 'active';
    $currentPage = 'My Profile'
?>
<?php include($dir.'pages/universal/header.php'); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <div id="systemNotification"></div>
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1><?php echo $title; ?></h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item"><a href="#"><?php echo $page; ?></a></li>
              <li class="breadcrumb-item active"><?php echo $title; ?></li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-md-5">
            <div class="card card-widget widget-user">
              <!-- Add the bg color to the header using any of the bg-* classes -->
              <div class="widget-user-header bg-info" id="bgImageDisplay" style="background: url('<?php echo $bgImage; ?>') center center;">
                <h2 class="widget-user-username"><b><?php echo $myName; ?></b></h2>
                <h5 class="widget-user-desc"><?php echo $designation; ?></h5>
                <div class="pull-right" style="float: right;"><a href="javascript:void();" data-toggle="modal" data-target="#update-bg"><i class="fa fa-edit"></i></a></div>
              </div>
              <a href="javascript:void();" data-toggle="modal" data-target="#update-profile">
                <div class="widget-user-image">
                  <img class="img-circle elevation-4" src="<?php print $userImage; ?>" alt="<?php print $myName; ?> profile picture" id="displayImage3">
                </div>
              </a>
              
              <div class="card-footer">
                <div class="row">
                  <div class="col-sm-3 border-right">
                    <div class="description-block">
                      <h5 class="description-header">0</h5>
                      <span class="description-text">SALES</span>
                    </div>
                    <!-- /.description-block -->
                  </div>
                  <!-- /.col -->
                  <div class="col-sm-3 border-right">
                    <div class="description-block">
                      <h5 class="description-header">0</h5>
                      <span class="description-text">CONTACTS</span>
                    </div>
                    <!-- /.description-block -->
                  </div>
                  <!-- /.col -->
                  <div class="col-sm-3">
                    <div class="description-block">
                      <h5 class="description-header">0</h5>
                      <span class="description-text">REFERRALS</span>
                    </div>
                    <!-- /.description-block -->
                  </div>
                  <div class="col-sm-3">
                    <div class="description-block">
                      <h5 class="description-header"><?php echo $naira; ?>0</h5>
                      <span class="description-text">EARNINGS</span>
                    </div>
                    <!-- /.description-block -->
                  </div>
                  <!-- /.col -->
                  
                </div><br><br>
                <div class="input-group col-md-12">
                  <div class="input-group-prepend">
                    <span class="input-group-text">Ref Link</span>
                  </div>
                  <?php
                    if(!empty($user['ref_link'])){
                      $btnId = 'copyLink';
                      $fav = '<i class="fa fa-copy"></i> Copy';
                      $link = $defaultUrl.'/?ref='.$user['ref_link'];
                    }
                    else{
                      $btnId = 'generateLink';
                      $fav = '<i class="fa fa-cog"></i> Generate Link';
                      
                      $link = '';
                    }

                    echo '<input type="text" disabled id="myLink" value="'.$link.'" class="form-control">
                      <span class="input-group-append">
                        <button type="button" class="btn btn-info btn-round" id="'.$btnId.'">'.$fav.'</button>
                      </span>';
                  ?>
                </div>
                <!-- /.row -->
              </div>
            </div>
            <!-- /.card -->

            <!-- About Me Box -->
            <div class="card card-info">
              <div class="card-header">
                <h3 class="card-title">About Me</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
              <div class="pull-right" style="float: right;"><a href="javascript:void();" data-toggle="modal" data-target="#add-education"><i class="fa fa-edit"></i></a></div>
                <strong><i class="fas fa-book mr-1"></i> Education</strong>
                <?php
                  $discipline = explode(' _ ', $user['discipline']);
                  if(sizeof($discipline) > 1){
                    $myQualification = trim($discipline[0]);
                    $institution = explode(' ? ',$discipline[1]);
                    if(sizeof($institution)>1){
                      $myInstitution = trim($institution[1]);
                      $myDiscipline = trim($institution[0]);
                    }
                    else{
                      $myInstitution = trim($institution[0]);
                      $myDiscipline = '';
                    }
                  }
                  else{
                    $institution = explode('?', $discipline[0]);
                    if(sizeof($institution)>1){
                      $myInstitution = trim($institution[1]);
                      $myQualification = trim($institution[0]);
                    }
                    else{
                      $myQualification = trim($institution[0]);
                    }
                  }
                ?>

                <p class="text-muted" id="discipline">
                  <?php
                    echo str_replace('?', '-',str_replace(' _',', ',$user['discipline']));
                  ?>
                </p>

                <hr>
                <div class="pull-right" style="float: right;"><a href="javascript:void();" data-toggle="modal" data-target="#edit-location"><i class="fa fa-edit"></i></a></div>
                <strong><i class="fas fa-map-marker-alt mr-1"></i> Location</strong>
                <?php
                  $myCity = $user['city'];
                  $myCity = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT name FROM lga WHERE id=$myCity LIMIT 1"));
                  $myCity = $myCity['name'];

                  $myState = $user['state'];
                  $myState = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT state_name FROM states WHERE state_id=$myState LIMIT 1"));
                  $myState = $myState['state_name'];

                  $myCountry = $user['country'];
                  $myCountry = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT country_name FROM countries WHERE country_id=$myCountry LIMIT 1"));
                  $myCountry = $myCountry['country_name'];
                ?>
                <p class="text-muted" id="location"><?php echo $myCity.', '.$myState.', '.$myCountry; ?></p>

                <hr>
                <div class="pull-right" style="float: right;"><a href="javascript:void();" data-toggle="modal" data-target="#add-skills"><i class="fa fa-edit"></i></a></div>
                <strong><i class="fas fa-pencil-alt mr-1"></i> Skills</strong>

                <p class="text-muted" id="mySkills">
                  <?php
                    $skills = explode(',', $user['skills']);
                    if(sizeof($skills)>0){
                      for($i = 0; $i<sizeof($skills); $i++){
                        echo '<span class="badge bg-info">'.$skills[$i].'</span> ';
                      }
                    }
                  ?>
                </p>

                <hr>
                <div class="pull-right" style="float: right;"><a href="javascript:void();" data-toggle="modal" data-target="#add-bio"><i class="fa fa-edit"></i></a></div>
                <strong><i class="far fa-file-alt mr-1"></i> Bio</strong>

                <p class="text-muted" id="myBio"><?php echo $user['bio']; ?></p>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
          <?php if($user['user_type']=='Super Administrator' AND $user['username']=='ajahjohn'){ ?>
          <div class="col-md-7">
            <div class="card">
              <div class="card-header p-2">
                <ul class="nav nav-pills">
                  <li class="nav-item"><a class="nav-link active" href="#settings" data-toggle="tab">Settings</a></li>
                  <li class="nav-item"><a class="nav-link" href="#activity" data-toggle="tab">Activity</a></li>
                  <li class="nav-item"><a class="nav-link" href="#timeline" data-toggle="tab">Timeline</a></li>
                </ul>
              </div><!-- /.card-header -->
              <div class="card-body">
                <div class="tab-content">
                  <div class="active tab-pane" id="settings">
                    <form class="row">
                      <div class="form-group col-md-4">
                        <label for="editProfileTitle">Title</label>
                        <input type="text" class="form-control" value="<?php echo $user['title']; ?>" id="editProfileTitle" placeholder="Title">
                      </div>
                      <div class="form-group col-md-4">
                        <label for="editProfileGender">Gender</label>
                        <select class="form-control select2bs4" id="updateProfileGender" required style="width: 100%;">
                          <?php
                            $query = mysqli_query($db_conn, "SELECT * FROM tbl_gender");
                            if(mysqli_num_rows($query)>0){
                              while($gender=mysqli_fetch_assoc($query)){
                                if($user['gender']==$gender['gender']){
                                  echo '<option value="'.$gender['gender'].'" selected>'.$gender['gender'].'</option>';
                                }
                                else{
                                  echo '<option value="'.$gender['gender'].'">'.$gender['gender'].'</option>';
                                }
                              }
                            }
                          ?>
                        </select>
                        <input type="text" class="form-control" value="<?php echo $user['gender']; ?>" id="editProfileGender" placeholder="Gender">
                      </div>
                      <div class="form-group col-md-4">
                        <label for="editProfileUsername">Username</label>
                        <input type="text" class="form-control" value="<?php echo $user['username']; ?>" id="editProfileUsername" placeholder="Username">
                      </div>
                      <div class="form-group col-md-4">
                        <label for="editProfileFirstName">First Name</label>
                        <input type="text" class="form-control" value="<?php echo $user['first_name']; ?>" id="editProfileFirstName" placeholder="First Name">
                      </div>
                      <div class="form-group col-md-4">
                        <label for="editProfileLastName">Last Name</label>
                        <input type="text" class="form-control" value="<?php echo $user['last_name']; ?>" id="editProfileLastName" placeholder="Last Name">
                      </div>
                      <div class="form-group col-md-4">
                        <label for="editProfileMiddleName">Middle Name</label>
                        <input type="text" class="form-control" value="<?php echo $user['middle_name']; ?>" id="editProfileMiddleName" placeholder="Middle Name">
                      </div>
                      <div class="form-group col-md-4">
                        <label for="editProfileEmail">Email <a href="javascript:void();" data-toggle="modal" data-target="#update-email"><small><i class="fa fa-edit"></i></small></a></label>
                        <input type="text" class="form-control" disabled value="<?php echo $user['email']; ?>" id="editProfileEmail" placeholder="Email Address">
                      </div>
                      <div class="form-group col-md-4">
                        <label for="editProfilePhone">Phone</label>
                        <input type="text" class="form-control" value="<?php echo $user['phone']; ?>" id="editProfilePhone" placeholder="Phone">
                      </div>
                      
                      <div class="form-group col-md-4">
                        <label for="dateOfBirth">Date of Birth</label>
                        <div class="input-group date" id="dateOfBirth" data-target-input="nearest">
                          <input type="text" class="form-control datetimepicker-input" id="dateOfBirthValue"  value="<?php echo date('m/d/Y', strtotime($user['dob'])); ?>" data-target="#dateOfBirth" />
                          <div class="input-group-append" data-target="#dateOfBirth" data-toggle="datetimepicker">
                              <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                          </div>
                        </div>
                      </div>
                      <div class="form-group col-md-12">
                        <label for="editProfileOrganization">Organization</label>
                        <input type="text" class="form-control" value="<?php echo $user['organization']; ?>" id="editProfileOrganization" placeholder="Organization">
                      </div>
                      <div class="form-group col-md-12">
                        <label for="editProfileAddress">Address</label>
                        <input type="text" class="form-control" value="<?php echo $user['address']; ?>" id="editProfileAddress" placeholder="Address">
                      </div>
                      
                      <div class="form-group col-md-12" align="right">
                        <button type="button" class="btn btn-info" id="updateProfileBtn"><i class="fa fa-save"></i> Save Changes</button>
                      </div>
                    </form>
                  </div>
                  <div class="tab-pane" id="activity">
                    <!-- Post -->
                    <div class="post">
                      <div class="user-block">
                        <img class="img-circle img-bordered-sm" src="<?php echo $dir; ?>dist/img/user1-128x128.jpg" alt="user image">
                        <span class="username">
                          <a href="#">Jonathan Burke Jr.</a>
                          <a href="#" class="float-right btn-tool"><i class="fas fa-times"></i></a>
                        </span>
                        <span class="description">Shared publicly - 7:30 PM today</span>
                      </div>
                      <!-- /.user-block -->
                      <p>
                        Lorem ipsum represents a long-held tradition for designers,
                        typographers and the like. Some people hate it and argue for
                        its demise, but others ignore the hate as they create awesome
                        tools to help create filler text for everyone from bacon lovers
                        to Charlie Sheen fans.
                      </p>

                      <p>
                        <a href="#" class="link-black text-sm mr-2"><i class="fas fa-share mr-1"></i> Share</a>
                        <a href="#" class="link-black text-sm"><i class="far fa-thumbs-up mr-1"></i> Like</a>
                        <span class="float-right">
                          <a href="#" class="link-black text-sm">
                            <i class="far fa-comments mr-1"></i> Comments (5)
                          </a>
                        </span>
                      </p>

                      <input class="form-control form-control-sm" type="text" placeholder="Type a comment">
                    </div>
                    <!-- /.post -->

                    <!-- Post -->
                    <div class="post clearfix">
                      <div class="user-block">
                        <img class="img-circle img-bordered-sm" src="<?php echo $dir; ?>dist/img/user7-128x128.jpg" alt="User Image">
                        <span class="username">
                          <a href="#">Sarah Ross</a>
                          <a href="#" class="float-right btn-tool"><i class="fas fa-times"></i></a>
                        </span>
                        <span class="description">Sent you a message - 3 days ago</span>
                      </div>
                      <!-- /.user-block -->
                      <p>
                        Lorem ipsum represents a long-held tradition for designers,
                        typographers and the like. Some people hate it and argue for
                        its demise, but others ignore the hate as they create awesome
                        tools to help create filler text for everyone from bacon lovers
                        to Charlie Sheen fans.
                      </p>

                      <form class="form-horizontal">
                        <div class="input-group input-group-sm mb-0">
                          <input class="form-control form-control-sm" placeholder="Response">
                          <div class="input-group-append">
                            <button type="submit" class="btn btn-danger">Send</button>
                          </div>
                        </div>
                      </form>
                    </div>
                    <!-- /.post -->

                    <!-- Post -->
                    <div class="post">
                      <div class="user-block">
                        <img class="img-circle img-bordered-sm" src="<?php echo $dir; ?>dist/img/user6-128x128.jpg" alt="User Image">
                        <span class="username">
                          <a href="#">Adam Jones</a>
                          <a href="#" class="float-right btn-tool"><i class="fas fa-times"></i></a>
                        </span>
                        <span class="description">Posted 5 photos - 5 days ago</span>
                      </div>
                      <!-- /.user-block -->
                      <div class="row mb-3">
                        <div class="col-sm-6">
                          <img class="img-fluid" src="<?php echo $dir; ?>dist/img/photo1.png" alt="Photo">
                        </div>
                        <!-- /.col -->
                        <div class="col-sm-6">
                          <div class="row">
                            <div class="col-sm-6">
                              <img class="img-fluid mb-3" src="<?php echo $dir; ?>dist/img/photo2.png" alt="Photo">
                              <img class="img-fluid" src="<?php echo $dir; ?>dist/img/photo3.jpg" alt="Photo">
                            </div>
                            <!-- /.col -->
                            <div class="col-sm-6">
                              <img class="img-fluid mb-3" src="<?php echo $dir; ?>dist/img/photo4.jpg" alt="Photo">
                              <img class="img-fluid" src="<?php echo $dir; ?>dist/img/photo1.png" alt="Photo">
                            </div>
                            <!-- /.col -->
                          </div>
                          <!-- /.row -->
                        </div>
                        <!-- /.col -->
                      </div>
                      <!-- /.row -->

                      <p>
                        <a href="#" class="link-black text-sm mr-2"><i class="fas fa-share mr-1"></i> Share</a>
                        <a href="#" class="link-black text-sm"><i class="far fa-thumbs-up mr-1"></i> Like</a>
                        <span class="float-right">
                          <a href="#" class="link-black text-sm">
                            <i class="far fa-comments mr-1"></i> Comments (5)
                          </a>
                        </span>
                      </p>

                      <input class="form-control form-control-sm" type="text" placeholder="Type a comment">
                    </div>
                    <!-- /.post -->
                  </div>
                  <!-- /.tab-pane -->
                  <div class="tab-pane" id="timeline">
                    <!-- The timeline -->
                    <div class="timeline timeline-inverse">
                      <!-- timeline time label -->
                      <div class="time-label">
                        <span class="bg-danger">
                          10 Feb. 2014
                        </span>
                      </div>
                      <!-- /.timeline-label -->
                      <!-- timeline item -->
                      <div>
                        <i class="fas fa-envelope bg-primary"></i>

                        <div class="timeline-item">
                          <span class="time"><i class="far fa-clock"></i> 12:05</span>

                          <h3 class="timeline-header"><a href="#">Support Team</a> sent you an email</h3>

                          <div class="timeline-body">
                            Etsy doostang zoodles disqus groupon greplin oooj voxy zoodles,
                            weebly ning heekya handango imeem plugg dopplr jibjab, movity
                            jajah plickers sifteo edmodo ifttt zimbra. Babblely odeo kaboodle
                            quora plaxo ideeli hulu weebly balihoo...
                          </div>
                          <div class="timeline-footer">
                            <a href="#" class="btn btn-primary btn-sm">Read more</a>
                            <a href="#" class="btn btn-danger btn-sm">Delete</a>
                          </div>
                        </div>
                      </div>
                      <!-- END timeline item -->
                      <!-- timeline item -->
                      <div>
                        <i class="fas fa-user bg-info"></i>

                        <div class="timeline-item">
                          <span class="time"><i class="far fa-clock"></i> 5 mins ago</span>

                          <h3 class="timeline-header border-0"><a href="#">Sarah Young</a> accepted your friend request
                          </h3>
                        </div>
                      </div>
                      <!-- END timeline item -->
                      <!-- timeline item -->
                      <div>
                        <i class="fas fa-comments bg-warning"></i>

                        <div class="timeline-item">
                          <span class="time"><i class="far fa-clock"></i> 27 mins ago</span>

                          <h3 class="timeline-header"><a href="#">Jay White</a> commented on your post</h3>

                          <div class="timeline-body">
                            Take me to your leader!
                            Switzerland is small and neutral!
                            We are more like Germany, ambitious and misunderstood!
                          </div>
                          <div class="timeline-footer">
                            <a href="#" class="btn btn-warning btn-flat btn-sm">View comment</a>
                          </div>
                        </div>
                      </div>
                      <!-- END timeline item -->
                      <!-- timeline time label -->
                      <div class="time-label">
                        <span class="bg-success">
                          3 Jan. 2014
                        </span>
                      </div>
                      <!-- /.timeline-label -->
                      <!-- timeline item -->
                      <div>
                        <i class="fas fa-camera bg-purple"></i>

                        <div class="timeline-item">
                          <span class="time"><i class="far fa-clock"></i> 2 days ago</span>

                          <h3 class="timeline-header"><a href="#">Mina Lee</a> uploaded new photos</h3>

                          <div class="timeline-body">
                            <img src="https://placehold.it/150x100" alt="...">
                            <img src="https://placehold.it/150x100" alt="...">
                            <img src="https://placehold.it/150x100" alt="...">
                            <img src="https://placehold.it/150x100" alt="...">
                          </div>
                        </div>
                      </div>
                      <!-- END timeline item -->
                      <div>
                        <i class="far fa-clock bg-gray"></i>
                      </div>
                    </div>
                  </div>
                  <!-- /.tab-pane -->
                  <!-- /.tab-pane -->
                </div>
                <!-- /.tab-content -->
              </div><!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <?php } ?>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  <script>
  $(function () {
    //Date picker
    $('#dateOfBirth').datetimepicker({
        format: 'L'
    });

  });
  </script>
  <script src="<?php echo $dir; ?>pages/main/profile/script.js"></script>
<?php include($dir.'pages/universal/footer.php'); ?>