$(document).ready(function(){
    ////load country details///
    $.ajax({
        type: 'POST',
        url: 'resources/scripts/settings/website.php',
        data: 'action=load-my-countries',
        success:function(response){
            $("#country").html(response);
        }
    });

    $.ajax({
        type: 'POST',
        url: 'resources/scripts/settings/website.php',
        data: 'action=load-my-states',
        success:function(response){
            $("#state").html(response);
        }
    });

    $.ajax({
        type: 'POST',
        url: 'resources/scripts/settings/website.php',
        data: 'action=load-my-cities',
        success:function(response){
            $("#currentcity").html(response);
        }
    });

    $('#uploadImageBtn').on('click', function(){
        var fd = new FormData();
        var files = $('#imageFile')[0].files;
        
        // Check file selected or not
        if(files.length > 0 ){
            $('#uploadMessage').attr('class','text-info');
            
            fd.append('file',files[0]);
            fd.append('action','upload-image');
            $.ajax({
                url: 'resources/scripts/profile/profile.php',
                type: 'post',
                data: fd,
                contentType: false,
                processData: false,
                dataType:'JSON',
                beforeSend:function(){
                    $('#uploadMessage').html('Uploading file...<i class="fa fa-spinner fa-spin"></i>');
                },
                success: function(response){
                    $('#uploadImageBtn').attr('disabled', 'disabled');
                    if(response.header=='successful'){
                       
                        document.getElementById('imageFile').value = '';
                        $('#imageFile').attr('placeholder','Choose file...');
                        $('#uploadMessage').addClass('text-success');
                        $('#uploadMessage').html('<i class="fa fa-check-circle"></i> Profile image updated.');
                        $("#displayImage").attr("src", response.data);
                        $("#displayImage1").attr("src", response.data);
                        $("#displayImage2").attr("src", response.data);
                        $("#displayImage3").attr("src", response.data);
                        //$("#uploadSuccess").modal('show');
                        $('#uploadImageBtn').removeAttr('disabled');
                        toastr.success('Profile Image successfully updated!');
                        $("#update-profile").modal('hide');
                        setTimeout(function(){
                            $('#uploadMessage').html('');
                        }, 5000);
                    }
                    else{
                        $('#uploadMessage').addClass('text-danger');
                        $('#uploadMessage').html('<i class="fa fa-times-circle"></i> '+response.message);
                        $('#uploadImageBtn').removeAttr('disabled');
                    }
                },
            });
        }else{
           $('#uploadMessage').addClass('text-danger');
           $('#uploadMessage').html('<i class="fa fa-times-circle"></i> Please, select a valid image file.');
           $('#imageFile').addClass('is-invalid');
        }
        
    });

    $('#uploadBgImageBtn').on('click', function(){
        var fd = new FormData();
        var files = $('#bgImageFile')[0].files;
        
        // Check file selected or not
        if(files.length > 0 ){
            $('#uploadBgMessage').attr('class','text-info');
            
            fd.append('file',files[0]);
            fd.append('action','upload-bg');
            $.ajax({
                url: 'resources/scripts/profile/profile.php',
                type: 'post',
                data: fd,
                contentType: false,
                processData: false,
                dataType:'JSON',
                beforeSend:function(){
                    $('#uploadBgMessage').html('Uploading file...<i class="fa fa-spinner fa-spin"></i>');
                },
                success: function(response){
                    $('#uploadBgImageBtn').attr('disabled', 'disabled');
                    if(response.header=='successful'){
                       
                        document.getElementById('bgImageFile').value = '';
                        $('#bgImageFile').attr('placeholder','Choose file...');
                        $('#uploadBgMessage').addClass('text-success');
                        $('#uploadBgMessage').html('<i class="fa fa-check-circle"></i> BG Cover updated.');
                        $("#bgImageDisplay").attr("style", response.data);
                        //$("#uploadSuccess").modal('show');
                        $('#uploadBgImageBtn').removeAttr('disabled');
                        toastr.success('Cover Image successfully updated!');
                        $("#update-bg").modal('hide');
                        setTimeout(function(){
                            $('#uploadBgMessage').html('');
                        }, 5000);
                    }
                    else{
                        $('#uploadBgMessage').addClass('text-danger');
                        $('#uploadBgMessage').html('<i class="fa fa-times-circle"></i> '+response.message);
                        $('#uploadBgImageBtn').removeAttr('disabled');
                    }
                },
            });
        }else{
           $('#uploadBgMessage').addClass('text-danger');
           $('#uploadBgMessage').html('<i class="fa fa-times-circle"></i> Please, select a valid image file.');
           $('#bgImageFile').addClass('is-invalid');
        }
        
    });

    //////update user profile details/////////////////
    $("#updateProfileBtn").on('click', function(){
        let editProfileTitle = $("#editProfileTitle").val();
        let editProfileGender = $("#editProfileGender").val();
        let editProfileFirstName = $("#editProfileFirstName").val();
        let editProfileLastName = $("#editProfileLastName").val();
        let editProfileMiddleName = $("#editProfileMiddleName").val();
        let editProfilePhone = $("#editProfilePhone").val();
        let editProfileUsername = $("#editProfileUsername").val();
        let dateOfBirth = $("#dateOfBirthValue").val();
        let editProfileOrganization = $("#editProfileOrganization").val();
        let editProfileAddress = $("#editProfileAddress").val();

        alert(dateOfBirth);
                 
    });


    $("#qualification").on('change', function(){
        var qual = $(this).val();
        if(qual){
            $("#qualification").removeClass('is-invalid');
            if(qual!='O Level'){
                $("#disciplineShow").attr('style', 'display:block;');
            }
            else{
                $("#disciplineShow").attr('style', 'display:none;');
            }
        }
        else{
            $("#disciplineShow").attr('style', 'display:none;');
            $("#qualification").addClass('is-invalid');
        }
    })

    $("#updateEducation").on('click', function(){
        var qualification = $("#qualification").val();
        var institution = $("#institution").val();
        
        if(!qualification){
            $("#qualification").addClass('is-invalid');
        }
        else{
            $("#qualification").removeClass('is-invalid');
        }

        if(!institution){
            $("#institution").addClass('is-invalid');
        }
        else{
            $("#institution").removeClass('is-invalid');
        }

        if(qualification!='O Level'){
            var discipline = $("#course").val();
            if(!discipline){
                $("#course").addClass('is-invalid');
                var error = 'Enter discipline';
            }
            else{
                $("#course").removeClass('is-invalid');
                var error = '';
            }
        }
        else{
            var error = '';
        }

        if(institution && qualification && !error){
            $.ajax({
                type: 'POST',
                url: 'resources/scripts/profile/profile.php',
                data: 'action=add-education&qualification='+qualification+'&institution='+institution+'&discipline='+discipline,
                dataType: 'JSON',
                beforeSend:function(){
                    $("#eduMsg").html('<i class="fa fa-spinner fa-spin"></i>...updating').addClass('text-info').removeClass('text-danger');
                },
                success:function(response){
                    if(response.header=='successful'){
                        $("#discipline").html(response.data);
                        toastr.success('Educational Qualification successfully updated');
                        $("#eduMsg").html('').removeClass('text-info');
                    }
                    else{
                        $("#eduMsg").html(response.message).removeClass('text-info').addClass('text-danger');
                    }
                }
            });
        }
    })

    $("#country").on('change', function(){
        var country = $(this).val();
        //alert(country);
        if(country){
            $("#country").removeClass('is-invalid');
            $.ajax({
                type: 'POST',
                url:'resources/scripts/settings/website.php',
                data:'action=load-country-states&countryid='+country,
                success:function(responseData){
                    //alert(responseData);
                    $("#state").html(responseData);
                    $("#currentcity").html('<option value="">Select State First</option>');
                }
            });
        }
        else{
            $("#country").addClass('is-invalid');
            $("#state").html('<option value="">Select Country First</option>');
            $("#currentcity").html('<option value="">Select State First</option>');
        }
    })

    $("#state").on('change', function(){
        var state = $(this).val();
        //alert(state);
        if(state){
            $("#state").removeClass('is-invalid');
            $.ajax({
                type: 'POST',
                url:'resources/scripts/settings/website.php',
                data:'action=load-new-cities&stateid='+state,
                success:function(responseData){
                    //alert(responseData);
                    $("#currentcity").html(responseData);
                }
            });
        }
        else{
            $("#state").addClass('is-invalid');
            $("#currentcity").html('<option value="">Select State First</option>');
        }
    })

    $("#currentcity").on('change', function(){
        var city = $(this).val();
        //alert(state);
        if(city){
            $("#currentcity").removeClass('is-invalid');
        }
        else{
            $("#currentcity").addClass('is-invalid');
        }
    })

    /////update the current location/////////////
    $("#updateLocation").on('click', function(){
        var country = $("#country").val();
        if(country){
            $("#country").removeClass('is-invalid');
        }
        else{
            $("#country").addClass('is-invalid');
        }
        var state = $("#state").val();
        if(state){
            $("#state").removeClass('is-invalid');
        }
        else{
            $("#state").addClass('is-invalid');
        }
        var city = $("#currentcity").val();
        if(city){
            $("#city").removeClass('is-invalid');
        }
        else{
            $("#city").addClass('is-invalid');
        }

        if(country && state && city){
            $.ajax({
                type: 'POST',
                url: 'resources/scripts/profile/profile.php',
                data: 'action=add-location&country='+country+'&state='+state+'&city='+city,
                dataType: 'JSON',
                beforeSend:function(){
                    $("#locMsg").html('<i class="fa fa-spinner fa-spin"></i>...updating location').addClass('text-info').removeClass('text-danger');
                },
                success:function(response){
                    if(response.header=='successful'){
                        $("#location").html(response.data);
                        toastr.success('Location successfully updated');
                        $("#locMsg").html('').removeClass('text-info');
                    }
                    else{
                        $("#locMsg").html(response.message).removeClass('text-info').addClass('text-danger');
                    }
                }
            });
        }
    });

    $("#updateSkills").on('click', function(){
        let skills = $("#skills").val();
        let array3 = skills.split(',');

        if(array3.length<=10){
            $("#skills").removeClass('is-invalid');
            $.ajax({
                type: 'POST',
                url: 'resources/scripts/profile/profile.php',
                data: 'action=add-skills&skills='+skills,
                dataType: 'JSON',
                beforeSend:function(){
                    $("#skillMsg").html('<i class="fa fa-spinner fa-spin"></i>...updating').addClass('text-info').removeClass('text-danger');
                },
                success:function(response){
                    if(response.header=='successful'){
                        $("#mySkills").html(response.data);
                        toastr.success('Skills successfully updated');
                        $("#skillMsg").html('').removeClass('text-info');
                    }
                    else{
                        $("#skillMsg").html(response.message).removeClass('text-info').addClass('text-danger');
                    }
                }
            });
        }
        else{
            $("#skillMsg").html('You can only add 10 skills maximum').addClass('text-danger');
            $("#skills").addClass('is-invalid');
        }
    });

    $("#updateBio").on('click', function(){
        let bio = $("#bio").val();

        if(bio){
            $("#bio").removeClass('is-invalid');
            $.ajax({
                type: 'POST',
                url: 'resources/scripts/profile/profile.php',
                data: 'action=add-bio&bio='+bio,
                dataType: 'JSON',
                beforeSend:function(){
                    $("#bioMsg").html('<i class="fa fa-spinner fa-spin"></i>...updating').addClass('text-info').removeClass('text-danger');
                },
                success:function(response){
                    if(response.header=='successful'){
                        $("#myBio").html(response.data);
                        toastr.success('Bio successfully updated');
                        $("#bioMsg").html('').removeClass('text-info');
                    }
                    else{
                        $("#bioMsg").html(response.message).removeClass('text-info').addClass('text-danger');
                    }
                }
            });
        }
        else{
            $("#bioMsg").html('You must enter your bio to continue').addClass('text-danger');
            $("#bio").addClass('is-invalid');
        }
    });

    $("#generateLink").on('click', function(){
        $.ajax({
            type: 'POST',
            url: 'resources/scripts/profile/profile.php',
            data: 'action=generate-ref-link',
            dataType: 'JSON',
            beforeSend:function(){
                $("#generateLink").html('<i class="fa fa-spinner fa-spin"></i>...Generating').attr('disabled','disabled');
            },
            success:function(response){
                if(response.header=='successful'){
                    $("#generateLink").html('<i class="fa fa-copy"></i> Copy').removeAttr('disabled').attr('id','copyLink');
                    toastr.success('Referral Link Generated');
                    $("#myLink").val(response.data)
                }
                else{
                    toastr.error(response.message);
                }
            }
        });
    });

    $("#copyLink").on('click', function(){
        var copyText = document.getElementById("myLink");
        copyText.select();
        copyText.setSelectionRange(0, 99999)
        navigator.clipboard.writeText(copyText.value);
        toastr.success('Copied: <strong>'+ copyText.value+'</strong>')
    });
        
});