<?php
    $dir = './';
    $title = 'Property Categories';
    $page = 'Properties';
    $propertyMenu = 'active';
    $propertyMenuState = 'menu-open';
    $propertyCategoryMenu = 'active';
?>
<?php include($dir.'pages/universal/header.php'); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <div id="systemNotification"></div>
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1><?php echo $title; ?></h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item"><a href="#"><?php echo $page; ?></a></li>
              <li class="breadcrumb-item active"><?php echo $title; ?></li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            <button class="btn btn-info float-right btn-sm" data-toggle="modal" data-target="#add-category"><i class="fa fa-plus"></i> Add New Category</button><br /><br />
          </div>
          <div class="col-md-6 col-lg-6 col-xl-6">
            <div class="card">
              <!-- /.card-header -->
              <div class="card-body" id="catDetails">
                
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
            <script>
              $(document).ready(function(){
                  ///////load the details////////////
                  $.ajax({
                      type:'POST',
                      url:'resources/scripts/property/category.php',
                      data:'action=load-categories',
                      beforeSend: function(){
                          $("#catDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                      },
                      success:function(responseData){
                          $("#catDetails").html(responseData);
                      }
                  });

                $(document).delegate("[data-target='#edit-category']", "click", function() {
                  var name = $(this).attr('name');
                  var id = $(this).attr('data-id');
                  var title = $(this).attr('title');
                  $("#editCatHead").html(title);
                  $("#editCatName").val(name);
                  $("#editOldName").val(name);
                  $("#editCatId").val(id);
                  $("#editCatMsg").html('');
                });

                $("#editCatBtn").on('click', function(){
                  var catId = $("#editCatId").val();
                  var catName = $("#editCatName").val();
                  var oldName = $("#editOldName").val();

                  if(catName){
                    $("#editCatName").removeClass('is-invalid');
                    $.ajax({
                        type:'POST',
                        url:'resources/scripts/property/category.php',
                        data:'action=edit-cat&catid='+catId+'&catname='+catName,
                        dataType: 'JSON',
                        beforeSend:function(){
                            $("#editCatBtn").html('Saving...<i class="fa fa-spinner fa-spin"></i>');
                        },
                        success:function(editCatResponse){
                            if(editCatResponse.header==='successful'){
                              //$("#editCatMsg").html('<br><b>'+oldName+'</b> '+editCatResponse.message+' to <b>'+catName+'</b>').addClass('text-success').removeClass('text-danger');
                              $("#editCatMsg").html('');
                              /* $(document).Toasts('create', {
                                  class: 'bg-success',
                                  title: 'Successful',
                                  body: '<b>'+oldName+'</b> '+editCatResponse.message+' to <b>'+catName+'</b>'
                              }); */
                              toastr.success('<b>'+oldName+'</b> '+editCatResponse.message+' to <b>'+catName+'</b>');
                              //$("#editCatMsg").html().addClass('text-success').removeClass('text-danger');
                              $("#editCatBtn").html('<i class="fa fa-check"></i> Saved').attr('disabled', 'disabled');
                              setTimeout(function(){
                                  $('#edit-category').modal('hide');
                                  //////refresh the list///////////
                                  $.ajax({
                                      type:'POST',
                                      url:'resources/scripts/property/category.php',
                                      data:'action=load-categories',
                                      beforeSend: function(){
                                          $("#catDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                                      },
                                      success:function(responseData){
                                          $("#catDetails").html(responseData);
                                      }
                                  });
                                  $("#editCatBtn").html('<i class="fa fa-save"></i> Save').removeAttr('disabled');
                                  $("#editCatMsg").html('');
                              }, 3000);
                            }
                            else{
                              /* $(document).Toasts('create', {
                                  class: 'bg-danger',
                                  title: 'Error Occurred',
                                  body: editCatResponse.message
                              }); */
                              $("#editCatMsg").html('<br>'+editCatResponse.message).addClass('text-danger').removeClass('text-success');
                              $("#editCatBtn").html('<i class="fa fa-save"></i> Save');
                            }
                        }
                    });
                  }
                  else{
                    $("#editCatName").addClass('is-invalid');
                  }
                });

                /////add new category////////////////
                $("#addCatBtn").on('click', function(){
                  var addCatName = $("#addCatName").val();
                  if(addCatName){
                    $("#addCatName").removeClass('is-invalid');
                    $.ajax({
                        type:'POST',
                        url:'resources/scripts/property/category.php',
                        data:'action=add-cat&catname='+addCatName,
                        dataType: 'JSON',
                        beforeSend:function(){
                            $("#addCatBtn").html('Submitting...<i class="fa fa-spinner fa-spin"></i>');
                        },
                        success:function(addCatResponse){
                            if(addCatResponse.header==='successful'){
                              $("#editCatMsg").html('');
                              /* $(document).Toasts('create', {
                                  class: 'bg-success',
                                  title: 'Successful',
                                  body: '<b>'+addCatName+'</b> successfully added to property categories.'
                              }); */
                              toastr.success('<b>'+addCatName+'</b> successfully added to property categories.');
                              $("#addCatBtn").html('<i class="fa fa-check"></i> Submitted').attr('disabled', 'disabled');
                              
                              setTimeout(function(){
                                  $('#add-category').modal('hide');
                                  //////refresh the list///////////
                                  $.ajax({
                                      type:'POST',
                                      url:'resources/scripts/property/category.php',
                                      data:'action=load-categories',
                                      beforeSend: function(){
                                          $("#catDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                                      },
                                      success:function(responseData){
                                          $("#catDetails").html(responseData);
                                      }
                                  });
                                  $("#addCatBtn").html('<i class="fa fa-save"></i> Submit').removeAttr('disabled');
                                  $("#addCatName").val('');
                                  $("#addCatMsg").html('');
                              }, 3000);
                              
                            }
                            else{
                              $("#addCatMsg").html('<br>'+addCatResponse.message).addClass('text-danger').removeClass('text-success');
                              $("#addCatBtn").html('<i class="fa fa-save"></i> Submit Again');
                            }
                            
                            
                        }
                    });

                  }
                  else{
                    $("#addCatName").addClass('is-invalid');
                  }
                });

                ///////delete category///////
                $(document).delegate("[data-target='#delete-category']", "click", function() {
                  var name = $(this).attr('name');
                  var id = $(this).attr('data-id');
                  var title = $(this).attr('title');
                  $("#deleteCatHead").html(title);
                  $("#delCatName").val(name);
                  $("#delCat").html(name);
                  $("#delCatId").val(id);
                  $("#delCatMsg").html('');
                });

                $("#deleteCatBtn").on('click', function(){
                  var catId = $("#delCatId").val();
                  var catName = $("#delCatName").val();

                  if(catId){
                    $.ajax({
                        type:'POST',
                        url:'resources/scripts/property/category.php',
                        data:'action=delete-cat&catid='+catId+'&catname='+catName,
                        dataType: 'JSON',
                        beforeSend:function(){
                            $("#deleteCatBtn").html('Deleting...<i class="fa fa-spinner fa-spin"></i>');
                        },
                        success:function(editCatResponse){
                            if(editCatResponse.header==='successful'){
                              $("#delCatMsg").html('');
                              /* $(document).Toasts('create', {
                                  class: 'bg-success',
                                  title: 'Successful',
                                  body: '<b>'+catName+'</b> was successfully deleted.'
                              }); */
                              toastr.success('<b>'+catName+'</b> was successfully deleted.');
                              //$("#editCatMsg").html().addClass('text-success').removeClass('text-danger');
                              $("#deleteCatBtn").html('<i class="fa fa-check"></i> Deleted').attr('disabled', 'disabled');
                              setTimeout(function(){
                                  $('#delete-category').modal('hide');
                                  //////refresh the list///////////
                                  $.ajax({
                                      type:'POST',
                                      url:'resources/scripts/property/category.php',
                                      data:'action=load-categories',
                                      beforeSend: function(){
                                          $("#catDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                                      },
                                      success:function(responseData){
                                          $("#catDetails").html(responseData);
                                      }
                                  });
                                  $("#deleteCatBtn").html('<i class="fa fa-trash"></i> Yes, Delete').removeAttr('disabled');
                                  $("#delCatMsg").html('');
                              }, 3000);
                            }
                            else{
                              $("#delCatMsg").html('<br>'+editCatResponse.message).addClass('text-danger').removeClass('text-success');
                              $("#deleteCatBtn").html('<i class="fa fa-trash"></i> Try Again');
                            }
                        }
                    });
                  }
                });

                ///////permanently delete category///////
                $(document).delegate("[data-target='#perm-delete-category']", "click", function() {
                  var name = $(this).attr('name');
                  var id = $(this).attr('data-id');
                  var title = $(this).attr('title');
                  $("#permDeleteCatHead").html(title);
                  $("#permDelCatName").val(name);
                  $("#permDelCat").html(name);
                  $("#permDelCatId").val(id);
                  $("#permDelCatMsg").html('');
                });

                $("#permDeleteCatBtn").on('click', function(){
                  var catId = $("#permDelCatId").val();
                  var catName = $("#permDelCatName").val();

                  if(catId){
                    $.ajax({
                        type:'POST',
                        url:'resources/scripts/property/category.php',
                        data:'action=perm-delete-cat&catid='+catId+'&catname='+catName,
                        dataType: 'JSON',
                        beforeSend:function(){
                            $("#permDeleteCatBtn").html('Deleting...<i class="fa fa-spinner fa-spin"></i>');
                        },
                        success:function(editCatResponse){
                            if(editCatResponse.header==='successful'){
                              $("#permDelCatMsg").html('');
                              /* $(document).Toasts('create', {
                                  class: 'bg-success',
                                  title: 'Successful',
                                  body: '<b>'+catName+'</b> was successfully deleted.'
                              }); */
                              toastr.success('<b>'+catName+'</b> was permanently deleted.');
                              //$("#editCatMsg").html().addClass('text-success').removeClass('text-danger');
                              $("#permDeleteCatBtn").html('<i class="fa fa-check"></i> Deleted').attr('disabled', 'disabled');
                              setTimeout(function(){
                                  $('#perm-delete-category').modal('hide');
                                  //////refresh the list///////////
                                  $.ajax({
                                      type:'POST',
                                      url:'resources/scripts/property/category.php',
                                      data:'action=load-categories',
                                      beforeSend: function(){
                                          $("#catDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                                      },
                                      success:function(responseData){
                                          $("#catDetails").html(responseData);
                                      }
                                  });
                                  $("#permDeleteCatBtn").html('<i class="fa fa-trash"></i> Yes, Delete').removeAttr('disabled');
                                  $("#permDelCatMsg").html('');
                              }, 3000);
                            }
                            else{
                              $("#permDelCatMsg").html('<br>'+editCatResponse.message).addClass('text-danger').removeClass('text-success');
                              $("#permDeleteCatBtn").html('<i class="fa fa-trash"></i> Try Again');
                            }
                        }
                    });
                  }
                });

                ///////disable category///////
                $(document).delegate("[data-target='#disable-category']", "click", function() {
                  var name = $(this).attr('name');
                  var id = $(this).attr('data-id');
                  var title = $(this).attr('title');
                  $("#disableCatHead").html(title);
                  $("#disCatName").val(name);
                  $("#disCat").html(name);
                  $("#disCatId").val(id);
                  $("#disCatMsg").html('');
                });

                $("#disableCatBtn").on('click', function(){
                  var catId = $("#disCatId").val();
                  var catName = $("#disCatName").val();

                  if(catId){
                    $.ajax({
                        type:'POST',
                        url:'resources/scripts/property/category.php',
                        data:'action=disable-cat&catid='+catId+'&catname='+catName,
                        dataType: 'JSON',
                        beforeSend:function(){
                            $("#disableCatBtn").html('Disabling...<i class="fa fa-spinner fa-spin"></i>');
                        },
                        success:function(editCatResponse){
                            if(editCatResponse.header==='successful'){
                              $("#disCatMsg").html('');
                              /* $(document).Toasts('create', {
                                  class: 'bg-success',
                                  title: 'Successful',
                                  body: '<b>'+catName+'</b> was successfully disabled.'
                              }); */
                              toastr.success('<b>'+catName+'</b> was successfully disabled.');
                              //$("#editCatMsg").html().addClass('text-success').removeClass('text-danger');
                              $("#disableCatBtn").html('<i class="fa fa-check"></i> Disabled').attr('disabled', 'disabled');
                              setTimeout(function(){
                                  $('#disable-category').modal('hide');
                                  //////refresh the list///////////
                                  $.ajax({
                                      type:'POST',
                                      url:'resources/scripts/property/category.php',
                                      data:'action=load-categories',
                                      beforeSend: function(){
                                          $("#catDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                                      },
                                      success:function(responseData){
                                          $("#catDetails").html(responseData);
                                      }
                                  });
                                  $("#disableCatBtn").html('<i class="fa fa-times"></i> Yes, Disable').removeAttr('disabled');
                                  $("#disCatMsg").html('');
                              }, 3000);
                            }
                            else{
                              $("#disCatMsg").html('<br>'+editCatResponse.message).addClass('text-danger').removeClass('text-success');
                              $("#disableCatBtn").html('<i class="fa fa-times"></i> Try Again');
                            }
                        }
                    });
                  }
                });

                ///////reactivate disabled category///////
                $(document).delegate("[data-target='#activate-category']", "click", function() {
                  var name = $(this).attr('name');
                  var id = $(this).attr('data-id');
                  var title = $(this).attr('title');
                  $("#activateCatHead").html(title);
                  $("#actCatName").val(name);
                  $("#actCat").html(name);
                  $("#actCatId").val(id);
                  $("#actCatMsg").html('');
                });

                $("#activateCatBtn").on('click', function(){
                  var catId = $("#actCatId").val();
                  var catName = $("#actCatName").val();

                  if(catId){
                    $.ajax({
                        type:'POST',
                        url:'resources/scripts/property/category.php',
                        data:'action=reactivate-cat&catid='+catId+'&catname='+catName,
                        dataType: 'JSON',
                        beforeSend:function(){
                            $("#activateCatBtn").html('Activating...<i class="fa fa-spinner fa-spin"></i>');
                        },
                        success:function(editCatResponse){
                            if(editCatResponse.header==='successful'){
                              $("#actCatMsg").html('');
                             /*  $(document).Toasts('create', {
                                  class: 'bg-success',
                                  title: 'Successful',
                                  body: '<b>'+catName+'</b> was successfully activated.'
                              }); */
                              toastr.success('<b>'+catName+'</b> was successfully activated.');
                              //$("#editCatMsg").html().addClass('text-success').removeClass('text-danger');
                              $("#activateCatBtn").html('<i class="fa fa-check"></i> Activated').attr('disabled', 'disabled');
                              setTimeout(function(){
                                  $('#activate-category').modal('hide');
                                  //////refresh the list///////////
                                  $.ajax({
                                      type:'POST',
                                      url:'resources/scripts/property/category.php',
                                      data:'action=load-categories',
                                      beforeSend: function(){
                                          $("#catDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                                      },
                                      success:function(responseData){
                                          $("#catDetails").html(responseData);
                                      }
                                  });
                                  $("#activateCatBtn").html('<i class="fa fa-save"></i> Yes, Activate').removeAttr('disabled');
                                  $("#actCatMsg").html('');
                              }, 3000);
                            }
                            else{
                              $("#actCatMsg").html('<br>'+editCatResponse.message).addClass('text-danger').removeClass('text-success');
                              $("#activateCatBtn").html('<i class="fa fa-save"></i> Try Again');
                            }
                        }
                    });
                  }
                });

                ///////restore deleted category///////
                $(document).delegate("[data-target='#restore-category']", "click", function() {
                  var name = $(this).attr('name');
                  var id = $(this).attr('data-id');
                  var title = $(this).attr('title');
                  $("#restoreCatHead").html(title);
                  $("#resCatName").val(name);
                  $("#resCat").html(name);
                  $("#resCatId").val(id);
                  $("#resCatMsg").html('');
                });

                $("#restoreCatBtn").on('click', function(){
                  var catId = $("#resCatId").val();
                  var catName = $("#resCatName").val();

                  if(catId){
                    $.ajax({
                        type:'POST',
                        url:'resources/scripts/property/category.php',
                        data:'action=restore-cat&catid='+catId+'&catname='+catName,
                        dataType: 'JSON',
                        beforeSend:function(){
                            $("#restoreCatBtn").html('Restoring...<i class="fa fa-spinner fa-spin"></i>');
                        },
                        success:function(editCatResponse){
                            if(editCatResponse.header==='successful'){
                              $("#resCatMsg").html('');
                              /* $(document).Toasts('create', {
                                  class: 'bg-success',
                                  title: 'Successful',
                                  body: '<b>'+catName+'</b> was successfully restored.'
                              }); */
                              toastr.success('<b>'+catName+'</b> was successfully restored.');
                              
                              //$("#editCatMsg").html().addClass('text-success').removeClass('text-danger');
                              $("#restoreCatBtn").html('<i class="fa fa-check"></i> Restored').attr('disabled', 'disabled');
                              setTimeout(function(){
                                  $('#restore-category').modal('hide');
                                  //////refresh the list///////////
                                  $.ajax({
                                      type:'POST',
                                      url:'resources/scripts/property/category.php',
                                      data:'action=load-categories',
                                      beforeSend: function(){
                                          $("#catDetails").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
                                      },
                                      success:function(responseData){
                                          $("#catDetails").html(responseData);
                                      }
                                  });
                                  $("#restoreCatBtn").html('<i class="fa fa-save"></i> Yes, Restore').removeAttr('disabled');
                                  $("#resCatMsg").html('');
                              }, 3000);
                            }
                            else{
                              $("#resCatMsg").html('<br>'+editCatResponse.message).addClass('text-danger').removeClass('text-success');
                              $("#restoreCatBtn").html('<i class="fa fa-save"></i> Try Again');
                            }
                        }
                    });
                  }
                });
              });
            </script>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <?php include($dir.'pages/universal/footer.php'); ?>