<?php
    $dir = './';
    $title = 'Nationality Setting';
    $currentPage = 'Nationality';
    $page = 'Settings';
    $settingMenu = 'active';
    $settingMenuState = 'menu-open';
    $nationalitySettingMenu = 'active';


	if(empty($_GET['selected'])){
		$headTitle = 'Countries, Regions, States & Localities';
	}
	else{
		$headTitle = $_GET['selected'];
	}
?>
<?php include($dir.'pages/universal/header.php'); ?>

  <!-- Content Wrapper. Contains page content -->
  <input type="hidden" id="currentPage" value="<?php echo $currentPage; ?>" />
  <div class="content-wrapper">
  	<div id="systemNotification"></div>
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
		<?php echo $message; ?>
        <div class="row mb-2">
          <div class="col-sm-6">
            <h4 class="text-info"><a href="./"><i class="fa fa-home"></i></a> Nationality Setting <small><i class="fa fa-angle-double-right"></i> <?php echo $headTitle; ?></small></h4>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item"><a href="#">Setting</a></li>
              <li class="breadcrumb-item active">Nationality Setting</li>
            </ol>
          </div>
		  <br><br>
		  <div class="col-sm-12" align="right">
			<button type="button" class="btn btn-sm btn-secondary pull-right" data-toggle="modal" data-target="#add-country">
			  <i class="fas fa-university"></i> Add New Country
			</button>
			<button type="button" class="btn btn-sm btn-info pull-right" data-toggle="modal" data-target="#add-zone">
			  <i class="fas fa-user"></i> Add New Zone
			</button>
			<button type="button" class="btn btn-sm btn-primary pull-right" data-toggle="modal" data-target="#add-state">
			  <i class="fas fa-university"></i> Add States
			</button>
			<button type="button" class="btn btn-sm btn-success pull-right" data-toggle="modal" data-target="#add-lga">
			  <i class="fas fa-user"></i> Add New LGAs
			</button>
			<button type="button" class="btn btn-sm bg-purple pull-right" data-toggle="modal" data-target="#add-cities">
			  <i class="fas fa-user"></i> Add New Cities
			</button>
		  </div><br><br>
        </div>
		
      </div><!-- /.container-fluid -->
    </section>
	

    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
			<?php 
				if(empty($_GET['selected']) AND empty($_GET['state'])){
					$queryCountries = mysqli_query($db_conn, "SELECT * FROM countries WHERE status=1");
			?>
			<div class="card card-info">
				<div class="card-header">
				<h3 class="card-title"><strong>COUNTRIES AND DETAILS (<?php echo mysqli_num_rows($queryCountries); ?>)</strong></h3>
				</div>
				<!-- /.card-header -->
				<div class="card-body">
					<table id="example1" class="table table-bordered table-striped">
					<thead>
					<tr>
						<th>#</th>
						<th>Country Name</th>
						<th>Code</th>
						<th>Phone Code</th>
						<th>Time Zones</th>
						<th>GMT</th>
						<th>Regions</th>
						<th>Number of States</th>
						<th><i class="fa fa-cogs"></i></th>
					</tr>
					</thead>
					<tbody>
						<?php
							$number = 1;
							while($country = mysqli_fetch_assoc($queryCountries)){
                                $timeZone = explode(',', $country['time_zone']);
                                $timeZones = '';
                                for($i=0; $i<sizeof($timeZone); $i++){
                                    if(empty($timeZones)){
                                        $timeZones .= $timeZone[$i];
                                    }
                                    else{
                                        $timeZones .= '<br>'.$timeZone[$i];
                                    }
                                }
								$regions = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT COUNT(*) AS regions FROM tbl_regions WHERE country_id='".$country['country_id']."' AND status=1"));
								$states = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT COUNT(*) AS total_states FROM states WHERE country_id='".$country['country_id']."' AND status=1"));
								
						?>
						<tr>
							<td><?php echo $number; ?></td>
							<td><strong><a href="./?selected=<?php echo $country['country_name']; ?>"><?php echo $country['country_name']; ?></a></strong></td>
							<td><?php echo $country['country_code']; ?></td>
							<td><?php echo $country['phone_code']; ?></td>
							<td><?php echo $timeZones; ?></td>
							<td><?php echo $country['gmt']; ?></td>
							<td><?php echo $regions['regions']; ?></td>
							<td><?php echo $states['total_states']; ?></td>
							<td>
								<a href="javascript: void();" class="btn btn-xs btn-info" data-toggle="modal" data-target="#edit-user-<?php echo $admin['user_id']; ?>"><i class="fa fa-edit" title="Edit"></i></a>
								<a href="javascript: void();" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#delete-user-<?php echo $admin['user_id']; ?>"><i class="fa fa-trash" title="Remove"></i></a>
								<a href="javascript: void();" class="btn btn-xs btn-secondary" data-toggle="modal" data-target="#update-password-<?php echo $admin['user_id']; ?>" title="Update Password"><i class="fa fa-lock"></i> <i class="fa fa-upload"></i></a>
							</td>
						</tr>
						
						<?php  $number++; } ?>
					</tbody>
					</table>
				</div>
            	<!-- /.card-body -->
          	</div>
			<?php
				}else{
					if(!empty($_GET['selected']) AND empty($_GET['state']) AND empty($_GET['region'])){
					$countryId = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT country_id FROM countries WHERE country_name='".$_GET['selected']."' LIMIT 1"));
					$countryId = $countryId['country_id'];
					$queryStates = mysqli_query($db_conn, "SELECT * FROM states WHERE country_id='$countryId' AND status=1 ORDER BY state_name ASC");
			?>
				<div class="card card-info">
				<div class="card-header">
				<h3 class="card-title"><strong>REGIONS IN <?php echo strtoupper($_GET['selected']); ?> (<?php echo mysqli_num_rows($queryStates); ?>)</strong></h3>
				</div>
				<!-- /.card-header -->
				<div class="card-body">
					<table id="example1" class="table table-bordered table-striped">
					<thead>
					<tr>
						<th>#</th>
						<th>State Name</th>
						<th>Cities/LGA</th>
						<th><i class="fa fa-cogs"></i></th>
					</tr>
					</thead>
					<tbody>
						<?php
							$number = 1;
							while($state = mysqli_fetch_assoc($queryStates)){
                                $stateId = $state['state_id'];
								$queryCities = mysqli_query($db_conn, "SELECT * FROM lga WHERE state_id='$stateId' AND status=1");
                                //$cities = mysqli_fetch_assoc($queryCities);
                                //$cities = $cities['total_cities'];
								$citiesName = '';
								while($city = mysqli_fetch_assoc($queryCities)){
									if(empty($citiesName)){
										$citiesName = '<a href="./?city='.$city['id'].'">'.$city['name'].'</a>';
									}
									else{
										$citiesName .= ', <a href="./?city='.$city['id'].'">'.$city['name'].'</a>';
									}
								}
						?>
						<tr>
							<td><?php echo $number; ?></td>
							<td><strong><?php echo $state['state_name']; ?></strong></td>
							<td><?php echo $citiesName; ?></td>
							<td>
								<a href="javascript: void();" class="btn btn-xs btn-info" data-toggle="modal" data-target="#edit-user-<?php echo $admin['user_id']; ?>"><i class="fa fa-edit" title="Edit"></i></a>
								<a href="javascript: void();" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#delete-user-<?php echo $admin['user_id']; ?>"><i class="fa fa-trash" title="Remove"></i></a>
								<a href="javascript: void();" class="btn btn-xs btn-secondary" data-toggle="modal" data-target="#update-password-<?php echo $admin['user_id']; ?>" title="Update Password"><i class="fa fa-lock"></i> <i class="fa fa-upload"></i></a>
							</td>
						</tr>
						
						<?php  $number++; } ?>
					</tbody>
					</table>
				</div>
            	<!-- /.card-body -->
          	</div>
			<?php 
				}elseif(!empty($_GET['state']) AND empty($_GET['selected']) AND empty($_GET['region'])){
					$stateId = $_GET['state'];
					$stateName = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT state_name FROM states WHERE state_id=$stateId LIMIT 1"));
					$queryZones = mysqli_query($db_conn, "SELECT * FROM tbl_zones WHERE state_id='$stateId'");
			?>
				<div class="card card-info">
				<div class="card-header">
				<h3 class="card-title"><strong>SENATORIAL ZONES IN <?php echo strtoupper($stateName['state_name']); ?> (<?php echo mysqli_num_rows($queryZones); ?>)</strong></h3>
				</div>
				<!-- /.card-header -->
				<div class="card-body">
					<table id="example1" class="table table-bordered table-striped">
					<thead>
					<tr>
						<th width="10px">#</th>
						<th width="20%">Zone Name</th>
						<th>LGAs/Cities</th>
						<th width="15%"><i class="fa fa-cogs"></i></th>
					</tr>
					</thead>
					<tbody>
						<?php
							$number = 1;
							while($zone = mysqli_fetch_assoc($queryZones)){
								$cityQuery = mysqli_query($db_conn, "SELECT * FROM lga WHERE zone_id!='' AND zone_id='".$zone['zone_id']."' AND status=1");
								$cityName = '';
								while($city=mysqli_fetch_assoc($cityQuery)){
									if(empty($cityName)){
										$cityName = $city['name'];
									}
									else{
										$cityName .= ', '.$city['name'];
									}
								}
						?>
						<tr>
							<td><?php echo $number; ?></td>
							<td><strong><?php echo $zone['zone_name'].' ('.mysqli_num_rows($cityQuery).')'; ?></strong></td>
							<td><strong><?php echo $cityName; ?></strong></td>
							<td>
								<a href="javascript: void();" class="btn btn-xs btn-info" data-toggle="modal" data-target="#edit-user-<?php echo $admin['user_id']; ?>"><i class="fa fa-edit" title="Edit"></i></a>
								<a href="javascript: void();" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#delete-user-<?php echo $admin['user_id']; ?>"><i class="fa fa-trash" title="Remove"></i></a>
								<a href="javascript: void();" class="btn btn-xs btn-secondary" data-toggle="modal" data-target="#update-password-<?php echo $admin['user_id']; ?>" title="Update Password"><i class="fa fa-lock"></i> <i class="fa fa-upload"></i></a>
							</td>
						</tr>
						
						<?php  $number++; } ?>
					</tbody>
					</table>
				</div>
            	<!-- /.card-body -->
          	</div>
			<?php } ?>
			<?php } ?>
		</div>
	</div>

      <!-- /.row -->
</section>
	
		<div class="modal fade" id="add-zone">
			<div class="modal-dialog modal-md">
				  <div class="modal-content" method="get">
					<div class="modal-header bg-info">
					  <h4 class="modal-title">Add State Senatorial Zone</h4>
					  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					  </button>
					</div>
					<div class="modal-body">
						<div class="row">
							<div class="text-center" id="msgBox"></div>
								<div class="col-md-12">
									<div class="form-group">
										<label>Country to Add to</label>
										<select class="form-control select2bs4" id="natCountryZone" style="width: 100%;">
											<option value="">Select Country</option>
										<?php
											$queryCountry = mysqli_query($db_conn, "SELECT * FROM countries WHERE status=1");
											while($country = mysqli_fetch_assoc($queryCountry)){
												print '<option value="'.$country['country_id'].'">'.$country['country_name'].'</option>';
											}
										?>
										</select>
									</div>
									<div class="form-group">
										<label>State</label>
										<select class="form-control select2bs4" id="stateName" style="width: 100%;">
											<option value="">Select Country first</option>
										</select>
									</div>
									<input type="hidden" id="stateNameVal" />
									<div class="form-group">
										<label>Zone Name</label>
										<input placeholder="Enter Zone" type="text" id="zoneName" class="form-control" >
									</div>
									<div class="form-group">
										<label>Select LGA/Cities</label>
										<select class="select2" id="citiesName" multiple="multiple" data-placeholder="Select a State" style="width: 100%;">
									
										</select>
									</div>
						  <!-- /.col -->
								</div>
							</div>
						<div class="modal-footer justify-content-between bg-info">
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
							<button type="button" class="btn btn-secondary" id="insertZone">Submit</button>
						</div>
					</div>
				  <!-- /.modal-content -->
				</div>
			</div>
		</div>
		
		<div class="modal fade" id="add-country">
			<div class="modal-dialog modal-md">
				  <div class="modal-content" method="post">
					<div class="modal-header bg-info">
					  <h4 class="modal-title">Add New Country</h4>
					  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					  </button>
					</div>
					<div class="modal-body">
						<div class="text-center" id="msgCountryBox"></div>
						<div class="row">
							<div class="col-md-12">
								<div class="form-group">
									<label>Country Name</label>
									<input placeholder="Enter Admin Type Name" type="text" id="countryToAdd" class="form-control" >
								</div>
						  <!-- /.col -->
							</div>
						</div>
					<div class="modal-footer justify-content-between bg-info">
					  <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
					  <button type="button" class="btn btn-secondary" id="addCountry">Submit</button>
					</div>
				  </div>
				  <!-- /.modal-content -->
				</div>
			</div>
		</div>
		
		<div class="modal fade" id="add-state">
			<div class="modal-dialog modal-md">
				  <div class="modal-content">
					<div class="modal-header bg-info">
					  <h4 class="modal-title">Add New States</h4>
					  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					  </button>
					</div>
					<div class="modal-body">
						<div class="text-center col-12" id="msgStatesBox"></div>
						<div class="row">
							<div class="col-md-12">
								<div class="form-group">
									<label>Country to Add to</label>
									<select class="form-control select2bs4" id="natCountryState" style="width: 100%;">
										<option value="">Select Country</option>
									<?php
										$queryCountry = mysqli_query($db_conn, "SELECT * FROM countries WHERE status=1");
										while($country = mysqli_fetch_assoc($queryCountry)){
											print '<option value="'.$country['country_id'].'">'.$country['country_name'].'</option>';
										}
									?>
									</select>
								</div>
								<input type="hidden" id="addCountryName" />
								<div class="form-group">
									<label>States to Add</label>
									<textarea placeholder="Enter states to be added" type="text" id="statesToAdd" rows="5" class="form-control"></textarea>
								</div>
						  <!-- /.col -->
							</div>
						</div>
					<div class="modal-footer justify-content-between bg-info">
					  <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
					  <button type="button" class="btn btn-secondary" id="addStates">Submit</button>
					</div>
				  </div>
				  <!-- /.modal-content -->
				</div>
			</div>
		</div>

		<div class="modal fade" id="add-lga">
			<div class="modal-dialog modal-md">
				  	<div class="modal-content">
						<div class="modal-header bg-info">
							<h4 class="modal-title">Add New LGAs</h4>
							<button type="button" class="close" data-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						<div class="modal-body">
							<div class="text-center" id="msgLgaBox"></div>
							<div class="row">
								<div class="col-md-12">
									<div class="form-group">
										<label>Country to Add to</label>
										<select class="form-control select2bs4" id="natCountryCities" style="width: 100%;">
											<option value="">Select Country</option>
										<?php
											$queryCountry = mysqli_query($db_conn, "SELECT * FROM countries WHERE status=1");
											while($country = mysqli_fetch_assoc($queryCountry)){
												print '<option value="'.$country['country_id'].'">'.$country['country_name'].'</option>';
											}
										?>
										</select>
									</div>
									<div class="form-group">
										<label>State to Add to</label>
										<select class="form-control select2bs4" id="addToState" style="width: 100%;">
											<option value="">Select Country first</option>
										</select>
									</div>
									<input type="hidden" id="addToStateName" />
									<div class="form-group">
										<label>Cities to Add</label>
										<textarea placeholder="Enter cities to be added" type="text" id="lgaToAdd" rows="5" class="form-control"></textarea>
									</div>
							<!-- /.col -->
								</div>
							</div>
						<div class="modal-footer justify-content-between bg-info">
						<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
						<button type="button" class="btn btn-secondary" id="addLga">Submit</button>
						</div>
				  	</div>
				  <!-- /.modal-content -->
				</div>
			</div>
		</div>


		<div class="modal fade" id="add-cities">
			<div class="modal-dialog modal-md">
				  	<div class="modal-content">
						<div class="modal-header bg-info">
							<h4 class="modal-title">Add New Cities</h4>
							<button type="button" class="close" data-dismiss="modal" aria-label="Close">
								<span aria-hidden="true">&times;</span>
							</button>
						</div>
						<div class="modal-body">
							<div class="text-center" id="msgCitiesBox"></div>
							<div class="row">
								<div class="col-md-12">
									<div class="form-group">
										<label>Country to Add to</label>
										<select class="form-control select2bs4" id="natCountryCitiesNew" style="width: 100%;">
											<option value="">Select Country</option>
										<?php
											$queryCountry = mysqli_query($db_conn, "SELECT * FROM countries WHERE status=1");
											while($country = mysqli_fetch_assoc($queryCountry)){
												print '<option value="'.$country['country_id'].'">'.$country['country_name'].'</option>';
											}
										?>
										</select>
									</div>
									<div class="form-group">
										<label>State to Add to</label>
										<select class="form-control select2bs4" id="addToStateNew" style="width: 100%;">
											<option value="">Select Country first</option>
										</select>
									</div>
									<input type="hidden" id="addToStateNewName" />
									<div class="form-group">
										<label>Cities to Add</label>
										<textarea placeholder="Enter cities to be added" type="text" id="citiesToAdd" rows="5" class="form-control"></textarea>
									</div>
							<!-- /.col -->
								</div>
							</div>
						<div class="modal-footer justify-content-between bg-info">
						<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
						<button type="button" class="btn btn-secondary" id="addCities">Submit</button>
						</div>
				  	</div>
				  <!-- /.modal-content -->
				</div>
			</div>
		</div>
		
  </div>->
  <?php include($dir.'pages/universal/footer.php'); ?>