<?php
    $dir = './';
    $title = 'Nationality Setting';
    $currentPage = 'Nationality';
    $page = 'Settings';
    $settingMenu = 'active';
    $settingMenuState = 'menu-open';
    $nationalitySettingMenu = 'active';

?>
<?php include($dir.'pages/universal/header.php'); ?>

  <!-- Content Wrapper. Contains page content -->
  <input type="hidden" id="currentPage" value="<?php echo $currentPage; ?>" />
  <div class="content-wrapper">
    <div id="systemNotification"></div>
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1><?php echo $title; ?></h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item"><a href="#"><?php echo $page; ?></a></li>
              <li class="breadcrumb-item active"><?php echo $title; ?></li>
            </ol>
          </div>
          <div class="col-sm-12" align="right"><br>
            <button type="button" class="btn btn-sm btn-secondary pull-right" data-toggle="modal" data-target="#add-country">
              <i class="fas fa-university"></i> Add New Country
            </button>
            <button type="button" class="btn btn-sm btn-info pull-right" data-toggle="modal" data-target="#add-zone">
              <i class="fas fa-plus"></i> Add New Zone
            </button>
            <button type="button" class="btn btn-sm btn-warning pull-right" data-toggle="modal" data-target="#add-zone-lga">
              <i class="fas fa-plus"></i> Add LGAs to Zone
            </button>
            <button type="button" class="btn btn-sm btn-primary pull-right" data-toggle="modal" data-target="#add-state">
              <i class="fas fa-university"></i> Add States
            </button>
            <button type="button" class="btn btn-sm btn-success pull-right" data-toggle="modal" data-target="#add-lga">
              <i class="fas fa-user"></i> Add New LGAs
            </button>
            <button type="button" class="btn btn-sm bg-purple pull-right" data-toggle="modal" data-target="#add-cities">
              <i class="fas fa-user"></i> Add New Cities
            </button>
            </div><br><br>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <?php 
            if(empty($_GET['selected']) AND empty($_GET['state'])){
              $queryCountries = mysqli_query($db_conn, "SELECT * FROM countries WHERE status=1");
          ?>
          <div class="card card-info">
            <div class="card-header">
            <h3 class="card-title"><strong>COUNTRIES AND DETAILS (<?php echo mysqli_num_rows($queryCountries); ?>)</strong></h3>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="example1" class="table table-bordered table-striped">
              <thead>
              <tr>
                <th>#</th>
                <th>Country Name</th>
                <th>Code</th>
                <th>Phone Code</th>
                <th>Time Zones</th>
                <th>GMT</th>
                <th>Regions</th>
                <th>Number of States</th>
                <!-- <th><i class="fa fa-cogs"></i></th> -->
              </tr>
              </thead>
              <tbody>
                <?php
                  $number = 1;
                  while($country = mysqli_fetch_assoc($queryCountries)){
                    $timeZone = explode(',', $country['time_zone']);
                    $timeZones = '';
                    for($i=0; $i<sizeof($timeZone); $i++){
                        if(empty($timeZones)){
                            $timeZones .= $timeZone[$i];
                        }
                        else{
                            $timeZones .= '<br>'.$timeZone[$i];
                        }
                    }
                    $regions = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT COUNT(*) AS regions FROM tbl_regions WHERE country_id='".$country['country_id']."' AND status=1"));
                    $states = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT COUNT(*) AS total_states FROM states WHERE country_id='".$country['country_id']."' AND status=1"));
                    
                ?>
                <tr>
                  <td><?php echo $number; ?></td>
                  <td><strong><a href="./?selected=<?php echo $country['country_name']; ?>"><?php echo $country['country_name']; ?></a></strong></td>
                  <td><?php echo $country['country_code']; ?></td>
                  <td><?php echo $country['phone_code']; ?></td>
                  <td><?php echo $timeZones; ?></td>
                  <td><?php echo $country['gmt']; ?></td>
                  <td><?php echo $regions['regions']; ?></td>
                  <td><?php echo $states['total_states']; ?></td>
                  <!-- <td>
                    <a href="javascript: void();" class="btn btn-xs btn-info" data-toggle="modal" data-target="#edit-user-<?php echo $admin['user_id']; ?>"><i class="fa fa-edit" title="Edit"></i></a>
                    <a href="javascript: void();" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#delete-user-<?php echo $admin['user_id']; ?>"><i class="fa fa-trash" title="Remove"></i></a>
                    <a href="javascript: void();" class="btn btn-xs btn-secondary" data-toggle="modal" data-target="#update-password-<?php echo $admin['user_id']; ?>" title="Update Password"><i class="fa fa-lock"></i> <i class="fa fa-upload"></i></a>
                  </td> -->
                </tr>
                
                <?php  $number++; } ?>
              </tbody>
              </table>
            </div>
                  <!-- /.card-body -->
                </div>
          <?php
            }else{
              if(!empty($_GET['selected']) AND empty($_GET['state']) AND empty($_GET['region'])){
              $countryId = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT country_id FROM countries WHERE country_name='".$_GET['selected']."' LIMIT 1"));
              $countryId = $countryId['country_id'];
              $queryStates = mysqli_query($db_conn, "SELECT * FROM states WHERE country_id='$countryId' AND status=1 ORDER BY state_name ASC");
          ?>
            <div class="card card-info">
            <div class="card-header">
            <h3 class="card-title"><strong>REGIONS IN <?php echo strtoupper($_GET['selected']); ?> (<?php echo mysqli_num_rows($queryStates); ?>)</strong></h3>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="example1" class="table table-bordered table-striped">
              <thead>
              <tr>
                <th>#</th>
                <th>State Name</th>
                <th>Zones</th>
                <th>Cities/LGA</th>
                <!-- <th><i class="fa fa-cogs"></i></th> -->
              </tr>
              </thead>
              <tbody>
                <?php
                  $number = 1;
                  while($state = mysqli_fetch_assoc($queryStates)){
                    $stateId = $state['state_id'];
                    $queryCities = mysqli_query($db_conn, "SELECT * FROM lga WHERE state_id='$stateId' AND status=1 ORDER BY name ASC");
                    
                    $citiesName = '';
                    while($city = mysqli_fetch_assoc($queryCities)){
                      if(empty($citiesName)){
                        $citiesName = $city['name'];
                      }
                      else{
                        $citiesName .= ','.$city['name'];
                      }
                    }
                    $zones = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT COUNT(*) as zones FROM tbl_zones WHERE state_id='$stateId' AND status=1"));
                ?>
                <tr>
                  <td><?php echo $number; ?></td>
                  <td><strong><a href="./?state=<?php echo $state['state_id']; ?>"><?php echo $state['state_name']; ?></a></strong></td>
                  <td><?php echo $zones['zones']; ?></td>
                  <td><?php echo $citiesName; ?></td>
                  <!-- <td>
                    <a href="javascript: void();" class="btn btn-xs btn-info" data-toggle="modal" data-target="#edit-user-<?php echo $admin['user_id']; ?>"><i class="fa fa-edit" title="Edit"></i></a>
                    <a href="javascript: void();" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#delete-user-<?php echo $admin['user_id']; ?>"><i class="fa fa-trash" title="Remove"></i></a>
                    <a href="javascript: void();" class="btn btn-xs btn-secondary" data-toggle="modal" data-target="#update-password-<?php echo $admin['user_id']; ?>" title="Update Password"><i class="fa fa-lock"></i> <i class="fa fa-upload"></i></a>
                  </td> -->
                </tr>
                
                <?php  $number++; } ?>
              </tbody>
              </table>
            </div>
                  <!-- /.card-body -->
                </div>
          <?php 
            }elseif(!empty($_GET['state']) AND empty($_GET['selected']) AND empty($_GET['region'])){
              $stateId = $_GET['state'];
              $stateName = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT state_name FROM states WHERE state_id=$stateId LIMIT 1"));
              $queryZones = mysqli_query($db_conn, "SELECT * FROM tbl_zones WHERE state_id='$stateId'");
          ?>
            <div class="card card-info">
            <div class="card-header">
            <h3 class="card-title"><strong>SENATORIAL ZONES IN <?php echo strtoupper($stateName['state_name']); ?> (<?php echo mysqli_num_rows($queryZones); ?>)</strong></h3>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="example1" class="table table-bordered table-striped">
              <thead>
              <tr>
                <th width="10px">#</th>
                <th width="20%">Zone Name</th>
                <th>LGAs/Cities</th>
                <!-- <th width="15%"><i class="fa fa-cogs"></i></th> -->
              </tr>
              </thead>
              <tbody>
                <?php
                  $number = 1;
                  while($zone = mysqli_fetch_assoc($queryZones)){
                    $zoneId = $zone['zone_id'];
                    $cityQuery = mysqli_query($db_conn, "SELECT * FROM lga WHERE zone_id!='' AND zone_id='$zoneId' AND status=1 ORDER BY name ASC");
                    $cityName = '';
                    while($city=mysqli_fetch_assoc($cityQuery)){
                      if(empty($cityName)){
                        $cityName = $city['name'];
                      }
                      else{
                        $cityName .= ', '.$city['name'];
                      }
                    }
                ?>
                <tr>
                  <td><?php echo $number; ?></td>
                  <td><strong><?php echo $zone['zone_name'].' ('.mysqli_num_rows($cityQuery).')'; ?></strong></td>
                  <td><strong><?php echo $cityName; ?></strong></td>
                  <!-- <td>
                    <a href="javascript: void();" class="btn btn-xs btn-info" data-toggle="modal" data-target="#edit-user-<?php echo $admin['user_id']; ?>"><i class="fa fa-edit" title="Edit"></i></a>
                    <a href="javascript: void();" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#delete-user-<?php echo $admin['user_id']; ?>"><i class="fa fa-trash" title="Remove"></i></a>
                    <a href="javascript: void();" class="btn btn-xs btn-secondary" data-toggle="modal" data-target="#update-password-<?php echo $admin['user_id']; ?>" title="Update Password"><i class="fa fa-lock"></i> <i class="fa fa-upload"></i></a>
                  </td> -->
                </tr>
                
                <?php  $number++; } ?>
              </tbody>
              </table>
            </div>
                  <!-- /.card-body -->
                </div>
          <?php } ?>
          <?php } ?>
        </div>
      </div>

          <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <?php include($dir.'pages/universal/footer.php'); ?>