$(document).ready(function(){
    ////load country details///
    
    $.ajax({
        type: 'POST',
        url: 'resources/scripts/settings/plans.php',
        data: 'action=load-plans',
		beforeSend: function(){
			$("#planDetails").html('<div class="card-body"><h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading</div>');
		},
        success:function(response){
            $("#planDetails").html(response);
        }
    });
	
	$(document).delegate("[data-target='#edit-plan']", "click", function() {
		var planCode = $(this).attr('data-id');
		var name = $(this).attr('name');
		var title = $(this).attr('title');
		$("#editPlanHead").html(title);
		

		$.ajax({
			type:'POST',
			url:'resources/scripts/settings/plans.php',
			data:'action=edit-plan&plancode='+planCode,
			beforeSend: function(){
				$("#editPlanBody").html('<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading');
			},
			success:function(responseData){
				$("#editPlanBody").html(responseData);
			}
		});

	});

    $('#addPlanBtn').on('click', function(){
        var fd = new FormData();
		var errorMsg = '';
        var files = $('#bannerImg')[0].files;
		if(files.length > 0 ){
			fd.append('file',files[0]);
			$("#bannerImg").removeClass('is-invalid');
		}
		else{
			if(errorMsg){
				errorMsg += '<br><i class="fa fa-times"></i> Please, select a valid banner';
			}
			else{
				errorMsg = '<i class="fa fa-times"></i> Please, select a valid banner';
			}
			$('#bannerImg').addClass('is-invalid');
		}
		let planName = $("#planName").val();
		if(!planName){
			if(errorMsg){
				errorMsg += '<br><i class="fa fa-times"></i> Plan Name Required';
			}
			else{
				errorMsg = '<i class="fa fa-times"></i> Plan Name Required';
			}
			$('#planName').addClass('is-invalid');
		}
		else{
			fd.append('planName',planName);
			$('#planName').removeClass('is-invalid');
		}
		let planAmount = $("#planAmount").val();
		
		if(!planAmount){
			if(errorMsg){
				errorMsg += '<br><i class="fa fa-times"></i> Plan Amount Required';
			}
			else{
				errorMsg = '<i class="fa fa-times"></i> Plan Amount Required';
			}
			$('#planAmount').addClass('is-invalid');
		}
		else{
			fd.append('planAmount',planAmount);
			$('#planAmount').removeClass('is-invalid');
		}
		let dailyRoi = $("#dailyRoi").val();
		if(!dailyRoi){
			if(errorMsg){
				errorMsg += '<br><i class="fa fa-times"></i> Daily ROI Required';
			}
			else{
				errorMsg = '<i class="fa fa-times"></i> Daily ROI Required';
			}
			$('#dailyRoi').addClass('is-invalid');
		}
		else{
			fd.append('dailyRoi',dailyRoi);
			$('#dailyRoi').removeClass('is-invalid');
		}
		
		let investmentPeriod = $("#investmentPeriod").val();
		if(!investmentPeriod){
			if(errorMsg){
				errorMsg += '<br><i class="fa fa-times"></i> Investment Period Required';
			}
			else{
				errorMsg = '<i class="fa fa-times"></i> Investment Period Required';
			}
			$('#investmentPeriod').addClass('is-invalid');
		}
		else{
			let invMin = $("#investmentPeriod").attr('min');
			if(investmentPeriod < invMin){
				if(errorMsg){
					errorMsg += '<br><i class="fa fa-times"></i> Investment Period must be at least <b>'+invMin+' Days</b>';
				}
				else{
					errorMsg = '<i class="fa fa-times"></i> Investment Period Required';
				}
				$('#investmentPeriod').addClass('is-invalid');
			}
			else{
				fd.append('investmentPeriod',investmentPeriod);
				$('#investmentPeriod').removeClass('is-invalid');
			}
		}
		let planDescription = $("#planDescription").val();
		if(!planDescription){
			if(errorMsg){
				errorMsg += '<br><i class="fa fa-times"></i> Plan Description Required';
			}
			else{
				errorMsg = '<i class="fa fa-times"></i> Plan Description Required';
			}
			$('#planDescription').addClass('is-invalid');
		}
		else{
			fd.append('planDescription',planDescription);
			$('#planDescription').removeClass('is-invalid');
		}
		 
		if(!errorMsg){
			$('#addPlanMsg').html('');
			//alert(fd);
            fd.append('action','add-plan');
            $.ajax({
                url: 'resources/scripts/settings/plans.php',
                type: 'post',
                data: fd,
                contentType: false,
                processData: false,
                dataType:'JSON',
                beforeSend:function(){
                    $('#addPlanMsg').addClass('text-center text-info').html('Adding <b>'+planName+'</b>...<i class="fa fa-spinner fa-spin"></i>');
                    $('#addPlanBtn').attr('disabled', 'disabled');
                },
                success: function(response){
                    if(response.header=='successful'){
						$('#addPlanMsg').removeClass('text-center text-info').html('');
                        document.getElementById('bannerImg').value = '';
                        
                        $('#addPlanBtn').removeAttr('disabled');
                        toastr.success('<b>'+planName+'</b> was successfully added.');
						$("#planName").val(''); 
						$("#planAmount").val(''); 
						$("#dailyRoi").val(3); 
						$("#investmentPeriod").val(90); 
						$("#planDescription").val('');
                        setTimeout(function(){
							//$("#add-plan").modal('hide');
							
                            $.ajax({
								type: 'POST',
								url: 'resources/scripts/settings/plans.php',
								data: 'action=load-plans',
								success:function(response){
									$("#planDetails").html(response);
								}
							});
                        }, 5000);
                    }
                    else{
                        $('#addPlanMsg').addClass('text-danger');
                        $('#addPlanMsg').html('<i class="fa fa-times-circle"></i> '+response.message);
                        $('#addPlanBtn').removeAttr('disabled');
                    }
                },
            });
        }else{
           $('#addPlanMsg').addClass('text-danger');
           $('#addPlanMsg').html(errorMsg);
        }
        
    });
        
});