<?php
	$dir = '../../../';
	require_once($dir.'../connection.php');
    $myId = $user['unique_id'];
	if(isset($_POST['action'])){
		if($_POST['action']=='load-properties'){
            $queryProperties = mysqli_query($db_conn, "SELECT * FROM tbl_properties WHERE prop_status='Active' ORDER BY prop_date_added DESC");
            $propDetails = '
            <button class="btn btn-info float-right" data-toggle="modal" data-target="#add-property"><i class="fa fa-map"></i> Add New Property</button><br /><br />
            <div class="card card-info">
              <div class="card-header">
                <h3 class="card-title">All Properties ('.mysqli_num_rows($queryProperties).')</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                    <tr>
                        <th>S/N</th>
                        <th>Property Name</th>
                        <th>Location</th>
                        <th>Price('.$naira.')</th>
                        <th>promo('.$naira.')</th>
                        <th>Size(M<sup>2</sup>)</th>
                        <th>Status</th>
                        <th>Date Added</th>
                        <th></th>
                    </tr>
                  </thead>
                  <tbody>';
                    
                $number = 1;
                while($property=mysqli_fetch_assoc($queryProperties)){
                    if($property['prop_status']=='Active'){
                        $status = '<label class="badge badge-success">Active</label>';
                        $btn = '<button class="btn btn-xs btn-info" name="'.$property['prop_name'].'" title="View '.$property['prop_name'].'" data-toggle="modal" data-target="#view-property" data-id="'.$property['prop_id'].'"><i class="fa fa-eye"></i></button>
                            <button class="btn btn-xs btn-success" name="'.$property['prop_name'].'" title="Edit '.$property['prop_name'].'" data-toggle="modal" data-target="#edit-property" data-id="'.$property['prop_id'].'"><i class="fa fa-edit"></i> </button>
                            <button type="button" class="btn btn-xs btn-warning" data-toggle="modal" data-target="#disable-property" name="'.$property['prop_name'].'" title="Disable '.$property['prop_name'].'" data-id="'.$property['prop_id'].'"><i class="fas fa-times"></i></button>
                            <button class="btn btn-xs btn-danger" name="'.$property['prop_name'].'" title="Delete '.$property['prop_name'].'" data-toggle="modal" data-target="#delete-prop" data-id="'.$property['prop_id'].'"><i class="fa fa-trash"></i></button>';
                    }
                    elseif($property['prop_status']=='Deleted'){
                        $status = '<label class="badge badge-danger">Deleted</label>';
                        $btn = '<button type="button" class="btn btn-xs btn-success" data-toggle="modal" data-target="#restore-property" name="'.$property['prop_name'].'" title="Restore '.$property['prop_name'].'" data-id="'.$property['prop_id'].'"><i class="fas fa-trash-restore"></i></button>
                        <button type="button" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#perm-delete-prop" name="'.$property['prop_name'].'" title="Permanently Delete '.$property['prop_name'].'" data-id="'.$property['prop_id'].'"><i class="fa fa-trash"></i></button>';
                    }
                    else{
                        $status = '<label class="badge badge-warning">Disabled</label>';
                        $btn = '<button type="button" class="btn btn-xs btn-success" data-toggle="modal" data-target="#restore-property" name="'.$property['prop_name'].'" title="Restore '.$property['prop_name'].'" data-id="'.$property['prop_id'].'"><i class="fas fa-undo"></i></button>';
                    }
                    
                    $propDetails .= '<tr>
                        <td>'.$number.'</td>
                        <td><b>'.$property['prop_name'].'</b></td>
                        <td>'.$property['prop_location'].'</td>
                        <td>'.numberFormat($property['actual_price']).'</td>
                        <td>'.numberFormat($property['promo_price']).'</td>
                        <td>'.numberFormat($property['prop_size']).'</td>
                        <td>'.$status.'</td>
                        <td>'.timeCheck($property['prop_date_added']).'</td>
                        <td>'.$btn.'</td>
                    </tr>';
            
                    $number++; 
                    $totalAmount += $payments['amount']; 
                }

            $propDetails .= '</tbody>
                    </table>
                </div>
                <!-- /.card-body -->
                </div>';

                $dataReturn = [
                    "head"=> "successful",
                    "body" => "$propDetails"
                ];
                
                echo json_encode($dataReturn);
                    
        }
		elseif($_POST['action']=='load-delete'){
            $propId = $_POST['prop-id'];
            $propDetail = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT * FROM tbl_properties WHERE prop_id='$propId' LIMIT 1"));
            $head = 'Delete <b>'.$propDetail['prop_name'].'</b>';
            $body = '<p>
                Are you sure you want to delete <b>'.$propDetail['prop_name'].'.<br>This process cannot be reversed.</b>
            </p><input type="hidden" id="prop-id" value="'.$propDetail['prop_id'].'" />';

            $dataReturn = [
				"head"=> $head,
				"body" => $body
            ];
			
            echo json_encode($dataReturn);
        }
		elseif($_POST['action']=='delete-prop'){
            $propId = $_POST['prop-id'];
            $propDetail = mysqli_fetch_assoc(mysqli_query($db_conn, "SELECT * FROM tbl_properties WHERE prop_id='$propId' LIMIT 1"));
            $propFolder = $dir."../assets/images/props/".strtolower(str_replace(' ','-',$propDetail['prop_type'])).'/';
            if($user['user_type']=='Super Administrator'){
                ///fetch all the images data and delete all/////
                $images = explode(',', $propDetail['prop_banner']);
                $size = sizeof($images);
                $success = 0;
                $failure = 0;
                $failMsg = '';
                if($size>1){
                    for($i=0; $i < $size; $i++){
                        if(unlink($propFolder.$images[$i])===true){
                            $success++;
                        }
                        else{
                            $failure++;
                            if(empty($failMsg)){
                                $failMsg = $images[$i];
                            }
                            else{
                                $failMsg .= ','.$images[$i];
                            }
                        }
                    }
                }
                else{
                    if(unlink($propFolder.$propDetail['prop_banner'])===true){
                        $success++;
                    }
                    else{
                        $failure++;
                    }
                }

                if($failure<1){
                    $deleteProp = mysqli_query($db_conn, "DELETE FROM tbl_properties WHERE prop_id='$propId' LIMIT 1");
                    if($deleteProp===true){
                        echo 'successful';
                    }
                    else{
                        echo mysqli_error($db_conn);
                    }
                }
                else{
                    echo "Could not Delete $failMsg from folder";
                }
            }
            else{
                /////change the status of the property/////////////
                $deleteProp = mysqli_query($db_conn, "UPDATE tbl_properties SET prop_status='Deleted' WHERE prop_id='$propId' LIMIT 1");
                if($deleteProp===true){
                    echo 'successful';
                }
                else{
                    echo mysqli_error($db_conn);
                }
            }
        }
		elseif($_POST['action']=='check-uploaded-images'){
            $values = explode(', ', $_SESSION['image_files']);
            $mainValues = '';
            for($i=0; $i<sizeof($values); $i++){
                if(!empty($values[$i])){
                    if(empty($mainValues)){
                        $mainValues = $values[$i];
                    }
                    else{
                        $mainValues .= ','.$values[$i];
                    }
                }
            }
            echo $mainValues;
        }
		elseif($_POST['action']=='view-image-edit'){
            echo '<img src="../assets/images/props/'.strtolower(str_replace(' ','-',$_POST['folder'])).'/'.$_POST['image'].'" width="100%" alt="property image" />';
        }
		elseif($_POST['action']=='view-image'){
            echo '<img src="dist/img/tmp/'.$_POST['image'].'" width="100%" alt="property image" />';
        }
		elseif($_POST['action']=='remove-images-add'){
            if(isset($_SESSION['image_files'])){
                $image = explode(',', $_SESSION['image_files']);
                $deleted = 0;
                $failed = 0;

                $preview = '<div class="row">';

                for($i=0; $i < (sizeof($image)); $i++){
                    if(unlink($dir.'dist/img/tmp/'.$image[$i])===true){
                        $deleted++;
                    }
                    else{
                        $failed++;
                    }
                }

                if($failed>0){
                    echo "Could not delete the $failed images";
                }
                else{
                    unset($_SESSION['image_files']);
                    echo 'successful';
                }
            }
        }
		elseif($_POST['action']=='remove-images-edit'){
            if(isset($_SESSION['image_files_edit'])){
                $image = explode(',', $_SESSION['image_files_edit']);
                $deleted = 0;
                $failed = 0;

                $preview = '<div class="row">';

                for($i=0; $i < (sizeof($image)); $i++){
                    if(unlink($dir.'dist/img/tmp/'.$image[$i])===true){
                        $deleted++;
                    }
                    else{
                        $failed++;
                    }
                }

                if($failed>0){
                    echo "Could not delete the $failed images";
                }
                else{
                    unset($_SESSION['image_files_edit']);
                    echo 'successful';
                }
            }
        }
        elseif($_POST['action']=='edit-property-header'){
            $propId = $_POST['property-id'];
            $query = mysqli_query($db_conn, "SELECT * FROM tbl_properties WHERE prop_id='$propId' LIMIT 1");
			$details = mysqli_fetch_assoc($query);
            echo $details['prop_name'].'('.$_SESSION['image_files_edit'].')';
        }
        elseif($_POST['action']=='edit-property'){
            $propId = mysqli_real_escape_string($db_conn, $_POST['property-id']);
            $query = mysqli_query($db_conn, "SELECT * FROM tbl_properties WHERE prop_id='$propId' LIMIT 1");
			$details = mysqli_fetch_assoc($query);

?>
        <div class="row">
            <div class="form-group col-md-6">
                <label>Property Name</label>
                <div class="input-group mb-3">
                <div class="input-group-prepend">
                    <span class="input-group-text"><i class="fa fa-building"></i></span>
                </div>
                <input type="text" class="form-control" value="<?php echo $details['prop_name']; ?>" placeholder="Enter property name">
                </div>
            </div>
            <div class="form-group col-md-6">
                <label>Property Type</label>
                <select class="form-control select2bs4" style="width: 100%;">
                <?php
                    $queryType = "SELECT * FROM tbl_prop_types WHERE status=1";
                    $result = mysqli_query($db_conn, $queryType);
                    if(mysqli_num_rows($result)>0){
                    while($type = mysqli_fetch_assoc($result)){
                        if($type['type_name']==$details['prop_type']){
                            echo '<option selected="selected" value="'.$type['type_name'].'">'.$type['type_name'].'</option>';
                        }
                        else{
                            echo '<option value="'.$type['type_name'].'">'.$type['type_name'].'</option>';
                        }
                    }
                    }
                    else{
                    echo '<option value="">No property type added</option>';
                    }
                ?>
                </select>
            </div>
            <div class="form-group col-md-4 col-lg-4 col-xl-4 col-sm-6 col-xs-12">
                <label>Plot Size</label>
                <div class="input-group mb-3">
                <div class="input-group-prepend">
                    <span class="input-group-text"><i class="fa fa-map"></i></span>
                </div>
                <input type="number" min="0" class="form-control" value="<?php echo $details['prop_size']; ?>" placeholder="Enter Size">
                <div class="input-group-prepend">
                    <span class="input-group-text">m<sup>2</sup></span>
                </div>
                </div>
            </div>
            <div class="form-group col-md-4 col-lg-4 col-xl-4 col-sm-6 col-xs-12">
                <label>Plot Price</label>
                <div class="input-group mb-3">
                <div class="input-group-prepend">
                    <span class="input-group-text"><?php echo $naira; ?></span>
                </div>
                <input type="text" class="form-control" value="<?php echo numberFormat($details['actual_price']); ?>" placeholder="Enter peice">
                </div>
            </div>
            <div class="form-group col-md-4 col-lg-4 col-xl-4 col-sm-6 col-xs-12">
                <label>Promo Price</label>
                <div class="input-group mb-3">
                <div class="input-group-prepend">
                    <span class="input-group-text"><?php echo $naira; ?></span>
                </div>
                <input type="text" class="form-control" value="<?php echo numberFormat($details['promo_price']); ?>" placeholder="Promo price">
                </div>
            </div>
            <div class="form-group col-md-6 col-lg-6 col-xl-6 col-sm-12 col-xs-12">
                <label>Property Location</label>
                <div class="input-group mb-3">
                <div class="input-group-prepend">
                    <span class="input-group-text"><i class="fa fa-map-marker"></i></span>
                </div>
                <input type="text" class="form-control" id="propLocation" value="<?php echo $details['prop_location']; ?>" placeholder="Enter Location of property">
                </div>
            </div>
            <!-- /.form-group -->
            <div class="form-group col-md-6 col-lg-6 col-xl-6 col-sm-12 col-xs-12">
                <label>Property Tag</label>
                <select class="form-control select2bs4" style="width: 100%;">
                    <?php
                    $queryTags = "SELECT * FROM tbl_prop_tags";
                    $result = mysqli_query($db_conn,$queryTags);
                    while($tags = mysqli_fetch_assoc($result)){
                        if($details['prop_extra']==$tags['tag']){
                            echo '<option value="'.$tags['tag'].'" selected="selected">'.$tags['tag'].'</option>';
                        }
                        else{
                            echo '<option value="'.$tags['tag'].'">'.$tags['tag'].'</option>';
                        }
                    }
                    ?>   
                </select>
            </div>
            <div class="form-group col-md-12">
                <label>Short Description</label>
                <div class="input-group mb-3">
                <div class="input-group-prepend">
                    <span class="input-group-text"><i class="fa fa-map-marker"></i></span>
                </div>
                <input type="text" class="form-control" id="shortDescription" value="<?php echo $details['short_description']; ?>" placeholder="Enter short description of property">
                </div>
            </div>

            <div class="form-group col-md-12">
                <label>Map Code</label>
                <textarea class="form-control" style="width: 100%;" id="map" rows="5">
                    <?php echo $details['prop_map']; ?>
                </textarea>
            </div>
            <!-- /.form-group -->

            <input type="hidden" id="imgid" value="<?php echo $details['prop_id']; ?>" />
        
            <div class="form-group col-md-12">
                <label>Description of Property</label>
                
                <textarea id="propDescription" placeholder="Enter property description here..." class="form-control" rows="10" style="width: 100%;" ><?php echo $details['prop_description']; ?></textarea>
            </div>
            
            <!-- /.form-group -->
        </div>
        <div class="modal-footer justify-content-between">
            <button type="button" class="btn btn-default" id="closeEditBtn" data-dismiss="modal">Close</button>
            <button type="button" class="btn btn-info" id="updatePropertyBtn"><i class="fa fa-save"></i> Save Changes</button>
        </div>
              
          <script>
            $(function () {
                //Initialize Select2 Elements
                $('.select2').select2();

                //Initialize Select2 Elements
                $('.select2bs4').select2({
                    theme: 'bootstrap4'
                });


                $(function () {
                    // Summernote
                    $('#summernote').summernote();

                    $('#compose-textarea').summernote()
                });
            });
        </script>
<?php
        }
        elseif($_POST['action']=='edit-property-images'){
            $propId = mysqli_real_escape_string($db_conn, $_POST['property-id']);
            $query = mysqli_query($db_conn, "SELECT * FROM tbl_properties WHERE prop_id='$propId' LIMIT 1");
			$details = mysqli_fetch_assoc($query);

?>
        <div class="row">
            <div class="form-group col-md-12">
                <div class="col-md-12 col-lg-12 col-xl-12">
                    <label>Property Images (<small class="text-danger"><b>JPEG, JPG, PNG</b></small>)</label>
                    <div class="custom-file">
                        <input type="file" multiple="multiple" id="filesedit" class="custom-file-input" accept=".JPG,.JPEG,.jpg,.jpeg,.png,.PNG">
                        <label class="custom-file-label" for="customFile">Browse Files</label>
                    </div>
                </div>
            </div>
            
            <link rel="stylesheet" href="plugins/ekko-lightbox/ekko-lightbox.css">
            
            <div class="form-group col-md-12 text-center" id="imgPreviewEdit">
                    <?php
                    $images = explode(',', $details['prop_banner']);
        
                    $preview = '<div class="row">';
        
                    if(sizeof($images)>1){
                        for($i=0; $i < (sizeof($images)-1); $i++){
                            $image .= '<div class="col-sm-2"><a href="javascript:void();" data-toggle="modal" data-target="#viewImage" data-id="'.$images[$i].'">
                            <br/><img src="../assets/images/props/'.strtolower($details['prop_type']).'/'.$images[$i].'"  class="img-fluid mb-2" alt="property image"/>
                            </a><br/><button type="button" class="btn btn-danger btn-xs deleteImageEdit" data-id="'.$images[$i].'" title="main"><i class="fa fa-trash"></i> Delete</button><br/></div>';
                        }
                    }else{
                        $image .= '<div class="col-sm-2"><a href="javascript:void();" data-toggle="modal" title="'.strtolower(str_replace(' ','-',$details['prop_type'])).';" data-target="#viewImage" data-id="'.$details['prop_banner'].'">
                        <br/><img src="../assets/images/props/'.strtolower(str_replace(' ','-',$details['prop_type'])).'/'.$details['prop_banner'].'"  class="img-fluid mb-2" alt="property image"/>
                        </a><br/><button type="button" class="btn btn-danger btn-xs deleteImageEdit" data-id="'.$images[$i].'" title="main"><i class="fa fa-trash"></i> Delete</button><br/></div>';
                    }

                    if(isset($_SESSION['image_files_edit'])){
                        $images = explode(',', $_SESSION['image_files']);
            
                        if(sizeof($images)>0){
                            for($i=0; $i < (sizeof($image)); $i++){
                                if(is_file($dir.'dist/img/tmp/'.$images[$i])){
                                    $image .= '<div class="col-sm-2"><a href="javascript:void();" data-toggle="modal" data-target="#viewImage" data-id="'.$images[$i].'">
                                    <br/><img src="dist/img/tmp/'.$images[$i].'"  class="img-fluid mb-2" alt="property image"/>
                                    </a><br/><button type="button" class="btn btn-danger btn-xs  deleteImageEdit" data-id="'.$images[$i].'" title="main"><i class="fa fa-trash"></i> Delete</button><br/></div>';
                                }
                            }
                        }
                    }
                    
        
                    $preview .= $image.'</div><script>
                        $(document).delegate("[data-target=\'#viewImageEdit\']", "click", function() {
                            var image = $(this).attr(\'data-id\');
                            var folder = $(this).attr(\'title\');
                            $("#deleteImageBtn").attr("data-id", image);
                            alert(folder);
                            /* $.ajax({
                                type:\'POST\',
                                url:\'resources/scripts/property/data.php\',
                                data:\'action=view-image-edit&folder=\'+folder+\'&image=\'+image,
                                beforeSend: function(){
                                    $("#imageViewerEdit").html(\'<h3 class="text-center"><i class="fa fa-spinner fa-spin"></i>...Loading\');
                                },
                                success:function(responseData){
                                    $("#imageViewerEdit").html(responseData);
                                }
                            }); */
                        });
        
                        $(".deleteImageEdit").on(\'click\', function(){
                            var imageDel = $(this).attr(\'data-id\');
                            var title = $(this).attr(\'title\');
                            $.ajax({
                                type:\'POST\',
                                url:\'resources/scripts/property/upload-images.php\',
                                data:\'action=delete-image&image=\'+imageDel,
                                beforeSend: function(){
                                    $(this).attr(\'disabled\',\'disabled\');
                                },
                                success:function(responseData){
                                    $.ajax({
                                        type:\'POST\',
                                        url:\'resources/scripts/property/upload-images.php\',
                                        data:\'action=load-images\',
                                        beforeSend:function(){
                                            $("#imgPreviewEdit").html(\'<h6><b class="text-info">Loading...<i class="fa fa-spinner fa-spin"></i></b></h65><br>\');
                                        },
                                        success:function(uploadResponse){
                                            $("#imgPreviewEdit").html(uploadResponse);
                                        }
                                    });
                                }
                            });
                        });
                    </script>';
                    
                    echo $preview;
                    ?>
            </div>
                
        </div>
        <div class="modal-footer justify-content-between">
            <button type="button" class="btn btn-default" id="closeEditBtn" data-dismiss="modal">Close</button>
            <button type="button" class="btn btn-info" id="updatePropertyImageBtn"><i class="fa fa-save"></i> Save Changes</button>
        </div>
              
          <script>
            $(function () {
                $(function () {
                    bsCustomFileInput.init();
                });

                $(function () {

                    $(document).on('click', '[data-toggle="lightbox"]', function(event) {
                        event.preventDefault();
                        $(this).ekkoLightbox({
                            alwaysShowClose: true
                        });
                    });
                });
            });

            /////multiple upload for iRev results
            const filepickeredit = document.getElementById("filesedit");

            filepickeredit.addEventListener("change", (event) => {
                var files = $('#filesedit')[0].files;
                var imgid = $("#imgid").val();
            
                var formData = new FormData();

                // Read selected files
                for (var index = 0; index < files.length; index++) {
                    formData.append("filesedit[]", document.getElementById('filesedit').files[index]);
                }
                if(files.length > 0){
                    formData.append('action', 'upload-images-edit');
                    formData.append('imgid', imgid);
                    $.ajax({
                        type: 'POST',
                        url: 'resources/scripts/property/upload-images.php',
                        data: formData,
                        contentType: false,
                        processData: false,
                        beforeSend:function(){
                            $("#imgPreviewEdit").html('<h6><b class="text-info"><i class="fa fa-spinner fa-spin"></i>...uploading '+files.length+' files. Please, wait</b></h65><br>');
                        },
                        success:function(uploadResponseEdit){
                            $.ajax({
                                type:'POST',
                                url:'resources/scripts/property/upload-images.php',
                                data:'action=load-images-edit&imgid='+imgid,
                                beforeSend:function(){
                                    $("#imgPreviewEdit").html('<h6><b class="text-info">Loading...<i class="fa fa-spinner fa-spin"></i></b></h65><br>');
                                },
                                success:function(uploadResponseEdit){
                                    $("#imgPreviewEdit").html(uploadResponseEdit);
                                }
                            });
                        }
                    });
                }
                else{
                    $('#filesedit').addClass('is-invalid');
                    $("#imgPreviewEdit").html('<h5><b class="text-danger">You must select at least one file</b></h5><br>');
                }
            });

        </script>
<?php
        }
		elseif($_POST['action']=='view-property'){
			$propId = mysqli_real_escape_string($db_conn, $_POST['property-id']);
			$query = mysqli_query($db_conn, "SELECT * FROM tbl_properties WHERE prop_id='$propId' LIMIT 1");
			$details = mysqli_fetch_assoc($query);
            $banners = explode(',', $details['prop_banner']);
            $propImages = '';
            $mainBanner = '';
            if(sizeof($banners)>1){
                $num = 0;
                while($num < (sizeof($banners))){
                    if($num==0){
                        $mainBanner = '<img src="../assets/images/props/'.strtolower(str_replace(' ','-', $details['prop_type'])).'/'.$banners[$num].'" class="product-image" alt="'.$details['prop_name'].' Property image">';
                        $propImages .= '<div class="product-image-thumb active"><img src="../assets/images/props/'.strtolower(str_replace(' ','-', $details['prop_type'])).'/'.$banners[$num].'" alt="Product Image"></div>';
                    }
                    else{
                        $propImages .= '<div class="product-image-thumb" ><img src="../assets/images/props/'.strtolower(str_replace(' ','-', $details['prop_type'])).'/'.$banners[$num].'" alt="'.$details['prop_name'].' Property image"></div>';
                    }
                    
                    $num++;
                }
            }
            else{
                $mainBanner = '<img src="../assets/images/props/'.strtolower(str_replace(' ','-', $details['prop_type'])).'/'.$banners[0].'" class="product-image" alt="'.$details['prop_name'].' Property image">';
            }

            if($details['prop_availability']=='Availabl'){
                $availability = '<span class="text-lg"><i class="fas fa-circle fa-1x text-green"></i> Available </span>';
            }
            else{
                $availability = '<span class="text-lg"><i class="fas fa-circle fa-1x text-red"></i> Unavailable </span>';
            }
            $faqDetails = '<div class="row col-md-12">
                <div class="col-md-12" id="accordion">
                    <div class="card card-primary card-outline">
                        <a class="d-block w-100" data-toggle="collapse" href="#collapseOne">
                            <div class="card-header">
                                <h4 class="card-title w-100">
                                    1. Lorem ipsum dolor sit amet
                                </h4>
                            </div>
                        </a>
                        <div id="collapseOne" class="collapse show" data-parent="#accordion">
                            <div class="card-body">
                                Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor.
                            </div>
                        </div>
                    </div>
                    <div class="card card-primary card-outline">
                        <a class="d-block w-100" data-toggle="collapse" href="#collapseTwo">
                            <div class="card-header">
                                <h4 class="card-title w-100">
                                    2. Aenean massa
                                </h4>
                            </div>
                        </a>
                        <div id="collapseTwo" class="collapse" data-parent="#accordion">
                            <div class="card-body">
                                Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.
                            </div>
                        </div>
                    </div>
                    <div class="card card-primary card-outline">
                        <a class="d-block w-100" data-toggle="collapse" href="#collapseThree">
                            <div class="card-header">
                                <h4 class="card-title w-100">
                                    3. Donec quam felis
                                </h4>
                            </div>
                        </a>
                        <div id="collapseThree" class="collapse" data-parent="#accordion">
                            <div class="card-body">
                                Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim.
                            </div>
                        </div>
                    </div>
                    <div class="card card-warning card-outline">
                        <a class="d-block w-100" data-toggle="collapse" href="#collapseFour">
                            <div class="card-header">
                                <h4 class="card-title w-100">
                                    4. Donec pede justo
                                </h4>
                            </div>
                        </a>
                        <div id="collapseFour" class="collapse" data-parent="#accordion">
                            <div class="card-body">
                                Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu.
                            </div>
                        </div>
                    </div>
                    <div class="card card-warning card-outline">
                        <a class="d-block w-100" data-toggle="collapse" href="#collapseFive">
                            <div class="card-header">
                                <h4 class="card-title w-100">
                                    5. In enim justo
                                </h4>
                            </div>
                        </a>
                        <div id="collapseFive" class="collapse" data-parent="#accordion">
                            <div class="card-body">
                                In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium.
                            </div>
                        </div>
                    </div>
                    <div class="card card-warning card-outline">
                        <a class="d-block w-100" data-toggle="collapse" href="#collapseSix">
                            <div class="card-header">
                                <h4 class="card-title w-100">
                                    6. Integer tincidunt
                                </h4>
                            </div>
                        </a>
                        <div id="collapseSix" class="collapse" data-parent="#accordion">
                            <div class="card-body">
                                Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus.
                            </div>
                        </div>
                    </div>
                    <div class="card card-danger card-outline">
                        <a class="d-block w-100" data-toggle="collapse" href="#collapseSeven">
                            <div class="card-header">
                                <h4 class="card-title w-100">
                                    7. Aenean leo ligula
                                </h4>
                            </div>
                        </a>
                        <div id="collapseSeven" class="collapse" data-parent="#accordion">
                            <div class="card-body">
                                Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim.
                            </div>
                        </div>
                    </div>
                    <div class="card card-danger card-outline">
                        <a class="d-block w-100" data-toggle="collapse" href="#collapseEight">
                            <div class="card-header">
                                <h4 class="card-title w-100">
                                    8. Aliquam lorem ante
                                </h4>
                            </div>
                        </a>
                        <div id="collapseEight" class="collapse" data-parent="#accordion">
                            <div class="card-body">
                                Aliquam lorem ante, dapibus in, viverra quis, feugiat a, tellus. Phasellus viverra nulla ut metus varius laoreet.
                            </div>
                        </div>
                    </div>
                    <div class="card card-danger card-outline">
                        <a class="d-block w-100" data-toggle="collapse" href="#collapseNine">
                            <div class="card-header">
                                <h4 class="card-title w-100">
                                    9.  Quisque rutrum
                                </h4>
                            </div>
                        </a>
                        <div id="collapseNine" class="collapse" data-parent="#accordion">
                            <div class="card-body">
                                Quisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi.
                            </div>
                        </div>
                    </div>
                </div>
            </div>';
            $propertyBody = '<div class="row">
            <div class="col-sm-6">
              <div class="col-12">
                '.$mainBanner.'
              </div>
              <div class="col-12 product-image-thumbs">
                '.$propImages.'
              </div>
            </div>
            <div class="col-sm-6">
              <h3 class="my-3"><b>'.$details['prop_name'].'</b></h3>
              <p>'.$details['prop_description'].'</p>

              <div class="col-12 product-image-thumbs">
                <small><i class="fa fa-map-marker"></i></small> Location: '.$details['prop_location'].'
              </div>
              <hr />
              <div class="col-md-12">
                <h6><small>Availability:</small> 
                    <label class="text-center">
                    '.$availability.'
                    </label>
                &nbsp;&nbsp;&nbsp;&nbsp;
                <small>Plot Size: </small> 
                <label class="text-center">
                <span class="text-xl">'.$details['prop_size'].'m<sup>2</sup></span>
                </label></h6>

                <hr />
                <h6>
                    <small>Amount: </small> 
                    <label class="text-center">
                    <span class="text-xl">'.$naira.numberFormat($details['promo_price']).'&nbsp;&nbsp;<small class="text-danger"><del>'.$naira.numberFormat($details['actual_price']).'</del></small></span>
                    </label>
                </h6>
              </div>
                
            </div>
          </div>
          

          <script>
            $(document).ready(function() {
                $(\'.product-image-thumb\').on(\'click\', function () {
                var $image_element = $(this).find(\'img\')
                $(\'.product-image\').prop(\'src\', $image_element.attr(\'src\'))
                $(\'.product-image-thumb.active\').removeClass(\'active\')
                $(this).addClass(\'active\')
                })
            })
        </script>';
            $dataReturn = [
				"property_name"=> $details['prop_name'],
				"property_body" => $propertyBody
            ];
			
            echo json_encode($dataReturn);
		}
        elseif($_POST['action']=='upload-images'){
            
        }
		elseif($_POST['action']=='add-property'){
?>
    
                 
                
<?php
		}
        
	}
	else{
		echo 'Invalid operation. You cannot access this page directly';
	}
?>