﻿<?php
	$title = 'Payments Method Setting';
	$currentPage = 'payment methods';
?>
<?php include_once('myaccount/header.php'); ?>
  
  <!-- Content
  ============================================= -->
  <div id="content" class="py-4" style="padding-top: 50px;">
    <div class="container-fluid">
      <div class="row"> 
        <!-- Left Panel
        ============================================= -->
        <?php include_once('mainpage/sidebar.php'); ?>
        <!-- Left Panel End -->  
        
        <!-- Middle Panel
        ============================================= -->
        <div class="col-lg-9"> 
          
          <!-- Credit or Debit Cards
          ============================================= -->
          <div class="bg-white shadow-sm rounded p-4 mb-4">
            <h3 class="text-5 fw-400 mb-4">Crypto Addresses <span class="text-muted text-4">(for withdrawal)</span></h3>
            <hr class="mb-4 mx-n4">
            <div class="row g-3" id="cryptoAddressPanel">
				
            </div>
          </div>
          <!-- Edit Card Details Modal
          ================================== -->
          <div id="edit-address" class="modal fade" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title fw-400">Update Crypto Address </h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body p-4">
                  <form id="updateCard" method="post">
                    <div class="mb-3">
                      <label for="edircardNumber" class="form-label">Address <span class="text-info ms-1" data-bs-toggle="tooltip" title="Kindly Note that we can only pay out to USDT addresses of BEP10, TRC20 or ERC20"><i class="fas fa-question-circle"></i></span></label>
                      <div class="input-group">
                        <input type="text" class="form-control" data-bv-field="edircardNumber" id="editUsdtAddress" placeholder="USDT Address">
						<span class="input-group-text">
							<select class="form-select" id="usdtNetwork" name="country_id">
								<option value="1">TCR20</option>
								<option value="244">BEP10</option>
								<option value="2">ERC20</option>
							</select>
						</span>
                      </div>
                    </div>
                    <div class="d-grid mt-4"><button class="btn btn-primary" type="button" id="updateAddress">Update Address</button></div>
                  </form>
                </div>
              </div>
            </div>
          </div>
		  <div id="add-address" class="modal fade" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title fw-400">Add New Crypto Address </h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body p-4">
                  <!--<form id="addCryptoCard" method="post">
                    <div class="mb-3">
                      <label for="edircardNumber" class="form-label">Address <span class="text-info ms-1" data-bs-toggle="tooltip" title="Kindly Note that we can only pay out to USDT addresses of BEP10, TRC20 or ERC20"><i class="fas fa-question-circle"></i></span></label>
                      <div class="input-group">
                        <input type="text" class="form-control" data-bv-field="edircardNumber" id="addUsdtAddress" placeholder="USDT Address">
						<span class="input-group-text">
							<select class="form-select" id="addNetwork">
								<option value="TCR20">TCR20</option>
								<option value="ERC20">ERC20</option>
							</select>
						</span>
                      </div>
                    </div>
                    <div class="d-grid mt-4"><button class="btn btn-primary" type="button" id="addNewAddress"><i class="fa fa-save"></i> Save Changes</button></div>
					<div class="form-check mb-3" id="usdtMsgBox">
					  
					</div>
				  </form>-->
				  <h4 class="text-center text-danger">Crypto Option Currently<br>Unavailable</h4>
                </div>
              </div>
            </div>
          </div> 
		  
          <!-- Bank Accounts
          ============================================= -->
          <div class="bg-white shadow-sm rounded p-4 mb-4">
            <h3 class="text-5 fw-400 mb-4">Bank Accounts <span class="text-muted text-4">(for withdrawal)</span></h3>
            <hr class="mb-4 mx-n4">
            <div class="row g-3" id="bankAccountPanel">
				
			</div>
          <!-- Edit Bank Account Details Modal
          ======================================== -->
          <div id="bank-account-details" class="modal fade" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered transaction-details" role="document">
              <div class="modal-content">
                <div class="modal-body">
                  <div class="row g-0">
                    <div class="col-sm-5 d-flex justify-content-center bg-primary rounded-start py-4">
                      <div class="my-auto text-center">
                        <div class="text-17 text-white mb-3"><i class="fas fa-university"></i></div>
                        <h3 class="text-6 text-white my-3">HDFC Bank</h3>
                        <div class="text-4 text-white my-4">XXX-9027 | US</div>
                        <p class="badge bg-light text-dark text-0 fw-500 rounded-pill px-2 mb-0">Primary</p>
                      </div>
                    </div>
                    <div class="col-sm-7">
                      <h5 class="text-5 fw-400 m-3">Bank Account Details
                        <button type="button" class="btn-close text-2 float-end" data-bs-dismiss="modal" aria-label="Close"></button>
                      </h5>
                      <hr>
                      <div class="px-3 mb-3">
                        <ul class="list-unstyled">
                          <li class="fw-500">Account Type:</li>
                          <li class="text-muted">Personal</li>
                        </ul>
                        <ul class="list-unstyled">
                          <li class="fw-500">Account Name:</li>
                          <li class="text-muted">Smith Rhodes</li>
                        </ul>
                        <ul class="list-unstyled">
                          <li class="fw-500">Account Number:</li>
                          <li class="text-muted">XXXXXXXXXXXX-9025</li>
                        </ul>
                        <ul class="list-unstyled">
                          <li class="fw-500">Bank Country:</li>
                          <li class="text-muted">India</li>
                        </ul>
                        <ul class="list-unstyled">
                          <li class="fw-500">Status:</li>
                          <li class="text-muted">Approved <span class="text-success text-3"><i class="fas fa-check-circle"></i></span></li>
                        </ul>
                        <div class="d-grid"><button type="button" class="btn btn-sm btn-outline-danger shadow-none"><span class="me-1"><i class="fas fa-minus-circle"></i></span>Delete Account</button></div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!-- Add New Bank Account Details Modal
          ======================================== -->
          <div id="add-new-bank-account" class="modal fade" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title fw-400">Add bank account</h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body p-4">
                  <form id="addbankaccount" method="post">
					<?php if(empty($_SESSION['add_bank_account'])){ ?>
                    <div class="mb-3">
                      <label for="inputCountry" class="form-label">Bank Country</label>
                      <select class="form-select" id="inputCountry" >
					  <?php
						$queryCountry = mysqli_query($db_conn, "SELECT * FROM countries WHERE status=1 ORDER BY country_name ASC");
						if(mysqli_num_rows($queryCountry)>0){
							echo '<option value=""> --- Please Select --- </option>';
							while($country=mysqli_fetch_assoc($queryCountry)){
								echo '<option value="'.$country['country_id'].'">'.$country['country_name'].'</option>';
							}
						}
						else{
							echo '<option value="">Countrie not available</option>';
						}
					  ?>
                        
                      </select>
                    </div>
					<div id="loadBanks">
						
					</div>
					<?php 
						}else{ 
							if ($_SERVER["HTTPS"] != "on"){
								$generatedCode = ' - '.$_SESSION['add_bank_account'];;
							}
					?>
                    <div class="col-md-12">
						<div class="bg-white shadow-sm rounded p-5 text-center">
						  <div class="featured-box style-4">
							<h3 class="text-7 mb-3">Security Check<?php echo $generatedCode; ?></h3>
							<p class="text-4 lh-base">In order to be sure this action is initiated by the right owner, we have sent a verification code to your registered
								email address.
							</p>
						  </div>
						</div>
					</div>
					<div class="mb-3">
					  <input type="text" class="form-control" data-bv-field="verificationCode" id="verificationCode" value="" placeholder="Enter Code">
					</div>
					<div class="d-grid"><button class="btn btn-primary" id="completeProcess" type="button">VERIFY NOW</button></div>
					<div class="form-check mb-3" id="msgBox">
					  
					</div>
					<?php } ?>
                  </form>
                </div>
              </div>
            </div>
          </div>
          <!-- Bank Accounts End --> 
          
        </div>
        <!-- Middle Panel End --> 
      </div>
    </div>
  </div>
  
  <!-- Content end --> 
  <?php include_once('myaccount/footer.php'); ?>