﻿<?php
	$title = 'Profile Setting';
?>
<?php include_once('myaccount/header.php'); ?>
  
  <!-- Content
  ============================================= -->
  <div id="content" class="py-4">
    <div class="container-fluid">
      <div class="row"> 
        <!-- Left Panel
        ============================================= -->
        <?php include_once('mainpage/sidebar.php'); ?>
        <!-- Left Panel End --> 
        
        <!-- Middle Panel
        ============================================= -->
        <div class="col-lg-9"> 
          
          <!-- Personal Details
          ============================================= -->
          <div class="bg-white shadow-sm rounded p-4 mb-4">
            <h3 class="text-5 fw-400 d-flex align-items-center mb-4">Personal Details<a href="#edit-personal-details" data-bs-toggle="modal" class="ms-auto text-2 text-uppercase btn-link"><span class="me-1"><i class="fas fa-edit"></i></span>Edit</a></h3>
            <hr class="mx-n4 mb-4">
            <div class="row gx-3 align-items-center">
              <p class="col-sm-3 text-muted text-sm-end mb-0 mb-sm-3">Name:</p>
              <p class="col-sm-9 text-3"><?php echo $myName; ?></p>
            </div>
            <div class="row gx-3 align-items-center">
              <p class="col-sm-3 text-muted text-sm-end mb-0 mb-sm-3">Date of Birth:</p>
              <p class="col-sm-9 text-3">00-00-0000</p>
            </div>
            <!--<div class="row gx-3 align-items-baseline">
              <p class="col-sm-3 text-muted text-sm-end mb-0 mb-sm-3">Address:</p>
              <p class="col-sm-9 text-3">4th Floor, Plot No.22, Above Public Park, 145 Murphy Canyon Rd,  Suite 100-18,<br>
                San Ditego,<br>
                California - 22434,<br>
                United States.</p>
            </div>-->
          </div>
          <!-- Edit Details Modal
          ================================== -->
          <div id="edit-personal-details" class="modal fade " role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title fw-400">Personal Details</h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body p-4">
                  <form id="personaldetails" method="post">
                    <div class="row g-3">
                      <div class="col-12 col-sm-6">
                        <label for="firstName" class="form-label">First Name</label>
                        <input type="text" class="form-control" data-bv-field="firstName" value="<?php echo $user['first_name']; ?>" id="firstName" required="" placeholder="First Name">
                      </div>
                      <div class="col-12 col-sm-6">
                        <label for="lastName" class="form-label">Last Name</label>
                        <input type="text" class="form-control" data-bv-field="lastName" value="<?php echo $user['last_name']; ?>" id="lastName" required="" placeholder="Last Name">
                      </div>
                      <div class="col-12">
                        <label for="birthDate" class="form-label">Date of Birth</label>
                        <div class="position-relative">
                          <input id="birthDate" value="<?php if(!empty($user['dob'])){ echo date("m-d-Y", strtotime($user['dob'])); }else{ echo date("m-d-Y", time()); } ?>" type="text" class="form-control" required="" placeholder="Date of Birth">
                          <span class="icon-inside"><i class="fas fa-calendar-alt"></i></span>
						</div>
                      </div>
					  </div>
					  
                      <h3 class="text-5 fw-400 mt-4">Address</h3>
                      <hr>
                      <div class="row g-3">
					  <div class="col-12">
                        <label for="address" class="form-label">Address</label>
                        <input type="text" value="4th Floor, Plot No.22, Above Public Park" class="form-control" data-bv-field="address" id="address" required="" placeholder="Address 1">
                      </div>
					  <div class="col-12 col-sm-6">
                          <label for="inputCountry" class="form-label">Country</label>
                          <select class="form-select" id="inputCountry" name="country_id">
                            <option value=""> --- Please Select --- </option>
                            <option value="244">Aaland Islands</option>
                            <option value="1">Afghanistan</option>
                            <option value="239">Zimbabwe</option>
                          </select>
                      </div>
					  <div class="col-12 col-sm-6">
                          <label for="input-zone" class="form-label">State</label>
                          <select class="form-select" id="input-zone" name="zone_id">
                            <option value=""> --- Please Select --- </option>
                            <option value="3613">Alabama</option>
                            <option value="3673">Virginia</option>
                            <option value="3674">Washington</option>
                            <option value="3675">West Virginia</option>
                            <option value="3676">Wisconsin</option>
                            <option value="3677">Wyoming</option>
                          </select>
                      </div>
                      <div class="col-12 col-sm-6">
                          <label for="city" class="form-label">City</label>
                          <input id="city" value="San Ditego" type="text" class="form-control" required="" placeholder="City">
                      </div>
                      
                      <div class="col-12 col-sm-6">
                        <label for="zipCode" class="form-label">Zip Code</label>
                        <input id="zipCode" value="22434" type="text" class="form-control" required="" placeholder="City">
                      </div>
                      
					  <div class="col-12 mt-4 d-grid"><button class="btn btn-primary" id="updateProfile" type="button">Save Changes</button></div>
                    </div>
                    
                  </form>
                </div>
              </div>
            </div>
          </div>
          <!-- Personal Details End --> 
          
          <!-- Account Settings
          ============================================= -->
          <div class="bg-white shadow-sm rounded p-4 mb-4">
            <h3 class="text-5 fw-400 d-flex align-items-center mb-4">Account Settings<a href="#edit-account-settings" data-bs-toggle="modal" class="ms-auto text-2 text-uppercase btn-link"><span class="me-1"><i class="fas fa-edit"></i></span>Edit</a></h3>
            <hr class="mx-n4 mb-4">
            <div class="row gx-3 align-items-center">
              <p class="col-sm-3 text-muted text-sm-end mb-0 mb-sm-3">Language:</p>
              <p class="col-sm-9 text-3">English (United States)</p>
            </div>
            <div class="row gx-3 align-items-center">
              <p class="col-sm-3 text-muted text-sm-end mb-0 mb-sm-3">Time Zone:</p>
              <p class="col-sm-9 text-3">(GMT-06:00) Central America</p>
            </div>
            <div class="row gx-3 align-items-center">
              <p class="col-sm-3 text-muted text-sm-end mb-0 mb-sm-3">Account Status:</p>
              <p class="col-sm-9 text-3"><span class="bg-success text-white rounded-pill d-inline-block px-2 mb-0"><i class="fas fa-check-circle"></i> Active</span></p>
            </div>
          </div>
          <!-- Edit Details Modal
          ================================== -->
          <div id="edit-account-settings" class="modal fade " role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title fw-400">Account Settings</h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body p-4">
                  <form id="accountSettings" method="post">
                    <div class="row g-3">
                      <div class="col-12">
                        <label for="language" class="form-label">Language</label>
                        <select class="form-select" id="language" name="language_id">
                          <option value="1">English (United States)</option>
                          <option value="2">Spanish </option>
                          <option value="3">Chinese</option>
                          <option value="4">Russian</option>
                        </select>
                      </div>
                      <div class="col-12">
                          <label for="input-timezone" class="form-label">Time Zone</label>
                          <select class="form-select" id="input-timezone" name="timezone_id">
                            <option value="-12">(GMT-12:00) International Date Line West</option>
                            <option value="-11">(GMT-11:00) Midway Island, 
                            <option value="13">(GMT+13:00) Nuku'alofa</option>
                          </select>
                      </div>
                      <div class="col-12">
                          <label for="accountStatus" class="form-label">Account Status</label>
                          <select class="form-select" id="accountStatus" name="language_id">
                            <option value="1">Active</option>
                            <option value="2">In Active</option>
                          </select>
                      </div>
					  <div class="col-12 d-grid mt-4">
						<button class="btn btn-primary" type="submit">Save Changes</button>
					  </div>
                    </div>
                  </form>
                </div>
              </div>
            </div>
          </div>
          <!-- Account Settings End --> 
          
          <!-- Email Addresses
          ============================================= -->
          <div class="bg-white shadow-sm rounded p-4 mb-4">
            <h3 class="text-5 fw-400 d-flex align-items-center mb-4">Email Addresses<a href="#edit-email" data-bs-toggle="modal" class="ms-auto text-2 text-uppercase btn-link"><span class="me-1"><i class="fas fa-edit"></i></span>Edit</a></h3>
            <hr class="mx-n4 mb-4">
            <div class="row gx-3 align-items-center">
              <p class="col-sm-3 text-muted text-sm-end mb-0 mb-sm-3">Email ID:</p>
              <p class="col-sm-9 text-3 d-sm-inline-flex d-md-flex align-items-center"><?php echo $user['email']; ?><span class="badge bg-info text-1 fw-500 rounded-pill px-2 py-1 ms-2">Primary</span></p>
            </div>
            <div class="row gx-3 align-items-center">
              <p class="col-sm-3 text-muted text-sm-end mb-0 mb-sm-3">Email ID:</p>
              <p class="col-sm-9 text-3"></p>
            </div>
          </div>
          <!-- Edit Details Modal
          ================================== -->
          <div id="edit-email" class="modal fade" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title fw-400">Email Addresses</h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body p-4">
                  <form id="emailAddresses" method="post">
                    <div class="mb-3">
                      <label for="emailID" class="form-label d-inline-flex align-items-center">Email ID <span class="badge bg-info text-1 fw-500 rounded-pill px-2 py-1 ms-2">Primary</span></label>
                      <input type="text" value="<?php echo $user['email']; ?>" class="form-control" data-bv-field="emailid" id="emailID" required="" placeholder="Email ID">
                    </div>
                    <div class="mb-3" class="form-label">
                      <label for="emailID2" class="form-label">Email ID 2 - <a class="btn-link text-uppercase text-1" href="#">Make Primary</a></label>
                      <div class="input-group">
                        <input type="text" value="smith.rhodes@outlook.com" class="form-control" data-bv-field="emailid2" id="emailID2" required="" placeholder="Email ID">
                        <a href="" data-bs-toggle="tooltip" title="Remove" class="input-group-text text-muted text-2"><i class="fas fa-times"></i></a>
                      </div>
                    </div>
                    <a class="btn-link text-uppercase d-flex align-items-center text-1 float-end mb-3" href="#"><span class="text-3 me-1"><i class="fas fa-plus-circle"></i></span>Add another email</a>
                    <div class="d-grid w-100"><button class="btn btn-primary" type="submit">Save Changes</button></div>
                  </form>
                </div>
              </div>
            </div>
          </div>
          <!-- Email Addresses End --> 
          
          <!-- Phone
          ============================================= -->
          <div class="bg-white shadow-sm rounded p-4 mb-4">
            <h3 class="text-5 fw-400 d-flex align-items-center mb-4">Phone<a href="#edit-phone" data-bs-toggle="modal" class="ms-auto text-2 text-uppercase btn-link"><span class="me-1"><i class="fas fa-edit"></i></span>Edit</a></h3>
            <hr class="mx-n4 mb-4">
            <div class="row gx-3 align-items-center">
              <p class="col-sm-3 text-muted text-sm-end mb-0 mb-sm-3">Mobile:</p>
              <p class="col-sm-9 text-3 align-items-center d-sm-inline-flex d-md-flex"><span class="badge bg-info text-1 fw-500 rounded-pill px-2 py-1 ms-2">Primary</span></p>
            </div>
            <div class="row gx-3 align-items-center">
              <p class="col-sm-3 text-muted text-sm-end mb-0 mb-sm-3">Mobile:</p>
              <p class="col-sm-9 text-3"></p>
            </div>
          </div>
          <!-- Edit Details Modal
          ================================== -->
          <div id="edit-phone" class="modal fade " role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title fw-400">Phone</h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body p-4">
                  <form id="phone" method="post">
                    <div class="mb-3">
                      <label for="mobileNumber" class="form-label d-inline-flex align-items-center">Mobile <span class="badge bg-info text-1 fw-500 rounded-pill px-2 py-1 ms-2">Primary</span></label>
                      <div class="input-group">
                          <div class="input-group-text p-0">
						  <select class="form-select border-0 bg-transparent" id="selectedCountry" name="selectedCountry">
                            <option value="AD,376">AD +376</option>
                            <option value="AE,971">AE +971</option>
                            <option value="AF,93">AF +93</option>
                          </select>
                        </div>
						<input type="text" value="2025550125" class="form-control" data-bv-field="mobilenumber" id="mobileNumber" required="" placeholder="Mobile Number">
                      </div>
                    </div>
                    <div class="mb-3">
                      <label for="mobileNumber2" class="form-label">Mobile 2 - <a class="btn-link text-uppercase text-1" href="#">Make Primary</a></label>
                      <div class="input-group">
                        <div class="input-group-text p-0">
                          <select class="form-select border-0 bg-transparent" id="selectedCountry" name="selectedCountry">
                            <option value="AD,376">AD +376</option>
                            <option value="AE,971">AE +971</option>
                            <option value="AF,93">AF +93</option>
                          </select>
                        </div>
                        <input type="text" value="3036660512" class="form-control" data-bv-field="mobilenumber2" id="mobileNumber2" required="" placeholder="Mobile Number">
                        <a href="" data-bs-toggle="tooltip" title="Remove" class="input-group-text text-2"><i class="fas fa-times"></i></a>
                      </div>
                    </div>
                    <a class="btn-link text-uppercase d-flex align-items-center text-1 float-end mb-3" href="#"><span class="text-3 me-1"><i class="fas fa-plus-circle"></i></span>Add another Phone</a>
                    <div class="d-grid w-100"><button class="btn btn-primary" type="submit">Save Changes</button></div>
                  </form>
                </div>
              </div>
            </div>
          </div>
          <!-- Phone End --> 
          
        </div>
        <!-- Middle Panel End --> 
      </div>
    </div>
  </div>
  <!-- Content end --> 
<?php include_once('myaccount/footer.php'); ?>
