﻿<?php
	$title = 'Security Setting';
?>
<?php include_once('myaccount/header.php'); ?>
  
  <!-- Content
  ============================================= -->
  <div id="content" class="py-4">
    <div class="container-fluid">
      <div class="row"> 
        <!-- Left Panel
        ============================================= -->
        <?php include_once('mainpage/sidebar.php'); ?>
        <!-- Left Panel End --> 
        
        <!-- Middle Panel
        ============================================= -->
        <div class="col-lg-9"> 
          
          <!-- Password
          ============================================= -->
          <div class="bg-white shadow-sm rounded p-4 mb-4">
            <h3 class="text-5 fw-400 d-flex align-items-center mb-4">Password<a href="#change-password" data-bs-toggle="modal" class="ms-auto text-2 text-uppercase btn-link"><span class="me-1"><i class="fas fa-edit"></i></span>Change</a></h3>
            <hr class="mx-n4 mb-4">
            <p class="text-3">Create or update your password. - <span class="text-muted">Last changed: <b id="passwordLastUpdate"></b></span></p>
          </div>
          <!-- Edit Details Modal
          ================================== -->
          <div id="change-password" class="modal fade " role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title fw-400">Change Password</h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body p-4">
                  <form id="changePassword" method="post">
                    <div class="mb-3">
                      <label for="existingPassword" class="form-label">Confirm Current Password</label>
                      <input type="password" class="form-control" data-bv-field="existingpassword" id="existingPassword" required="" placeholder="Enter Current Password">
                    </div>
                    <div class="mb-3">
                      <label for="newPassword" class="form-label">New Password</label>
                      <input type="password" class="form-control" data-bv-field="newpassword" id="newPassword" required="" placeholder="Enter New Password">
                    </div>
                    <div class="mb-3">
                      <label for="confirmPassword" class="form-label">Confirm New Password</label>
                      <input type="password" class="form-control" data-bv-field="confirmgpassword" id="confirmPassword" required="" placeholder="Enter Confirm New Password">
                    </div>
                    <div class="d-grid mt-4"><button class="btn btn-primary" id="updatePassword" type="button">Change Password</button></div>
					<div class="form-check mb-3" id="errorMsg">
					  
					</div>
                  </form>
                </div>
              </div>
            </div>
          </div>
          <!-- Password End --> 
          
          <!-- Security Questions
          ============================================= -->
          <div class="bg-white shadow-sm rounded p-4 mb-4">
            <h3 class="text-5 fw-400 d-flex align-items-center mb-4">Security Questions<a href="#change-security-questions" data-bs-toggle="modal" class="ms-auto text-2 text-uppercase btn-link"><span class="me-1"><i class="fas fa-edit"></i></span>Change</a></h3>
            <hr class="mx-n4 mb-4">
            <p class="text-3">For your protection, please choose 3 security questions. This way, we can verify it’s really you if there’s ever a doubt.</p>
          </div>
          <!-- Edit Details Modal
          ================================== -->
          <div id="change-security-questions" class="modal fade " role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title fw-400">Security Questions</h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body p-4">
                  <p class="text-3 mb-4">We'll use these questions as a way to make sure it's you trying to access your account in critical operations</p>
                  <form id="changeQuestions" method="post">
                    <div class="mb-2">
                      <label for="question1" class="form-label">Security Question 1</label>
                      <select class="form-select" id="question1" name="question1">
                        <?php
							$queryQuestions = mysqli_query($db_conn, "SELECT * FROM tbl_questions WHERE status=1 ORDER BY RAND() LIMIT 10");
							if(mysqli_num_rows($queryQuestions)>0){
								echo '<option value="">Select Security Question</option>';
								while($question = mysqli_fetch_assoc($queryQuestions)){
									echo '<option value="'.$question['question'].'">'.$question['question'].'</option>';
								}
							}
							else{
								echo '<option value="">Questions not available</option>';
							}
						?>
                      </select>
                    </div>
					
                    <div class="mb-4" id="ans1" style="display: none;">
                      <input type="text" class="form-control" data-bv-field="answers1" id="answers1" placeholder="Answer">
                    </div>
					<div id="set2" style="display: none;">
						<div class="mb-2">
						  <label for="question2" class="form-label">Security Question 2</label>
						  <select class="form-select" id="question2">
							<option value="">Select Security Question 1 first</option>
						  </select>
						</div>
						<div class="mb-4" id="ans2" style="display: none;">
						  <input type="text" class="form-control" data-bv-field="answers2" id="answers2" placeholder="Answer">
						</div>
					</div>
					<div id="set3" style="display: none;">
						<div class="mb-2">
						  <label for="question3" class="form-label">Security Question 3</label>
						  <select class="form-select" id="question3">
							<option value="">Select Security Question 2 First</option>
						  </select>
						</div>
						<div class="mb-4" id="ans3" style="display: none;">
						  <input type="text" class="form-control" data-bv-field="answers3" id="answers3" placeholder="Answer">
						</div>
					</div>
                    <div id="btnSet" style="display: none;"><div class="d-grid"><button class="btn btn-primary" type="button" id="securityQuestionBtn">Save Changes</button></div></div>
					<div class="form-check mb-3" id="errorMsgQuestions">
					  
					</div>
                  </form>
                </div>
              </div>
            </div>
          </div>
          <!-- Security Questions End --> 
          
          <!-- 2-Step Verification
          ============================================= ->
          <div class="bg-white shadow-sm rounded p-4 mb-4">
            <h3 class="text-5 fw-400 d-flex align-items-center mb-4">2-Step Verification<a href="#two-step-verification" data-bs-toggle="modal" class="ms-auto text-2 text-uppercase btn-link"><span class="me-1"><i class="fas fa-tools"></i></span>SetUp</a></h3>
            <hr class="mx-n4 mb-4">
            <p class="text-3">Add an extra layer of security to your account by using a one-time security code in addition to your password each time you log in.</p>
          </div>
          <!-- Edit Details Modal
          ================================== ->
          <div id="two-step-verification" class="modal fade " role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title fw-400">2-Step Verification</h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body p-4 text-center">
                  <p class="lead">Protect your account with 2-step verification</p>
                  <h3 class="text-5 mb-3">Where should we send your one-time code?</h3>
                  <p class="lh-base">Let’s set up the mobile number where you’ll receive your codes for 2-step verification.</p>
                  <form id="changePassword" method="post">
                    <div class="mb-3">
                      <div class="input-group">
                        <div class="input-group-text p-0">
                          <select class="form-select border-0 bg-transparent" id="selectedCountry" name="selectedCountry">
                            <option value="AD,376">AD +376</option>
                            <option value="AE,971">AE +971</option>
                            <option value="ZW,263">ZW +263</option>
                          </select>
                        </div>
                        <input type="text" value="2025550125" class="form-control" data-bv-field="mobilenumber" id="mobileNumber" required="" placeholder="Mobile Number">
                      </div>
                    </div>
                    <div class="d-grid mt-4"><button class="btn btn-primary" type="submit">Next</button></div>
                  </form>
                  <p class="text-muted mt-3 mb-0">By continuing, you confirm that you are authorized to use this phone number and agree to receive text messages.</p>
                </div>
              </div>
            </div>
          </div>
          <!-- 2-Step Verification End --> 
          
        </div>
        <!-- Middle Panel End --> 
      </div>
    </div>
  </div>
  <!-- Content end --> 
 <?php include_once('myaccount/footer.php'); ?>