﻿<?php
	$title = 'Withdrawal';
	
	if(isset($_POST['startOver'])){
		unset($_SESSION['account_details']);
		unset($_SESSION['address']);
		unset($_SESSION['amount']);
		unset($_SESSION['total_withdrawal']);
		unset($_SESSION['transaction_fee']);
		unset($_SESSION['body']);
		
		header("location: ./");
	}
?>
<?php include_once('myaccount/header.php'); ?>
  
  <!-- Content
  ============================================= -->
  <div id="content" class="py-4">
    <div class="container" id="withdrawalPanel"> 
      <?php if(empty($_SESSION['body'])){ ?>
      <!-- Steps Progress bar -->
      <div class="row mt-4 mb-5">
        <div class="col-lg-11 mx-auto">
          <div class="row widget-steps">
            <div class="col-4 step active">
              <div class="step-name">Details</div>
              <div class="progress">
                <div class="progress-bar"></div>
              </div>
              <a href="#" class="step-dot"></a> </div>
            <div class="col-4 step disabled">
              <div class="step-name">Confirm</div>
              <div class="progress">
                <div class="progress-bar"></div>
              </div>
              <a href="#" class="step-dot"></a> </div>
            <div class="col-4 step disabled">
              <div class="step-name">Success</div>
              <div class="progress">
                <div class="progress-bar"></div>
              </div>
              <a href="#" class="step-dot"></a> </div>
          </div>
        </div>
      </div>
      <h2 class="fw-400 text-center mt-3 mb-4">Withdrawal</h2>
      <div class="row">
        <div class="col-md-9 col-lg-7 col-xl-6 mx-auto"> 
          <!-- Withdraw Money Form
        ============================================= -->
          <div class="bg-white shadow-sm rounded p-3 pt-sm-5 pb-sm-5 px-sm-5 mb-4">
            <div class="text-center bg-primary p-4 rounded mb-4">
              <h3 class="text-10 text-white fw-400" id="availableBalance"></h3>
              <p class="text-white">Available Balance</p>
              <button type="button" class="btn btn-outline-light btn-sm shadow-none text-uppercase rounded-pill text-1" id="withdrawAll">Withdraw All</button> </div>
            <form id="form-send-money" method="post">
              <div class="mb-3">
                <label for="withdrawto" class="form-label">Withdraw to</label>
                <select id="withdrawto" class="form-select" required="">
				<?php
					$queryAccounts = mysqli_query($db_conn, "SELECT * FROM tbl_withdrawal_address WHERE user_id='$myId' AND status=1 ORDER BY type DESC");
					if(mysqli_num_rows($queryAccounts)>0){
						while($account=mysqli_fetch_assoc($queryAccounts)){
							if($account['type']=='Crypto Address'){
								$walletAddress = $account['address'];
								$walletAddress = substr(0, -1, 6);
								$network = $account['network'];
								$id = $account['id'];
								$accountNumber = $account['address'];
								$accountNumber = substr($accountNumber, 0, 7).'xxxxxxxx'.substr($accountNumber, -7, 7);
								
								echo '<option value="'.$id.'">USDT - '.$accountNumber.' - '.$network.'</option>';
							}
							else{
								$accountNumber = $account['address'];
								$accountNumber = $account['address'];
								$accountNumber = substr($accountNumber, 0, 3).'xxxx'.substr($accountNumber, -3, 3);
								$bankName = $account['network'];
								$id = $account['id'];
								
								echo '<option value="'.$id.'">'.$bankName.' - '.$accountNumber.' - NGN</option>';
							}
						}
					}
					else{
						echo '<option value="">No Account Added</option>';
						$addAccount = '<label class="form-label float-end">
							<b><a href="javascript:void();" onclick="location.href=\'./?session=settings-payment-methods\';">
								Add Withdrawal Address</a>
							</b></label>';
					}
				?>
                </select>
				
				<?php echo $addAccount; ?>
              </div>
              <div class="mb-3">
                <label for="withdrawAmount" class="form-label">Amount <span class="text-info ms-1" data-bs-toggle="tooltip" title="Minimum single withdrawal is 25% of Investment Amount"><i class="fas fa-question-circle"></i></span></label>
                <div class="input-group">
                  <span class="input-group-text">$</span>
                  <input type="number" class="form-control" min="5" data-bv-field="withdrawAmount" id="withdrawAmount" placeholder="Enter amount">
                </div>
              </div>
              <hr>
              <p class="text-3 fw-500" id="withdrawValue" style="display: none;">Amount to Withdraw <span class="float-end" id="amountCheck"></span></p>
              <div class="d-grid"><button class="btn btn-primary" type="button" id="withdrawBtn">Continue</button></div>
			  
			  <div class="form-check mb-3" id="msgBox"></div>	
			</form>
          </div>
        </div>
      </div>
	  <?php 
		}else{ 
			echo $_SESSION['body'];
		} 
	  ?>
    </div>
	
	
  </div>
  <!-- Content end --> 
<?php include_once('myaccount/footer.php'); ?>