$(document).ready(function(){
	function validateEmail(email) {
		const re = '/^[^\s@]+@[^\s@]+\.[^\s@]+$/';
		return re.test(String(email).toLowerCase());
	}
	/* function isValidPhoneNumber(phoneNumber) {
		// Define the regex pattern for a valid Nigerian phone number.
		// This pattern matches phone numbers in the formats: 08168290811, 2348168290811, +2348168290811.
		const pattern = /^(?:\+?234|0)?(7\d|8\d|9\d)\d{8}$/;
		
		// Test the phone number against the regex pattern.
		return pattern.test(phoneNumber);
	} */
	
	function isValidPhoneNumber(phoneNumber) {
		// Define the regex pattern for a global E.164 phone number format
		const globalPattern = /^\+?[1-9]\d{1,14}$/;

		// Test if the phone number matches the global E.164 pattern
		return globalPattern.test(phoneNumber);
	}

	
	let currentPage = $("#currentPage").val();
	let mainPage = $("#mainPage").val();
	let page = $("#page").val();
	let mypage = $("#mypage").val();
	let usertype = $("#user-type").val();
	let returnUrl = $("#returnUrl").val();
	let nairaSign = $("#nairaSign").val();
	
	var userType = $("#userType").val();
	
	var $wrapper=$('.main-wrapper');
	var $slimScrolls=$('.slimscroll');
	var $pageWrapper=$('.page-wrapper');
	feather.replace();
	$(window).resize(function(){
		if($('.page-wrapper').length>0){
			var height=$(window).height();
			$(".page-wrapper").css("min-height",height);
		}
	});
	$('body').append('<div class="sidebar-overlay"></div>');
	$(document).on('click','#mobile_btn',function(){
		$wrapper.toggleClass('slide-nav');
		$('.sidebar-overlay').toggleClass('opened');
		$('html').addClass('menu-opened');
		$('#task_window').removeClass('opened');
		return false;
	});
	$(".sidebar-overlay").on("click",function(){
		$('html').removeClass('menu-opened');
		$(this).removeClass('opened');
		$wrapper.removeClass('slide-nav');
		$('.sidebar-overlay').removeClass('opened');
		$('#task_window').removeClass('opened');
	});
	$(document).on("click",".hideset",function(){
		$(this).parent().parent().parent().hide();
	});
	$(document).on("click",".delete-set",function(){
		$(this).parent().parent().hide();
	});
	if($('.product-slide').length>0){
		$('.product-slide').owlCarousel({
			items:1,
			margin:30,
			dots:false,
			nav:true,
			loop:false,
			responsiveClass:true,
			responsive:{
				0:{items:1},
				800:{items:1},
				1170:{items:1}
			}
		});
	}
	if($('.owl-product').length>0){
		var owl=$('.owl-product');
		owl.owlCarousel({
			margin:10,
			dots:false,
			nav:true,
			loop:false,
			touchDrag:false,
			mouseDrag:false,
			responsive:{
				0:{items:2},
				768:{items:4},
				1170:{items:8}
			}
		});
	}
	if($('.datanew').length>0){
		$('.datanew').DataTable({
			"bFilter":true,
			"sDom":'fBtlpi',
			'pagingType':'numbers',
			"ordering":true,
			"language":{
				search:' ',
				sLengthMenu:'_MENU_',
				searchPlaceholder:"Search...",
				info:"_START_ - _END_ of _TOTAL_ items",
			},
			initComplete:(settings,json)=>{
				$('.dataTables_filter').appendTo('#tableSearch');
				$('.dataTables_filter').appendTo('.search-input');
			},
		});
	}
	function readURL(input){
		if(input.files&&input.files[0]){
			var reader=new FileReader();
			reader.onload=function(e){
				$('#userImage4').attr('src',e.target.result);
			}
			reader.readAsDataURL(input.files[0]);
		}
	}
	$("#imgInp").change(function(){
		readURL(this);
	});
	if($('.datatable').length>0){
		$('.datatable').DataTable({"bFilter":false});
	}
	setTimeout(function(){
		$('#global-loader');
		setTimeout(function(){
			$("#global-loader").fadeOut("slow");
		},100);
	},500);
	if($('.datetimepicker').length>0){
		$('.datetimepicker').datetimepicker({
			format:'DD-MM-YYYY',
			icons:{
				up:"fas fa-angle-up",
				down:"fas fa-angle-down",
				next:'fas fa-angle-right',
				previous:'fas fa-angle-left'
			}
		});
	}
	if($('.toggle-password').length>0){
		$(document).on('click','.toggle-password',function(){
			$(this).toggleClass("fa-eye fa-eye-slash");
			var input=$(".pass-input");
			if(input.attr("type")=="password"){
				input.attr("type","text");
			}
			else{
				input.attr("type","password");
			}
		});
	}
	if($('.toggle-passwords').length>0){
		$(document).on('click','.toggle-passwords',function(){
			$(this).toggleClass("fa-eye fa-eye-slash");
			var input=$(".pass-inputs");
			if(input.attr("type")=="password"){
				input.attr("type","text");
			}else{
				input.attr("type","password");
			}
		});
	}
	if($('.toggle-passworda').length>0){
		$(document).on('click','.toggle-passworda',function(){
			$(this).toggleClass("fa-eye fa-eye-slash");
			var input=$(".pass-inputs");
			if(input.attr("type")=="password"){
				input.attr("type","text");
			}else{
				input.attr("type","password");
			}
		});
	}
	if($('.select').length>0){$('.select').select2({minimumResultsForSearch:-1,width:'100%'});}
	if($('.counter').length>0){$('.counter').counterUp({delay:20,time:2000});}
	if($('#timer-countdown').length>0){$('#timer-countdown').countdown({from:180,to:0,movingUnit:1000,timerEnd:undefined,outputPattern:'$day Day $hour : $minute : $second',autostart:true});}
	if($('#timer-countup').length>0){$('#timer-countup').countdown({from:0,to:180});}
	if($('#timer-countinbetween').length>0){$('#timer-countinbetween').countdown({from:30,to:20});}
	if($('#timer-countercallback').length>0){$('#timer-countercallback').countdown({from:10,to:0,timerEnd:function(){this.css({'text-decoration':'line-through'}).animate({'opacity':.5},500);}});}
	if($('#timer-outputpattern').length>0){$('#timer-outputpattern').countdown({outputPattern:'$day Days $hour Hour $minute Min $second Sec..',from:60*60*24*3});}
	if($('#summernote').length>0){$('#summernote').summernote({height:300,minHeight:null,maxHeight:null,focus:true});}
	if($slimScrolls.length>0){
		$slimScrolls.slimScroll({
			height:'auto',
			width:'100%',
			position:'right',
			size:'7px',
			color:'#ccc',
			wheelStep:10,
			touchScrollStep:100
		});
		var wHeight=$(window).height()-60;
		$slimScrolls.height(wHeight);
		$('.sidebar .slimScrollDiv').height(wHeight);
		$(window).resize(function(){
			var rHeight=$(window).height()-60;
			$slimScrolls.height(rHeight);
			$('.sidebar .slimScrollDiv').height(rHeight);
		});
	}
	var Sidemenu=function(){
		this.$menuItem=$('#sidebar-menu a');
	};
	function init(){
		var $this=Sidemenu;
		$('#sidebar-menu a').on('click',function(e){
			if($(this).parent().hasClass('submenu')){
				e.preventDefault();
			}
			if(!$(this).hasClass('subdrop')){
				$('ul',$(this).parents('ul:first')).slideUp(250);
				$('a',$(this).parents('ul:first')).removeClass('subdrop');
				$(this).next('ul').slideDown(350);
				$(this).addClass('subdrop');
			}else if($(this).hasClass('subdrop')){
				$(this).removeClass('subdrop');
				$(this).next('ul').slideUp(350);
			}
		});
		$('#sidebar-menu ul li.submenu a.active').parents('li:last').children('a:first').addClass('active').trigger('click');
	}
	init();
	$(document).on('mouseover',function(e){
		e.stopPropagation();
		if($('body').hasClass('mini-sidebar')&&$('#toggle_btn').is(':visible')){
			var targ=$(e.target).closest('.sidebar, .header-left').length;
			if(targ){
				$('body').addClass('expand-menu');
				$('.subdrop + ul').slideDown();
			}else{
				$('body').removeClass('expand-menu');
				$('.subdrop + ul').slideUp();
			}
			return false;
		}
	});
	$(document).on('click','#toggle_btn',function(){
		if($('body').hasClass('mini-sidebar')){
			$('body').removeClass('mini-sidebar');
			$(this).addClass('active');
			$('.subdrop + ul').slideDown();
			localStorage.setItem('screenModeNightTokenState','night');
			setTimeout(function(){
				$("body").removeClass("mini-sidebar");
				$(".header-left").addClass("active");
			},100);
		}else{
			$('body').addClass('mini-sidebar');
			$(this).removeClass('active');
			$('.subdrop + ul').slideUp();
			localStorage.removeItem('screenModeNightTokenState','night');
			setTimeout(function(){
				$("body").addClass("mini-sidebar");
				$(".header-left").removeClass("active");
			},100);
		}
		return false;
	});
	if(localStorage.getItem('screenModeNightTokenState')=='night'){
		setTimeout(function(){
			$("body").removeClass("mini-sidebar");
			$(".header-left").addClass("active");
		},100);
	}
	$('.submenus').on('click',function(){
		$('body').addClass('sidebarrightmenu');
	});
	$('#searchdiv').on('click',function(){
		$('.searchinputs').addClass('show');
	});
	$('.search-addon span').on('click',function(){
		$('.searchinputs').removeClass('show');
	});
	$(document).on('click','#filter_search',function(){
		$('#filter_inputs').slideToggle("slow");
	});
	$(document).on('click','#filter_search1',function(){
		$('#filter_inputs1').slideToggle("slow");
	});
	$(document).on('click','#filter_search2',function(){
		$('#filter_inputs2').slideToggle("slow");
	});
	$(document).on('click','#filter_search',function(){
		$('#filter_search').toggleClass("setclose");
	});
	$(document).on("click",".productset",function(){
		$(this).toggleClass("active");
	});
	$('.inc.button').click(function(){
		var $this=$(this),
		$input=$this.prev('input'),
		$parent=$input.closest('div'),
		newValue=parseInt($input.val())+1;
		$parent.find('.inc').addClass('a'+newValue);
		$input.val(newValue);
		newValue+=newValue;
	});
	$('.dec.button').click(function(){
		var $this=$(this),$input=$this.next('input'),
		$parent=$input.closest('div'),
		newValue=parseInt($input.val())-1;
		console.log($parent);
		$parent.find('.inc').addClass('a'+newValue);
		$input.val(newValue);
		newValue+=newValue;
	});
	if($('.custom-file-container').length>0){
		var firstUpload=new FileUploadWithPreview('myFirstImage')
		var secondUpload=new FileUploadWithPreview('mySecondImage')
	}
	$('.counters').each(function(){var $this=$(this),countTo=$this.attr('data-count');$({countNum:$this.text()}).animate({countNum:countTo},{duration:2000,easing:'linear',step:function(){$this.text(Math.floor(this.countNum));},complete:function(){$this.text(this.countNum);}});});if($('.toggle-password').length>0){$(document).on('click','.toggle-password',function(){$(this).toggleClass("fa-eye fa-eye");var input=$(".pass-input");if(input.attr("type")=="text"){input.attr("type","text");}else{input.attr("type","password");}});}
	if($('.win-maximize').length>0){$('.win-maximize').on('click',function(e){if(!document.fullscreenElement){document.documentElement.requestFullscreen();}else{if(document.exitFullscreen){document.exitFullscreen();}}})}
	$(document).on('click','#check_all',function(){$('.checkmail').click();return false;});if($('.checkmail').length>0){$('.checkmail').each(function(){$(this).on('click',function(){if($(this).closest('tr').hasClass('checked')){$(this).closest('tr').removeClass('checked');}else{$(this).closest('tr').addClass('checked');}});});}
	if($('.popover-list').length>0){var popoverTriggerList=[].slice.call(document.querySelectorAll('[data-bs-toggle="popover"]'))
	var popoverList=popoverTriggerList.map(function(popoverTriggerEl){return new bootstrap.Popover(popoverTriggerEl)})}
	if($('.clipboard').length>0){var clipboard=new Clipboard('.btn');}
	var chatAppTarget=$('.chat-window');(function(){if($(window).width()>991)
	chatAppTarget.removeClass('chat-slide');$(document).on("click",".chat-window .chat-users-list a.media",function(){if($(window).width()<=991){chatAppTarget.addClass('chat-slide');}
	return false;});$(document).on("click","#back_user_list",function(){if($(window).width()<=991){chatAppTarget.removeClass('chat-slide');}
	return false;});})();$(document).on('click','.mail-important',function(){$(this).find('i.fa').toggleClass('fa-star').toggleClass('fa-star-o');});
	var selectAllItems = "#select-all";
	var checkboxItem = ":checkbox";
	$(selectAllItems).click(function(){
		if(this.checked){
			$(checkboxItem).each(function(){
				this.checked=true;
			});
		}else{
			$(checkboxItem).each(function(){
				this.checked=false;
			});
		}
	});
	
	if($('[data-bs-toggle="tooltip"]').length>0){var tooltipTriggerList=[].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
	var tooltipList=tooltipTriggerList.map(function(tooltipTriggerEl){return new bootstrap.Tooltip(tooltipTriggerEl)})}
	var right_side_views='<div class="right-side-views d-none">'+
	'<ul class="sticky-sidebar siderbar-view">'+
	'<li class="sidebar-icons">'+
	'<a class="toggle tipinfo open-layout open-siderbar" href="javascript:void(0);" data-toggle="tooltip" data-placement="left" data-bs-original-title="Tooltip on left">'+
	'<div class="tooltip-five ">'+
	'<img src="assets/img/icons/siderbar-icon2.svg" class="feather-five" alt="">'+
	'<span class="tooltiptext">Check Layout</span>'+
	'</div>'+
	'</a>'+
	'</li>'+
	'</ul>'+
	'</div>'+
	'<div class="sidebar-layout">'+
	'<div class="sidebar-content">'+
	'<div class="sidebar-top">'+
	'<div class="container-fluid">'+
	'<div class="row align-items-center">'+
	'<div class="col-xl-6 col-sm-6 col-12">'+
	'<div class="sidebar-logo">'+
	'<a href="index.html" class="logo">'+
	'<img src="assets/img/logo.png" alt="Logo" class="img-flex">'+
	'</a>'+
	'</div>'+
	'</div>'+
	'<div class="col-xl-6 col-sm-6 col-12">'+
	'<a class="btn-closed" href="javascript:void(0);"><img class="img-fliud" src="assets/img/icons/sidebar-delete-icon.svg" alt="demo"></a>'+
	'</div>'+
	'</div>'+
	'</div>'+
	'</div>'+
	'<div class="container-fluid">'+
	'<div class="row align-items-center">'+
	'<h5 class="sidebar-title">Choose layout</h5>'+
	'<div class="col-xl-12 col-sm-6 col-12">'+
	'<div class="sidebar-image align-center">'+
	'<img class="img-fliud" src="assets/img/demo-one.png" alt="demo">'+
	'</div>'+
	'<div class="row">'+
	'<div class="col-lg-6 layout">'+
	'<h5 class="layout-title">Dark Mode</h5>'+
	'</div>'+
	'<div class="col-lg-6 layout dark-mode">'+
	'<label class="toggle-switch" for="notification_switch3">'+
	'<span>'+
	'<input type="checkbox" class="toggle-switch-input" id="notification_switch3">'+
	'<span class="toggle-switch-label ms-auto">'+
	'	<span class="toggle-switch-indicator"></span>'+
	'</span>'+
	'</span>'+
	' </label>'+
	'</div>'+
	'</div>'+
	'</div>'+
	'</div>'+
	'</div>'+
	'</div>'+
	'</div>'+
	$("body").append(right_side_views);$('.open-layout').on("click",function(s){s.preventDefault();$('.sidebar-layout').addClass('show-layout');$('.sidebar-settings').removeClass('show-settings');});$('.btn-closed').on("click",function(s){s.preventDefault();$('.sidebar-layout').removeClass('show-layout');});$('.open-settings').on("click",function(s){s.preventDefault();$('.sidebar-settings').addClass('show-settings');$('.sidebar-layout').removeClass('show-layout');});$('.btn-closed').on("click",function(s){s.preventDefault();$('.sidebar-settings').removeClass('show-settings');});$('.open-siderbar').on("click",function(s){s.preventDefault();$('.siderbar-view').addClass('show-sidebar');});$('.btn-closed').on("click",function(s){s.preventDefault();$('.siderbar-view').removeClass('show-sidebar');});if($('.toggle-switch').length>0){const toggleSwitch=document.querySelector('.toggle-switch input[type="checkbox"]');const currentTheme=localStorage.getItem('theme');var app=document.getElementsByTagName("BODY")[0];if(currentTheme){app.setAttribute('data-theme',currentTheme);if(currentTheme==='dark'){toggleSwitch.checked=true;}}
	function switchTheme(e){if(e.target.checked){app.setAttribute('data-theme','dark');localStorage.setItem('theme','dark');}
	else{app.setAttribute('data-theme','light');localStorage.setItem('theme','light');}}
	toggleSwitch.addEventListener('change',switchTheme,false);}
	if(window.location.hash=="#LightMode"){localStorage.setItem('theme','dark');}
	else{if(window.location.hash=="#DarkMode"){localStorage.setItem('theme','light');}}
	$('ul.tabs li').click(function(){var $this=$(this);var $theTab=$(this).attr('id');console.log($theTab);if($this.hasClass('active')){}else{$this.closest('.tabs_wrapper').find('ul.tabs li, .tabs_container .tab_content').removeClass('active');$('.tabs_container .tab_content[data-tab="'+$theTab+'"], ul.tabs li[id="'+$theTab+'"]').addClass('active');}});
	
	$(".delete-user").on("click", function () {
		let userId = $(this).attr('data-id');
		let delName = $(this).attr('name');
		
		Swal.fire({
			title: "Delete " + delName,
			html: "This user will be deleted from the system. <br>You won't be able to revert this!",
			icon: "warning",
			showCancelButton: true,
			confirmButtonColor: "#3085d6",
			cancelButtonColor: "#d33",
			confirmButtonText: "<i class='fa fa-check-circle'></i> Yes, Delete",
			confirmButtonClass: "btn btn-danger",
			cancelButtonClass: "btn btn-secondary ml-1",
			buttonsStyling: false,
			allowOutsideClick: false,
			allowEscapeKey: false,
			allowEnterKey: false
		}).then(function(result){
			if(result.value) {
				let formdata = new FormData();
				formdata.append('userid',userId);
				formdata.append('action','delete-user');
				
				$.ajax({
					url: 'assets/resources/scripts/useraccount.php',
					type: 'POST',
					data: formdata,
					dataType: 'JSON',
					contentType: false,
					processData: false,
					beforeSend: function(){
						Swal.fire({
							title: 'Deleting...',
							html: "<i class='fas fa-spinner fa-spin'></i> Please wait...",
							allowOutsideClick: false,
							showConfirmButton: false,
							willOpen: () => {
								Swal.showLoading(); // show loading spinner
							}
						});
					},
					success: function(response) {
						// Check if deletion was successful
						if(response.header==='successful') {
							Swal.fire({
								icon: "success",
								title: "Deleted!",
								text: delName+" "+response.message,
								confirmButtonClass: "btn btn-success"
							}).then(function() {
								location.reload();
							});
						} else {
							Swal.fire({
								icon: "error",
								title: "Error!",
								text: response.message || "Failed to delete the item.",
								confirmButtonClass: "btn btn-danger",
								allowOutsideClick: false,
								allowEscapeKey: false,
								allowEnterKey: false
							});
						}
					},
					error: function() {
						// Handle error during AJAX call
						Swal.fire({
							icon: "error",
							title: "Error!",
							text: "Something went wrong. Please try again later.",
							confirmButtonClass: "btn btn-danger",
							allowOutsideClick: false,
							allowEscapeKey: false,
							allowEnterKey: false
						});
					}
				});
			}
		});
	});
	
	let emailUpdate = $("#emailUpdate").val();
	if(emailUpdate){
		let formdata = new FormData();
		formdata.append('action','check-email-update');
		
		$.ajax({
			url: 'assets/resources/scripts/useraccount.php',
			type: 'POST',
			data: formdata,
			dataType: 'JSON',
			contentType: false,
			processData: false,
			success: function(response) {
				if(response.header==='successful') {
					Swal.fire({
						icon: "success",
						title: "Email Updated",
						html: response.message,
						confirmButtonClass: "btn btn-success",
						allowOutsideClick: false,
						allowEscapeKey: false,
						allowEnterKey: false
					});
				}
			}
		});
	}
	
	///////update email/////
	$(".update-email").on("click", function () {
		showEmailUpdatePopup();
	});
	
	// Function to show the email update popup
	function showEmailUpdatePopup() {
		Swal.fire({
			title: "Update Email Address",
			input: 'email', // Use the 'email' type to validate the email input
			inputLabel: 'Please enter your new email address',
			inputPlaceholder: 'Enter your email',
			inputAttributes: {
				'aria-label': 'Type your email address'
			},
			showCancelButton: true,
			confirmButtonText: 'Update Email',
			confirmButtonColor: "#3085d6",
			cancelButtonColor: "#d33",
			confirmButtonClass: "btn btn-primary",
			cancelButtonClass: "btn btn-danger ml-1",
			buttonsStyling: false,
			allowOutsideClick: false,
			allowEscapeKey: false,
			allowEnterKey: true,
			preConfirm: (email) => {
				if (!email || !validateEmail(email)) {
					Swal.showValidationMessage('Please enter a valid email address');
				}
				return email;
			}
		}).then((result) => {
			if (result.isConfirmed && result.value) {
				const email = result.value;
				let formdata = new FormData();
				formdata.append('email',email);
				formdata.append('action','update-email');
				
				$.ajax({
					url: 'assets/resources/scripts/useraccount.php',
					type: 'POST',
					data: formdata,
					dataType: 'JSON',
					contentType: false,
					processData: false,
					beforeSend: function(){
						Swal.fire({
							title: 'Updating Email...',
							html: "<i class='fas fa-spinner fa-spin'></i> Please wait...",
							allowOutsideClick: false,
							allowEscapeKey: false,
							allowEnterKey: false,
							showConfirmButton: false,
							willOpen: () => {
								Swal.showLoading();
							}
						});
					},
					success: function(response) {
						if(response.header==='successful') {
							Swal.fire({
								icon: "success",
								title: "Successful",
								html: response.message,
								confirmButtonClass: "btn btn-success",
								allowOutsideClick: false,
								allowEscapeKey: false,
								allowEnterKey: false
							})
							/* $("#returnedOtp").val(response.data);
							showOtpPopup(); */ // Call the OTP popup after email is updated
						}else{
							// If email validation fails on the server side, recall the email popup
							Swal.fire({
								icon: 'error',
								title: 'Error!',
								text: response.message || 'Failed to update email address.',
								confirmButtonClass: 'btn btn-danger'
							}).then(() => {
								showEmailUpdatePopup(); // Reopen email input box
							});
						}
					},
					error: function() {
						Swal.fire({
							icon: 'error',
							title: 'Error!',
							text: 'Something went wrong while updating email. Please try again later.',
							confirmButtonClass: 'btn btn-danger'
						}).then(() => {
							showEmailUpdatePopup(); // Reopen email input box in case of error
						});
					}
				});
			}
		});
	}

	// Function to show the OTP validation popup
	if(returnUrl=='Profile.php'){
		function showOtpPopup() {
			let returnedOtp = $("#returnedOtp").val();
			Swal.fire({
				title: 'Enter OTP ('+returnedOtp+')',
				html: `
					<div style="display: flex; justify-content: center; gap: 10px;">
						<input type="text" id="otp1" maxlength="1" class="otp-input" style="width: 50px; text-align: center; font-size: 20px;">
						<input type="text" id="otp2" maxlength="1" class="otp-input" style="width: 50px; text-align: center; font-size: 20px;">
						<input type="text" id="otp3" maxlength="1" class="otp-input" style="width: 50px; text-align: center; font-size: 20px;">
						<input type="text" id="otp4" maxlength="1" class="otp-input" style="width: 50px; text-align: center; font-size: 20px;">
						<input type="text" id="otp5" maxlength="1" class="otp-input" style="width: 50px; text-align: center; font-size: 20px;">
						<input type="text" id="otp6" maxlength="1" class="otp-input" style="width: 50px; text-align: center; font-size: 20px;">
					</div>
				`,
				confirmButtonText: 'Validate OTP',
				confirmButtonClass: 'btn btn-primary',
				buttonsStyling: false,
				focusConfirm: false,
				preConfirm: () => {
					// Collect the values from each OTP input
					const otp = [
						document.getElementById('otp1').value,
						document.getElementById('otp2').value,
						document.getElementById('otp3').value,
						document.getElementById('otp4').value,
						document.getElementById('otp5').value,
						document.getElementById('otp6').value
					].join('');
					
					// Validate if OTP is 6 digits
					if (otp.length !== 6 || isNaN(otp)) {
						Swal.showValidationMessage('Please enter a valid 6-digit OTP');
					}
					return otp; // Return OTP for further processing
				}
			}).then((result) => {
				if (result.isConfirmed) {
					const otp = result.value;
					let formdata = new FormData();
					formdata.append('action','change-email');
					formdata.append('otp',otp);
					
					$.ajax({
						url: 'assets/resources/scripts/useraccount.php',
						type: 'POST',
						data: formdata,
						dataType: 'JSON',
						contentType: false,
						processData: false,
						beforeSend: function(){
							Swal.fire({
								title: 'Updating Email...',
								html: `<i class='fas fa-spinner fa-spin'></i> Please wait...`,
								allowOutsideClick: false,
								allowEscapeKey: false,
								allowEnterKey: false,
								showConfirmButton: false,
								willOpen: () => {
									Swal.showLoading();
								}
							});
						},
						success: function(response) {
							if (response.header==='successful') {
								Swal.fire({
									icon: 'success',
									title: 'Email Updated',
									text: 'Your Email address was successfully updated',
									confirmButtonClass: 'btn btn-success'
								}).then(() => {
									$("#email").val(response.data);
								});
							} 
							else if(response.header==='invalid otp'){
								Swal.fire({
									icon: 'error',
									title: 'Invalid OTP!',
									html: response.message || 'The OTP you entered is incorrect.',
									confirmButtonClass: 'btn btn-danger'
								}).then(() => {
									showOtpPopup(); // Reopen email input box
								});
							}
							else {
								Swal.fire({
									icon: 'error',
									title: response.header,
									text: response.message || 'Could not update email.',
									confirmButtonClass: 'btn btn-danger'
								});
							}
						},
						error: function() {
							Swal.fire({
								icon: 'error',
								title: 'Error!',
								text: 'Something went wrong. Please try again later.',
								confirmButtonClass: 'btn btn-danger'
							});
						}
					});


					/* if(otp == returnedOtp){
						
					}
					else{
						Swal.showValidationMessage('Incorrect OTP Entered');
					} */
				}
			});

			// Optional: JavaScript to auto-focus next field after user types in each OTP input
			const otpInputs = document.querySelectorAll('.otp-input');
			otpInputs.forEach((input, index) => {
				input.addEventListener('input', function() {
					if (input.value.length === 1 && index < otpInputs.length - 1) {
						otpInputs[index + 1].focus();
					}
				});

				input.addEventListener('keydown', function(e) {
					if (e.key === 'Backspace' && !input.value && index > 0) {
						otpInputs[index - 1].focus();
					}
				});
			});
		}
	}
	
	$("#editAccount").on('click', function(){
		$("#firstName").removeAttr('disabled');
		$("#lastName").removeAttr('disabled');
		$("#middleName").removeAttr('disabled');
		$("#username").removeAttr('disabled');
		$("#countryCode").removeAttr('disabled');
		$("#phone").removeAttr('disabled');
		$("#gender").removeAttr('disabled');
		$("#title").removeAttr('disabled');
		$("#day").removeAttr('disabled');
		$("#month").removeAttr('disabled');
		$("#year").removeAttr('disabled');
		$("#editDisplay").attr('style','display:none;');
		$("#updateBtns").attr('style','display:block;');
	});
	 
	$("#cancelUpdate").on('click', function(){
		$("#firstName").attr('disabled','disabled');
		$("#lastName").attr('disabled','disabled');
		$("#middleName").attr('disabled','disabled');
		$("#username").attr('disabled','disabled');
		$("#countryCode").attr('disabled','disabled');
		$("#phone").attr('disabled','disabled');
		$("#gender").attr('disabled','disabled');
		$("#title").attr('disabled','disabled');
		$("#day").attr('disabled','disabled');
		$("#month").attr('disabled','disabled');
		$("#year").attr('disabled','disabled');
		$("#editDisplay").attr('style','display:block;');
		$("#updateBtns").attr('style','display:none;');
	});
	
	$("#updateAccount").on('click', function(){
		let formdata = new FormData();
		let errorMsg = '';
		
		let title = $("#title").val();
		if(title){
			formdata.append('title', title);
			$("#title").removeClass('is-invalid');
		}
		else{
			$("#title").addClass('is-invalid');
			errorMsg = '<i class="fa fa-times-circle"></i> Select Title';
		}
		let firstName = $("#firstName").val();
		if(firstName){
			formdata.append('firstName', firstName);
			$("#firstName").removeClass('is-invalid');
		}
		else{
			$("#firstName").addClass('is-invalid');
			if(errorMsg){
				errorMsg += '<br><i class="fa fa-times-circle"></i> Enter First name';
			}
			else{
				errorMsg = '<i class="fa fa-times-circle"></i> Enter First name';
			}
		}
		let lastName = $("#lastName").val();
		if(lastName){
			formdata.append('lastName', lastName);
			$("#lastName").removeClass('is-invalid');
		}
		else{
			$("#lastName").addClass('is-invalid');
			if(errorMsg){
				errorMsg += '<br><i class="fa fa-times-circle"></i> Enter Last Name';
			}
			else{
				errorMsg = '<i class="fa fa-times-circle"></i> Enter Last Name';
			}
		}
		let gender = $("#gender").val();
		if(gender){
			formdata.append('gender', gender);
			$("#gender").removeClass('is-invalid');
		}
		else{
			$("#gender").addClass('is-invalid');
			if(errorMsg){
				errorMsg += '<br><i class="fa fa-times-circle"></i> Select Gender';
			}
			else{
				errorMsg = '<i class="fa fa-times-circle"></i> Select Gender';
			}
		}
		
		let username = $("#username").val();
		if(username){
			formdata.append('username', username);
			$("#username").removeClass('is-invalid');
		}
		else{
			$("#username").addClass('is-invalid');
			if(errorMsg){
				errorMsg += '<br><i class="fa fa-times-circle"></i> Enter Username';
			}
			else{
				errorMsg = '<i class="fa fa-times-circle"></i> Enter Username';
			}
		}
		let countryCode = $("#countryCode").val();
		let phone = $("#phone").val();
		let phoneNumber = countryCode+phone;
		if(phone){
			if(isValidPhoneNumber(phoneNumber)){
				$("#phone").removeClass('is-invalid');
				formdata.append('phone',countryCode+"-"+phone);
			}
			else{
				$("#phone").addClass('is-invalid');
				if(errorMsg){
					errorMsg += '<br><i class="fa fa-times-circle"></i> Invalid Phone Number';
				}
				else{
					errorMsg += '<i class="fa fa-times-circle"></i> Invalid Phone Number';
				}
			}
		}
		else{
			$("#phone").addClass('is-invalid');
			if(errorMsg){
				errorMsg += '<br><i class="fa fa-times-circle"></i> Phone is required';
			}
			else{
				errorMsg += '<i class="fa fa-times-circle"></i> Phone is required';
			}
		}
		
		let day = $("#day").val();
		if(day){
			$("#day").removeClass('is-invalid');
		}
		else{
			if(errorMsg){
				errorMsg += '<br><i class="fa fa-times-circle"></i> Select your Day of Birth';
				$("#day").addClass('is-invalid');
			}
			else{
				errorMsg = '<i class="fa fa-times-circle"></i> Select Your Day of Birth';
				$("#day").addClass('is-invalid');
			}
		}
		let month = $("#month").val();
		if(month){
			$("#month").removeClass('is-invalid');
		}
		else{
			if(errorMsg){
				errorMsg += '<br><i class="fa fa-times-circle"></i> Select Your Month of Birth';
				$("#month").addClass('is-invalid');
			}
			else{
				errorMsg = '<i class="fa fa-times-circle"></i> Select Your Month of Birth';
				$("#month").addClass('is-invalid');
			}
		}
		let year = $("#year").val();
		if(year){
			let dateOfBirth = day+'-'+month+'-'+year;
			formdata.append('dateOfBirth',dateOfBirth);
		}
		else{
			let dateOfBirth = day+'-'+month;
			formdata.append('dateOfBirth',dateOfBirth);
		}
		
		if(errorMsg){
			errorMsg = '<span class="text-danger">'+errorMsg+'</span>';
			Swal.fire({
				icon: "error",
				title: "Error!",
				html: errorMsg,
				confirmButtonClass: "btn btn-danger",
				allowOutsideClick: false,
				allowEscapeKey: false,
				allowEnterKey: false
			});
		}
		else{
			formdata.append('action','update-profile');
			$.ajax({
				url: 'assets/resources/scripts/useraccount.php',
				type: 'POST',
				data: formdata,
				contentType: false,
				processData: false,
				dataType:'JSON',
				beforeSend:function(){
					Swal.fire({
						title: 'Updating...',
						html: "",
						allowOutsideClick: false,
						showConfirmButton: false,
						willOpen: () => {
							Swal.showLoading(); // show loading spinner
						}
					});
				},
				success: function(response){
					if(response.header=='successful'){
						$("#firstName").attr('disabled','disabled');
						$("#lastName").attr('disabled','disabled');
						$("#middleName").attr('disabled','disabled');
						$("#username").attr('disabled','disabled');
						$("#phone").attr('disabled','disabled');
						$("#title").attr('disabled','disabled');
						$("#countryCode").attr('disabled','disabled');
						$("#gender").attr('disabled','disabled');
						$("#day").attr('disabled','disabled');
						$("#month").attr('disabled','disabled');
						$("#year").attr('disabled','disabled');
						$("#editDisplay").attr('style','display:block;');
						$("#updateBtns").attr('style','display:none;');
						$("#myName1").html(lastName+' '+firstName);
						$("#myName2").html(lastName+' '+firstName);
						Swal.fire({
							icon: "success",
							title: "Successful",
							text: "Your profile details were successfully updated",
							confirmButtonClass: "btn btn-success",
							allowOutsideClick: false,
							allowEscapeKey: false,
							allowEnterKey: false
						})
					}
					else{
						repMsg = '<span class="text-danger">'+response.message+'</span>';
						Swal.fire({
							icon: "error",
							title: "Error!",
							html: repMsg,
							confirmButtonClass: "btn btn-danger",
							allowOutsideClick: false,
							allowEscapeKey: false,
							allowEnterKey: false
						});
					}
				}
			});
		}
	});
	
	////update password///////
	$(".update-password").on("click", function () {
		showUpdatePassword();
	});
	
	// Function to show the email update popup
	function checkPasswordStrength(password) {
		let strength = 0;

		if (password.length >= 8) strength++;
		if (/[A-Z]/.test(password)) strength++;
		if (/[a-z]/.test(password)) strength++;
		if (/\d/.test(password)) strength++;
		if (/[@$!%*?&]/.test(password)) strength++;

		return strength;
	}

	function updateStrengthMeter(strength, bar, label) {
		const strengthTexts = ["Too Weak", "Weak", "Moderate", "Strong", "Very Strong"];
		const strengthColors = ["#e74c3c", "#f39c12", "#f1c40f", "#27ae60", "#2ecc71"];

		const width = (strength / 5) * 100;
		bar.style.width = width + "%";
		bar.style.backgroundColor = strengthColors[strength - 1] || "#ddd";
		label.textContent = strengthTexts[strength - 1] || "";
	}

	function togglePasswordVisibility(input, toggleIconId) {
		const toggleIcon = document.getElementById(toggleIconId);
		if (input.type === "password") {
			input.type = "text";
			toggleIcon.classList.remove("fa-eye");
			toggleIcon.classList.add("fa-eye-slash");
		} else {
			input.type = "password";
			toggleIcon.classList.remove("fa-eye-slash");
			toggleIcon.classList.add("fa-eye");
		}
	}
	function showUpdatePassword(){
		Swal.fire({
			title: 'Update Account Password',
			html: `
				<form id="passwordUpdateForm">
					<div class="input-container">
						<input type="password" id="newPassword" class="swal2-input" placeholder="New Password" required>
						<i class="fas fa-eye toggle-password-update" id="toggleNewPassword"></i>
					</div>
					<div id="password-strength">
						<div id="password-strength-bar"></div>
					</div>
					<div id="strength-label"></div>
					<div class="input-container">
						<input type="password" id="confirmPassword" class="swal2-input" placeholder="Confirm Password" required>
						<i class="fas fa-eye toggle-password-update" id="toggleConfirmPassword"></i>
					</div>
				</form>
			`,
			focusConfirm: false,
			showCancelButton: true,
			confirmButtonText: 'Update Password',
			cancelButtonText: 'Cancel',
			didOpen: () => {
				const newPasswordInput = document.getElementById('newPassword');
				const confirmPasswordInput = document.getElementById('confirmPassword');
				const strengthBar = document.getElementById('password-strength-bar');
				const strengthLabel = document.getElementById('strength-label');

				// Toggle Password Visibility
				document.getElementById('toggleNewPassword').addEventListener('click', () => {
					togglePasswordVisibility(newPasswordInput, 'toggleNewPassword');
				});
				document.getElementById('toggleConfirmPassword').addEventListener('click', () => {
					togglePasswordVisibility(confirmPasswordInput, 'toggleConfirmPassword');
				});

				// Password strength logic
				newPasswordInput.addEventListener('input', () => {
					const password = newPasswordInput.value;
					const strength = checkPasswordStrength(password);
					updateStrengthMeter(strength, strengthBar, strengthLabel);
				});
			},
			preConfirm: () => {
				const newPassword = document.getElementById('newPassword').value;
				const confirmPassword = document.getElementById('confirmPassword').value;

				if (!newPassword || !confirmPassword) {
					Swal.showValidationMessage('Please fill in both fields.');
					return false;
				}

				if (newPassword !== confirmPassword) {
					Swal.showValidationMessage('Passwords do not match.');
					return false;
				}

				const strength = checkPasswordStrength(newPassword);
				if (strength < 3) {
					Swal.showValidationMessage('Password is too weak. Please use a stronger password.');
					return false;
				}

				return { newPassword };
			}
		}).then((result) => {
			if (result.isConfirmed) {
				let password = result.value.newPassword;
				let formdata = new FormData();
				formdata.append('password',password);
				formdata.append('action','update-password');
				
				$.ajax({
					url: 'assets/resources/scripts/useraccount.php',
					type: 'POST',
					data: formdata,
					contentType: false,
					processData: false,
					dataType:'JSON',
					beforeSend:function(){
						Swal.fire({
							title: 'Updating...',
							html: "Your password is being updated. Please, wait",
							allowOutsideClick: false,
							showConfirmButton: false,
							willOpen: () => {
								Swal.showLoading(); // show loading spinner
							}
						});
					},
					success: function(response){
						if(response.header=='successful'){
							Swal.fire({
								icon: "success",
								title: "Password Updated!",
								text: "Your account password has been updated successfully.",
								confirmButtonClass: "btn btn-success",
								allowOutsideClick: false,
								allowEscapeKey: false,
								allowEnterKey: false
							});
						}
						else{
							repMsg = '<span class="text-danger">'+response.message+'</span>';
							Swal.fire({
								icon: "error",
								title: "Error!",
								html: repMsg,
								confirmButtonClass: "btn btn-danger",
								allowOutsideClick: false,
								allowEscapeKey: false,
								allowEnterKey: false
							}).then(function() {
								showUpdatePassword();
							});
						}
					}
				});
			}
		});
	}
	
	////////update profile Image////
	$('#profileImg').change(function(){
		var fd = new FormData();
		var files = $('#profileImg')[0].files;
		fd.append('file',files[0]);
		fd.append('action','upload-profile-image');
		$.ajax({
			url: 'assets/resources/scripts/useraccount.php',
			type: 'POST',
			data: fd,
			contentType: false,
			processData: false,
			dataType:'JSON',
			beforeSend:function(){
				Swal.fire({
					title: 'Uploading...',
					html: "<i class='fas fa-spinner fa-spin'></i> Please wait...",
					allowOutsideClick: false,
					showConfirmButton: false,
					willOpen: () => {
						Swal.showLoading(); // show loading spinner
					}
				});
			},
			success: function(response){
				if(response.header=='successful'){
					$('#profileImg').removeAttr('disabled');
					$("#userImage1").attr('src',response.imgsrc);
					$("#userImage2").attr('src',response.imgsrc);
					$("#userImage3").attr('src',response.imgsrc);
					$("#userImage4").attr('src',response.imgsrc);
					$("#userImage5").attr('src',response.imgsrc);
					
					Swal.fire({
						icon: "success",
						title: "Uploaded",
						text: "Profile Image successfully uploaded",
						confirmButtonClass: "btn btn-success",
						allowOutsideClick: false,
						allowEscapeKey: false,
						allowEnterKey: false
					})
				}
				else{
					$('#profileImg').removeAttr('disabled');
					Swal.fire({
						icon: "error",
						title: "Error!",
						text: response.message || "Could not upload profile image.",
						confirmButtonClass: "btn btn-danger",
						allowOutsideClick: false,
						allowEscapeKey: false,
						allowEnterKey: false
					});
				}
			},
			error: function() {
				Swal.fire({
					icon: "error",
					title: "Error!",
					text: "Something went wrong. Please try again later.",
					confirmButtonClass: "btn btn-danger",
					allowOutsideClick: false,
					allowEscapeKey: false,
					allowEnterKey: false
				});
			}
		});
	});
	
	////upload profile bg cover////
	$('#cover_upload').change(function(){
		var fd = new FormData();
		var files = $('#cover_upload')[0].files;
		fd.append('file',files[0]);
		fd.append('action','upload-cover-image');
		$.ajax({
			url: 'assets/resources/scripts/useraccount.php',
			type: 'POST',
			data: fd,
			contentType: false,
			processData: false,
			dataType:'JSON',
			beforeSend:function(){
				Swal.fire({
					title: 'Uploading...',
					html: "<i class='fas fa-spinner fa-spin'></i> Please wait...",
					allowOutsideClick: false,
					showConfirmButton: false,
					willOpen: () => {
						Swal.showLoading(); // show loading spinner
					}
				});
			},
			success: function(response){
				if(response.header=='successful'){
					$('#cover_upload').removeAttr('disabled');
					$("#profileBg").attr('src',response.imgsrc);
					
					Swal.fire({
						icon: "success",
						title: "Uploaded",
						text: "Cover Image successfully uploaded",
						confirmButtonClass: "btn btn-success",
						allowOutsideClick: false,
						allowEscapeKey: false,
						allowEnterKey: false
					})
				}
				else{
					$('#cover_upload').removeAttr('disabled');
					Swal.fire({
						icon: "error",
						title: "Error!",
						text: response.message || "Could not upload cover image.",
						confirmButtonClass: "btn btn-danger",
						allowOutsideClick: false,
						allowEscapeKey: false,
						allowEnterKey: false
					});
				}
			},
			error: function() {
				Swal.fire({
					icon: "error",
					title: "Error!",
					text: "Something went wrong. Please try again later.",
					confirmButtonClass: "btn btn-danger",
					allowOutsideClick: false,
					allowEscapeKey: false,
					allowEnterKey: false
				});
			}
		});
	});
	
	/////change password//////
	$(".change-password").on('click', function(){
		let userId = $(this).attr('data-id');
		let fullname = $(this).attr('name');
		Swal.fire({
		  title: 'Reset Password',
		  text: "This action will reset the password for "+fullname+". Are you sure you want to reset the user's password?",
		  icon: 'warning',
		  showCancelButton: true,
		  confirmButtonText: 'Yes, Send Link',
		  cancelButtonText: 'Cancel',
		  confirmButtonColor: '#3085d6',
		  cancelButtonColor: '#d33',
		  customClass: {
			confirmButton: 'btn btn-primary',
			cancelButton: 'btn btn-danger ml-1',
		  },
		  buttonsStyling: false,
		  allowOutsideClick: false,
		  allowEscapeKey: false
		}).then((result) => {
			if (result.isConfirmed) {
				let formdata = new FormData();
				formdata.append('action','reset-password');
				formdata.append('userid',userId);
				$.ajax({
					url: 'assets/resources/scripts/useraccount.php',
					type: 'POST',
					data: formdata,
					contentType: false,
					processData: false,
					dataType:'JSON',
					beforeSend:function(){
						Swal.fire({
							title: 'Resetting Password...',
							html: "<i class='fas fa-spinner fa-spin'></i> Please wait...",
							allowOutsideClick: false,
							allowEscapeKey: false,
							allowEnterKey: false,
							showConfirmButton: false,
							willOpen: () => {
								Swal.showLoading();
							}
						});
					},
					success: function (response){
					  if (response.header==='successful') {
						Swal.fire({
						  title: 'Password Reset!',
						  text: "The password for "+fullname+" has been successfully reset. "+response.data,
						  icon: 'success',
						  confirmButtonText: 'OK',
						  confirmButtonColor: '#3085d6',
						  customClass: {
							confirmButton: 'btn btn-success'
						  },
						  buttonsStyling: false
						});
					  }else {
						Swal.fire({
						  title: 'Error!',
						  text: response.message,
						  icon: 'error',
						  confirmButtonText: 'OK',
						  confirmButtonColor: '#d33',
						  customClass: {
							confirmButton: 'btn btn-danger'
						  },
						  buttonsStyling: false
						});
					  }
					},
					error: function(){
					  // Handle error when the request fails
					  Swal.fire({
						title: 'Error!',
						text: 'Something went wrong. Please try again later.',
						icon: 'error',
						confirmButtonText: 'OK',
						confirmButtonColor: '#d33',
						customClass: {
						  confirmButton: 'btn btn-danger'
						},
						buttonsStyling: false
					  });
					}
				});
			}
		});
	});
	
	/////suspend user//////
	$(".suspend-user").on('click', function(){
		let userId = $(this).attr('data-id');
		let fullname = $(this).attr('name');
		Swal.fire({
		  title: 'Suspend User',
		  text: "This action will Suspend the account for "+fullname+". Are you sure you want to Continue?",
		  icon: 'warning',
		  showCancelButton: true,
		  confirmButtonText: 'Yes, Suspend',
		  cancelButtonText: 'Cancel',
		  confirmButtonColor: '#3085d6',
		  cancelButtonColor: '#d33',
		  customClass: {
			confirmButton: 'btn btn-primary',
			cancelButton: 'btn btn-danger ml-1',
		  },
		  buttonsStyling: false,
		  allowOutsideClick: false,
		  allowEscapeKey: false
		}).then((result) => {
			if (result.isConfirmed) {
				let formdata = new FormData();
				formdata.append('action','suspend-user');
				formdata.append('userid',userId);
				$.ajax({
					url: 'assets/resources/scripts/useraccount.php',
					type: 'POST',
					data: formdata,
					contentType: false,
					processData: false,
					dataType:'JSON',
					beforeSend:function(){
						Swal.fire({
							title: 'Suspending User...',
							html: "<i class='fas fa-spinner fa-spin'></i> Please wait...",
							allowOutsideClick: false,
							allowEscapeKey: false,
							allowEnterKey: false,
							showConfirmButton: false,
							willOpen: () => {
								Swal.showLoading();
							}
						});
					},
					success: function (response){
					  if (response.header==='successful') {
						Swal.fire({
						  title: 'Successful',
						  text: "The account for "+fullname+" has been successfully Suspended.",
						  icon: 'success',
						  confirmButtonText: 'OK',
						  confirmButtonColor: '#3085d6',
						  customClass: {
							confirmButton: 'btn btn-success'
						  },
						  buttonsStyling: false
						}).then(function() {
							location.reload();
						});
					  }else {
						Swal.fire({
						  title: 'Error!',
						  text: response.message,
						  icon: 'error',
						  confirmButtonText: 'OK',
						  confirmButtonColor: '#d33',
						  customClass: {
							confirmButton: 'btn btn-danger'
						  },
						  buttonsStyling: false
						});
					  }
					},
					error: function(){
					  // Handle error when the request fails
					  Swal.fire({
						title: 'Error!',
						text: 'Something went wrong. Please try again later.',
						icon: 'error',
						confirmButtonText: 'OK',
						confirmButtonColor: '#d33',
						customClass: {
						  confirmButton: 'btn btn-danger'
						},
						buttonsStyling: false
					  });
					}
				});
			}
		});
	});
	
	////restore user account////////
	$(".restore-user").on('click', function(){
		let userId = $(this).attr('data-id');
		let fullname = $(this).attr('name');
		Swal.fire({
		  title: 'Restore User',
		  text: "This action will Restore the account for "+fullname+". Are you sure you want to Continue?",
		  icon: 'warning',
		  showCancelButton: true,
		  confirmButtonText: 'Yes, Restore',
		  cancelButtonText: 'Cancel',
		  confirmButtonColor: '#3085d6',
		  cancelButtonColor: '#d33',
		  customClass: {
			confirmButton: 'btn btn-primary',
			cancelButton: 'btn btn-danger ml-1',
		  },
		  buttonsStyling: false,
		  allowOutsideClick: false,
		  allowEscapeKey: false
		}).then((result) => {
			if (result.isConfirmed) {
				let formdata = new FormData();
				formdata.append('action','restore-user');
				formdata.append('userid',userId);
				$.ajax({
					url: 'assets/resources/scripts/useraccount.php',
					type: 'POST',
					data: formdata,
					contentType: false,
					processData: false,
					dataType:'JSON',
					beforeSend:function(){
						Swal.fire({
							title: 'Restoring User...',
							html: "<i class='fas fa-spinner fa-spin'></i> Please wait...",
							allowOutsideClick: false,
							allowEscapeKey: false,
							allowEnterKey: false,
							showConfirmButton: false,
							willOpen: () => {
								Swal.showLoading();
							}
						});
					},
					success: function (response){
					  if (response.header==='successful') {
						Swal.fire({
						  title: 'Successful',
						  text: "The account for "+fullname+" has been successfully Restored.",
						  icon: 'success',
						  confirmButtonText: 'OK',
						  confirmButtonColor: '#3085d6',
						  customClass: {
							confirmButton: 'btn btn-success'
						  },
						  buttonsStyling: false
						}).then(function() {
							location.reload();
						});
					  }else {
						Swal.fire({
						  title: 'Error!',
						  text: response.message,
						  icon: 'error',
						  confirmButtonText: 'OK',
						  confirmButtonColor: '#d33',
						  customClass: {
							confirmButton: 'btn btn-danger'
						  },
						  buttonsStyling: false
						});
					  }
					},
					error: function(){
					  // Handle error when the request fails
					  Swal.fire({
						title: 'Error!',
						text: 'Something went wrong. Please try again later.',
						icon: 'error',
						confirmButtonText: 'OK',
						confirmButtonColor: '#d33',
						customClass: {
						  confirmButton: 'btn btn-danger'
						},
						buttonsStyling: false
					  });
					}
				});
			}
		});
	});
	
	////add new administrator
	$(document).delegate("[data-bs-target='#addAdmin']", "click", function() {
        $('#addAdmin').on('hide.bs.modal', function(e) {
			e.preventDefault();
        });
	});
	$('#closeAddAdminIcon').on('click', function(){
        $('#addAdmin').off("hide.bs.modal").trigger("click").modal('hide');
    });
	$('#closeAddAdmin').on('click', function(){
        $('#addAdmin').off("hide.bs.modal").trigger("click").modal('hide');
    });
	
	$("#addAminBtn").on('click', function(){
		let formdata = new FormData();
		let errorMsg = '';
		
		let firstName = $("#firstName").val();
		if(firstName){
			$("#state").removeClass('is-invalid');
			formdata.append('firstName',firstName);
		}
		else{
			$("#firstName").addClass('is-invalid');
			if(errorMsg){
				errorMsg += '<br>First Name is required';
			}
			else{
				errorMsg += 'First Name is required';
			}
		}
		let lastName = $("#lastName").val();
		if(lastName){
			$("#lastName").removeClass('is-invalid');
			formdata.append('lastName',lastName);
		}
		else{
			$("#lastName").addClass('is-invalid');
			if(errorMsg){
				errorMsg += '<br>Surname is required';
			}
			else{
				errorMsg += 'Surname is required';
			}
		}
		
		let email = $("#email").val();
		if(email){
			if(!(/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(email))){
				$("#email").addClass('is-invalid');
				if(errorMsg){
					errorMsg += '<br>Invalid Email Entered';
				}
				else{
					errorMsg += 'Invalid Email Entered';
				}
			}
			else{
				formdata.append('email',email);
			}
		}
		else{
			$("#email").addClass('is-invalid');
			if(errorMsg){
				errorMsg += '<br>Email is required';
			}
			else{
				errorMsg += 'Email is required';
			}
		}
		
		if(!errorMsg){
			let addUserType = $("#UserType").val();
			formdata.append('action','create-account');
			formdata.append('usertype',addUserType);
			$.ajax({
				type: 'POST',
				url:'assets/resources/scripts/useraccount.php',
				data: formdata,
				contentType: false,
				processData: false,
				dataType:'JSON',
				beforeSend: function(){
					$("#addBusiness").attr('disabled','disabled');
					$("#bzMsgBox").html('');
					$("#addAdmin").off("hide.bs.modal").modal('hide');
					Swal.fire({
						title: 'Creating Admin Account. Please, wait...',
						html: "",
						allowOutsideClick: false,
						showConfirmButton: false,
						willOpen: () => {
							Swal.showLoading(); // show loading spinner
						}
					});
				},
				success:function(responseData){
					if(responseData.header==='successful'){
						$("#addAdmin").off("hide.bs.modal").modal('hide');
						Swal.fire({
							icon: "success",
							title: "Success",
							html: responseData.message,
							confirmButtonClass: "btn btn-success",
							allowOutsideClick: false,
							allowEscapeKey: false,
							allowEnterKey: false
						});
					}
					else{
						$("#addBusiness").removeAttr('disabled');
						errorMsg = '<span class="text-danger">'+responseData.message+'</span>';
						Swal.fire({
							icon: "error",
							title: "Error Occurred",
							html: errorMsg,
							confirmButtonClass: "btn btn-danger",
							allowOutsideClick: false,
							allowEscapeKey: false,
							allowEnterKey: false
						});
					}
				}
			});
		}
		else{
			Swal.fire({
				title: 'Error!',
				html: "<span class='text-danger'>"+errorMsg+"</span>",
				icon: 'error',
				confirmButtonText: 'OK',
				confirmButtonColor: '#d33',
				customClass: {
				  confirmButton: 'btn btn-danger'
				},
				allowOutsideClick: false,
				allowEscapeKey: false,
				allowEnterKey: false,
				buttonsStyling: false
			});
		}
	});
	
	
	/////////MANAGE QUESTIONS
	///////submitCategory/////
	$(document).delegate("[data-bs-target='#addCategory']", "click", function() {
        $('#addCategory').on('hide.bs.modal', function(e) {
			e.preventDefault();
        });
	});
	$('#closeAddCatBtn').on('click', function(){
        $('#addCategory').off("hide.bs.modal").trigger("click").modal('hide');
		location.href="./";
	});
	$('#closeAddCatIcon').on('click', function(){
        $('#addCategory').off("hide.bs.modal").trigger("click").modal('hide');
		location.href="./";
	});
	
	$("#submitCategory").on('click', function(){
		let formdata = new FormData();
		let categoryName = $("#categoryName").val();
		if(categoryName){
			formdata.append('categoryName',categoryName);
			formdata.append('action','add-category');
			
			$.ajax({
				type: 'POST',
				url:'assets/resources/scripts/scripts.php',
				data: formdata,
				contentType: false,
				processData: false,
				dataType:'JSON',
				beforeSend: function(){
					$("#submitCategory").attr('disabled','disabled');
					Swal.fire({
						icon: "info",
						title: 'Adding Category. ',
						html: "Please, wait...",
						allowOutsideClick: false,
						showConfirmButton: false,
						willOpen: () => {
							Swal.showLoading(); // show loading spinner
						}
					});
				},
				success:function(responseData){
					if(responseData.header==='successful'){
						Swal.fire({
							icon: "success",
							title: "Success",
							html: responseData.message,
							confirmButtonClass: "btn btn-success",
							allowOutsideClick: false,
							allowEscapeKey: false,
							allowEnterKey: false
						});
						
						////reset the form//////
						$("#categoryName").val('');
						$("#submitCategory").removeAttr('disabled');
					}
					else{
						$("#submitCategory").removeAttr('disabled');
						errorMsg = '<span class="text-danger">'+responseData.message+'</span>';
						Swal.fire({
							icon: "error",
							title: "Error Occurred",
							html: errorMsg,
							confirmButtonClass: "btn btn-danger",
							allowOutsideClick: false,
							allowEscapeKey: false,
							allowEnterKey: false
						});
					}
				}
			});	
		}
		else{
			Swal.fire({
				title: 'Error!',
				html: "<span class='text-danger'>Enter Category</span>",
				icon: 'error',
				confirmButtonText: 'OK',
				confirmButtonColor: '#d33',
				customClass: {
				  confirmButton: 'btn btn-danger'
				},
				allowOutsideClick: false,
				allowEscapeKey: false,
				allowEnterKey: false,
				buttonsStyling: false
			});
		}
	});
	
	//////delete multiple categories//////
	$(".delete-all-category").on('click', function(){
		let catIds = $("#selectedId").val();
		let catNames = $("#selectedNames").val();
		
		Swal.fire({
		  title: 'Delete Categories',
		  html: catNames+" will be deleted.<br>Are you sure you want to continue?",
		  icon: 'warning',
		  showCancelButton: true,
		  confirmButtonText: 'Yes, Delete',
		  cancelButtonText: 'Cancel',
		  confirmButtonColor: '#3085d6',
		  cancelButtonColor: '#d33',
		  customClass: {
			confirmButton: 'btn btn-primary',
			cancelButton: 'btn btn-danger ml-1',
		  },
		  buttonsStyling: false,
		  allowOutsideClick: false,
		  allowEscapeKey: false
		}).then((result) => {
			if (result.isConfirmed) {
				let formdata = new FormData();
				formdata.append('action','delete-categories');
				formdata.append('catids',catIds);
				$.ajax({
					url: 'assets/resources/scripts/scripts.php',
					type: 'POST',
					data: formdata,
					contentType: false,
					processData: false,
					dataType:'JSON',
					beforeSend:function(){
						Swal.fire({
							title: 'Deleting Categories...',
							html: "We are deleting all the selected categories. Please wait...",
							allowOutsideClick: false,
							allowEscapeKey: false,
							allowEnterKey: false,
							showConfirmButton: false,
							willOpen: () => {
								Swal.showLoading();
							}
						});
					},
					success: function (response){
					  if (response.header==='successful') {
						Swal.fire({
						  title: 'Categories Successfully Deleted',
						  html: response.message,
						  icon: 'success',
						  confirmButtonText: 'OK',
						  confirmButtonColor: '#3085d6',
						  customClass: {
							confirmButton: 'btn btn-success'
						  },
						  buttonsStyling: false
						}).then((result) => {
							location.href="./";
						});
					  }else {
						Swal.fire({
						  title: response.header,
						  html: response.message,
						  icon: 'error',
						  confirmButtonText: 'OK',
						  confirmButtonColor: '#d33',
						  customClass: {
							confirmButton: 'btn btn-danger'
						  },
						  buttonsStyling: false
						});
					  }
					},
					error: function(){
					  // Handle error when the request fails
					  Swal.fire({
						title: 'Error!',
						text: 'Something went wrong. Please try again later.',
						icon: 'error',
						confirmButtonText: 'OK',
						confirmButtonColor: '#d33',
						customClass: {
						  confirmButton: 'btn btn-danger'
						},
						buttonsStyling: false
					  });
					}
				});
			}
		});
	});
	
	$(".change-status").on('click', function(){
		let catId = $(this).attr('data-id');
		let catName = $(this).attr('name');
		let formdata = new FormData();
		
		formdata.append('action','change-category-status');
		formdata.append('catid',catId);
		$.ajax({
			url: 'assets/resources/scripts/scripts.php',
			type: 'POST',
			data: formdata,
			contentType: false,
			processData: false,
			dataType:'JSON',
			beforeSend:function(){
				Swal.fire({
					title: 'Updating',
					html: "Please, wait...",
					allowOutsideClick: false,
					allowEscapeKey: false,
					allowEnterKey: false,
					showConfirmButton: false,
					willOpen: () => {
						Swal.showLoading();
					}
				});
			},
			success: function (response){
			  if(response.header==='successful') {
				Swal.fire({
				  title: 'Category Updated',
				  html: catName+" "+response.message,
				  icon: 'success',
				  confirmButtonText: 'OK',
				  confirmButtonColor: '#3085d6',
				  customClass: {
					confirmButton: 'btn btn-success'
				  },
				  buttonsStyling: false
				});
			  }else {
				Swal.fire({
				  title: response.header,
				  html: response.message,
				  icon: 'error',
				  confirmButtonText: 'OK',
				  confirmButtonColor: '#d33',
				  customClass: {
					confirmButton: 'btn btn-danger'
				  },
				  buttonsStyling: false
				});
			  }
			},
			error: function(){
			  // Handle error when the request fails
			  Swal.fire({
				title: 'Error!',
				text: 'Something went wrong. Please try again later.',
				icon: 'error',
				confirmButtonText: 'OK',
				confirmButtonColor: '#d33',
				customClass: {
				  confirmButton: 'btn btn-danger'
				},
				buttonsStyling: false
			  });
			}
		});
		
	});
	
	////delete single category///////
	$(".delete-category").on('click', function(){
		let catId = $(this).attr('data-id');
		let catName = $(this).attr('name');
		
		Swal.fire({
			title: "Delete " + catName,
			html: "This category will de deleted <br>You won't be able to revert this!",
			icon: "warning",
			showCancelButton: true,
			confirmButtonColor: "#3085d6",
			cancelButtonColor: "#d33",
			confirmButtonText: "<i class='fa fa-check-circle'></i> Yes, Delete",
			confirmButtonClass: "btn btn-danger",
			cancelButtonClass: "btn btn-secondary ml-1",
			allowOutsideClick: false,
			allowEscapeKey: false,
			allowEnterKey: true
		}).then(function(result){
			if(result.value) {
				let formdata = new FormData();
				formdata.append('catid',catId);
				formdata.append('action','delete-category');
				
				$.ajax({
					url: 'assets/resources/scripts/scripts.php',
					type: 'POST',
					data: formdata,
					dataType: 'JSON',
					contentType: false,
					processData: false,
					beforeSend: function(){
						Swal.fire({
							title: 'Deleting '+catName,
							html: "Please wait while we delete...",
							allowOutsideClick: false,
							showConfirmButton: false,
							willOpen: () => {
								Swal.showLoading(); // show loading spinner
							}
						});
					},
					success: function(response) {
						// Check if deletion was successful
						if(response.header==='successful') {
							Swal.fire({
								title: "Successful",
								html: catName+" "+response.message,
								icon: "success",
								showCancelButton: true,
								confirmButtonColor: "#3085d6",
								cancelButtonColor: "#d33",
								confirmButtonText: "<i class='fa fa-redo'></i> Undo",
								confirmButtonClass: "btn btn-success",
								cancelButtonClass: "btn btn-secondary ml-1",
								allowOutsideClick: false,
								allowEscapeKey: false,
								allowEnterKey: true
							}).then(function(result){
								if (result.isConfirmed) {
									let formdata = new FormData();
									formdata.append('action','restore-cat');
									formdata.append('catid',catId);
									 
									$.ajax({
										url: 'assets/resources/scripts/scripts.php',
										type: 'POST',
										data: formdata,
										dataType: 'JSON',
										contentType: false,
										processData: false,
										beforeSend: function(){
											Swal.fire({
												title: 'Restoring '+catName,
												html: "Please wait while we Undo the delete...",
												allowOutsideClick: false,
												showConfirmButton: false,
												willOpen: () => {
													Swal.showLoading(); // show loading spinner
												}
											});
										},
										success: function(response) {
											if(response.header==='successful') {
												Swal.fire({
												  title: 'Category Restored',
												  html: catName+" "+response.message,
												  icon: 'success',
												  confirmButtonText: 'OK',
												  confirmButtonColor: '#3085d6',
												  customClass: {
													confirmButton: 'btn btn-success'
												  },
												  buttonsStyling: false,
												  allowOutsideClick: false,
												  allowEscapeKey: false
												});
											  }else {
												Swal.fire({
												  title: response.header,
												  html: response.message,
												  icon: 'error',
												  confirmButtonText: 'OK',
												  confirmButtonColor: '#d33',
												  customClass: {
													confirmButton: 'btn btn-danger'
												  },
												  allowOutsideClick: false,
												  allowEscapeKey: false,
												  buttonsStyling: false
												});
											  }
										}
									});
								} else if (result.dismiss === Swal.DismissReason.cancel) {
									location.href="./";
								}
							});
						} else {
							Swal.fire({
								icon: "error",
								title: "Error Occurred",
								text: response.message,
								confirmButtonClass: "btn btn-danger",
								allowOutsideClick: false,
								allowEscapeKey: false,
								allowEnterKey: false
							});
						}
					},
					error: function() {
						// Handle error during AJAX call
						Swal.fire({
							icon: "error",
							title: "Error!",
							text: "Something went wrong. Please try again later.",
							confirmButtonClass: "btn btn-danger",
							allowOutsideClick: false,
							allowEscapeKey: false,
							allowEnterKey: false
						});
					}
				});
			}
		});
	});
	
	////edit category//////
	$(document).delegate("[data-bs-target='#editCategory']", "click", function() {
        $('#editCategory').on('hide.bs.modal', function(e) {
			e.preventDefault();
        });
		
		let catId = $(this).attr('data-id');
		let catName = $(this).attr('name');
		$("#editCatId").val(catId);
		$("#editCategoryName").val(catName);
		
	});
	$('#closeEditCatBtn').on('click', function(){
        $('#editCategory').off("hide.bs.modal").trigger("click").modal('hide');
		location.reload();
	});
	$('#closeEditCatIcon').on('click', function(){
        $('#editCategory').off("hide.bs.modal").trigger("click").modal('hide');
		location.reload();
	});
	
	$("#editCategoryBtn").on('click', function(){
		let catId = $("#editCatId").val();
		let catName = $("#editCategoryName").val();
		
		let formdata = new FormData();
		formdata.append('action','edit-category');
		formdata.append('catid',catId);
		formdata.append('catname',catName);
		
		$.ajax({
			url: 'assets/resources/scripts/scripts.php',
			type: 'POST',
			data: formdata,
			dataType: 'JSON',
			contentType: false,
			processData: false,
			beforeSend: function(){
				Swal.fire({
					title: 'Updating '+catName,
					html: "Please wait while we Update",
					allowOutsideClick: false,
					showConfirmButton: false,
					willOpen: () => {
						Swal.showLoading(); // show loading spinner
					}
				});
			},
			success: function(response) {
				if(response.header==='successful') {
					Swal.fire({
					  title: 'Category Updated',
					  html: response.message,
					  icon: 'success',
					  confirmButtonText: 'OK',
					  confirmButtonColor: '#3085d6',
					  customClass: {
						confirmButton: 'btn btn-success'
					  },
					  buttonsStyling: false,
					  allowOutsideClick: false,
					  allowEscapeKey: false
					});
				  }else {
					Swal.fire({
					  title: response.header,
					  html: response.message,
					  icon: 'error',
					  confirmButtonText: 'OK',
					  confirmButtonColor: '#d33',
					  customClass: {
						confirmButton: 'btn btn-danger'
					  },
					  allowOutsideClick: false,
					  allowEscapeKey: false,
					  buttonsStyling: false
					});
				  }
			}
		});
	});
	
	////////upload bulk questions//////
	$("#saveQuestions").on('click', function(){
		let errorMsg = '';
		let quizData = $("#bulkInput").val();
		let formdata = new FormData();
		formdata.append('quiz_data',quizData);
		formdata.append('action','upload-bulk-questions');
		
		let catId = $("#bulkCatId").val();
		if(catId){
			$("#bulkCatId").removeAttr('style');
			formdata.append('catid',catId);
		}
		else{
			$("#bulkCatId").attr('style','border-color: red;');
			if(errorMsg){
				errorMsg += '<br>Select Category';
			}
			else{
				errorMsg = 'Category Required';
			}
		}
		let testament = $("#bulkTestament").val();
		if(testament){
			$("#bulkTestament").removeAttr('style');
			formdata.append('testament',testament);
		}
		else{
			$("#bulkTestament").attr('style','border-color: red;');
			if(errorMsg){
				errorMsg += '<br>Testament Required';
			}
			else{
				errorMsg = 'Testament Required';
			}
		}
		let level = $("#bulkLevel").val();
		if(level){
			$("#bulkLevel").removeAttr('style');
			formdata.append('level',level);
		}
		else{
			$("#bulkLevel").attr('style','border-color: red;');
			if(errorMsg){
				errorMsg += '<br>Level Required';
			}
			else{
				errorMsg = 'Level Required';
			}
		}
		let ageCat = $("#bulkAgeCat").val();
		if(ageCat){
			$("#bulkAgeCat").removeAttr('style');
			formdata.append('agecat',ageCat);
		}
		else{
			$("#bulkAgeCat").attr('style','border-color: red;');
			if(errorMsg){
				errorMsg += '<br>Age Category Required';
			}
			else{
				errorMsg = 'Age Category Required';
			}
		}
		
		if(errorMsg){
			Swal.fire({
				icon: "error",
				title: "Error Occurred",
				html: errorMsg,
				confirmButtonClass: "btn btn-danger",
				allowOutsideClick: false,
				allowEscapeKey: false,
				allowEnterKey: false
			});
		}else{
			$.ajax({
				type: 'POST',
				url:'assets/resources/scripts/scripts.php',
				data: formdata,
				contentType: false,
				processData: false,
				dataType:'JSON',
				beforeSend: function(){
					$("#submitCategory").attr('disabled','disabled');
					Swal.fire({
						icon: "info",
						title: 'Uploading ',
						html: "Please, wait...",
						allowOutsideClick: false,
						showConfirmButton: false,
						willOpen: () => {
							Swal.showLoading(); // show loading spinner
						}
					});
				},
				success:function(responseData){
					if(responseData.header==='successful'){
						Swal.fire({
							icon: "success",
							title: "Success",
							html: responseData.message,
							confirmButtonClass: "btn btn-success",
							allowOutsideClick: false,
							allowEscapeKey: false,
							allowEnterKey: false
						});
					}
					else{
						errorMsg = '<span class="text-danger">'+responseData.message+'</span>';
						Swal.fire({
							icon: "error",
							title: "Error Occurred",
							html: errorMsg,
							confirmButtonClass: "btn btn-danger",
							allowOutsideClick: false,
							allowEscapeKey: false,
							allowEnterKey: false
						});
					}
				}
			});	
		}
	});
  
  // Close modal
  $("#closeEditQuesBtn").on('click', function(){
	  $('#previewModal').off("hide.bs.modal").trigger("click").modal('hide');
  });
  
  $("#closeEditQuesIcon").on('click', function(){
	  $('#previewModal').off("hide.bs.modal").trigger("click").modal('hide');
  });
  
  /////questions manager/////
  $("#question").on('blur', function(){
		let record = $(this).val();
		if(record){
			$(this).removeAttr('style');
		}
		else{
			$(this).attr('style','border-color: red;');
		}
	});
	
	$("#question").on('input', function(){
		let record = $(this).val();
		if(record){
			$(this).removeAttr('style');
		}
		else{
			$(this).attr('style','border-color: red;');
		}
	});
	
	$("#options").on('blur', function(){
		let record = $(this).val();
		if(record){
			$(this).removeAttr('style');
		}
		else{
			$(this).attr('style','border-color: red;');
		}
	});
	
	$("#options").on('input', function(){
		let record = $(this).val();
		if(record){
			$(this).removeAttr('style');
		}
		else{
			$(this).attr('style','border-color: red;');
		}
	});
	
	$("#correctAnswer").on('blur', function(){
		let record = $(this).val();
		if(record){
			$(this).removeAttr('style');
		}
		else{
			$(this).attr('style','border-color: red;');
		}
	});
	
	$("#correctAnswer").on('input', function(){
		let record = $(this).val();
		if(record){
			$(this).removeAttr('style');
		}
		else{
			$(this).attr('style','border-color: red;');
		}
	});
	
	$("#description").on('blur', function(){
		let record = $(this).val();
		if(record){
			$(this).removeAttr('style');
		}
		else{
			$(this).attr('style','border-color: red;');
		}
	});
	
	$("#description").on('input', function(){
		let record = $(this).val();
		if(record){
			$(this).removeAttr('style');
		}
		else{
			$(this).attr('style','border-color: red;');
		}
	});
	
	$("#catId").on('change', function(){
		let dataVal = $(this).val();
		if(dataVal){
			$(this).removeAttr('style');
		}
		else{
			$(this).attr('style','border-color: red;');
		}
	});
	
	$("#testament").on('change', function(){
		let dataVal = $(this).val();
		if(dataVal){
			$(this).removeAttr('style');
		}
		else{
			$(this).attr('style','border-color: red;');
		}
	});
	
	$("#level").on('change', function(){
		let dataVal = $(this).val();
		if(dataVal){
			$(this).removeAttr('style');
		}
		else{
			$(this).attr('style','border-color: red;');
		}
	});
	
	$("#ageCat").on('change', function(){
		let dataVal = $(this).val();
		if(dataVal){
			$(this).addClass('is-valid');
			$(this).removeClass('is-invalid');
		}
		else{
			$(this).addClass('is-invalid');
			$(this).removeClass('is-valid');
		}
	});
	
	$("#submitQuestion").on('click', function(){
		let errorMsg = '';
		let formdata = new FormData();
		
		let question = $("#question").val();
		if(question){
			$("#question").removeAttr('style');
			formdata.append('question',question);
		}
		else{
			$("#question").attr('style','border-color: red;');
			errorMsg = 'Question Required';
		}
		let options = $("#options").val();
		if(options){
			$("#options").removeAttr('style');
			formdata.append('options',options);
		}
		else{
			$("#options").attr('style','border-color: red;');
			if(errorMsg){
				errorMsg += '<br>Options Required';
			}
			else{
				errorMsg = 'Options Required';
			}
		}
		let correctAnswer = $("#correctAnswer").val();
		if(correctAnswer){
			$("#correctAnswer").removeAttr('style');
			formdata.append('correctAnswer',correctAnswer);
		}
		else{
			$("#correctAnswer").attr('style','border-color: red;');
			if(errorMsg){
				errorMsg += '<br>Correct Answer Required';
			}
			else{
				errorMsg = 'Correct Answer Required';
			}
		}
		let description = $("#description").val();
		if(description){
			$("#description").removeAttr('style');
			formdata.append('description',description);
		}
		else{
			$("#description").attr('style','border-color: red;');
			if(errorMsg){
				errorMsg += '<br>Description Required';
			}
			else{
				errorMsg = 'Description Required';
			}
		}
		
		let catId = $("#catId").val();
		if(catId){
			$("#catId").removeAttr('style');
			formdata.append('catid',catId);
		}
		else{
			$("#catId").attr('style','border-color: red;');
			if(errorMsg){
				errorMsg += '<br>Select Category';
			}
			else{
				errorMsg = 'Category Required';
			}
		}
		let testament = $("#testament").val();
		if(testament){
			$("#testament").removeAttr('style');
			formdata.append('testament',testament);
		}
		else{
			$("#testament").attr('style','border-color: red;');
			if(errorMsg){
				errorMsg += '<br>Testament Required';
			}
			else{
				errorMsg = 'Testament Required';
			}
		}
		let level = $("#level").val();
		if(level){
			$("#level").removeAttr('style');
			formdata.append('level',level);
		}
		else{
			$("#level").attr('style','border-color: red;');
			if(errorMsg){
				errorMsg += '<br>Level Required';
			}
			else{
				errorMsg = 'Level Required';
			}
		}
		let ageCat = $("#ageCat").val();
		if(ageCat){
			$("#ageCat").removeAttr('style');
			formdata.append('agecat',ageCat);
		}
		else{
			$("#ageCat").attr('style','border-color: red;');
			if(errorMsg){
				errorMsg += '<br>Age Category Required';
			}
			else{
				errorMsg = 'Age Category Required';
			}
		}
		
		if(!errorMsg){
			formdata.append('action','add-question');
			$.ajax({
				url: 'assets/resources/scripts/scripts.php',
				type: 'POST',
				data: formdata,
				dataType: 'JSON',
				contentType: false,
				processData: false,
				beforeSend: function(){
					Swal.fire({
						title: 'Adding Question',
						html: "Please wait while we create the quiz question",
						allowOutsideClick: false,
						showConfirmButton: false,
						willOpen: () => {
							Swal.showLoading(); // show loading spinner
						}
					});
				},
				success: function(response) {
					if(response.header==='successful') {
						Swal.fire({
						  title: 'Successful',
						  html: response.message,
						  icon: 'success',
						  confirmButtonText: 'OK',
						  confirmButtonColor: '#3085d6',
						  customClass: {
							confirmButton: 'btn btn-success'
						  },
						  buttonsStyling: false,
						  allowOutsideClick: false,
						  allowEscapeKey: false
						}).then((result) => {
							resetQuestionForm();
						});
					}else {
						Swal.fire({
						  title: response.header,
						  html: response.message,
						  icon: 'error',
						  confirmButtonText: 'OK',
						  confirmButtonColor: '#d33',
						  customClass: {
							confirmButton: 'btn btn-danger'
						  },
						  allowOutsideClick: false,
						  allowEscapeKey: false,
						  buttonsStyling: false
						});
					}
				}
			});
		}
		else{
			Swal.fire({
			  title: "Error Occurred!",
			  html: "<span class='text-danger'>"+errorMsg+"</span>",
			  icon: 'error',
			  confirmButtonText: 'OK',
			  confirmButtonColor: '#d33',
			  customClass: {
				confirmButton: 'btn btn-danger'
			  },
			  allowOutsideClick: false,
			  allowEscapeKey: false,
			  buttonsStyling: false
			});
		}
		
	});
	
	////////SETTING SCRIPTS//////  
	if(currentPage=='Setting'){
		$("#updateMail").on('click', function(){
			let mailPassword = $("#mailPassword").val();
			let formdata = new FormData();
			let errorMsg = '';
			if(!mailPassword){
				errorMsg = '<i class="fa fa-times"></i> Enter Mail Password';
			}
			else{
				formdata.append('mailPassword',mailPassword);
			}
			let mailAddress = $("#mailAddress").val();
			if(!mailAddress){
				if(errorMsg){
					errorMsg = '<br><i class="fa fa-times"></i> Enter Mail Username';
				}
				else{
					errorMsg = '<i class="fa fa-times"></i> Enter Mail Username';
				}
			}
			else{
				formdata.append('mailAddress',mailAddress);
			}
			let mailPort = $("#mailPort").val();
			if(!mailPort){
				if(errorMsg){
					errorMsg = '<br><i class="fa fa-times"></i> Enter Mail Port';
				}
				else{
					errorMsg = '<i class="fa fa-times"></i> Enter Mail Port';
				}
			}
			else{
				formdata.append('mailPort',mailPort);
			}
			let mailHost = $("#mailHost").val();
			if(!mailHost){
				if(errorMsg){
					errorMsg = '<br><i class="fa fa-times"></i> Enter Mail Host';
				}
				else{
					errorMsg = '<i class="fa fa-times"></i> Enter Mail Host';
				}
			}
			else{
				formdata.append('mailHost',mailHost);
			}
			
			if(errorMsg){
				Swal.fire({
				  title: response.header,
				  html: errorMsg,
				  icon: 'error',
				  confirmButtonText: 'OK',
				  confirmButtonColor: '#d33',
				  customClass: {
					confirmButton: 'btn btn-danger'
				  },
				  allowOutsideClick: false,
				  allowEscapeKey: false,
				  buttonsStyling: false
				});
			}
			else{
				emailSetting(formdata);
			}
		});
		
		function emailSetting(formdata){
			formdata.append('action','add-email-setting');
			$.ajax({
				url: 'assets/resources/scripts/scripts.php',
				type: 'POST',
				data: formdata,
				dataType: 'JSON',
				contentType: false,
				processData: false,
				beforeSend: function(){
					Swal.fire({
						title: 'Updating Email Setting',
						html: "Please, wait while we update the details",
						allowOutsideClick: false,
						showConfirmButton: false,
						willOpen: () => {
							Swal.showLoading(); // show loading spinner
						}
					});
				},
				success: function(response) {
					if(response.header==='successful') {
						Swal.fire({
						  title: 'Email Details Updated',
						  html: 'Mail details successfully updated.',
						  icon: 'success',
						  confirmButtonText: 'OK',
						  confirmButtonColor: '#3085d6',
						  customClass: {
							confirmButton: 'btn btn-success'
						  },
						  buttonsStyling: false,
						  allowOutsideClick: false,
						  allowEscapeKey: false
						});
					}else{
						Swal.fire({
						  title: response.header,
						  html: response.message,
						  icon: 'error',
						  confirmButtonText: 'OK',
						  confirmButtonColor: '#d33',
						  customClass: {
							confirmButton: 'btn btn-danger'
						  },
						  allowOutsideClick: false,
						  allowEscapeKey: false,
						  buttonsStyling: false
						});
					}
				},
				error: function(jqXHR, textStatus, errorThrown) {
					// Display detailed error information
					console.error("AJAX Request Error:");
					console.error("Status: " + textStatus); // Status of the request (e.g., "error", "timeout")
					console.error("Error Thrown: " + errorThrown); // Textual portion of the error
					console.error("Response Text: " + jqXHR.responseText); // Response from the server, if any
					Swal.fire({
					  title: "Error occurred",
					  html: "Critical Error occurred: "+jqXHR.responseText,
					  icon: 'error',
					  confirmButtonText: 'OK',
					  confirmButtonColor: '#d33',
					  customClass: {
						confirmButton: 'btn btn-danger'
					  },
					  allowOutsideClick: false,
					  allowEscapeKey: false,
					  buttonsStyling: false
					});
				}
			});
		}
		
		///////////subscription plans setting/////////
		$(document).delegate("[data-bs-target='#addPlan']", "click", function() {
			$('#addPlan').on('hide.bs.modal', function(e) {
				e.preventDefault();
			});
		});
		$('#closeAddPlanBtn').on('click', function(){
			$('#addPlan').off("hide.bs.modal").trigger("click").modal('hide');
			location.href="./";
		});
		$('#closeAddPlanIcon').on('click', function(){
			$('#addPlan').off("hide.bs.modal").trigger("click").modal('hide');
			location.href="./";
		});
		
		$("#submitPlan").on('click', function(){
			let formdata = new FormData();
			let errorMsg = '';
			let SubName 	= $("#SubName").val();
			if(SubName){
				formdata.append('SubName',SubName);
			}
			else{
				errorMsg = '<i class="fa fa-times"></i> Plan Name is Required';
			}
			let Amount 		= $("#Amount").val();
			if(Amount){
				if(isNaN(Amount)){
					if(errorMsg){
						errorMsg = '<br><i class="fa fa-times"></i> Amount must be a number.';
					}
					else{
						errorMsg = '<i class="fa fa-times"></i> Amount must be a number';
					}
				}
				else{
					formdata.append('Amount',Amount);
				}
			}
			else{
				if(errorMsg){
					errorMsg = '<br><i class="fa fa-times"></i> Amount is Required.';
				}
				else{
					errorMsg = '<i class="fa fa-times"></i> Amount is Required';
				}
			}
			let Discount 	= $("#Discount").val();
			if(Discount){
				if(isNaN(Discount)){
					if(errorMsg){
						errorMsg = '<br><i class="fa fa-times"></i> Discount value must be a number.';
					}
					else{
						errorMsg = '<i class="fa fa-times"></i> Discount Value must be a number';
					}
				}
				else{
					formdata.append('Discount',Discount);
				}
			}
			else{
				if(errorMsg){
					errorMsg = '<br><i class="fa fa-times"></i> Discount Value is Required.';
				}
				else{
					errorMsg = '<i class="fa fa-times"></i> Discount Value is Required';
				}
			}
			let Lv1Bonus	= $("#Lv1Bonus").val();
			if(Lv1Bonus){
				if(isNaN(Lv1Bonus)){
					if(errorMsg){
						errorMsg = '<br><i class="fa fa-times"></i> Level 1 Bonus value must be a number.';
					}
					else{
						errorMsg = '<i class="fa fa-times"></i> Level 1 Bonus Value must be a number';
					}
				}
				else{
					formdata.append('Lv1Bonus',Lv1Bonus);
				}
			}
			else{
				if(errorMsg){
					errorMsg = '<br><i class="fa fa-times"></i> Level 1 Bonus value is Required.';
				}
				else{
					errorMsg = '<i class="fa fa-times"></i> Level 1 Bonus value is Required';
				}
			}
			let Lv2Bonus	= $("#Lv2Bonus").val();
			if(Lv2Bonus){
				if(isNaN(Lv2Bonus)){
					if(errorMsg){
						errorMsg = '<br><i class="fa fa-times"></i> Level 2 Bonus value must be a number.';
					}
					else{
						errorMsg = '<i class="fa fa-times"></i> Level 2 Bonus Value must be a number';
					}
				}
				else{
					formdata.append('Lv2Bonus',Lv2Bonus);
				}
			}
			else{
				if(errorMsg){
					errorMsg = '<br><i class="fa fa-times"></i> Level 2 Bonus value is Required.';
				}
				else{
					errorMsg = '<i class="fa fa-times"></i> Level 2 Bonus value is Required';
				}
			}
			let Lv3Bonus	= $("#Lv3Bonus").val();
			if(Lv3Bonus){
				if(isNaN(Lv3Bonus)){
					if(errorMsg){
						errorMsg = '<br><i class="fa fa-times"></i> Level 3 Bonus value must be a number.';
					}
					else{
						errorMsg = '<i class="fa fa-times"></i> Level 3 Bonus Value must be a number';
					}
				}
				else{
					formdata.append('Lv3Bonus',Lv3Bonus);
				}
			}
			else{
				if(errorMsg){
					errorMsg = '<br><i class="fa fa-times"></i> Level 3 Bonus value is Required.';
				}
				else{
					errorMsg = '<i class="fa fa-times"></i> Level 3 Bonus value is Required';
				}
			}
			let Description	= $("#Description").val();
			if(Description){
				formdata.append('Description',Description);
			}
			
			if(errorMsg){
				Swal.fire({
					icon: "error",
					title: "Error Occurred",
					html: "<span class='text-danger'>"+errorMsg+"</span>",
					confirmButtonClass: "btn btn-danger",
					allowOutsideClick: false,
					allowEscapeKey: false,
					allowEnterKey: false
				});
			}
			else{
				formdata.append('action','add-new-plan');
				$.ajax({
					url: 'assets/resources/scripts/scripts.php',
					type: 'POST',
					data: formdata,
					contentType: false,
					processData: false,
					dataType:'JSON',
					beforeSend:function(){
						$("#submitPlan").html('<i class="fa fa-spinner fa-spin"></i>...saving').attr('disabled','disabled');
					},
					success: function (response){
						if(response.header==='successful') {
							alertify.success("<i class='fa fa-check'></i> <b>"+SubName+"</b> Successfully Added.");
							$("#SubName").val('');
							$("#Amount").val('');
							$("#Discount").val('');
							$("#Description").val('');
							$("#Lv1Bonus").val('');
							$("#Lv2Bonus").val('');
							$("#Lv3Bonus").val('');
						}else {
							alertify.error("<i class='fa fa-times'></i> "+response.message);
						}
						$("#submitPlan").html('Submit').removeAttr('disabled');
					}
				});
			}
		});
		
		//////delete multiple categories//////
		$(".delete-all-plans").on('click', function(){
			let planIds = $("#selectedId").val();
			let planNames = $("#selectedNames").val();
			
			Swal.fire({
			  title: 'Delete Subscription Plans',
			  html: planNames+" will be deleted.<br>Are you sure you want to continue?",
			  icon: 'warning',
			  showCancelButton: true,
			  confirmButtonText: 'Yes, Delete',
			  cancelButtonText: 'Cancel',
			  confirmButtonColor: '#3085d6',
			  cancelButtonColor: '#d33',
			  customClass: {
				confirmButton: 'btn btn-danger',
				cancelButton: 'btn btn-secondary ml-1',
			  },
			  buttonsStyling: false,
			  allowOutsideClick: false,
			  allowEscapeKey: false
			}).then((result) => {
				if (result.isConfirmed) {
					let formdata = new FormData();
					formdata.append('action','delete-plans');
					formdata.append('planids',planIds);
					$.ajax({
						url: 'assets/resources/scripts/scripts.php',
						type: 'POST',
						data: formdata,
						contentType: false,
						processData: false,
						dataType:'JSON',
						beforeSend:function(){
							Swal.fire({
								title: 'Deleting Subscription Plans...',
								html: "We are deleting all the selected Subscription plans. Please wait...",
								allowOutsideClick: false,
								allowEscapeKey: false,
								allowEnterKey: false,
								showConfirmButton: false,
								willOpen: () => {
									Swal.showLoading();
								}
							});
						},
						success: function (response){
						  if (response.header==='successful') {
							Swal.fire({
							  title: 'Subscription Plans Successfully Deleted',
							  html: response.message,
							  icon: 'success',
							  confirmButtonText: 'OK',
							  confirmButtonColor: '#3085d6',
							  customClass: {
								confirmButton: 'btn btn-success'
							  },
							  buttonsStyling: false
							}).then((result) => {
								location.href="./";
							});
						  }else {
							Swal.fire({
							  title: response.header,
							  html: response.message,
							  icon: 'error',
							  confirmButtonText: 'OK',
							  confirmButtonColor: '#d33',
							  customClass: {
								confirmButton: 'btn btn-danger'
							  },
							  buttonsStyling: false
							});
						  }
						},
						error: function(){
						  // Handle error when the request fails
						  Swal.fire({
							title: 'Error!',
							text: 'Something went wrong While Deleting Subscription Plans. Please try again later.',
							icon: 'error',
							confirmButtonText: 'OK',
							confirmButtonColor: '#d33',
							customClass: {
							  confirmButton: 'btn btn-danger'
							},
							buttonsStyling: false
						  });
						}
					});
				}
			});
		});
		
		$(".change-status-plan").on('click', function(){
			let planId = $(this).attr('data-id');
			let planName = $(this).attr('name');
			let formdata = new FormData();
			
			formdata.append('action','change-plan-status');
			formdata.append('planid',planId);
			$.ajax({
				url: 'assets/resources/scripts/scripts.php',
				type: 'POST',
				data: formdata,
				contentType: false,
				processData: false,
				dataType:'JSON',
				beforeSend:function(){
					Swal.fire({
						title: 'Updating',
						html: "Please, wait...",
						allowOutsideClick: false,
						allowEscapeKey: false,
						allowEnterKey: false,
						showConfirmButton: false,
						willOpen: () => {
							Swal.showLoading();
						}
					});
				},
				success: function (response){
				  if(response.header==='successful') {
					Swal.fire({
					  title: 'Plan Updated',
					  html: planName+" "+response.message,
					  icon: 'success',
					  confirmButtonText: 'OK',
					  confirmButtonColor: '#3085d6',
					  customClass: {
						confirmButton: 'btn btn-success'
					  },
					  buttonsStyling: false
					});
				  }else {
					Swal.fire({
					  title: response.header,
					  html: response.message,
					  icon: 'error',
					  confirmButtonText: 'OK',
					  confirmButtonColor: '#d33',
					  customClass: {
						confirmButton: 'btn btn-danger'
					  },
					  buttonsStyling: false
					});
				  }
				},
				error: function(){
				  // Handle error when the request fails
				  Swal.fire({
					title: 'Error!',
					text: 'Something went wrong While updating plan. Please try again later.',
					icon: 'error',
					confirmButtonText: 'OK',
					confirmButtonColor: '#d33',
					customClass: {
					  confirmButton: 'btn btn-danger'
					},
					buttonsStyling: false
				  });
				}
			});
			
		});
		
		////delete single category///////
		$(".delete-plan").on('click', function(){
			let planId = $(this).attr('data-id');
			let planName = $(this).attr('name');
			
			Swal.fire({
				title: "Delete " + planName,
				html: "This Plan will de deleted.<br>You won't be able to revert this!",
				icon: "warning",
				showCancelButton: true,
				confirmButtonColor: "#3085d6",
				cancelButtonColor: "#d33",
				confirmButtonText: "<i class='fa fa-check-circle'></i> Yes, Delete",
				confirmButtonClass: "btn btn-danger",
				cancelButtonClass: "btn btn-secondary ml-1",
				allowOutsideClick: false,
				allowEscapeKey: false,
				allowEnterKey: true
			}).then(function(result){
				if(result.value) {
					let formdata = new FormData();
					formdata.append('planid',planId);
					formdata.append('action','delete-plan');
					
					$.ajax({
						url: 'assets/resources/scripts/scripts.php',
						type: 'POST',
						data: formdata,
						dataType: 'JSON',
						contentType: false,
						processData: false,
						beforeSend: function(){
							Swal.fire({
								title: 'Deleting '+planName,
								html: "Please wait while we delete...",
								allowOutsideClick: false,
								showConfirmButton: false,
								willOpen: () => {
									Swal.showLoading(); // show loading spinner
								}
							});
						},
						success: function(response) {
							// Check if deletion was successful
							if(response.header==='successful') {
								Swal.fire({
									title: "Successful",
									html: planName+" "+response.message,
									icon: "success",
									showCancelButton: true,
									confirmButtonColor: "#3085d6",
									cancelButtonColor: "#d33",
									confirmButtonText: "<i class='fa fa-redo'></i> Undo",
									confirmButtonClass: "btn btn-success",
									cancelButtonClass: "btn btn-secondary ml-1",
									allowOutsideClick: false,
									allowEscapeKey: false,
									allowEnterKey: true
								}).then(function(result){
									if (result.isConfirmed) {
										let formdata = new FormData();
										formdata.append('action','restore-plan');
										formdata.append('planid',planId);
										 
										$.ajax({
											url: 'assets/resources/scripts/scripts.php',
											type: 'POST',
											data: formdata,
											dataType: 'JSON',
											contentType: false,
											processData: false,
											beforeSend: function(){
												Swal.fire({
													title: 'Restoring '+planName,
													html: "Please wait while we Undo the delete...",
													allowOutsideClick: false,
													showConfirmButton: false,
													willOpen: () => {
														Swal.showLoading(); // show loading spinner
													}
												});
											},
											success: function(response) {
												if(response.header==='successful') {
													Swal.fire({
													  title: 'Plan Restored',
													  html: planName+" "+response.message,
													  icon: 'success',
													  confirmButtonText: 'OK',
													  confirmButtonColor: '#3085d6',
													  customClass: {
														confirmButton: 'btn btn-success'
													  },
													  buttonsStyling: false,
													  allowOutsideClick: false,
													  allowEscapeKey: false
													});
												}else{
													Swal.fire({
													  title: response.header,
													  html: '<span class="text-danger">'+response.message+'</span>',
													  icon: 'error',
													  confirmButtonText: 'OK',
													  confirmButtonColor: '#d33',
													  customClass: {
														confirmButton: 'btn btn-danger'
													  },
													  allowOutsideClick: false,
													  allowEscapeKey: false,
													  buttonsStyling: false
													});
												}
											}
										});
									} else if (result.dismiss === Swal.DismissReason.cancel) {
										location.href="./";
									}
								});
							} else {
								Swal.fire({
									icon: "error",
									title: "Error Occurred",
									text: '<span class="text-danger">'+response.message+'</span>',
									confirmButtonClass: "btn btn-danger",
									allowOutsideClick: false,
									allowEscapeKey: false,
									allowEnterKey: false
								});
							}
						},
						error: function() {
							// Handle error during AJAX call
							Swal.fire({
								icon: "error",
								title: "Error!",
								text: "Something went wrong. Please try again later.",
								confirmButtonClass: "btn btn-danger",
								allowOutsideClick: false,
								allowEscapeKey: false,
								allowEnterKey: false
							});
						}
					});
				}
			});
		});
		
		$(".restore-plan").on('click', function(){
			let planId = $(this).attr('data-id');
			let planName = $(this).attr('name');
			
			Swal.fire({
				title: "Restore " + planName,
				html: "This Plan will de Restored.<br>Do you wish to proceed?",
				icon: "warning",
				showCancelButton: true,
				confirmButtonColor: "#3085d6",
				cancelButtonColor: "#d33",
				confirmButtonText: "<i class='fa fa-check-circle'></i> Yes, Restore",
				confirmButtonClass: "btn btn-danger",
				cancelButtonClass: "btn btn-secondary ml-1",
				allowOutsideClick: false,
				allowEscapeKey: false,
				allowEnterKey: true
			}).then(function(result){
				if(result.value) {
					let formdata = new FormData();
					formdata.append('action','restore-plan');
					formdata.append('planid',planId);
					 
					$.ajax({
						url: 'assets/resources/scripts/scripts.php',
						type: 'POST',
						data: formdata,
						dataType: 'JSON',
						contentType: false,
						processData: false,
						beforeSend: function(){
							Swal.fire({
								title: 'Restoring '+planName,
								html: "Please wait while we Undo the delete...",
								allowOutsideClick: false,
								showConfirmButton: false,
								willOpen: () => {
									Swal.showLoading(); // show loading spinner
								}
							});
						},
						success: function(response) {
							if(response.header==='successful') {
								Swal.fire({
								  title: 'Plan Restored',
								  html: planName+" "+response.message,
								  icon: 'success',
								  confirmButtonText: 'OK',
								  confirmButtonColor: '#3085d6',
								  customClass: {
									confirmButton: 'btn btn-success'
								  },
								  buttonsStyling: false,
								  allowOutsideClick: false,
								  allowEscapeKey: false
								}).then(function() {
									location.reload();
								});
							}else{
								Swal.fire({
								  title: response.header,
								  html: '<span class="text-danger">'+response.message+'</span>',
								  icon: 'error',
								  confirmButtonText: 'OK',
								  confirmButtonColor: '#d33',
								  customClass: {
									confirmButton: 'btn btn-danger'
								  },
								  allowOutsideClick: false,
								  allowEscapeKey: false,
								  buttonsStyling: false
								});
							}
						}
					});
				}
			});
		});
		
		////edit category//////
		$(document).delegate("[data-bs-target='#editRole']", "click", function() {
			$('#editRole').on('hide.bs.modal', function(e) {
				e.preventDefault();
			});
			
			let roleId = $(this).attr('data-id');
			let roleName = $(this).attr('name');
			let roleDescription = $(this).attr('description');
			$("#editRoleId").val(roleId);
			$("#editRoleName").val(roleName);
			$("#editRoleDescription").val(roleDescription);
			
		});
		$('#closeEditRoleBtn').on('click', function(){
			$('#editRole').off("hide.bs.modal").trigger("click").modal('hide');
		});
		$('#closeEditRoleIcon').on('click', function(){
			$('#editRole').off("hide.bs.modal").trigger("click").modal('hide');
		});
		
		$("#editRoleBtn").on('click', function(){
			let roleId = $("#editRoleId").val();
			
			let formdata = new FormData();
			let errorMsg = '';
			let roleName = $("#editRoleName").val();
			if(roleName){
				formdata.append('roleName',roleName);
				$("#editRoleName").removeAttr('style');
			}
			else{
				$("#editRoleName").attr('style','border-color: red;');
				errorMsg = '<i class="fa fa-times"></i> Enter Role Name';
			}
			let roleDescription = $("#editRoleDescription").val();
			if(roleDescription){
				formdata.append('roleDescription',roleDescription);
				$("#editRoleDescription").removeAttr('style');
			}
			else{
				$("#editRoleDescription").attr('style','border-color: red;');
				if(errorMsg){
					errorMsg += '<br><i class="fa fa-times"></i> Enter Role Description';
				}
				else{
					errorMsg = '<i class="fa fa-times"></i> Enter Role Description';
				}
			}
			formdata.append('action','edit-role');
			formdata.append('roleId',roleId);
			
			$.ajax({
				url: 'assets/resources/scripts/scripts.php',
				type: 'POST',
				data: formdata,
				dataType: 'JSON',
				contentType: false,
				processData: false,
				beforeSend: function(){
					$("#editRoleBtn").html('<i class="fa fa-spinner fa-spin"></i> ...Updating').attr('disabled','disabled');
				},
				success: function(response) {
					if(response.header==='successful') {
						alertify.success(response.message);
						$("#editRoleBtn").html('<i class="fa fa-save"></i> Save').removeAttr('disabled');
						reloadRoles();
						$("#editRole").modal('hide');
					}else {
						alertify.error(response.message);
						$("#editRoleBtn").html('<i class="fa fa-save"></i> Save').removeAttr('disabled');
					}
				}
			});
		});
		
		function reloadRoles(){
			$.ajax({
				url: 'assets/resources/scripts/scripts.php',
				type: 'POST',
				data: formdata,
				dataType: 'JSON',
				contentType: false,
				processData: false,
				beforeSend: function(){
					
				},
				success: function(response) {
					$("#roleDetails").html(response.data);
				}
			});
		}
		
		$("#submitRole").on('click', function(){
			let formdata = new FormData();
			let errorMsg = '';
			let roleName = $("#addRoleName").val();
			if(roleName){
				formdata.append('roleName',roleName);
			}
			else{
				errorMsg = '<i class="fa fa-times"></i> Enter Role Type';
				$("#roleName").attr('style','border-color: red;');
			}
			let roleDescription = $("#addRoleDescription").val();
			if(roleDescription){
				formdata.append('roleDescription',roleDescription);
			}
			else{
				if(errorMsg){
					errorMsg = '<br><i class="fa fa-times"></i> Enter Role Description';
				}
				else{
					errorMsg = '<i class="fa fa-times"></i> Enter Role Description';
				}
				$("#roleDescription").addClass('is-invalid');
			}
			
			if(!errorMsg){
				formdata.append('action','add-new-role');
				
				$.ajax({
					url: 'assets/resources/scripts/scripts.php',
					type: 'POST',
					data: formdata,
					dataType: 'JSON',
					contentType: false,
					processData: false,
					beforeSend: function(){
						Swal.fire({
							title: 'Adding New Role',
							html: "Please wait while we add the new role",
							allowOutsideClick: false,
							showConfirmButton: false,
							willOpen: () => {
								Swal.showLoading(); // show loading spinner
							}
						});
					},
					success: function(response) {
						if(response.header==='successful') {
							Swal.fire({
							  title: 'Successful',
							  html: "Role Successfully Added",
							  icon: 'success',
							  confirmButtonText: 'OK',
							  confirmButtonColor: '#3085d6',
							  customClass: {
								confirmButton: 'btn btn-success'
							  },
							  buttonsStyling: false,
							  allowOutsideClick: false,
							  allowEscapeKey: false
							}).then(function() {
								$("#addRoleName").val('');
								$("#addRoleDescription").val('');
							});
						}else {
							Swal.fire({
							  title: response.header,
							  html: '<span class="text-danger">'+response.message+'</span>',
							  icon: 'error',
							  confirmButtonText: 'OK',
							  confirmButtonColor: '#d33',
							  customClass: {
								confirmButton: 'btn btn-danger'
							  },
							  allowOutsideClick: false,
							  allowEscapeKey: false,
							  buttonsStyling: false
							});
						}
					}
				});
			}
			else{
				Swal.fire({
				  title: 'Error Occurred',
				  html: '<span class="text-danger">'+errorMsg+'</span>',
				  icon: 'error',
				  confirmButtonText: 'OK',
				  confirmButtonColor: '#d33',
				  customClass: {
					confirmButton: 'btn btn-danger'
				  },
				  allowOutsideClick: false,
				  allowEscapeKey: false,
				  buttonsStyling: false
				});
			}
		});
		
		$("#closeAddRoleIcon").on('click', function(){
			location.reload();
		});
		$("#closeAddRoleBtn").on('click', function(){
			location.reload();
		});
		
		$(".change-role-status").on('click', function(){
			let roleId = $(this).attr('data-id');
			let roleName = $(this).attr('name');
			let formdata = new FormData();
			
			formdata.append('action','change-role-status');
			formdata.append('roleId',roleId);
			$.ajax({
				url: 'assets/resources/scripts/scripts.php',
				type: 'POST',
				data: formdata,
				contentType: false,
				processData: false,
				dataType:'JSON',
				beforeSend:function(){
					Swal.fire({
						title: 'Updating Role',
						html: "Please, wait...",
						allowOutsideClick: false,
						allowEscapeKey: false,
						allowEnterKey: false,
						showConfirmButton: false,
						willOpen: () => {
							Swal.showLoading();
						}
					});
				},
				success: function (response){
				  if(response.header==='successful') {
					Swal.fire({
					  title: 'Role Updated',
					  html: roleName+" "+response.message,
					  icon: 'success',
					  confirmButtonText: 'OK',
					  confirmButtonColor: '#3085d6',
					  customClass: {
						confirmButton: 'btn btn-success'
					  },
					  buttonsStyling: false
					});
				  }else {
					Swal.fire({
					  title: response.header,
					  html: '<span class="text-danger">'+response.message+'</span>',
					  icon: 'error',
					  confirmButtonText: 'OK',
					  confirmButtonColor: '#d33',
					  customClass: {
						confirmButton: 'btn btn-danger'
					  },
					  buttonsStyling: false
					});
				  }
				}
			});
			
		});
		
		////delete single category///////
		$(".delete-role").on('click', function(){
			let roleId = $(this).attr('data-id');
			let roleName = $(this).attr('name');
			
			Swal.fire({
				title: "Delete " + roleName,
				html: "<span class='text-danger'>This Role will de deleted and You won't be able to revert this!</span>",
				icon: "warning",
				showCancelButton: true,
				confirmButtonColor: "#3085d6",
				cancelButtonColor: "#d33",
				confirmButtonText: "<i class='fa fa-check-circle'></i> Yes, Delete",
				confirmButtonClass: "btn btn-danger",
				cancelButtonClass: "btn btn-secondary ml-1",
				allowOutsideClick: false,
				allowEscapeKey: false,
				allowEnterKey: true
			}).then(function(result){
				if(result.value) {
					let formdata = new FormData();
					formdata.append('roleId',roleId);
					formdata.append('action','delete-role');
					
					$.ajax({
						url: 'assets/resources/scripts/scripts.php',
						type: 'POST',
						data: formdata,
						dataType: 'JSON',
						contentType: false,
						processData: false,
						beforeSend: function(){
							Swal.fire({
								title: 'Deleting '+roleName,
								html: "Please wait while we delete the role...",
								allowOutsideClick: false,
								showConfirmButton: false,
								willOpen: () => {
									Swal.showLoading(); // show loading spinner
								}
							});
						},
						success: function(response) {
							// Check if deletion was successful
							if(response.header==='successful') {
								Swal.fire({
									title: "Successful",
									html: roleName+" "+response.message,
									icon: "success",
									showCancelButton: true,
									confirmButtonColor: "#3085d6",
									cancelButtonColor: "#d33",
									confirmButtonText: "<i class='fa fa-redo'></i> Undo",
									confirmButtonClass: "btn btn-success",
									cancelButtonClass: "btn btn-secondary ml-1",
									allowOutsideClick: false,
									allowEscapeKey: false,
									allowEnterKey: true
								}).then(function(result){
									if (result.isConfirmed) {
										let formdata = new FormData();
										formdata.append('action','restore-cat');
										formdata.append('roleId',roleId);
										 
										$.ajax({
											url: 'assets/resources/scripts/scripts.php',
											type: 'POST',
											data: formdata,
											dataType: 'JSON',
											contentType: false,
											processData: false,
											beforeSend: function(){
												Swal.fire({
													title: 'Restoring '+roleName,
													html: "Please wait while we Undo the delete...",
													allowOutsideClick: false,
													showConfirmButton: false,
													willOpen: () => {
														Swal.showLoading(); // show loading spinner
													}
												});
											},
											success: function(response) {
												if(response.header==='successful') {
													Swal.fire({
													  title: 'Role Restored',
													  html: roleName+" "+response.message,
													  icon: 'success',
													  confirmButtonText: 'OK',
													  confirmButtonColor: '#3085d6',
													  customClass: {
														confirmButton: 'btn btn-success'
													  },
													  buttonsStyling: false,
													  allowOutsideClick: false,
													  allowEscapeKey: false
													});
												}else {
													Swal.fire({
													  title: response.header,
													  html: '<span class="text-danger">'+response.message+'</span>',
													  icon: 'error',
													  confirmButtonText: 'OK',
													  confirmButtonColor: '#d33',
													  customClass: {
														confirmButton: 'btn btn-danger'
													  },
													  allowOutsideClick: false,
													  allowEscapeKey: false,
													  buttonsStyling: false
													});
												}
											}
										});
									} else if (result.dismiss === Swal.DismissReason.cancel) {
										location.href="./";
									}
								});
							}else {
								Swal.fire({
									icon: "error",
									title: "Error Occurred",
									text: '<span class="text-danger">'+response.message+'</span>',
									confirmButtonClass: "btn btn-danger",
									allowOutsideClick: false,
									allowEscapeKey: false,
									allowEnterKey: false
								});
							}
						}
					});
				}
			});
		});
	}
	
  
	
	///////COUNTRY, STATE, CITY///////
	$("#country").on('change', function(){
        var country = $(this).val();
        //alert(country);
        if(country){
			$(this).removeClass('is-invalid');
            $("#country").removeClass('is-invalid');
            $.ajax({
                type: 'POST',
                url:'resources/scripts/settings/website.php',
                data:'action=load-country-states&countryid='+country,
                success:function(responseData){
                    //alert(responseData);
                    $("#state").html(responseData);
                    $("#city").html('<option value="">Select State First</option>');
                }
            });
        }
        else{
            $("#country").addClass('is-invalid');
            $("#state").html('<option value="">Select Country First</option>');
            $("#city").html('<option value="">Select State First</option>');
			$(this).addClass('is-invalid');
        }
    })

    $("#state").on('change', function(){
        var state = $(this).val();
        if(state){
			$(this).removeClass('is-invalid');
            $.ajax({
                type: 'POST',
                url:'resources/scripts/settings/website.php',
                data:'action=load-new-cities&stateid='+state,
                success:function(responseData){
                    //alert(responseData);
                    $("#city").html(responseData);
                    $("#cityMarket").html(responseData);
                }
            });
        }
        else{
            $("#city").html('<option value="">Select State First</option>');
            $("#cityMarket").html('<option value="">Select State First</option>');
			$(this).addClass('is-invalid');
        }
    });

    $("#city").on('change', function(){
        var city = $(this).val();
        //alert(state);
        if(city){
            $(this).removeClass('is-invalid');
        }
        else{
            $(this).addClass('is-invalid');
			
        }
    });
});