<?php 
	//$password = md5('passw0rd');
	$title = $appName.' | User Sign In';
?>
<!DOCTYPE html>
<html lang="en">
	<head>
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
		<meta name="description" content="POS - Bootstrap Admin Template">
		<meta name="keywords" content="admin, estimates, bootstrap, business, corporate, creative, invoice, html5, responsive, Projects">
		<meta name="author" content="Dreamguys - Bootstrap Admin Template">
		<meta name="robots" content="noindex, nofollow">
		<title><?php echo $title; ?></title>

		<link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">

		<link rel="stylesheet" href="assets/css/bootstrap.min.css">

		<link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
		<link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">

		<link rel="stylesheet" href="assets/css/style.css">
		
		<script src="https://kit.fontawesome.com/4600147d2b.js" crossorigin="anonymous"></script>  
		<script src="../jquery.min.js"></script>
		<script src="https://code.jquery.com/jquery-3.7.0.min.js" type="text/javascript"></script>
	</head>
<body class="account-page">

	<div class="main-wrapper">
		<div class="account-content">
			<div class="login-wrapper">
				<div class="login-content">
					<div class="login-userset">
						<div class="login-logo">
							<img src="assets/img/logo.png" alt="img">
						</div>
						<div class="login-userheading">
							<h3>Sign In</h3>
							<h4 id="loginMsg">Login to access your Dashboard</h4>
						</div>
						<div class="form-login">
							<label>Email</label>
							<div class="form-addons">
								<input type="text" id="username" placeholder="Enter your email address">
								<img src="assets/img/icons/mail.svg" alt="img">
							</div>
						</div>
						<div class="form-login">
							<label>Password</label>
							<div class="pass-group">
								<input type="password" id="password" class="pass-input" placeholder="Enter your password">
								<span class="fas toggle-password fa-eye-slash"></span>
							</div>
						</div>
						<div class="form-login">
							<div class="alreadyuser">
								<h4><a href="./?action=forgot-password" class="hover-a">Forgot Password?</a></h4>
							</div>
						</div>
						<div class="form-login">
							<button type="button" id="loginBtn" class="btn btn-login bg-success">Sign In <i class="fas fa-sign-in"></i></button>
						</div>
					</div>
				</div>
				<div class="login-img">
					<img src="assets/img/login-1.jpg" alt="img">
				</div>
			</div>
		</div>
	</div>

	<script>
		$(document).ready(function(){
			$("#loginBtn").on('click', function(){
				let formdata = new FormData();
				let errorMsg = '';
				let username = $("#username").val();
				if(username){
					formdata.append('username',username);
				}
				else{
					if(errorMsg){
						errorMsg += '<br><i class="fa fa-times-circle"></i> Enter Email';
					}
					else{
						errorMsg = '<i class="fa fa-times-circle"></i> Enter Email';
					}
				}
				
				let password = $("#password").val();
				if(password){
					formdata.append('password',password);
				}
				else{
					if(errorMsg){
						errorMsg += '<br><i class="fa fa-times-circle"></i> Enter your password';
					}
					else{
						errorMsg = '<i class="fa fa-times-circle"></i> Enter your password';
					}
				}
				
				
				if(errorMsg){
					$("#loginMsg").html(errorMsg).addClass('text-danger');
				}
				else{
					formdata.append('action','login');
					$.ajax({
						type:'POST',
						url:'./assets/resources/scripts/useraccount.php',
						data:formdata,
						dataType: 'JSON',
						contentType: false,
						processData: false,
						beforeSend: function(){
							$("#loginBtn").html('<i class="fas fa-spinner fa-spin"></i>...Please, wait').attr('disable');
						},
						success:function(responseData){
							//alert(responseData);
							if(responseData.header == 'successful'){
								//$("#loginMsg").html('Login Successful. Loading Dashboard...<i class="fas fa-spinner fa-spin"></i>').removeClass('text-danger').addClass('text-success');
								$("#loginBtn").html('<i class="fas fa-spinner fa-spin"></i>...Loading Dashboard');
								Swal.fire({
									title: 'Login Successful',
									html: "Loading Dashboard. Please wait...",
									allowOutsideClick: false,
									showConfirmButton: false,
									willOpen: () => {
										Swal.showLoading(); // show loading spinner
									}
								});
								location.href=responseData.redirect;
							}
							else{
								$("#loginBtn").removeAttr('disabled').html('Sign In <i class="fas fa-sign-in"></i>');
								//$("#loginMsg").html(responseData.message).addClass('text-danger');
								Swal.fire({
									icon: "error",
									title: "Oops!",
									html: responseData.message,
									confirmButtonClass: "btn btn-danger",
									allowOutsideClick: false,
									allowEscapeKey: false,
									allowEnterKey: false
								});
							}
						},
						error: function(jqXHR, textStatus, errorThrown) {
							// Display detailed error information
							console.error("AJAX Request Error:");
							console.error("Status: " + textStatus); // Status of the request (e.g., "error", "timeout")
							console.error("Error Thrown: " + errorThrown); // Textual portion of the error
							console.error("Response Text: " + jqXHR.responseText); // Response from the server, if any
							alert(jqXHR.responseText);
							$("#genCert").html('Upload & Generate').removeAttr('disabled');
						}
					});
				}
			});
		});
	</script>

<script src="assets/js/jquery-3.6.0.min.js"></script>
<script src="assets/js/feather.min.js"></script>
<script src="assets/js/bootstrap.bundle.min.js"></script>
<script src="assets/plugins/sweetalert/sweetalert2.all.min.js"></script>
<script src="assets/plugins/sweetalert/sweetalerts.min.js"></script>
<script src="assets/js/script.js"></script>
</body>
</html>