<?php 
	$approvedEtransportMenu = 'class="active"';
	$etransportMenu = 'class="active"';
	
	$sessionDet = explode('/',$_SESSION['session']);
	$currentPage = ucwords(str_replace('-',' ',$sessionDet[0]));
	$mainPage = str_replace('.php','',ucwords(str_replace('-',' ',$sessionDet[1])));
	$title = $currentPage.' - '.$mainPage.' | '.$appName;
	$page = $currentPage;
	$return_url = $sessionDet[1];
	
	include('pages/main/header.php');
	
	$status = 'Approved';
	$projectId = 'ETI-9827654';
	if($userType=='Super Administrator' || $userType=='Administrator'){
		$queryApp = mysqli_query($db_conn, "SELECT 
			a.request_id, a.asset_amount, a.date_requested, a.status, a.account_name, 
			a.attended_by, a.date_attended, a.payment_start_date, a.payment_end_date, 
			a.total_payable_amount, a.agent_id, a.account_number, a.bank_name, 
			b.firstname, b.lastname, b.middlename, b.email, b.phone, b.stateoforigin, 
			b.lgaoforigin, b.housenumber, b.streetname, b.stateofresidence, 
			b.lgaofresidence, b.cityofresidence, c.first_name as agent_first_name,
			c.last_name as agent_last_name, c.middle_name as agent_middle_name, 
			c.dept_id, c.city, c.state, d.state_name AS agent_state, 
			e.name AS agent_city, f.state_name AS trader_state, g.name AS trader_city
			FROM tbl_etransport a
			INNER JOIN tbl_traders_enumeration b ON b.matan_id = a.trader_id
			INNER JOIN tbl_users c ON c.unique_id = a.agent_id
			INNER JOIN states d ON d.state_id = c.state -- Agent state
			INNER JOIN lga e ON e.id = c.city -- Agent city
			INNER JOIN states f ON f.state_id = b.stateofresidence -- Trader state of residence
			INNER JOIN lga g ON g.id = b.lgaofresidence -- Trader city of residence
			WHERE a.status='$status' ORDER BY date_requested DESC
		");
	}elseif($userType=='National Project Manager'){
		$myDept = $user['dept_id'];
		$queryApp = mysqli_query($db_conn, "SELECT 
			a.request_id, a.asset_amount, a.date_requested, a.status, a.account_name, 
			a.attended_by, a.date_attended, a.payment_start_date, a.payment_end_date, 
			a.total_payable_amount, a.agent_id, a.account_number, a.bank_name, 
			b.firstname, b.lastname, b.middlename, b.email, b.phone, b.stateoforigin, 
			b.lgaoforigin, b.housenumber, b.streetname, b.stateofresidence, 
			b.lgaofresidence, b.cityofresidence, c.first_name as agent_first_name, 
			c.last_name as agent_last_name, c.middle_name as agent_middle_name, 
			c.dept_id, c.city, c.state, d.state_name AS agent_state, 
			e.name AS agent_city, f.state_name AS trader_state, g.name AS trader_city
			FROM tbl_etransport a
			INNER JOIN tbl_traders_enumeration b ON b.matan_id = a.trader_id
			INNER JOIN tbl_users c ON c.unique_id = a.agent_id
			INNER JOIN states d ON d.state_id = c.state -- Agent state
			INNER JOIN lga e ON e.id = c.city -- Agent city
			INNER JOIN states f ON f.state_id = b.stateofresidence -- Trader state of residence
			INNER JOIN lga g ON g.id = b.lgaofresidence -- Trader city of residence
			WHERE a.status='$status' AND c.dept_id='$projectId' ORDER BY date_requested DESC
		");
	}elseif($userType=='State Project Manager'){
		$myDept = $user['dept_id'];
		$myState = $user['state'];
		$queryApp = mysqli_query($db_conn, "SELECT 
			a.request_id, a.asset_amount, a.date_requested, a.status, a.account_name, 
			a.attended_by, a.date_attended, a.payment_start_date, a.payment_end_date, 
			a.total_payable_amount, a.agent_id, a.account_number, a.bank_name, 
			b.firstname, b.lastname, b.middlename, b.email, b.phone, b.stateoforigin, 
			b.lgaoforigin, b.housenumber, b.streetname, b.stateofresidence, 
			b.lgaofresidence, b.cityofresidence, c.first_name as agent_first_name, 
			c.last_name as agent_last_name, c.middle_name as agent_middle_name, 
			c.dept_id, c.city, c.state, d.state_name AS agent_state, 
			e.name AS agent_city, f.state_name AS trader_state, g.name AS trader_city
			FROM tbl_etransport a
			INNER JOIN tbl_traders_enumeration b ON b.matan_id = a.trader_id
			INNER JOIN tbl_users c ON c.unique_id = a.agent_id
			INNER JOIN states d ON d.state_id = c.state -- Agent state
			INNER JOIN lga e ON e.id = c.city -- Agent city
			INNER JOIN states f ON f.state_id = b.stateofresidence -- Trader state of residence
			INNER JOIN lga g ON g.id = b.lgaofresidence -- Trader city of residence
			WHERE a.status='$status' AND c.dept_id='$projectId' AND b.stateofresidence='$myState'
			ORDER BY date_requested DESC
		");
	}
	elseif($userType=='LG Project Manager'){
		$myDept = $user['dept_id'];
		$myState = $user['state'];
		$myLgaId = $user['city'];
		$queryApp = mysqli_query($db_conn, "SELECT 
			a.request_id, a.asset_amount, a.date_requested, a.status, a.account_name, 
			a.attended_by, a.date_attended, a.payment_start_date, a.payment_end_date, 
			a.total_payable_amount, a.agent_id, a.account_number, a.bank_name, 
			b.firstname, b.lastname, b.middlename, b.email, b.phone, b.stateoforigin, 
			b.lgaoforigin, b.housenumber, b.streetname, b.stateofresidence, 
			b.lgaofresidence, b.cityofresidence, c.first_name as agent_first_name, 
			c.last_name as agent_last_name, c.middle_name as agent_middle_name, 
			c.dept_id, c.city, c.state, d.state_name AS agent_state, 
			e.name AS agent_city, f.state_name AS trader_state, g.name AS trader_city
			FROM tbl_etransport a
			INNER JOIN tbl_traders_enumeration b ON b.matan_id = a.trader_id
			INNER JOIN tbl_users c ON c.unique_id = a.agent_id
			INNER JOIN states d ON d.state_id = c.state -- Agent state
			INNER JOIN lga e ON e.id = c.city -- Agent city
			INNER JOIN states f ON f.state_id = b.stateofresidence -- Trader state of residence
			INNER JOIN lga g ON g.id = b.lgaofresidence -- Trader city of residence
			WHERE a.status='$status' AND c.dept_id='$projectId' AND b.stateofresidence='$myState'
			AND b.cityofresidence='$myLgaId'
			ORDER BY date_requested DESC
		");
	}
	elseif($userType=='Agent'){
		$myDept = $user['dept_id'];
		$myState = $user['state'];
		$myLgaId = $user['city'];
		$queryApp = mysqli_query($db_conn, "SELECT 
			a.request_id, a.asset_amount, a.date_requested, a.status, a.account_name, 
			a.attended_by, a.date_attended, a.payment_start_date, a.payment_end_date, 
			a.total_payable_amount, a.agent_id, a.account_number, a.bank_name, 
			b.firstname, b.lastname, b.middlename, b.email, b.phone, b.stateoforigin, 
			b.lgaoforigin, b.housenumber, b.streetname, b.stateofresidence, 
			b.lgaofresidence, b.cityofresidence, c.first_name as agent_first_name, 
			c.last_name as agent_last_name, c.middle_name as agent_middle_name, 
			c.dept_id, c.city, c.state, d.state_name AS agent_state, 
			e.name AS agent_city, f.state_name AS trader_state, g.name AS trader_city
			FROM tbl_etransport a
			INNER JOIN tbl_traders_enumeration b ON b.matan_id = a.trader_id
			INNER JOIN tbl_users c ON c.unique_id = a.agent_id
			INNER JOIN states d ON d.state_id = c.state -- Agent state
			INNER JOIN lga e ON e.id = c.city -- Agent city
			INNER JOIN states f ON f.state_id = b.stateofresidence -- Trader state of residence
			INNER JOIN lga g ON g.id = b.lgaofresidence -- Trader city of residence
			WHERE a.status='$status' AND c.dept_id='$projectId' AND b.stateofresidence='$myState'
			AND b.cityofresidence='$myLgaId' AND a.agent_id='$myId'
			ORDER BY date_requested DESC
		");
	}
?>
	<div class="page-wrapper">
		<div class="content">
			<div class="page-header">
				<div class="page-title">
					<h4><?php echo $currentPage; ?></h4>
					<h6><?php echo $mainPage; ?></h6>
				</div>
			</div>
			
			<div class="row">
				<div class="col-lg-3 col-sm-6 col-12">
					<div class="dash-widget">
						<div class="dash-widgetimg">
							<span><img src="assets/img/icons/expense1.svg" alt="img"></span>
						</div>
						<div class="dash-widgetcontent">
							<h5><?php echo $naira; ?>307,144.00</h5>
							<h6>My Wallet Balance</h6>
						</div>
					</div>
				</div>
				<div class="col-lg-3 col-sm-6 col-12">
					<div class="dash-widget dash1">
						<div class="dash-widgetimg">
							<span><img src="assets/img/icons/dash2.svg" alt="img"></span>
						</div>
						<div class="dash-widgetcontent">
							<h5><?php echo $naira; ?>56,385,950.00</h5>
							<h6>All Repayments (652)</h6>
						</div>
					</div>
				</div>
				<div class="col-lg-3 col-sm-6 col-12">
					<div class="dash-widget dash2">
						<div class="dash-widgetimg">
							<span><i class="fas fa-credit-card"></i></span>
						</div>
						<div class="dash-widgetcontent">
							<h5><?php echo $naira; ?>863,872.89</h5>
							<h6>Pending Approval (64)</h6>
						</div>
					</div>
				</div>
				<div class="col-lg-3 col-sm-6 col-12">
					<div class="dash-widget dash3">
						<div class="dash-widgetimg">
							<span><img src="assets/img/icons/dash4.svg" alt="img"></span>
						</div>
						<div class="dash-widgetcontent">
							<h5><?php echo $naira; ?>2,843,400.00</h5>
							<h6>Over Due Payments (105)</h6>
						</div>
					</div>
				</div>
				<div class="col-lg-3 col-sm-6 col-12 d-flex">
					<div class="dash-count">
						<div class="dash-counts">
							<h4>657</h4>
							<h5>All Applications</h5>
						</div>
						<div class="dash-imgs">
						<i data-feather="user"></i>
						</div>
					</div>
				</div>
				<div class="col-lg-3 col-sm-6 col-12 d-flex">
					<div class="dash-count das1">
						<div class="dash-counts">
							<h4>10</h4>
							<h5>Administrators</h5>
						</div>
						<div class="dash-imgs">
							<i data-feather="file"></i>
						</div>
					</div>
				</div>
				<div class="col-lg-3 col-sm-6 col-12 d-flex">
					<div class="dash-count das2">
						<div class="dash-counts">
							<h4>154</h4>
							<h5>Pending Approval</h5>
						</div>
						<div class="dash-imgs">
							<i data-feather="file-text"></i>
						</div>
					</div>
				</div>
				<div class="col-lg-3 col-sm-6 col-12 d-flex">
					<div class="dash-count das3">
						<div class="dash-counts">
							<h4>527</h4>
							<h5>Approved Applications</h5>
						</div>
						<div class="dash-imgs">
							<i data-feather="user-check"></i>
						</div>
					</div>
				</div>
			</div>

			<div class="card">
				<div class="card-body">
					<div class="table-top">
						<div class="search-set">
							<div class="search-path">
								<a class="btn btn-filter" id="filter_search">
								<img src="assets/img/icons/filter.svg" alt="img">
								<span><img src="assets/img/icons/closes.svg" alt="img"></span>
								</a>
							</div>
							<div class="search-input">
								<a class="btn btn-searchset"><img src="assets/img/icons/search-white.svg" alt="img"></a>
							</div>
						</div>
						<div class="wordset">
							<ul>
								<li>
									<a data-bs-toggle="tooltip" data-bs-placement="top" title="pdf"><img src="assets/img/icons/pdf.svg" alt="img"></a>
								</li>
								<li>
									<a data-bs-toggle="tooltip" data-bs-placement="top" title="excel"><img src="assets/img/icons/excel.svg" alt="img"></a>
								</li>
								<li>
									<a data-bs-toggle="tooltip" data-bs-placement="top" title="print"><img src="assets/img/icons/printer.svg" alt="img"></a>
								</li>
							</ul>
						</div>
					</div>

					<div class="card" id="filter_inputs">
						<div class="card-body pb-0">
							<div class="row">
								<div class="col-lg-2 col-sm-6 col-12">
									<div class="form-group">
										<input type="text" placeholder="Enter Phone Number">
									</div>
								</div>
								<div class="col-lg-2 col-sm-6 col-12">
									<div class="form-group">
										<input type="text" placeholder="Enter Email">
									</div>
								</div>
								<div class="col-lg-1 col-sm-6 col-12  ms-auto">
									<div class="form-group">
										<a class="btn btn-filters ms-auto"><img src="assets/img/icons/search-whites.svg" alt="img"></a>
									</div>
								</div>
							</div>
						</div>
					</div>

					<div class="table-responsive">
						<table class="table  datanew">
							<thead>
								<tr>
									<th>
										<label class="checkboxs">
										<input type="checkbox" id="select-all">
										<span class="checkmarks"></span>
										</label>
									</th>
									<th>Trader</th>
									<th>Contact</th>
									<th>Address</th>
									<th>Location</th>
									<th>Date Applied </th>
									<th>Agent</th>
									<th>Status</th>
									<th class="no-sort"><i class="fas fa-cogs"></i></th>
								</tr>
							</thead>
							<tbody>
								<?php
									$number = 1;
									while($etransport = mysqli_fetch_assoc($queryApp)){
										$fullName = $etransport['lastname'].' '.$etransport['firstname'].' '.$etransport['middlename'];
										$fullName = ucwords(strtolower($fullName));
										$contact = $etransport['phone'].'<br>'.$etransport['email'];
										$address = $etransport['housenumber'].' '.$etransport['streetname'].', '.$etransport['cityofresidence'];
										$location = getCityName($etransport['lgaofresidence']).', '.getStateName($etransport['stateofresidence']);
										$dateApplied = timeCheck($etransport['date_requested']);
										$agent = $etransport['agent_last_name'].' '.$etransport['agent_first_name'].' '.$etransport['agent_middle_name'];
										
										if($etransport['status']=='Approved'){
											$status = '<span class="badge  bg-success">Approved</span>';
										}
										elseif($etransport['status']=='Rejected'){
											$status = '<span class="badge  bg-danger">Rejected</span>';
										}
										else{
											$status = '<span class="badge  bg-warning">Pending</span>';
										}
										$btn = '<div class="btn-group dropdown-action">
											<a class="dropdown-toggle" data-bs-toggle="dropdown" href="javascript:void();">
												<i class="fe fe-more-horizontal"></i>
											</a>
											<div role="menu" class="dropdown-menu">
												<a class="dropdown-item me-3 print-application bg-info text-white" name="'.$fullName.'" data-id="'.$etransport['request_id'].'" data-bs-toggle="modal" data-bs-target="#print-application" href="javascript:void(0);">
													Print Slip
												</a>
											</div>
										</div>';
										
								?>
								<tr>
									<td>
										<label class="checkboxs">
										<input type="checkbox">
										<span class="checkmarks"></span>
										</label>
									</td>
									<td><?php echo $fullName; ?></td>
									<td><?php echo $contact; ?></td>
									<td><?php echo ucwords(strtolower($address)); ?></td>
									<td><?php echo $location; ?></td>
									<td><?php echo $dateApplied; ?></span></td>
									<td><?php echo ucwords(strtolower($agent)); ?></td>
									<td><?php echo $status; ?></td>
									<td>
										<?php echo $btn; ?>
									</td>
								</tr>
								<?php $number++; } ?>
								
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<?php include('pages/main/footer.php'); ?>