<?php
	$title = 'My Profile | '.$appName;
	$page = 'User Management';
	
	$sessionDet = explode('/',$_SESSION['session']);
	$currentPage = ucwords(str_replace('-',' ',$sessionDet[0]));
	$mainPage = str_replace('.php','',ucwords(str_replace('-',' ',$sessionDet[1])));
	if(empty($mainPage)){
		$title = $currentPage.' | '.$appName;
		$currentPage = str_replace('.php','',$currentPage);
		if($currentPage=='Profile' || $currentPage=='Dashboard' || $currentPage=='Activity'){
			$currentPage = "My $currentPage";
		}
	}
	else{
		$title = $currentPage.' - '.$mainPage.' | '.$appName;
	}
	
	$return_url = $sessionDet[1];
	$page = $sessionDet[0];
	
	include('pages/main/header.php');
?>

	<div class="page-wrapper">
		<div class="content">
			<div class="page-header">
				<div class="page-title">
					<h4><?php echo $currentPage; ?></h4>
					<h6><?php echo $mainPage; ?></h6>
				</div>
			</div>
			<input type="hidden" id="returnedOtp" />
			<div class="card">
			
				<div class="card-body">
					<div class="profile-set">
						<div class="profile-cover">
							<div class="profile-cover-wrap">
								<img class="profile-cover-img" id="profileBg" src="<?php echo $bgImage; ?>" alt="<?php echo $profileDet['First_Name'].' '.$profileDet['Last_Name']; ?> Profile Cover" id="cover-image">

								<div class="cover-content" id="cover_icon">
									<div class="custom-file-btn">
										<input type="file" class="custom-file-btn-input" id="cover_upload">
										<label class="custom-file-btn-label btn btn-sm btn-white" id="cover_icon" for="cover_upload">
											<i class="fas fa-camera"></i>
											<span class="d-none d-sm-inline-block ms-1">Update Cover</span>
										</label>
									</div>
								</div>
							</div>
						</div>
						<div class="profile-top">
							<div class="profile-content">
								<div class="profile-contentimg">
									<img src="<?php echo $userImage; ?>" alt="img" style="height: 120px; width: 100%" id="userImage5">
									<div class="profileupload">
										<input type="file" id="profileImg">
										<a href="javascript:void(0);"><img src="assets/img/icons/edit-set.svg" alt="img"></a>
									</div>
								</div>
								<div class="profile-contentname">
									<h2 id="myName2"><?php echo $admData['Last_Name'].' '.$admData['First_Name']; ?></h2>
									<h4><?php echo $userType; ?></h4>
								</div>
							</div>
							<div class="ms-auto">
								<a href="javascript:void(0);" class="btn btn-submit me-2 update-password"><i class="me-2" data-feather="lock"></i> Update Password</a>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-lg-4 col-sm-12">
							<div class="form-group">
								<label>Title</label>
								<select class="js-example-basic-single select2" disabled id="title">
									<?php
										$myTitle = $admData['TitleID'];
										$selectTitle = mysqli_query($db_conn, "SELECT TitleID, TitleName FROM bkq_usertitle WHERE Status=1 ORDER BY TitleName ASC");
										if(mysqli_num_rows($selectTitle)>0){
											if(!$myTitle){ echo '<option value="">Select Title</option>'; }
											while($title=mysqli_fetch_assoc($selectTitle)){
												if($myTitle==$title['TitleID']){
													echo '<option selected value="'.$title['TitleID'].'">'.$title['TitleName'].'</option>';
												}
												else{
													echo '<option value="'.$title['TitleID'].'">'.$title['TitleName'].'</option>';
												}
											}
										}
										else{
											echo '<option value="">No Title Available</option>';
										}
									?>
								</select>
							</div>
						</div>
						<div class="col-lg-4 col-sm-12">
							<div class="form-group">
								<label>First Name</label>
								<input type="text" disabled value="<?php echo ucwords(strtolower($admData['First_Name'])); ?>" placeholder="First Name" id="firstName">
							</div>
						</div>
						<div class="col-lg-4 col-sm-12">
							<div class="form-group">
								<label>Last Name</label>
								<input type="text" disabled value="<?php echo ucwords(strtolower($admData['Last_Name'])); ?>" placeholder="Last Name" id="lastName">
							</div>
						</div>
						<div class="col-lg-4 col-sm-12">
							<div class="form-group">
								<label>Gender <?php echo $admData['Gender']; ?></label>
								<select class="js-example-basic-single select2" disabled id="gender">
									<?php
										$myGender = $admData['Gender'];
										$selectGender = mysqli_query($db_conn, "SELECT Gender FROM bkq_gender WHERE Status=1 ORDER BY Gender ASC");
										if(mysqli_num_rows($selectGender)>0){
											if(!$gender){ echo '<option value="">Select Gender</option>';}
											while($gender=mysqli_fetch_assoc($selectGender)){
												if($myGender==$gender['Gender']){
													echo '<option selected value="'.$gender['Gender'].'">'.$gender['Gender'].'</option>';
												}
												else{
													echo '<option value="'.$gender['Gender'].'">'.$gender['Gender'].'</option>';
												}
											}
										}
										else{
											echo '<option value="">No Gender Available</option>';
										}
									?>
								</select>
							</div>
						</div>
						<div class="col-lg-4 col-sm-12">
							<div class="form-group">
								<label>Email (<a href="javscript:void();" class="text-info update-email">Update <i class="fa fa-edit"></i></a>)</label>
								<input type="text" disabled value="<?php echo $user['Email']; ?>" id="email">
							</div>
						</div>
						<div class="col-lg-4 col-sm-12">
							<div class="form-group">
								<label>User Name</label>
								<input type="text" disabled value="<?php echo $user['UserName']; ?>" placeholder="Choose username" id="username">
							</div>
						</div>
						<?php
							$phoneNumber = explode('-',$profileDet['phone']);
							$phone = end($phoneNumber);
							$countryCode = $phoneNumber[0];
						?>
						<div class="col-lg-4 col-sm-12">
							<div class="form-group">
								<label>Phone</label>
								<div class="input-group">
									<select class="input-bordered" disabled id="countryCode" name="country-code" style="width: auto;">
										<?php
											$queryCode = mysqli_query($db_conn, "SELECT * FROM `bkq_country` WHERE `Code` NOT LIKE '%+%' AND Code!='NONE' AND Code!='' ORDER BY Code ASC");
											while($code = mysqli_fetch_assoc($queryCode)){
												if($code['Code']==$countryCode){
													echo '<option selected value="'.$code['Code'].'">+'.$code['Code'].' ('.$code['ShortName'].')</option>';
												}
												else{
													echo '<option value="'.$code['Code'].'">+'.$code['Code'].' ('.$code['ShortName'].')</option>';
												}
											}
										?>
									</select>
									<input type="text" id="phone" disabled value="<?php echo $phone; ?>" class="form-control" placeholder="Enter Phone number" aria-label="Text input with dropdown button">
								</div>
							</div>
						</div>
						<?php
							$dob = explode('-',$profileDet['dob']);
							if(sizeof($dob) > 2){
								$year = $dob[2];
								$month = $dob[1];
								$day = $dob[0];
							}
							else{
								$month = $dob[1];
								$day = $dob[0];
							}
						?>
						<div class="col-lg-4 col-sm-12">
							<div class="form-group">
								<label>Date of Birth</label>
								<div class="input-group">
									<select class="input-bordered form-control" disabled id="month" style="width: auto;">
										<option value="">Month</option>
										<?php
											$months = [
												"01" => "January",
												"02" => "February",
												"03" => "March",
												"04" => "April",
												"05" => "May",
												"06" => "June",
												"07" => "July",
												"08" => "August",
												"09" => "September",
												"10" => "October",
												"11" => "November",
												"12" => "December"
											];
											$monthNumber = 1;
											while ($monthNumber <= 12) {
												if($monthNumber<10){
													$monthNumberN = '0'.$monthNumber;
												}
												else{
													$monthNumberN = $monthNumber;
												}
												if($month==$monthNumberN){
													echo '<option selected value="'.$monthNumberN.'">'.$months[$monthNumberN].'</option>"';
												}
												else{
													echo '<option value="'.$monthNumberN.'">'.$months[$monthNumberN].'</option>"';
												}
												
												$monthNumber++;
											}
										?>
									</select>
									<select class="input-bordered form-control" disabled id="day" style="width: auto;">
										<?php
											$dataVal = '';
											if(isset($month)){
												if($month=='01' || $month=='03' || $month=='05' || $month=='07' || $month=='08' || $month=='10' || $month=='12'){
													$limit = 31;
												}
												elseif($month=='04' || $month=='06' || $month=='09' || $month=='11'){
													$limit = 30;
												}
												else{
													$limit = 29;
												}
												
												for($start = 1; $start <= $limit; $start++){
													if($start < 10){
														$dayNum = '0'.$start;
													}
													else{
														$dayNum = $start;
													}
													
													if($day==$dayNum){
														$dataVal .= '<option selected value="'.$dayNum.'">'.$dayNum.'</option>';
													}
													else{
														$dataVal .= '<option value="'.$dayNum.'">'.$dayNum.'</option>';
													}
												}
											}
											else{
												$dataVal = '<option value="">'.$day.'</option>';
											}
											
											echo $dataVal;
										?>
										
									</select>
									<select class="input-bordered form-control" disabled id="year" style="width: auto;">
										<option value="">Year</option>
										<?php
											$currentYear = intval(date("Y", time()));
											$limit = $currentYear-95;
											while($currentYear >= $limit){
												if($year==$currentYear){
													echo '<option selected value="'.$currentYear.'">'.$currentYear.'</option>';
												}
												else{
													echo '<option value="'.$currentYear.'">'.$currentYear.'</option>';
												}
												$currentYear--;
											}
										?>
									</select>
								</div>
							</div>
						</div>
						
						<div class="col-12" id="editDisplay">
							<a href="javascript:void(0);" id="editAccount" class="btn btn-submit me-2">Edit</a>
						</div>
						<div class="col-12" id="updateBtns" style="display: none;">
							<a href="javascript:void(0);" id="updateAccount" class="btn btn-submit me-2">Submit</a>
							<a href="javascript:void(0);" id="cancelUpdate" class="btn btn-cancel">Cancel</a>
						</div>
					</div>
				</div>
			</div>

		</div>
	</div>
</div>

<?php include('pages/main/footer.php'); ?>