<?php 
	$questionManagerMenu = 'class="active"';
	$questionBankMenu = 'class="active"';
	
	$sessionDet = explode('/',$_SESSION['session']);
	$currentPage = ucwords(str_replace('-',' ',$sessionDet[0]));
	$mainPage = str_replace('.php','',ucwords(str_replace('-',' ',$sessionDet[1])));
	$title = $currentPage.' - '.$mainPage.' | '.$appName;
	$return_url = $sessionDet[1];
	$page = $sessionDet[0];
	
	include('pages/main/header.php');
	
	
?>
	<div class="page-wrapper">
		<div class="content">
			<div class="page-header">
				<div class="page-title">
					<h4><?php echo $currentPage; ?></h4>
					<h6><?php echo $mainPage; ?></h6>
				</div>
				<div class="page-btn">
					<button type="button" onclick="location.href='./?loc=question-bank/questions-manager'" class="btn btn-danger mr-1 mb-1"><i class="fas fa-times-circle"></i> Close</button>
				</div>
			</div>

			<div class="card col-md-12 col-lg-12 col-sm-12 col-xs-12">
				<div class="card-body">
					<div class="row">
						<div class="col-12">
							<div class="form-group">
								<label>Bulk Questions<span class="manitory">*</span></label>
								<textarea rows="5" id="bulkInput" placeholder="Enter Bulk Question"></textarea>
							</div>
						</div>
						<div class="col-md-4 col-sm-12 col-xs-12">
							<div class="form-group">
								<label>Category<span class="manitory">*</span></label>
								<select class="js-example-basic-single select2" id="bulkCatId">
									<?php
										$queryCat = mysqli_query($db_conn, "SELECT * FROM bkq_question_categories WHERE Status=1 ORDER BY category_name ASC");
										if(mysqli_num_rows($queryCat)>0){
											echo '<option value="" selected>Select Category</option>';
											while($cat=mysqli_fetch_assoc($queryCat)){
												echo '<option value="'.$cat['QuestionCatID'].'">'.$cat['category_name'].'</option>';
											}
											echo '<option value="0">N/A</option>';
										}
										else{
											echo '<option value="">Category Not Available</option>';
										}
									?>
								</select>
							</div>
						</div>
						<div class="col-md-4 col-sm-12 col-xs-12">
							<div class="form-group">
								<label>Testament<span class="manitory">*</span></label>
								<select class="js-example-basic-single select2" id="bulkTestament">
									<?php
										$queryTestament = mysqli_query($db_conn, "SELECT * FROM bkq_testament WHERE Status=1 ORDER BY Testament ASC");
										if(mysqli_num_rows($queryTestament)>0){
											echo '<option value="">Select Testament</option>';
											while($testament=mysqli_fetch_assoc($queryTestament)){
												echo '<option value="'.$testament['TestamentID'].'">'.$testament['Testament'].'</option>';
											}
											echo '<option value="0">N/A</option>';
										}
										else{
											echo '<option value="">Testament Not Available</option>';
										}
									?>
								</select>
							</div>
						</div>
						<div class="col-md-4 col-sm-12 col-xs-12">
							<div class="form-group">
								<label>Level<span class="manitory">*</span></label>
								<select class="js-example-basic-single select2" id="bulkLevel">
									<?php
										$queryLevel = mysqli_query($db_conn, "SELECT * FROM bkq_question_level WHERE Status=1");
										if(mysqli_num_rows($queryLevel)>0){
											echo '<option value="">Select Qestion Level</option>';
											while($level=mysqli_fetch_assoc($queryLevel)){
												echo '<option value="'.$level['LevelID'].'">'.$level['Level'].'</option>';
											}
											echo '<option value="0">N/A</option>';
										}
										else{
											echo '<option value="">Level Not Available</option>';
										}
									?>
								</select>
							</div>
						</div>
						<div class="col-md-4 col-sm-12 col-xs-12">
							<div class="form-group">
								<label>Age Category<span class="manitory">*</span></label>
								<select class="js-example-basic-single select2" id="bulkAgeCat">
									<?php
										$queryAgeCat = mysqli_query($db_conn, "SELECT * FROM bkq_question_age_category WHERE Status=1 ORDER BY AgeFrom ASC");
										if(mysqli_num_rows($queryAgeCat)>0){
											echo '<option value="">Select Age Category</option>';
											while($ageCat=mysqli_fetch_assoc($queryAgeCat)){
												echo '<option value="'.$ageCat['AgeCatID'].'">'.$ageCat['AgeCat'].' ('.$ageCat['AgeFrom'].' - '.$ageCat['AgeTo'].' Years)</option>';
											}
											echo '<option value="0">N/A</option>';
										}
										else{
											echo '<option value="">Age Category Not Available</option>';
										}
									?>
								</select>
							</div>
						</div>
					</div>
				</div>
				<div class="card-footer">
					<button type="button" id="processAndPreview" class="btn btn-submit">Preview</button>
				</div>
			</div>
		</div>
	</div>
	
	<div class="modal fade" id="previewModal" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title">Questions Preview</h5>
					<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
						<span aria-hidden="true" id="closeEditQuesIcon">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<div class="row col-md-12">
						<div id="questionList"></div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" id="saveQuestions" class="btn btn-submit">Save Changes</button>
					<button type="button" id="closeEditQuesBtn" class="btn btn-cancel" data-bs-dismiss="modal">Cancel</button>
				</div>
			</div>
		</div>
	</div>
	
</div>
<script>
	$(document).ready(function(){
	  const bulkInput = document.getElementById('bulkInput');
	  const processAndPreviewButton = document.getElementById('processAndPreview');
	  const modal = document.getElementById('previewModal');
	  const modalClose = document.getElementById('closeModal');
	  const questionList = document.getElementById('questionList');
	  const saveQuestionsButton = document.getElementById('saveQuestions');

	  let processedQuestions = [];

	  // Parse the input text
	  const parseInput = (input) => {
		const blocks = input.split(/\n\n+/); // Split by double newline
		const uniqueQuestions = new Set();

		const parsedData = blocks.map(block => {
		  const lines = block.split('\n').filter(line => line.trim() !== '');
		  if (lines.length < 2) return null; // Skip incomplete entries

		  const question = lines[0].trim(); // First line is the question
		  let answers = [];
		  let correctAnswer = '';
		  let description = 'No description available';

		  // Extract answers, correct answer, and description
		  lines.slice(1).forEach(line => {
			if (line.toLowerCase().startsWith('correct answer:')) {
			  correctAnswer = line.replace(/^Correct Answer:\s*/i, '').trim();
			} else if (line.toLowerCase().startsWith('description:')) {
			  description = line.replace(/^Description:\s*/i, '').trim();
			} else {
			  answers.push(line.trim());
			}
		  });

		  // Skip duplicates
		  if (uniqueQuestions.has(question)) return null;
		  uniqueQuestions.add(question);

		  return { question, answers, correctAnswer, description };
		});

		return parsedData.filter(Boolean);
	  };

	  // Process questions and display in modal
	  processAndPreviewButton.addEventListener('click', () => {
		const inputText = bulkInput.value.trim();
		if (!inputText) {
			Swal.fire({
				icon: "error",
				title: "Error Occurred",
				html: "Please enter questions and answers.",
				confirmButtonClass: "btn btn-danger",
				allowOutsideClick: false,
				allowEscapeKey: false,
				allowEnterKey: false
			});
		  return;
		}

		processedQuestions = parseInput(inputText);

		// Display questions in the modal
		questionList.innerHTML = '';
		processedQuestions.forEach(({ question, answers, correctAnswer, description }, index) => {
		  const questionBlock = document.createElement('div');
		  questionBlock.className = 'question-block';

		  questionBlock.innerHTML = `
			<div class="question-text"><strong>Q${index + 1}: ${question}</strong><br></div>
			<div class="answers">
			  ${answers.map((answer, i) => `
				<div class="answer-item">
				  ${String.fromCharCode(65 + i)}. ${answer}
				</div>
			  `).join('')}
			</div>
			<div class="correct-answer">
			  <span class="correct-tag">Correct Answer:</span> ${correctAnswer}
			</div>
			<div class="description-block">Description: ${description}</div>
		  `;

		  questionList.appendChild(questionBlock);
		});

		$("#previewModal").modal('show');
		$('#previewModal').on('hide.bs.modal', function(e) {
			e.preventDefault();
        });
	  });

	  
	});

</script>
<?php include('pages/main/footer.php'); ?>