<?php 
	$questionManagerMenu = 'class="active"';
	$questionBankMenu = 'class="active"';
	
	$sessionDet = explode('/',$_SESSION['session']);
	$currentPage = ucwords(str_replace('-',' ',$sessionDet[0]));
	$mainPage = str_replace('.php','',ucwords(str_replace('-',' ',$sessionDet[1])));
	$title = $currentPage.' - '.$mainPage.' | '.$appName;
	$return_url = $sessionDet[1];
	$page = $sessionDet[0];
	
	include('pages/main/header.php');
	
?>
	<div class="page-wrapper">
		<div class="content">
			<div class="page-header">
				<div class="page-title">
					<h4><?php echo $currentPage; ?></h4>
					<h6><?php echo $mainPage; ?></h6>
				</div>
				<div class="page-btn">
					<button type="button" onclick="location.href='./?loc=question-bank/bulk-upload'" class="btn btn-success mr-1 mb-1"><i class="fas fa-cloud-upload"></i> Bulk Upload</button>
					<button type="button" onclick="location.href='./?loc=question-bank/add-question'" class="btn btn-info mr-1 mb-1"><i class="fa fa-plus-circle"></i> Add Question</button>
				</div>
			</div>
			<?php include('pages/main/question-bank/stats.php'); ?>
			<div class="card col-md-12 col-lg-12 col-sm-12 col-xs-12">
				<div class="card-body">
					<div class="table-top">
						<div class="search-set">
							<div class="search-input">
								<a class="btn btn-searchset"><img src="assets/img/icons/search-white.svg" alt="img"></a>
							</div>
						</div>
						<div class="wordset">
							<ul>
								<li>
									<a data-bs-toggle="tooltip" data-bs-placement="top" title="pdf"><img src="assets/img/icons/pdf.svg" alt="img"></a>
								</li>
								<li>
									<a data-bs-toggle="tooltip" data-bs-placement="top" title="excel"><img src="assets/img/icons/excel.svg" alt="img"></a>
								</li>
								<li>
									<a data-bs-toggle="tooltip" data-bs-placement="top" title="print"><img src="assets/img/icons/printer.svg" alt="img"></a>
								</li>
							</ul>
						</div>
					</div>
					<div class="table-responsive">
						<table class="table  datanew">
							<thead>
								<tr>
									<th>
										
									</th>
									<th>Question</th>
									<th>Options</th>
									<th>Correct</th>
									<th>Category</th>
									<th>Added By</th>
									<th>Status</th>
									<th class="text-end">Action</th>
								</tr>
							</thead>
							<tbody>
							<?php
								
								$queryQuestion = mysqli_query($db_conn, "SELECT a.QuestionID,a.UserID, a.Question, a.QuesCreated, a.QuestHashID, 
									a.CatID, a.TestamentID, a.LevelID,a.AgeCatID,a.Status, b.Option1, b.Option2,
									b.Option3,b.Option4,b.Option5,b.RightAnswer,b.OptExplain, c.Last_Name, 
									c.First_Name FROM bkq_question a, bkq_question_answers b, 
									bkq_personnel c 
									WHERE a.Status=1 AND b.QuestionHashID=a.QuestHashID AND c.UserID=a.UserID 
								");
								if(mysqli_num_rows($queryQuestion)>0){
									while($question = mysqli_fetch_assoc($queryQuestion)){
										if($question['Status']==1){
											$statusTag = 'checked';
										}
										else{
											$statusTag = '';
										}
										
										$options = $question['Option1'];
										if(!empty($question['Option2'])){
											$options .= '<br>'.$question['Option2'];
										}
										if(!empty($question['Option3'])){
											$options .= '<br>'.$question['Option3'];
										}
										if(!empty($question['Option4'])){
											$options .= '<br>'.$question['Option4'];
										}
										if(!empty($question['Option5'])){
											$options .= '<br>'.$question['Option5'];
										}
										
										echo '<tr>
											<td>
												<label class="checkboxs select-cat">
													<input type="checkbox" data-id="'.$question['QuestionID'].'" name="'.$question['Question'].'">
													<span class="checkmarks"></span>
												</label>
											</td>
											<td>'.stripslashes($question['Question']).'</td>
											<td>'.stripslashes($options).'</td>
											<td>'.stripslashes($question['RightAnswer']).'</td>
											<td>'.$question['category_name'].'</td>
											<td>'.$question['First_Name'].' '.$question['Last_Name'].'</td>
											<td>
												<div class="status-toggle d-flex justify-content-between align-items-center">
													<input type="checkbox" id="'.$question['QuestionID'].'" class="check change-status" '.$statusTag.' data-id="'.$question['QuestionID'].'" name="'.$question['Question'].'">
													<label for="'.$question['QuestionID'].'" class="checktoggle">checkbox</label>
												</div>
											</td>
											<td class="text-end">
												<a class="me-3" href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#editCategory" data-id="'.$question['QuestionID'].'" name="'.$question['Question'].'">
													<img src="assets/img/icons/edit.svg" width="25px" alt="img">
												</a>
												<a class="me-3" href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#editCategory" data-id="'.$question['QuestionID'].'" name="'.$question['Question'].'">
													<img src="assets/img/icons/check-circle-broken.svg" width="25px" alt="img">
												</a>
												<a class="me-3 delete-category" href="javascript:void(0);" data-id="'.$question['QuestionID'].'" name="'.$question['Question'].'">
													<img src="assets/img/icons/delete.svg" width="25px" alt="img">
												</a>
											</td>
										</tr>';
									}
								}
							?>
							</tbody>
						</table>
					</div>
					
				</div>
			</div>
		</div>
	</div>
	
	<div class="modal fade" id="addQuestion" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title">Add Question </h5>
					<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
						<span aria-hidden="true" id="closeAddCatIcon">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<div class="row">
						<div class="col-12">
							<div class="form-group">
								<label>Question<span class="manitory">*</span></label>
								<textarea rows="5" id="question" placeholder="Enter Question Here"></textarea>
							</div>
						</div>
						<div class="col-12">
							<div class="form-group">
								<label>Options<span class="manitory">*</span></label>
								<textarea rows="5" id="options" placeholder="Enter Options"></textarea>
							</div>
						</div>
						<div class="col-12">
							<div class="form-group">
								<label>Correct Answer<span class="manitory">*</span></label>
								<input type="text" id="correctAnswer" placeholder="Enter Correct Option" />
							</div>
						</div>
						<div class="col-12">
							<div class="form-group">
								<label>Description<span class="manitory">*</span></label>
								<textarea rows="5" id="description" placeholder="Enter Description here..."></textarea>
							</div>
						</div>
						<div class="col-md-4 col-sm-12 col-xs-12">
							<div class="form-group">
								<label>Category<span class="manitory">*</span></label>
								<select class="js-example-basic-single select2" id="catId">
									<option selected="selected">orange</option>
									<?php
										$queryCat = mysqli_query($db_conn, "SELECT * FROM bkq_question_categories WHERE Status=1 ORDER BY category_name ASC");
										if(mysqli_num_rows($queryCat)>0){
											echo '<option value="">Select Category</option>';
											while($cat=mysqli_fetch_assoc($queryCat)){
												echo '<option value="'.$cat['cat_id'].'">'.$cat['category_name'].'</option>';
											}
											echo '<option value="0">N/A</option>';
										}
										else{
											echo '<option value="">Category Not Available</option>';
										}
									?>
								</select>
							</div>
						</div>
						<div class="col-md-4 col-sm-12 col-xs-12">
							<div class="form-group">
								<label>Testament<span class="manitory">*</span></label>
								<select class="js-example-basic-single select2" id="testament">
									<?php
										$queryTestament = mysqli_query($db_conn, "SELECT * FROM bkq_testament WHERE Status=1 ORDER BY Testament ASC");
										if(mysqli_num_rows($queryTestament)>0){
											echo '<option value="">Select Testament</option>';
											while($testament=mysqli_fetch_assoc($queryTestament)){
												echo '<option value="'.$testament['TestamentID'].'">'.$testament['Testament'].'</option>';
											}
											echo '<option value="0">N/A</option>';
										}
										else{
											echo '<option value="">Testament Not Available</option>';
										}
									?>
								</select>
							</div>
						</div>
						<div class="col-md-4 col-sm-12 col-xs-12">
							<div class="form-group">
								<label>Level<span class="manitory">*</span></label>
								<select class="select" id="level" style="border-color: red;">
									<?php
										$queryLevel = mysqli_query($db_conn, "SELECT * FROM bkq_question_level WHERE Status=1");
										if(mysqli_num_rows($queryLevel)>0){
											echo '<option value="">Select Qestion Level</option>';
											while($level=mysqli_fetch_assoc($queryLevel)){
												echo '<option value="'.$level['LevelID'].'">'.$level['Level'].'</option>';
											}
											echo '<option value="0">N/A</option>';
										}
										else{
											echo '<option value="">Level Not Available</option>';
										}
									?>
								</select>
							</div>
						</div>
						<div class="col-md-4 col-sm-12 col-xs-12">
							<div class="form-group">
								<label>Age Category<span class="manitory">*</span></label>
								<select class="select" id="ageCat">
									<?php
										$queryAgeCat = mysqli_query($db_conn, "SELECT * FROM bkq_question_age_category WHERE Status=1 ORDER BY AgeFrom ASC");
										if(mysqli_num_rows($queryAgeCat)>0){
											echo '<option value="">Select Age Category</option>';
											while($ageCat=mysqli_fetch_assoc($queryAgeCat)){
												echo '<option value="'.$ageCat['AgeCatID'].'">'.$ageCat['AgeCat'].' ('.$ageCat['AgeFrom'].' - '.$ageCat['AgeTo'].' Years)</option>';
											}
											echo '<option value="0">N/A</option>';
										}
										else{
											echo '<option value="">Age Category Not Available</option>';
										}
									?>
								</select>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" id="submitQuestion" class="btn btn-submit">Submit</button>
					<button type="button" id="closeAddQuesBtn" class="btn btn-cancel" data-bs-dismiss="modal">Cancel</button>
				</div>
			</div>
		</div>
	</div>
	
	<div class="modal fade" id="editQuestion" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title">Edit Question </h5>
					<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
						<span aria-hidden="true" id="closeEdittIcon">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<div class="row">
						<div class="col-12">
							<div class="form-group">
								<label>Category Name<span class="manitory">*</span></label>
								<textarea rows="5" id="editQuestion" placeholder="Enter Question Here"></textarea>
							</div>
						</div>
						<div class="col-12">
							<div class="form-group">
								<label>Options<span class="manitory">*</span></label>
								<textarea rows="5" id="editOptions" placeholder="Enter Options"></textarea>
							</div>
						</div>
						<div class="col-12">
							<div class="form-group">
								<label>Correct Answer<span class="manitory">*</span></label>
								<input type="text" id="editCorrectAnswer" placeholder="Enter Correct Option" />
							</div>
						</div>
						<div class="col-12">
							<div class="form-group">
								<label>Description<span class="manitory">*</span></label>
								<textarea rows="5" id="editDescription" placeholder="Enter Description here..."></textarea>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" id="submitEditQuestion" class="btn btn-submit">Save Changes</button>
					<button type="button" id="closeEditQuesBtn" class="btn btn-cancel" data-bs-dismiss="modal">Cancel</button>
				</div>
			</div>
		</div>
	</div>
	
	<div class="modal fade" id="editQuestion" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title">Edit Question </h5>
					<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
						<span aria-hidden="true" id="closeEdittIcon">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<div class="row">
						<div class="col-12">
							<div class="form-group">
								<label>Category Name<span class="manitory">*</span></label>
								<textarea rows="5" id="editQuestion" placeholder="Enter Question Here"></textarea>
							</div>
						</div>
						<div class="col-12">
							<div class="form-group">
								<label>Options<span class="manitory">*</span></label>
								<textarea rows="5" id="editOptions" placeholder="Enter Options"></textarea>
							</div>
						</div>
						<div class="col-12">
							<div class="form-group">
								<label>Correct Answer<span class="manitory">*</span></label>
								<input type="text" id="editCorrectAnswer" placeholder="Enter Correct Option" />
							</div>
						</div>
						<div class="col-12">
							<div class="form-group">
								<label>Description<span class="manitory">*</span></label>
								<textarea rows="5" id="editDescription" placeholder="Enter Description here..."></textarea>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" id="submitEditQuestion" class="btn btn-submit">Save Changes</button>
					<button type="button" id="closeEditQuesBtn" class="btn btn-cancel" data-bs-dismiss="modal">Cancel</button>
				</div>
			</div>
		</div>
	</div>
	
	
	
</div>

<?php include('pages/main/footer.php'); ?>