<?php 
	$revenueMenu = 'class="active"';
	$withdrawalMenu = 'class="active"';
	
	$sessionDet = explode('/',$_SESSION['session']);
	$currentPage = ucwords(str_replace('-',' ',$sessionDet[0]));
	$mainPage = str_replace('.php','',ucwords(str_replace('-',' ',$sessionDet[1])));
	$title = $currentPage.' - '.$mainPage.' | '.$appName;
	$return_url = $sessionDet[1];
	$page = $sessionDet[0];
	
	include('pages/main/header.php');
	
	
?>
	<input type="hidden" id="curPage" value="<?php echo str_replace('Users','', $mainPage); ?>" />
	<div class="page-wrapper">
		<div class="content">
			<div class="page-header">
				<div class="page-title">
					<h4><?php echo $currentPage; ?></h4>
					<h6><?php echo $mainPage; ?></h6>
				</div>
				<div class="page-btn">
					<a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#addPlan" class="btn btn-added"><img src="assets/img/icons/plus.svg" alt="img">Add Category</a>
				</div>
			</div>

			<div class="card col-md-12 col-lg-12 col-sm-12 col-xs-12">
				<div class="card-body">
					<div class="table-top">
						<div class="search-set">
							<div class="search-input">
								<a class="btn btn-searchset"><img src="assets/img/icons/search-white.svg" alt="img"></a>
							</div>
						</div>
						<div class="wordset">
							<ul>
								<li>
									<a data-bs-toggle="tooltip" data-bs-placement="top" title="pdf"><img src="assets/img/icons/pdf.svg" alt="img"></a>
								</li>
								<li>
									<a data-bs-toggle="tooltip" data-bs-placement="top" title="excel"><img src="assets/img/icons/excel.svg" alt="img"></a>
								</li>
								<li>
									<a data-bs-toggle="tooltip" data-bs-placement="top" title="print"><img src="assets/img/icons/printer.svg" alt="img"></a>
								</li>
							</ul>
						</div>
					</div>
					<div class="table-responsive">
						<table class="table  datanew">
							<thead>
								<tr>
									<th>
										
									</th>
									<th>User Name</th>
									<th>Amount(<i class="fa fa-dollar"></i>)</th>
									<th>Request Date</th>
									<th>Plan</th>
									<th>Status</th>
									<th class="text-end">Action</th>
								</tr>
							</thead>
							<tbody>
							<?php
								$queryWithdrawal = mysqli_query($db_conn, "SELECT a.WithdrawalRef,a.Amount, a.WithdrawalAddress, a.RequestedDate,
									a.ApprovalDate,a.ApprovedBy,a.Type,a.Status, b.First_Name, b.Last_Name,
									c.WithdrawalAddress,c.Type AS AddressType, c.Network,c.AccountName 
									FROM bkq_withdrawals a, bkq_personnel b, bkq_withdrawal_address c 
									WHERE a.Status !='' AND b.UserID=a.UserID AND c.WithAddressID=a.WithdrawalAddress 
									AND c.UserID=a.UserID
								");
								if(mysqli_num_rows($queryWithdrawal)>0){
									while($withdrawal = mysqli_fetch_assoc($queryWithdrawal)){
										if($withdrawal['Status']=='Approved'){
											$status = '<span class="badge  bg-success">Approved</span>';
											$btn = '
												<a class="me-3 change-password" href="javascript:void(0);" data-id="'.$withdrawal['WithdrawalRef'].'" type="'.$withdrawal['Type'].'" name="'.$withdrawal['First_Name'].'" title="Reject withdrawal">
													<img src="assets/img/icons/eye.svg" width="25px" alt="img">
												</a>
												<a class="me-3 delete-user" href="javascript:void(0);" data-id="'.$userId.'" name="'.$fullName.'" title="Delete '.$fullName.'">
													<img src="assets/img/icons/print.svg" alt="img">
												</a>
											';
											$statusTag = '<br>On: '.$withdrawal['ApprovalDate'].'<br>By: <b>'.$withdrawal['ApproverFirst'].' '.$withdrawal['ApproverLast'].'</b>';
										}
										elseif($withdrawal['Status']=='Pending'){
											$status = '<span class="badge  bg-warning">Pending</span>';
											$btn = '
												<a class="me-3 view-withdrawal" href="javascript:void(0);" data-id="'.$withdrawal['WithdrawalRef'].'" type="'.$withdrawal['Type'].'" name="'.$withdrawal['First_Name'].'" title="Reject withdrawal">
													<img src="assets/img/icons/eye.svg" width="25px" alt="img">
												</a>
												<a class="me-3 reject-withdrawal" href="javascript:void(0);" data-id="'.$withdrawal['WithdrawalRef'].'" type="'.$withdrawal['Type'].'" name="'.$withdrawal['First_Name'].'" title="Reject withdrawal">
													<img src="assets/img/icons/close-circle1.svg" alt="img">
												</a>
												<a class="me-3 approve-withdrawal" href="javascript:void(0);" data-id="'.$withdrawal['WithdrawalRef'].'" type="'.$withdrawal['Type'].'" name="'.$withdrawal['First_Name'].'" title="Reject withdrawal">
													<img src="assets/img/icons/check-circle-broken.svg" alt="img">
												</a>
											';
										}
										else{
											$status = '<span class="badge bg-danger">'.$withdrawal['Status'].'</span>';
											$btn = '
												<a class="me-3 change-password" href="javascript:void(0);" data-id="'.$withdrawal['WithdrawalRef'].'" type="'.$withdrawal['Type'].'" name="'.$withdrawal['First_Name'].'" title="Reject withdrawal">
													<img src="assets/img/icons/eye.svg" width="25px" alt="img">
												</a>
												<a class="me-3 delete-user" href="javascript:void(0);" data-id="'.$withdrawal['WithdrawalRef'].'" type="'.$withdrawal['Type'].'" name="'.$withdrawal['First_Name'].'" title="Reject withdrawal">
													<img src="assets/img/icons/print.svg" alt="img">
												</a>
											';
											$statusTag = '<br>On: '.$withdrawal['ApprovalDate'].'<br>By: <b>'.$withdrawal['ApproverFirst'].' '.$withdrawal['ApproverLast'].'</b>';
										}
										
										
										echo '<tr>
											<td>
												<label class="checkboxs select-cat">
													<input type="checkbox" data-id="'.$plan['SubIDNo'].'" name="'.$plan['SubName'].'">
													<span class="checkmarks"></span>
												</label>
											</td>
											<td>'.$withdrawal['Last_Name'].' '.$withdrawal['First_Name'].'</td>
											<td>'.$withdrawal['Amount'].'</td>
											<td>'.$plan['Period'].'</td>
											<td>'.$plan['Offer'].'%</td>
											<td>'.$plan['LevelOneBonus'].'%</td>
											<td>'.$plan['LevelTwoBonus'].'%</td>
											<td>'.$plan['LevelThreeBonus'].'%</td>
											<td>
												<div class="status-toggle d-flex justify-content-between align-items-center">
													<input type="checkbox" id="'.$plan['SubIDNo'].'" class="check change-status-plan" '.$statusTag.' data-id="'.$plan['SubIDNo'].'" name="'.$plan['SubName'].'">
													<label for="'.$plan['SubIDNo'].'" class="checktoggle">checkbox</label>
												</div>
											</td>
											<td class="text-end">
												<a class="me-3" href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#viewPlan" data-id="'.$plan['SubIDNo'].'" name="'.$plan['SubName'].'">
													<img src="assets/img/icons/eye.svg" alt="img">
												</a>
												<a class="me-3" href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#editPlan" data-id="'.$plan['SubIDNo'].'" name="'.$plan['SubName'].'">
													<img src="assets/img/icons/edit.svg" alt="img">
												</a>
												<a class="me-3 delete-plan" href="javascript:void(0);" data-id="'.$plan['SubIDNo'].'" name="'.$plan['SubName'].'">
													<img src="assets/img/icons/delete.svg" alt="img">
												</a>
											</td>
										</tr>';
									}
								}
							?>
							</tbody>
						</table>
					</div>
					
					<div class="table-foot">
						<hr />
						<input type="hidden" id="selectedId" />
						<input type="hidden" id="selectedNames" />
						<a class="me-3 delete-all-plans" title="Delete all selected" href="javascript:void(0);">
							<img src="assets/img/icons/delete.svg" alt="img">
						</a>
					</div>
					<script>
						$(document).ready(function(){
							$(".table-foot").attr('style','display: none');
							$(".change-status").on('change', function(){
								
							});
							
							// Arrays to store selected IDs and names
							let selectedIds = [];
							let selectedNames = [];

							// Function to handle click events on .select-cat elements
							function updateSelection(event) {
								const dataId = event.target.getAttribute("data-id");
								const categoryName = event.target.getAttribute("name");

								// Ensure both dataId and categoryName exist before proceeding
								if (dataId && categoryName) {
									if (selectedIds.includes(dataId)) {
										// Remove data-id and name if it already exists in the array
										selectedIds = selectedIds.filter(id => id !== dataId);
										selectedNames = selectedNames.filter(name => name !== categoryName);
									} else {
										// Add data-id and name if it doesn't exist in the array
										selectedIds.push(dataId);
										selectedNames.push(categoryName);
									}
								}
								
								const formattedNames =
								selectedNames.length > 1
									? `${selectedNames.slice(0, -1).join(", ")} and ${selectedNames.slice(-1)}`
									: selectedNames.join("");
									
								// Update the selected IDs and names labels
								const idsLabel = document.getElementById("selected-label");
								const namesLabel = document.getElementById("selected-names-label");

								idsLabel.textContent = selectedIds.length ? selectedIds.join(",") : "None";
								namesLabel.textContent = selectedNames.length ? formattedNames : "None";
							
								if(idsLabel.textContent==="None"){
									$(".table-foot").attr('style','display: none');
									$("#selectedId").val('');
									$("#selectedNames").val('');
								}
								else{
									$(".table-foot").attr('style','display: block');
									$("#selectedId").val(idsLabel.textContent);
									$("#selectedNames").val(formattedNames);
								}
							}

							// Attach click event listeners to elements with .select-cat class
							document.querySelectorAll(".select-cat").forEach(element => {
								element.addEventListener("click", updateSelection);
							});
						});
					</script>
					<p id="selected-label" style="display:none;"></p>
					<p id="selected-names-label" style="display:none;"></p>
				</div>
			</div>
		</div>
	</div>
	
	<div class="modal fade" id="addPlan" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title">Add Category </h5>
					<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
						<span aria-hidden="true" id="closeAddPlanIcon">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<div class="row">
						<div class="col-12">
							<div class="form-group">
								<label>Category Name<span class="manitory">*</span></label>
								<input type="text" id="categoryName" placeholder="Category name">
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" id="submitPlan" class="btn btn-submit">Submit</button>
					<button type="button" id="closeAddPlanBtn" class="btn btn-cancel" data-bs-dismiss="modal">Cancel</button>
				</div>
			</div>
		</div>
	</div>
	
	<div class="modal fade" id="editPlan" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title">Edit category </h5>
					<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
						<span aria-hidden="true" id="closeEditCatIcon">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<div class="row">
						<div class="col-12">
							<div class="form-group">
								<label>Category Name<span class="manitory">*</span></label>
								<input type="text" id="editCategoryName" placeholder="Enter category">
							</div>
						</div>
					</div>
				</div>
				<input type="hidden" id="editCatId" />
				<div class="modal-footer">
					<button type="button" id="editCategoryBtn" class="btn btn-submit">Confirm</button>
					<button type="button" id="closeEditCatBtn" class="btn btn-cancel" data-bs-dismiss="modal">Cancel</button>
				</div>
			</div>
		</div>
	</div>

	
</div>

<?php include('pages/main/footer.php'); ?>