<?php 
	$settingMenu = 'class="active"';
	$apiMenu = 'class="active"';
	
	$sessionDet = explode('/',$_SESSION['session']);
	$currentPage = ucwords(str_replace('-',' ',$sessionDet[0]));
	$mainPage = str_replace('.php','',ucwords(str_replace('-',' ',$sessionDet[1])));
	$title = $currentPage.' - '.$mainPage.' | '.$appName;
	$return_url = $sessionDet[1];
	$page = $sessionDet[0];
	
	include('pages/main/header.php');
	
	
?>
	<input type="hidden" id="curPage" value="<?php echo str_replace('Users','', $mainPage); ?>" />
	<div class="page-wrapper">
		<div class="content">
			<div class="page-header">
				<div class="page-title">
					<h4><?php echo $currentPage; ?></h4>
					<h6><?php echo $mainPage; ?></h6>
				</div>
				<div class="page-btn">
					<a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#addpayment" class="btn btn-added"><img src="assets/img/icons/plus.svg" alt="img">Add API Setting</a>
				</div>
			</div>

			<div class="card">
            <div class="card-body">
              <div class="table-top">
                <div class="search-set">
                  <div class="search-input">
                    <a class="btn btn-searchset">
						<img src="assets/img/icons/search-white.svg" alt="img" /></a>
                  </div>
                </div>
                <div class="wordset">
                  <ul>
                    <li>
                      <a data-bs-toggle="tooltip" data-bs-placement="top" title="pdf" >
						<img src="assets/img/icons/pdf.svg" alt="img" />
					  </a>
                    </li>
                    <li>
                      <a
                        data-bs-toggle="tooltip"
                        data-bs-placement="top"
                        title="excel"
                        ><img src="assets/img/icons/excel.svg" alt="img"
                      /></a>
                    </li>
                    <li>
                      <a data-bs-toggle="tooltip" data-bs-placement="top" title="print">
						<img src="assets/img/icons/printer.svg" alt="img" />
					  </a>
                    </li>
                  </ul>
                </div>
              </div>
              <div class="table-responsive load-api-details">
                
              </div>
            </div>
          </div>
		</div>
	</div>
	
	<div class="modal fade" id="addpayment" tabindex="-1" role="dialog" aria-hidden="true">
      <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">Add New API Details</h5>
            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="row">
              <div class="col-md-6 col-lg-6 col-xl-6 col-sm-12 col-xs-12">
                <div class="form-group">
                  <label>API Name</label>
                  <input type="text" id="apiName" placeholder="Enter API Name" />
                </div>
              </div>
			  <div class="col-md-6 col-lg-6 col-xl-6 col-sm-12 col-xs-12">
                <div class="form-group">
                  <label>Public Key</label>
                  <input type="text" id="apiPublic" placeholder="Enter API Public Key" />
                </div>
              </div>
			  <div class="col-md-6 col-lg-6 col-xl-6 col-sm-12 col-xs-12">
                <div class="form-group">
                  <label>Secret Key</label>
                  <input type="text" id="apiSecret" placeholder="Enter API Secret Key" />
                </div>
              </div>
              <div class="col-md-6 col-lg-6 col-xl-6 col-sm-12 col-xs-12">
                <div class="form-group mb-0">
                  <label>Status</label>
                  <select class="select" id="apiStatus">
                    <option value="">Choose Status</option>
                    <option value="Active">Active</option>
                    <option value="InActive">InActive</option>
                  </select>
                </div>
              </div>
			  
			  <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-xs-12">
                <div class="form-group">
                  <label>Description</label>
                  <input type="text" id="apiDescription" placeholder="Enter API Description" />
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" id="addApi" class="btn btn-submit">Confirm</button>
            <button type="button" class="btn btn-cancel" data-bs-dismiss="modal">Cancel</button>
          </div>
        </div>
      </div>
    </div>
	<script>
		$(document).ready(function(){
			loadApiDetails();
			
			$("#addApi").on('click', function(){
				let errorMsg = '';
				let formdata = new FormData();
				formdata.append('action', 'add-api-detail');
				
				let apiName = $("#apiName").val();
				if(apiName){
					formdata.append('apiName', apiName);
					$("#apiName").removeAttr('style');
				} else {
					errorMsg = '<i class="fa fa-times"></i> API Name required';
					$("#apiName").css('border-color', 'red');
				}

				let apiPublic = $("#apiPublic").val();
				if(apiPublic){
					formdata.append('apiPublic', apiPublic);
					$("#apiPublic").removeAttr('style');
				} else {
					errorMsg += errorMsg ? '<br>' : '';
					errorMsg += '<i class="fa fa-times"></i> API Public Key required';
					$("#apiPublic").css('border-color', 'red');
				}

				let apiSecret = $("#apiSecret").val();
				if(apiSecret){
					formdata.append('apiSecret', apiSecret);
					$("#apiSecret").removeAttr('style');
				} else {
					errorMsg += errorMsg ? '<br>' : '';
					errorMsg += '<i class="fa fa-times"></i> API Secret Key required';
					$("#apiSecret").css('border-color', 'red');
				}

				let apiStatus = $("#apiStatus").val();
				if(apiStatus){
					formdata.append('apiStatus', apiStatus);
				} else {
					errorMsg += errorMsg ? '<br>' : '';
					errorMsg += '<i class="fa fa-times"></i> Select Status';
				}

				let apiDescription = $("#apiDescription").val();
				if(apiDescription){
					formdata.append('apiDescription', apiDescription);
					$("#apiDescription").removeAttr('style');
				} else {
					errorMsg += errorMsg ? '<br>' : '';
					errorMsg += '<i class="fa fa-times"></i> API Description required';
					$("#apiDescription").css('border-color', 'red');
				}

				if(!errorMsg){
					let button = $(this); // Store reference to button
					button.html('Submitting...<i class="fa fa-spinner fa-spin"></i>');

					$.ajax({
						url: "../resources/scripts/scripts.php",
						type: "POST",
						data: formdata,
						processData: false,  // Required for FormData
						contentType: false,  // Required for FormData
						beforeSend: function(){
							button.prop("disabled", true); // Disable button during submission
						},
						success: function(response) {
							button.prop("disabled", false); // Re-enable button
							if(response === 'success'){
								alertify.success('<i class="fa fa-check"></i> API Details Successfully Added');
								$("#apiName").val('');
								$("#apiPublic").val('');
								$("#apiSecret").val('');
								$("#apiDescription").val('');
								$("#apiStatus").val(''); // Corrected reset for dropdown
								loadApiDetails();
							} else {
								alertify.error('<i class="fa fa-times"></i> ' + response);
							}
							button.html('Confirm');
						}
					});
				}
			});
			
			function loadApiDetails(){
				$.ajax({
					url: "../resources/scripts/scripts.php",
					type: "POST",
					data: { action: "load-api-details" },
					beforeSend: function(){
						$(".load-api-details").html('<h3 class="text-center">Loading...<i class="fa fa-spinner fa-spin"></i></h3>');
					},
					success: function(response) {
						$(".load-api-details").html(response);
					}
				});
			}
		});
	
	</script>

    <div class="modal fade" id="editpayment" tabindex="-1" role="dialog" aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">Edit payment type</h5>
            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="row">
              <div class="col-12">
                <div class="form-group">
                  <label>Payment Name</label>
                  <input type="text" value="Cash" />
                </div>
              </div>
              <div class="col-12">
                <div class="form-group mb-0">
                  <label>Status</label>
                  <select class="select">
                    <option>Active</option>
                    <option>InActive</option>
                  </select>
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-submit">Update</button>
            <button type="button" class="btn btn-cancel" data-bs-dismiss="modal">
              Cancel
            </button>
          </div>
        </div>
      </div>
    </div>
	
</div>

<?php include('pages/main/footer.php'); ?>