<?php 
	$settingMenu = 'class="active"';
	$planMenu = 'class="active"';
	
	$sessionDet = explode('/',$_SESSION['session']);
	$currentPage = ucwords(str_replace('-',' ',$sessionDet[0]));
	$mainPage = str_replace('.php','',ucwords(str_replace('-',' ',$sessionDet[1])));
	$title = $currentPage.' - '.$mainPage.' | '.$appName;
	$return_url = $sessionDet[1];
	$page = $sessionDet[0];
	
	include('pages/main/header.php');
	
	
?>
	<input type="hidden" id="curPage" value="<?php echo str_replace('Users','', $mainPage); ?>" />
	<div class="page-wrapper">
		<div class="content">
			<div class="page-header">
				<div class="page-title">
					<h4><?php echo $currentPage; ?></h4>
					<h6><?php echo $mainPage; ?></h6>
				</div>
				<div class="page-btn">
					<a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#addPlan" class="btn btn-added"><img src="assets/img/icons/plus.svg" alt="img">Add Plan</a>
				</div>
			</div>

			<div class="card col-md-12 col-lg-12 col-sm-12 col-xs-12">
				<div class="card-body">
					<div class="table-top">
						<div class="search-set">
							<div class="search-input">
								<a class="btn btn-searchset"><img src="assets/img/icons/search-white.svg" alt="img"></a>
							</div>
						</div>
						<div class="wordset">
							<ul>
								<li>
									<a data-bs-toggle="tooltip" data-bs-placement="top" title="pdf"><img src="assets/img/icons/pdf.svg" alt="img"></a>
								</li>
								<li>
									<a data-bs-toggle="tooltip" data-bs-placement="top" title="excel"><img src="assets/img/icons/excel.svg" alt="img"></a>
								</li>
								<li>
									<a data-bs-toggle="tooltip" data-bs-placement="top" title="print"><img src="assets/img/icons/printer.svg" alt="img"></a>
								</li>
							</ul>
						</div>
					</div>
					<div class="table-responsive">
						<table class="table  datanew">
							<thead>
								<tr>
									<th>
										
									</th>
									<th>Plan Name</th>
									<th>Amount(<i class="fa fa-dollar"></i>)</th>
									<th>Duration</th>
									<th>Offer</th>
									<th>LV1 Bonus</th>
									<th>LV2 Bonus</th>
									<th>LV3 Bonus</th>
									<th>Status</th>
									<th class="text-end">Action</th>
								</tr>
							</thead>
							<tbody>
							<?php
								$queryPlan = mysqli_query($db_conn, "SELECT * FROM bkq_subscription_plans");
								if(mysqli_num_rows($queryPlan)>0){
									while($plan = mysqli_fetch_assoc($queryPlan)){
										$editPlanDet = $plan['SubIDNo'].'_'.$plan['SubName'].'_'.$plan['Amount'].'_'.$plan['Offer'].'_'.$plan['LevelOneBonus'].'_'.$plan['LevelTwoBonus'].'_'.$plan['LevelThreeBonus'].'_'.$plan['ShortDescription'];
										if($plan['Status']==1){
											$statusTag = 'checked';
											$statusTag = '<div class="status-toggle d-flex justify-content-between align-items-center">
												<input type="checkbox" id="'.$plan['SubIDNo'].'" class="check change-status-plan" '.$statusTag.' data-id="'.$plan['SubIDNo'].'" name="'.$plan['SubName'].'">
												<label for="'.$plan['SubIDNo'].'" class="checktoggle">checkbox</label>
											</div>';
											$btn = '<a class="me-3" href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#viewPlanDetails" data-id="'.$plan['SubIDNo'].'" name="'.$plan['SubName'].'">
												<img src="assets/img/icons/eye.svg" alt="img">
											</a>
											<a class="me-3" href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#editPlan" data-id="'.$editPlanDet.'" name="'.$plan['SubName'].'">
												<img src="assets/img/icons/edit.svg" alt="img">
											</a>
											<a class="me-3 delete-plan" href="javascript:void(0);" data-id="'.$plan['SubIDNo'].'" name="'.$plan['SubName'].'">
												<img src="assets/img/icons/delete.svg" alt="img">
											</a>';
										}
										elseif($plan['Status']==0){
											$statusTag = '';
											$statusTag = '<div class="status-toggle d-flex justify-content-between align-items-center">
												<input type="checkbox" id="'.$plan['SubIDNo'].'" class="check change-status-plan" '.$statusTag.' data-id="'.$plan['SubIDNo'].'" name="'.$plan['SubName'].'">
												<label for="'.$plan['SubIDNo'].'" class="checktoggle">checkbox</label>
											</div>';
											$btn = '<a class="me-3" href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#viewPlanDetails" data-id="'.$plan['SubIDNo'].'" name="'.$plan['SubName'].'">
												<img src="assets/img/icons/eye.svg" alt="img">
											</a>
											<a class="me-3" href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#editPlan" data-id="'.$editPlanDet.'" name="'.$plan['SubName'].'">
												<img src="assets/img/icons/edit.svg" alt="img">
											</a>
											<a class="me-3 delete-plan" href="javascript:void(0);" data-id="'.$plan['SubIDNo'].'" name="'.$plan['SubName'].'">
												<img src="assets/img/icons/delete.svg" alt="img">
											</a>';
										}
										else{
											$statusTag = '<span class="badge bg-danger">Deleted</span>';
											$btn = '<a class="me-3 restore-plan" href="javascript:void(0);" data-id="'.$plan['SubIDNo'].'" name="'.$plan['SubName'].'">
												<img src="assets/img/icons/restore.svg" width="15px" alt="img">
											</a>
											<a class="me-3 delete-plan" href="javascript:void(0);" data-id="'.$plan['SubIDNo'].'" name="'.$plan['SubName'].'">
												<img src="assets/img/icons/delete.svg" alt="img">
											</a>';
										}
										echo '<tr>
											<td>
												<label class="checkboxs select-cat">
													<input type="checkbox" data-id="'.$plan['SubIDNo'].'" name="'.$plan['SubName'].'">
													<span class="checkmarks"></span>
												</label>
											</td>
											<td>'.$plan['SubName'].'</td>
											<td>'.$plan['Amount'].'</td>
											<td>'.$plan['Period'].'</td>
											<td>'.$plan['Offer'].'%</td>
											<td>'.$plan['LevelOneBonus'].'%</td>
											<td>'.$plan['LevelTwoBonus'].'%</td>
											<td>'.$plan['LevelThreeBonus'].'%</td>
											<td>
												'.$statusTag.'
											</td>
											<td class="text-end">
												'.$btn.'
											</td>
										</tr>';
									}
								}
							?>
							</tbody>
						</table>
					</div>
					
					<div class="table-foot">
						<hr />
						<input type="hidden" id="selectedId" />
						<input type="hidden" id="selectedNames" />
						<a class="me-3 delete-all-plans" title="Delete all selected" href="javascript:void(0);">
							<img src="assets/img/icons/delete.svg" alt="img">
						</a>
					</div>
					<script>
						$(document).ready(function(){
							$(document).delegate("[data-bs-target='#editPlan']", "click", function() {
								const str = $(this).attr('data-id');
								const [data1, data2, data3, data4, data5, data6, data7, data8] = str.split("_").map(item => item.trim());
								$("#editSubName").val(data2);
								$("#editAmount").val(data3);
								$("#editDiscount").val(data4);
								$("#editLv1Bonus").val(data5);
								$("#editLv2Bonus").val(data6);
								$("#editLv3Bonus").val(data7);
								$("#selectedPlan").val(data1);
								$("#editPlanHeader").html(data2);
								$("#editDescription").val(data8);
							});
							
							$(document).delegate("[data-bs-target='#viewPlanDetails']", "click", function() {
								let viewPlanName = $(this).attr('name');
								let viewPlanId = $(this).attr('data-id');
								$("#viewPlanHeader").html(viewPlanName);
								
								let fd = new FormData();
								fd.append('action','view-plan-details');
								fd.append('planid',viewPlanId);
								$.ajax({
									url: '../resources/scripts/scripts.php',
									type: 'POST',
									data: fd,
									contentType: false,
									processData: false,
									dataType:'JSON',
									beforeSend:function(){
										$("#viewPlanBody").html('<h3 class="text-center">Loading Features...<i class="fa fa-spinner fa-spin"></i></h3>');
									},
									success: function (response){
										$("#viewPlanBody").html(response.dataVal);
									},
									error: function(jqXHR, textStatus, errorThrown) {
										// Display detailed error information
										console.error("AJAX Request Error:");
										console.error("Status: " + textStatus); // Status of the request (e.g., "error", "timeout")
										console.error("Error Thrown: " + errorThrown); // Textual portion of the error
										console.error("Response Text: " + jqXHR.responseText); // Response from the server, if any

										// Display errors in a user-friendly way
										alert("Error occurred:\n" +
											"Status: " + textStatus + "\n" +
											"Error: " + errorThrown + "\n" +
											"Details: " + jqXHR.responseText);
									}
								});
							});
							
							$("#editPlanBtn").on('click',function(){
								let formdata = new FormData();
								let errorMsg = '';
								let selectedPlan 	= $("#selectedPlan").val();
								formdata.append('planId',selectedPlan);
								let editSubName 	= $("#editSubName").val();
								if(editSubName){
									formdata.append('editSubName',editSubName);
								}
								else{
									errorMsg = '<i class="fa fa-times"></i> Plan Name is Required';
								}
								let editAmount 		= $("#editAmount").val();
								if(editAmount){
									if(isNaN(editAmount)){
										if(errorMsg){
											errorMsg = '<br><i class="fa fa-times"></i> Amount must be a number.';
										}
										else{
											errorMsg = '<i class="fa fa-times"></i> Amount must be a number';
										}
									}
									else{
										formdata.append('editAmount',editAmount);
									}
								}
								else{
									if(errorMsg){
										errorMsg = '<br><i class="fa fa-times"></i> Amount is Required.';
									}
									else{
										errorMsg = '<i class="fa fa-times"></i> Amount is Required';
									}
								}
								let editDiscount 	= $("#editDiscount").val();
								if(editDiscount){
									if(isNaN(editDiscount)){
										if(errorMsg){
											errorMsg = '<br><i class="fa fa-times"></i> Discount value must be a number.';
										}
										else{
											errorMsg = '<i class="fa fa-times"></i> Discount Value must be a number';
										}
									}
									else{
										formdata.append('editDiscount',editDiscount);
									}
								}
								else{
									if(errorMsg){
										errorMsg = '<br><i class="fa fa-times"></i> Discount Value is Required.';
									}
									else{
										errorMsg = '<i class="fa fa-times"></i> Discount Value is Required';
									}
								}
								let editLv1Bonus	= $("#editLv1Bonus").val();
								if(editLv1Bonus){
									if(isNaN(editLv1Bonus)){
										if(errorMsg){
											errorMsg = '<br><i class="fa fa-times"></i> Level 1 Bonus value must be a number.';
										}
										else{
											errorMsg = '<i class="fa fa-times"></i> Level 1 Bonus Value must be a number';
										}
									}
									else{
										formdata.append('editLv1Bonus',editLv1Bonus);
									}
								}
								else{
									if(errorMsg){
										errorMsg = '<br><i class="fa fa-times"></i> Level 1 Bonus value is Required.';
									}
									else{
										errorMsg = '<i class="fa fa-times"></i> Level 1 Bonus value is Required';
									}
								}
								let editLv2Bonus	= $("#editLv2Bonus").val();
								if(editLv2Bonus){
									if(isNaN(editLv2Bonus)){
										if(errorMsg){
											errorMsg = '<br><i class="fa fa-times"></i> Level 2 Bonus value must be a number.';
										}
										else{
											errorMsg = '<i class="fa fa-times"></i> Level 2 Bonus Value must be a number';
										}
									}
									else{
										formdata.append('editLv2Bonus',editLv2Bonus);
									}
								}
								else{
									if(errorMsg){
										errorMsg = '<br><i class="fa fa-times"></i> Level 2 Bonus value is Required.';
									}
									else{
										errorMsg = '<i class="fa fa-times"></i> Level 2 Bonus value is Required';
									}
								}
								let editLv3Bonus	= $("#editLv3Bonus").val();
								if(editLv3Bonus){
									if(isNaN(editLv3Bonus)){
										if(errorMsg){
											errorMsg = '<br><i class="fa fa-times"></i> Level 3 Bonus value must be a number.';
										}
										else{
											errorMsg = '<i class="fa fa-times"></i> Level 3 Bonus Value must be a number';
										}
									}
									else{
										formdata.append('editLv3Bonus',editLv3Bonus);
									}
								}
								else{
									if(errorMsg){
										errorMsg = '<br><i class="fa fa-times"></i> Level 3 Bonus value is Required.';
									}
									else{
										errorMsg = '<i class="fa fa-times"></i> Level 3 Bonus value is Required';
									}
								}
								let editDescription	= $("#editDescription").val();
								if(editDescription){
									formdata.append('editDescription',editDescription);
								}
								
								if(errorMsg){
									Swal.fire({
										icon: "error",
										title: "Error Occurred",
										html: "<span class='text-danger'>"+errorMsg+"</span>",
										confirmButtonClass: "btn btn-danger",
										allowOutsideClick: false,
										allowEscapeKey: false,
										allowEnterKey: false
									});
								}
								else{
									formdata.append('action','edit-plan');
									$.ajax({
										url: '../resources/scripts/scripts.php',
										type: 'POST',
										data: formdata,
										contentType: false,
										processData: false,
										dataType:'JSON',
										beforeSend:function(){
											Swal.fire({
												title: 'Updating',
												html: "Please, wait...",
												allowOutsideClick: false,
												allowEscapeKey: false,
												allowEnterKey: false,
												showConfirmButton: false,
												willOpen: () => {
													Swal.showLoading();
												}
											});
										},
										success: function (response){
										  if(response.header==='successful') {
											Swal.fire({
											  title: 'Plan Updated',
											  html: response.message,
											  icon: 'success',
											  confirmButtonText: 'OK',
											  confirmButtonColor: '#3085d6',
											  customClass: {
												confirmButton: 'btn btn-success'
											  },
											  buttonsStyling: false
											});
										  }else {
											Swal.fire({
											  title: response.header,
											  html: "<span class='text-danger'>"+response.message+"</span>",
											  icon: 'error',
											  confirmButtonText: 'OK',
											  confirmButtonColor: '#d33',
											  customClass: {
												confirmButton: 'btn btn-danger'
											  },
											  buttonsStyling: false
											});
										  }
										}
									});
								}
							});
							
							
							
							$(".table-foot").attr('style','display: none');
							$(".change-status").on('change', function(){
								
							});
							
							// Arrays to store selected IDs and names
							let selectedIds = [];
							let selectedNames = [];

							// Function to handle click events on .select-cat elements
							function updateSelection(event) {
								const dataId = event.target.getAttribute("data-id");
								const categoryName = event.target.getAttribute("name");

								// Ensure both dataId and categoryName exist before proceeding
								if (dataId && categoryName) {
									if (selectedIds.includes(dataId)) {
										// Remove data-id and name if it already exists in the array
										selectedIds = selectedIds.filter(id => id !== dataId);
										selectedNames = selectedNames.filter(name => name !== categoryName);
									} else {
										// Add data-id and name if it doesn't exist in the array
										selectedIds.push(dataId);
										selectedNames.push(categoryName);
									}
								}
								
								const formattedNames =
								selectedNames.length > 1
									? `${selectedNames.slice(0, -1).join(", ")} and ${selectedNames.slice(-1)}`
									: selectedNames.join("");
									
								// Update the selected IDs and names labels
								const idsLabel = document.getElementById("selected-label");
								const namesLabel = document.getElementById("selected-names-label");

								idsLabel.textContent = selectedIds.length ? selectedIds.join(",") : "None";
								namesLabel.textContent = selectedNames.length ? formattedNames : "None";
							
								if(idsLabel.textContent==="None"){
									$(".table-foot").attr('style','display: none');
									$("#selectedId").val('');
									$("#selectedNames").val('');
								}
								else{
									$(".table-foot").attr('style','display: block');
									$("#selectedId").val(idsLabel.textContent);
									$("#selectedNames").val(formattedNames);
								}
							}

							// Attach click event listeners to elements with .select-cat class
							document.querySelectorAll(".select-cat").forEach(element => {
								element.addEventListener("click", updateSelection);
							});
						});
					</script>
					<p id="selected-label" style="display:none;"></p>
					<p id="selected-names-label" style="display:none;"></p>
				</div>
			</div>
		</div>
	</div>
	
	<div class="modal fade" id="addPlan" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title">Add New Subscription Plan </h5>
					<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
						<span aria-hidden="true" id="closeAddPlanIcon">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<div class="row">
						<div class="col-md-6 col-lg-4 col-xl-4 col-sm-6">
							<div class="form-group">
								<label>Plan Name<span class="manitory">*</span></label>
								<input type="text" id="SubName" placeholder="Plan Name">
							</div>
						</div>
						<div class="col-md-6 col-lg-4 col-xl-4 col-sm-6">
							<div class="form-group">
								<label>Amount($)<span class="manitory">*</span></label>
								<input type="text" id="Amount" placeholder="Enter amount">
							</div>
						</div>
						<div class="col-md-6 col-lg-4 col-xl-4 col-sm-6">
							<div class="form-group">
								<label>Discount(%)<span class="manitory">*</span></label>
								<input type="text" id="Discount" placeholder="12">
							</div>
						</div>
						<div class="col-md-6 col-lg-4 col-xl-4 col-sm-6">
							<div class="form-group">
								<label>Level 1 Bonus(%)<span class="manitory">*</span></label>
								<input type="text" id="Lv1Bonus" placeholder="6">
							</div>
						</div>
						<div class="col-md-6 col-lg-4 col-xl-4 col-sm-6">
							<div class="form-group">
								<label>Level 2 Bonus(%)<span class="manitory">*</span></label>
								<input type="text" id="Lv2Bonus" placeholder="4">
							</div>
						</div>
						<div class="col-md-6 col-lg-4 col-xl-4 col-sm-6">
							<div class="form-group">
								<label>Level 3 Bonus(%)<span class="manitory">*</span></label>
								<input type="text" id="Lv3Bonus" placeholder="3">
							</div>
						</div>
						<div class="col-md-12 col-lg-12 col-xl-12 col-sm-12">
							<div class="form-group">
								<label>Short Description</label>
								<input type="text" id="Description" placeholder="Enter Description...">
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" id="submitPlan" class="btn btn-submit">Submit</button>
					<button type="button" id="closeAddPlanBtn" class="btn btn-cancel" data-bs-dismiss="modal">Cancel</button>
				</div>
			</div>
		</div>
	</div>
	
	<div class="modal fade" id="editPlan" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title">Edit <b id="editPlanHeader"></b> </h5>
					<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
						<span aria-hidden="true" id="closeEditPlanIcon">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<div class="row">
						<div class="col-md-6 col-lg-4 col-xl-4 col-sm-6">
							<div class="form-group">
								<label>Plan Name<span class="manitory">*</span></label>
								<input type="text" id="editSubName" placeholder="Plan Name">
							</div>
						</div>
						<div class="col-md-6 col-lg-4 col-xl-4 col-sm-6">
							<div class="form-group">
								<label>Amount($)<span class="manitory">*</span></label>
								<input type="text" id="editAmount" placeholder="Enter amount">
							</div>
						</div>
						<div class="col-md-6 col-lg-4 col-xl-4 col-sm-6">
							<div class="form-group">
								<label>Discount(%)<span class="manitory">*</span></label>
								<input type="text" id="editDiscount" placeholder="12">
							</div>
						</div>
						<div class="col-md-6 col-lg-4 col-xl-4 col-sm-6">
							<div class="form-group">
								<label>Level 1 Bonus(%)<span class="manitory">*</span></label>
								<input type="text" id="editLv1Bonus" placeholder="6">
							</div>
						</div>
						<div class="col-md-6 col-lg-4 col-xl-4 col-sm-6">
							<div class="form-group">
								<label>Level 2 Bonus(%)<span class="manitory">*</span></label>
								<input type="text" id="editLv2Bonus" placeholder="4">
							</div>
						</div>
						<div class="col-md-6 col-lg-4 col-xl-4 col-sm-6">
							<div class="form-group">
								<label>Level 3 Bonus(%)<span class="manitory">*</span></label>
								<input type="text" id="editLv3Bonus" placeholder="3">
							</div>
						</div>
						<div class="col-md-12 col-lg-12 col-xl-12 col-sm-12">
							<div class="form-group">
								<label>Short Description</label>
								<input type="text" id="editDescription" placeholder="Enter Description...">
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" id="editPlanBtn" class="btn btn-submit">Confirm</button>
					<button type="button" id="closeEditPlanBtn" class="btn btn-cancel" data-bs-dismiss="modal">Cancel</button>
				</div>
			</div>
			<input type="hidden" id="selectedPlan" />
		</div>
	</div>
	
	<div class="modal fade" id="viewPlanDetails" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title">Features of <b id="viewPlanHeader"></b> </h5>
					<button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
						<span aria-hidden="true" id="closeViewPlanIcon">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<div class="row" id="viewPlanBody">
						
					</div>
					
				</div>
				<div class="modal-footer">
					<button type="button" id="closeViewPlanBtn" class="btn btn-cancel" data-bs-dismiss="modal">Cancel</button>
				</div>
			</div>
			<input type="hidden" id="selectedPlan" />
		</div>
	</div>
	
	
</div>

<?php include('pages/main/footer.php'); ?>