<?php
	$myKey = 'passw0rd@123456';
	
	////////check validity of USD wallet address///////
	function validateUSDTAddress($address, $network) {
		$patterns = [
			'ERC-20' => '/^0x[a-fA-F0-9]{40}$/', // Ethereum-based USDT (ERC-20)
			'BEP-20' => '/^0x[a-fA-F0-9]{40}$/', // Binance Smart Chain USDT (BEP-20)
			'BEP-10' => '/^bnb[a-zA-Z0-9]{39}$/', // Binance Beacon Chain USDT (BEP-10)
			'TRC-20' => '/^T[a-zA-HJ-NP-Z0-9]{33}$/', // Tron-based USDT (TRC-20)
		];

		if (!isset($patterns[$network])) {
			return "Unsupported network.";
		}

		return preg_match($patterns[$network], $address) ? "Valid Address" : "Invalid Address";
	}
	
	////////bulk upload data cleaning function////////
	function parseQuizData($input) {
		// Split the input into blocks by double newlines
		$blocks = preg_split("/\n\s*\n/", trim($input));
		$questions = [];
		$uniqueQuestions = []; // To track unique questions and their options

		foreach ($blocks as $block) {
			// Split block into individual lines
			$lines = array_filter(array_map('trim', explode("\n", $block)));

			if (count($lines) > 1) {
				$question = $lines[0]; // First line is the question
				$answers = [];
				$correctAnswer = null;
				$description = null;

				// Parse the rest of the lines
				for ($i = 1; $i < count($lines); $i++) {
					$line = $lines[$i];

					if (stripos($line, 'Correct Answer:') === 0) {
						$correctAnswer = trim(substr($line, strlen('Correct Answer:')));
					} elseif (stripos($line, 'Description:') === 0) {
						$description = trim(substr($line, strlen('Description:')));
					} else {
						$answers[] = $line; // Otherwise, it's an answer option
					}
				}

				// Generate a unique key based on question and options
				$uniqueKey = md5($question . implode('|', $answers));

				// Add the question only if it's not already in the uniqueQuestions array
				if (!isset($uniqueQuestions[$uniqueKey])) {
					$questions[] = [
						'question' => $question,
						'answers' => $answers,
						'correct_answer' => $correctAnswer,
						'description' => $description,
					];

					// Mark this question and its options as processed
					$uniqueQuestions[$uniqueKey] = true;
				}
			}
		}

		return $questions;
	}
	
	/////BVN verification////
	function verifyBVN($bvn){
		
		$curl = curl_init();
		curl_setopt_array($curl, [
		  CURLOPT_URL => "https://api.verified.africa/sfx-verify/v3/id-service/",
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => "",
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 30,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => "POST",
		  CURLOPT_POSTFIELDS => json_encode([
			'verificationType' => 'BVN-FULL-DETAILS',
			'searchParameter' => $bvn
		  ]),
		  CURLOPT_HTTPHEADER => [
			"accept: application/json",
			"apiKey: Tz4CL'4vHV*-h+AC",
			"content-type: application/json",
			"userid: 1589315632475"
		  ],
		]);
//9OAe92gojMv4Or7M9W5U
		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if ($err) {
		  echo "cURL Error #:" . $err;
		} else {
		  return $response;
		}
	}
	
	/////encrypt data//////////
	function dataEncryption($data, $encryptionKey) {
		// Convert the JSON data to a string
		$jsonString = json_encode($data);

		// Generate a random initialization vector (IV)
		$iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length('AES-256-CBC'));

		// Encrypt the JSON string
		$encryptedMessage = openssl_encrypt($jsonString, 'AES-256-CBC', $encryptionKey, 0, $iv);

		// Combine IV and encrypted message for storage/transport
		$encryptedPayload = base64_encode($iv . $encryptedMessage);

		return $encryptedPayload;
	}

	// Function to decrypt a message
	function dataDecryption($encryptedPayload, $encryptionKey) {
		// Decode the base64-encoded payload
		$decodedPayload = base64_decode($encryptedPayload);

		// Extract the IV and encrypted message
		$ivLength = openssl_cipher_iv_length('AES-256-CBC');
		$iv = substr($decodedPayload, 0, $ivLength);
		$encryptedMessage = substr($decodedPayload, $ivLength);

		// Decrypt the JSON string
		$jsonString = openssl_decrypt($encryptedMessage, 'AES-256-CBC', $encryptionKey, 0, $iv);

		// Convert the decrypted JSON string back to an array or object
		$data = json_decode($jsonString, true);

		return $data;
	}
	
	////get the date a user joined
	function dateJoined($date){
		$date = strtotime($date);
		$today = strtotime("today");
		$yesterday = strtotime("yesterday");
		$thisWeek = strtotime("this week");
		$lastWeek = strtotime("last week");
		$thisMonth = strtotime("this month");
		$thisYear = strtotime("this year");
		$dateN = time();
		$date2 = $dateN - $date;
		if(date("d M Y", $date) == date("d M Y", $today)){
			if($date2 < 60){
				$dateValue =  intval($date2).' secs ago'."\n";
			}
			elseif($date2 >= 60 && $date2 < (60*60)){
				$dateValue = intval($date2/(60));
				if($dateValue < 2){
					$dateValue = $dateValue .' min ago';
				}
				else{
					$dateValue = $dateValue .' mins ago';
				}
			}
			elseif($date2 >= (60*60) && $date2 < (60*60*6)){
				$dateValue = intval($date2/(60*60));
				if($dateValue < 2){
					$dateValue = $dateValue .' hr ago';
				}
				else{
					$dateValue = $dateValue .' hrs ago';
				}
			}
			else{
				$dateValue = "Today, ".date("h:ia", $date);
			}
		}
		elseif(date("d M Y", $date) == date("d M Y", $yesterday)){
			$dateValue = "Yesterday, ".date("h:ia", $date);
		}
		elseif(date("W Y", $thisWeek) == date("W Y", $date)){
			$dateValue = date("l, h:ia", $date);
		}
		elseif(date("W Y", $lastWeek) == date("W Y", $date)){
			$dateValue = 'Last Week, '.date("l, h:ia", $date);
		}
		elseif(date("M Y", $thisMonth) == date("M Y", $date)){
			$dateValue = date("jS F", $date);
		}
		elseif(date("Y", $thisYear) == date("Y", $date)){
			$dateValue = date("F jS", $date);
		}
		else{
			$dateValue = date("F jS, Y", $date);
		}
		return $dateValue;
	}
	
	////get the date a user joined
	function joined($date) {
		// Convert the given date string to a timestamp
		$timestamp = strtotime($date);
		$currentTimestamp = time();
		
		// Calculate the difference in seconds
		$timeDifference = $currentTimestamp - $timestamp;
		
		// If the input date is invalid or in the future, return "Invalid date"
		if ($timestamp === false || $timeDifference < 0) {
			return "Invalid date";
		}

		// Format the date for output
		$formattedTime = date("h:ia", $timestamp);

		// Determine the time difference in minutes, hours, and days
		$minutes = floor($timeDifference / 60);
		$hours = floor($timeDifference / 3600);
		$days = floor($timeDifference / 86400);

		// Return the appropriate time description
		if ($timeDifference <= 300) { // 300 seconds = 5 minutes
			return "Just Now";
		} elseif ($minutes < 60) { // Less than 1 hour
			return "$minutes mins ago";
		} elseif ($hours < 2) { // Less than 2 hours
			return "$hours hr ago";
		} elseif ($hours < 12) { // Less than 12 hours
			return "$hours hrs ago";
		} elseif ($days < 1) { // Same day
			return "Today @ $formattedTime";
		} elseif ($days < 2) { // Yesterday
			return "Yesterday";
		} else { // More than 2 days ago
			return date("M d, Y @ h:ia", $timestamp);
		}
	}
	
	function dateAdded($date){
		$date = strtotime($date);
		$today = strtotime("today");
		$yesterday = strtotime("yesterday");
		$thisWeek = strtotime("this week");
		$lastWeek = strtotime("last week");
		$thisMonth = strtotime("this month");
		$thisYear = strtotime("this year");
		$dateN = time();
		$date2 = $dateN - $date;
		if(date("d M Y", $date) == date("d M Y", $today)){
			if($date2 < 60){
				$dateValue =  'Just Now'."\n";
			}
			elseif($date2 >= 60 && $date2 < (60*60)){
				$dateValue = intval($date2/(60));
				if($dateValue < 2){
					$dateValue =  'Just Now';
				}
				else{
					$dateValue = $dateValue .' mins ago';
				}
			}
			elseif($date2 >= (60*60) && $date2 < (60*60*6)){
				$dateValue = intval($date2/(60*60));
				if($dateValue < 2){
					$dateValue = $dateValue .' hr ago';
				}
				else{
					$dateValue = $dateValue .' hrs ago';
				}
			}
			else{
				$dateValue = "Today, ".date("h:ia", $date);
			}
		}
		elseif(date("d M Y", $date) == date("d M Y", $yesterday)){
			$dateValue = "Yesterday, ".date("h:ia", $date);
		}
		elseif(date("W Y", $thisWeek) == date("W Y", $date)){
			$dateValue = date("l, h:ia", $date);
		}
		elseif(date("W Y", $lastWeek) == date("W Y", $date)){
			$dateValue = 'Last Week, '.date("l, h:ia", $date);
		}
		elseif(date("M Y", $thisMonth) == date("M Y", $date)){
			$dateValue = date("jS F", $date);
		}
		elseif(date("Y", $thisYear) == date("Y", $date)){
			$dateValue = date("F jS", $date);
		}
		else{
			$dateValue = date("F jS, Y", $date);
		}
		return $dateValue;
	}
		
	/////DELETE DIRECTORY////////////////
	function deleteDirectory($dirPath) {
        $iterator = new RecursiveIteratorIterator(
           new RecursiveDirectoryIterator($dirPath, 
           RecursiveDirectoryIterator::SKIP_DOTS),
           RecursiveIteratorIterator::CHILD_FIRST
        );
        foreach ($iterator as $file) {
           if ($file->isDir()) {
              rmdir($file->getPathname());
           } else {
              unlink($file->getPathname());
           }
        }
        
        if(rmdir($dirPath)){
            return 'Successful';
        }
        else{
            return 'Failed';
        }
    }
    
    function password_generate($chars){
        $data = '1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
        return substr(str_shuffle($data), 0, $chars);
    }

    function mb_str_contains(string $haystack, string $needle, $encoding = null) {
        return $needle === '' || mb_substr_count($haystack, $needle, (empty($encoding) ? mb_internal_encoding() : $encoding)) > 0;
    }

    function currentPageURL(){
        $PageURL = 'http';
    if ($_SERVER["HTTPS"] == "on"){
        $PageURL .= "s";
    }
    
    $PageURL .= "://";
    if ($_SERVER["SERVER_PORT"] != "80"){
        $PageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
    }
    else{
        $PageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
    }
        return $PageURL;
    }

    function fileSizeCheck($fileSize){
		if($fileSize>=1024){
			$fileSize = $fileSize/1024;
			if($fileSize>=1024){
				$fileSize = $fileSize/1024;
				if($fileSize>=1024){
					$fileSize = round(($fileSize/1024), 2).'GB';
				}
				else{
					$fileSize = round($fileSize, 2).'MB';
				}
			}
			else{
				$fileSize = round($fileSize, 2).'KB';
			}
		}
		else{
			$fileSize = $fileSize.'B';
		}
		return $fileSize;
	}

	function numberFormat($number){
		$value = explode('.', round($number, 2));
		$main = $value[0];
		$decimal = $value[1];
		if(empty($decimal)){
			$mainValue =  number_format($main);
		}
		else{
			$mainValue = number_format($main).'.'.$decimal;
		}

		return $mainValue;
	}

    function nairaAmount($number){
        $value = explode('.', round($number, 2));
        $main = $value[0];
        $decimal = $value[1];
        if(empty($decimal)){
            $mainValue =  number_format($main);
        }
        else{
            $mainValue = number_format($main).'.'.$decimal;
        }

        return "&#8358;".$mainValue;
    }

	function timeCheck($date){
		$date = strtotime($date);
		$today = strtotime("today");
		$yesterday = strtotime("yesterday");
		$thisWeek = strtotime("this week");
		$lastWeek = strtotime("last week");
		$dateN = time();
		$date2 = $dateN - $date;
		if(date("d M Y", $date) == date("d M Y", $today)){
			if($date2 < 60){
				$dateValue =  intval($date2).' secs ago'."\n";
			}
			elseif($date2 >= 60 && $date2 < (60*60)){
				$dateValue = intval($date2/(60));
				if($dateValue < 2){
					$dateValue = $dateValue .' min ago';
				}
				else{
					$dateValue = $dateValue .' mins ago';
				}
			}
			elseif($date2 >= (60*60) && $date2 < (60*60*6)){
				$dateValue = intval($date2/(60*60));
				if($dateValue < 2){
					$dateValue = $dateValue .' hr ago';
				}
				else{
					$dateValue = $dateValue .' hrs ago';
				}
			}
			else{
				$dateValue = "Today, ".date("h:ia", $date);
			}
		}
		elseif(date("d M Y", $date) == date("d M Y", $yesterday)){
			$dateValue = "Yesterday, ".date("h:ia", $date);
		}
		elseif(date("W Y", $thisWeek) == date("W Y", $date)){
			$dateValue = date("l, h:ia", $date);
		}
		else{
			$dateValue = date("d M, Y h:ia", $date);
		}

		return $dateValue;
	}

	function compressImage($source, $destination, $quality) { 
		// Get image info 
		$imgInfo = getimagesize($source); 
		$mime = $imgInfo['mime']; 
		// Create a new image from file 
		switch($mime){ 
			case 'image/jpeg': 
				$image = imagecreatefromjpeg($source); 
			   imagejpeg($image, $destination, $quality);
				break; 
			case 'image/png': 
				$image = imagecreatefrompng($source); 
				imagepng($image, $destination, $quality);
				break; 
			case 'image/gif': 
				$image = imagecreatefromgif($source); 
				imagegif($image, $destination, $quality);
				break; 
			default: 
				$image = imagecreatefromjpeg($source); 
			   imagejpeg($image, $destination, $quality);
		} 
		return $destination; 
	} 


	function numberTowords($num){
		$ones = array(
			0 =>"", 1 => "ONE", 2 => "TWO",3 => "THREE", 4 => "FOUR", 5 => "FIVE", 6 => "SIX", 7 => "SEVEN", 8 => "EIGHT",
			9 => "NINE", 10 => "TEN", 11 => "ELEVEN", 12 => "TWELVE", 13 => "THIRTEEN", 14 => "FOURTEEN", 15 => "FIFTEEN", 16 => "SIXTEEN",
			17 => "SEVENTEEN", 18 => "EIGHTEEN", 19 => "NINETEEN", "014" => "FOURTEEN"
		);
		$tens = array( 
			0 => "ZERO", 1 => "TEN", 2 => "TWENTY-", 3 => "THIRTY-", 4 => "FORTY-", 5 => "FIFTY-", 6 => "SIXTY-", 7 => "SEVENTY-", 8 => "EIGHTY-", 9 => "NINETY-" 
		); 
		$hundreds = array( 
			"HUNDRED", "THOUSAND,", "MILLION,", "BILLION,", "TRILLION,", "QUARDRILLION," 
		); /*limit t quadrillion */
		$num = number_format($num,2,".",","); 
		$num_arr = explode(".",$num); 
		$wholenum = $num_arr[0]; 
		$decnum = $num_arr[1]; 
		$whole_arr = array_reverse(explode(",",$wholenum)); 
		krsort($whole_arr,1); 
		$rettxt = ""; 

		foreach($whole_arr as $key => $i){
		
			while(substr($i,0,1)=="0")
				$i=substr($i,1,5);
				if($i < 20){ 
					$rettxt .= $ones[$i]; 
				}elseif($i < 100){ 
					if(substr($i,0,1)!="0")  $rettxt .= $tens[substr($i,0,1)]; 
					if(substr($i,1,1)!="0") $rettxt .= "".$ones[substr($i,1,1)]; 
				}else{ 
					if(substr($i,0,1)!="0"){
						if(substr($i,-2,2)=='00'){
							$rettxt .= $ones[substr($i,0,1)]." ".$hundreds[0];
						}
						else{
							$rettxt .= $ones[substr($i,0,1)]." ".$hundreds[0]." AND";
						}
					} 
					if(substr($i,1,1)!="0")$rettxt .= " ".$tens[substr($i,1,1)]; 
					if(substr($i,2,1)!="0")$rettxt .= "".$ones[substr($i,2,1)]; 
				} 
				if($key > 0){ 
					$rettxt .= " ".$hundreds[$key]." "; 
				}
		} 

		
		if($decnum > 0){
			$explodeFunction = explode('TY-', $rettxt);
			if(empty(end($explodeFunction))){
				$rettxt = str_replace('TY-', 'TY',$rettxt)." NAIRA";
			}
			else{
				$rettxt = str_replace('TY- ', 'TY',$rettxt)." NAIRA";
			}

			$rettxt .= ", ";
			if($decnum < 20){
				$rettxt .= $ones[$decnum];
			}elseif($decnum < 100){
				$rettxt .= $tens[substr($decnum,0,1)];
				$rettxt .= " ".$ones[substr($decnum,1,1)];
			}

			$explodeFunction = explode('TY- ', $rettxt);
			if(empty(end($explodeFunction))){
				$rettxt = str_replace('- ', ' ',$rettxt);
			}
			else{
				$rettxt = str_replace('TY- ', 'TY-',$rettxt);
			}

			$rettxt .= " KOBO";
		}
		else{
			$explodeFunction = explode('TY-', $rettxt);
			if(empty(end($explodeFunction))){
				$rettxt = str_replace('TY-', 'TY-',$rettxt)." NAIRA";
			}
			else{
				$rettxt = str_replace('TY- ', 'TY-',$rettxt)." NAIRA";
			}
		}

		$rettxt = ucwords(strtolower($rettxt." ONLY"));
		$rettxt = str_replace(',  Naira', ' Naira', $rettxt);
		$rettxt = str_replace('-thousand', ' Thousand', $rettxt);
		$rettxt = str_replace('-million', ' Million', $rettxt);
		$rettxt = str_replace('-billion', ' Billion', $rettxt);
		$rettxt = str_replace(',  Million,  Thousand Naira', ' Naira', $rettxt);
		return $rettxt;
	}

	if (!empty($_SERVER["HTTP_CLIENT_IP"])){
	//check for ip from share internet
		$ip = $_SERVER["HTTP_CLIENT_IP"];
	}
	elseif (!empty($_SERVER["HTTP_X_FORWARDED_FOR"])){
	// Check for the Proxy User
		$ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
	}
	else{
		$ip = $_SERVER["REMOTE_ADDR"];
	}

	$ipAddress = $ip;

	
?>