﻿<?php
	$websiteDescription = 'Welcome to the forefront of sustainable investment opportunities! At our platform, we empower individuals to contribute to a greener future while maximizing their financial potential. With a range of innovative investment plans, cutting-edge technology, and a commitment to environmental responsibility, we offer investors the chance to plug into profitable solutions. Join us in driving change, fueling progress, and electrifying your portfolio for a brighter tomorrow!';
    $keywords = 'Electric Vehicles, EV, electric vehicle charging station, charging station, car charger, investment opportunity, Sustainable investment,Electric vehicle charging investment,Green energy investment,Renewable energy investment,Clean energy investment,Profitable sustainability,Environmental investing,Eco-friendly investment,Sustainable finance,Green technology investment,Electric vehicle infrastructure investment,Clean energy solutions,Renewable energy projects,Sustainable portfolio management,Climate-conscious investing';
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
	<meta property="og:description" content="<?php echo $websiteDescription; ?>" />
    <meta property="og:site_name" content="<?php echo $appName; ?>"/>
    <meta property="og:image" content="https://elkcharge.com/userdash/assets/images/account-bg.jpg">
    <meta property="og:url" content="<?php echo $defaultUrl; ?>">
    <meta property="og:keyword" content="<?php echo $keywords; ?>" />
    <meta property="og:image:alt" content="<?php echo $appName; ?>" />
    <meta property="og:type" content="website" />

    <title><?php echo $appName; ?> | Create New Account</title>

    <link rel="stylesheet" href="userdash/assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="userdash/assets/css/all.min.css">
    <link rel="stylesheet" href="userdash/assets/css/animate.css">
    <link rel="stylesheet" href="userdash/assets/css/odometer.css">
    <link rel="stylesheet" href="userdash/assets/css/nice-select.css">
    <link rel="stylesheet" href="userdash/assets/css/owl.min.css">
    <link rel="stylesheet" href="userdash/assets/css/jquery-ui.min.css">
    <link rel="stylesheet" href="userdash/assets/css/magnific-popup.css">
    <link rel="stylesheet" href="userdash/assets/css/flaticon.css">
    <link rel="stylesheet" href="userdash/assets/css/main.css">

    <link rel="shortcut icon" href="img/favicon.png" type="image/x-icon">
    <script src="https://kit.fontawesome.com/4600147d2b.js" crossorigin="anonymous"></script>  
    <script src="jquery.min.js"></script>
    <!-- <script src="https://code.jquery.com/jquery-2.1.1.min.js" type="text/javascript"></script> -->
    <script src="https://code.jquery.com/jquery-3.7.0.min.js" type="text/javascript"></script>
  
</head>

<body>

    <div class="preloader">
        <div class="preloader-inner">
            <div class="preloader-icon">
                <span></span>
                <span></span>
            </div>
        </div>
    </div>

    <!--============= Sign In Section Starts Here =============-->
    <div class="account-section bg_img" data-background="userdash/assets/images/account-bg.jpg">
        <div class="container">
            <div class="account-title text-center">
                <a href="javascript:void" onclick="location.href='./?action=home';" class="back-home"><i class="fas fa-angle-left"></i><span>Back <span class="d-none d-sm-inline-block">To ElkCharge</span></span></a>
            </div>
            <div class="account-wrapper">
                <div class="account-body">
                    <span class="d-block mb-20">Fill the form below to continue</span>
					<span class="sign-in-recovery" id="errorMsg"></span>
                    <form class="account-form">
                        <div class="form-group">
                            <label for="firstname">First Name </label>
                            <input type="text" placeholder="Enter Your name" autocomplete="off" id="firstname">
                        </div>
                        <div class="form-group">
                            <label for="email">Your Email </label>
                            <input type="text" placeholder="Enter Your Email" autocomplete="off" id="email">
                        </div>
                        <div class="form-group text-center">
                            <button type="button" id="createAccountBtn">Create My Account</button>
                        </div>
                    </form>
                </div>
                <div class="or">
                    <span></span>
                </div>
                <div class="account-header pb-0">
                    <span class="d-block mt-15">Already have an account? <a href="javascript:void()" onclick="location.href='./?action=login';">Sign In</a></span>
                </div>
            </div>
            <div class="sponsor-slider-wrapper cl-white text-center mt-40">
                <h5 class="slider-heading mb-3">Trusted by over 1,000,000 investors worldwide</h5>
            </div>
			
        </div>
    </div>
    <!--============= Sign In Section Ends Here =============-->

    <script src="userdash/assets/js/jquery-3.3.1.min.js"></script>
    <script src="userdash/assets/js/modernizr-3.6.0.min.js"></script>
    <script src="userdash/assets/js/plugins.js"></script>
    <script src="userdash/assets/js/bootstrap.min.js"></script>
    <script src="userdash/assets/js/magnific-popup.min.js"></script>
    <script src="userdash/assets/js/jquery-ui.min.js"></script>
    <script src="userdash/assets/js/wow.min.js"></script>
    <script src="userdash/assets/js/odometer.min.js"></script>
    <script src="userdash/assets/js/viewport.jquery.js"></script>
    <script src="userdash/assets/js/nice-select.js"></script>
    <script src="userdash/assets/js/owl.min.js"></script>
    <script src="userdash/assets/js/paroller.js"></script>
    <script src="userdash/assets/js/main.js"></script>


</body>

</html>